/*
 * Created on 06.02.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package bingo.server;

import java.rmi.RemoteException;
import java.util.*;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;
import javax.jms.*;
import javax.naming.*;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TextMessage;

/**
 * @author Jack Yao
 *
 * @ejb.bean name = "HostServer"
 *           type = "Stateless"
 * 			 display-name = "Host Server"
 *			 description = "come on"
 *			 view-type = "remote"
 *			 jndi-name = "server/bingo/HostServer"
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class HostServerBean implements SessionBean {

	/**
		 * 
		 */
	public HostServerBean() {
		super();
		// TODO Auto-generated constructor stub
	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext arg0)
		throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
		 * default create method
		 * @throws CreateException
		 * ejb.create-method
	*/
	public void ejbCreate() throws CreateException {
		Context ctx;
		TopicConnection connection = null;
		TopicConnectionFactory connectionFactory = null;
		TopicPublisher publisher = null;
		TextMessage message = null;
		Topic Dest = null;
		TopicSession session = null;

		String sequence = "";
		int currentGame = 0;

		//Define a JNDI context and topic connection
		try {

			ctx = getLocalCxt();
			connectionFactory =
				(TopicConnectionFactory) ctx.lookup("ConnectionFactory");
			connection = connectionFactory.createTopicConnection();
			session =
				connection.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
			Dest = (Topic) ctx.lookup("topic/BingoTopic1");
			publisher = session.createPublisher(Dest);
		} catch (NamingException e1) {
			System.out.println("NamingException\n");
			System.out.println(e1.getExplanation());
			//System.exit(1);
		} catch (JMSException e2) {
			System.out.println("JMS Exception, ErrorCode:");
			System.out.println(e2.getErrorCode());
			//System.exit(1);
		}

		//Create a TextMessage holder			
		try {
			message = session.createTextMessage();
		} catch (JMSException e3) {
			System.out.println(
				"JMSException while creating TextMessageHolder, ErrorCode:\n");
			System.out.println(e3.getErrorCode());
			//System.exit(1);
		}
		while(1==1){
		
		currentGame = Wait(publisher, message, currentGame);

		sequence = Prepare(publisher, message, currentGame);

		Play(publisher, message, sequence, currentGame);
		currentGame = 0;
		if (1==0)
		break;
		}
		//Close connection to JMS
		if (connection != null) {
			try {
				connection.close();
			} catch (JMSException e1) {
				System.out.println("JMS Exception, ErrorCode:");
				System.out.println(e1.getErrorCode());
				//System.exit(1);
			}
		}

	}
	private void Play(
		TopicPublisher publisher,
		TextMessage message,
		String sequence,
		int currentGame) {
		int count = 1; //This is the counter for current draw
		String messageText = "";
		String currentMsg = "GID:" + currentGame + ";";
		try {
			while ((isGameStopped(currentGame) == false) && (count <= 100)) {
				messageText = currentMsg; //set current game head info
				messageText = messageText + "MID:" + count + ";";
				//set message ID info
				//Remove the first number and update the counter in the database
				messageText =
					messageText
						+ "DRAW:"
						+ sequence.substring(0, sequence.indexOf(","))
						+ ";";
				sequence =
					sequence.substring(
						sequence.indexOf(",") + 1,
						sequence.length());
				try {
					//Publish the message just generated.
					message.setText(messageText);
		
					publisher.publish(message);
					//Print out same message to standard output for
					//debugging purpose
					System.out.println("Sending message: " + message.getText());
		
					setCounter(count, currentGame);
					count++;
					Thread.sleep(1000);
				} catch (JMSException e1) {
					System.out.println("JMS Exception, ErrorCode:");
					System.out.println(e1.getErrorCode());
					//System.exit(1);
				} catch (InterruptedException e2) {
					System.out.println(
						"Sleep interrupted, continue execution.\n");
				} catch (Exception e3) {
					System.out.println(
						"Failed to store draw counter in DB, stopping...\n");
					try {
						message.setText("ERROR:DATABASE_ERROR;");
						publisher.publish(message);
					} catch (JMSException e) {
						System.out.println(
							"JMSException while creating TextMessageHolder, ErrorCode:\n");
						System.out.println(e.getErrorCode());
					}
					//System.exit(1);
				}
			}
		} catch (Exception e1) {
			try {
				message.setText("ERROR:DATABASE_ERROR;");
				publisher.publish(message);
			} catch (JMSException e) {
				System.out.println(
					"JMSException while creating TextMessageHolder, ErrorCode:\n");
				System.out.println(e.getErrorCode());
			}
			//System.exit(1);
		}
		
		try {
			if (isGameStopped(currentGame) == true) {
				messageText = currentMsg; //set current game head info
				messageText = messageText + "MID:0;DRAW:0;";
				//set message ID as 0, indicating the game is over
				try {
					//Publish the message just generated.
					message.setText(messageText);
					publisher.publish(message);
					//Print out same message to standard output 
					System.out.println("Sending message: " + message.getText());
				} catch (JMSException e1) {
					System.out.println("JMS Exception, ErrorCode:");
					System.out.println(e1.getErrorCode());
					//System.exit(1);
				}
			}
		} catch (Exception e1) {
			try {
				message.setText("ERROR:DATABASE_ERROR;");
				publisher.publish(message);
			} catch (JMSException e) {
				System.out.println(
					"JMSException while creating TextMessageHolder, ErrorCode:\n");
				System.out.println(e.getErrorCode());
			}
			//System.exit(1);
		}
		try {
			if (!isGameStopped(currentGame)) {
				BingoDB db = new BingoDB();
				db.StopGame(currentGame);
			}
		} catch (Exception e) {
		
		}
	}
	private String Prepare(
		TopicPublisher publisher,
		TextMessage message,
		int currentGame) {
		String sequence;
		//Create a pool of 100 balls in random sequence
		sequence = getRandomString(100, 100);
		//Store the sequence in the database
		try {
			storeSequence(sequence, currentGame);
		} catch (Exception e1) {
			try {
				message.setText("ERROR:DATABASE_ERROR;");
				publisher.publish(message);
				//System.exit(1);
			} catch (JMSException e) {
				System.out.println(
					"JMSException while creating TextMessageHolder, ErrorCode:\n");
				System.out.println(e.getErrorCode());
				//System.exit(1);
			}
		}
		return sequence;
	}
	private int Wait(
		TopicPublisher publisher,
		TextMessage message,
		int currentGame) {
		while (currentGame == 0) {
			try {
				currentGame = getCurrentGame();
				Thread.sleep(5000);
			} catch (InterruptedException e1) {
				System.out.println(
					"Sleep interrupted, ignore and continue execution.\n");
			} catch (Exception e2) {
				System.out.println(
					"Failed to get current game, HostServer stopping...\n");
				try {
					message.setText("ERROR:DATABASE_ERROR;");
					publisher.publish(message);
					//System.exit(1);
				} catch (JMSException e) {
					System.out.println(
						"JMSException while creating TextMessageHolder, ErrorCode:\n");
					System.out.println(e.getErrorCode());
					//System.exit(1);
				}
			}
		}
		return currentGame;
	}

	//	method to generate a new game ID
	// invalid game ID = 0
	private int getCurrentGame() throws Exception {
		BingoDB db = new BingoDB();
		return db.GetCurrentGame();
	}

	//Store this string into the database with current game ID
	//If encounter any exception updating database, program exits,
	private void storeSequence(String sequence, int currentGame)
		throws Exception {
		System.out.println("db.StoreSequence(sequence, currentGame);");
		BingoDB db = new BingoDB();
		db.StoreSequence(sequence, currentGame);
	}

	//Update ball counter in the database with current game ID
	//If encounter any exception updating database, program exits,
	private void setCounter(int count, int currentGame) throws Exception {
		BingoDB db = new BingoDB();
		db.SetCounter(count, currentGame);
	}

	//This method queries database to see if game is stopped, and 
	//return true if so.
	private boolean isGameStopped(int currentGame) throws Exception {
		BingoDB db = new BingoDB();
		return db.IsGameStopped(currentGame);
	}

	//This method takes two parameters, pool defines the size of pool,
	//and second parameter defines how many items will be pulled out of the 
	//pool.
	private String getRandomString(int pool, int candidates) {
		String result = "";
		Vector poolVec = new Vector(pool);
		//Generate a pool of numbers
		for (int i = 1; i <= pool; i++) {
			poolVec.addElement(new Integer(i));
		}
		//retrieve a number of candidates defined by "candidates"
		Random seed = new Random();
		for (int i = pool; i > pool - candidates; i--) {
			result = result + poolVec.remove(seed.nextInt(i)) + ",";
		}
		return result;
	}
	/**
	* @param name
	* @return
	* This is a "starter" call to invoke the ejbCreate() method 
	* @ejb.interface-method view-type = "remote"
	*/
	public String StartServer() {
		return "Server Started\n";
	}

	/*
	 * This method returns localJNDI Context, may differ
	 *  than what is defined by jndi.properties
	 */
	private Context getLocalCxt() throws NamingException {
		Hashtable props = new Hashtable();
		props.put(
			InitialContext.INITIAL_CONTEXT_FACTORY,
			"org.jnp.interfaces.NamingContextFactory");
		props.put(
			"java.naming.factory.url.pkgs",
			"org.jboss.naming:org.jnp.interfaces");
		props.put(InitialContext.PROVIDER_URL, "localhost:1099");
		return new InitialContext(props);

	}

}
