package bingo.server;
/*
 * Created on 06.02.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @author Alexander
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
import java.*;
import java.io.*;
import java.sql.*;

public class BingoDB {
	private java.sql.Connection con = null;
	private final String url = "jdbc:microsoft:sqlserver://";
	private final String serverName = "msepc21.sp.cs.cmu.edu";
	//msepc42.sp.cs.cmu.edu AlexB
	private final String portNumber = "1433";
	private final String databaseName = "Bingo";
	private final String userName = "sa";
	private final String password = "1234";
	// Informs the driver to use server a side-cursor,
	// which permits more than one active statement
	// on a connection.
	private final String selectMethod = "cursor";

	//	Constructor
	public BingoDB() {
	}

	private String getConnectionUrl() {
		String fullUrl = "";
		fullUrl =
			url
				+ serverName
				+ ":"
				+ portNumber
				+ ";databaseName="
				+ databaseName
				+ ";selectMethod="
				+ selectMethod
				+ ";";
		//String asd = getConnectionUrlFromFile();
		return fullUrl;
	}
	private String getConnectionUrlFromFile() {
		String url = "";
		try {
			String currentDirectory = System.getProperty("user.dir");
			System.out.println("user.dir: " + currentDirectory);

			BufferedReader br =
				new BufferedReader(new FileReader("connectionurl.txt"));

			url = br.readLine();
		} catch (Exception e) {
			e.printStackTrace();
			//System.out.println();

		}
		return url;
	}

	private java.sql.Connection getConnection() {
		try {
			Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
			con =
				java.sql.DriverManager.getConnection(
					getConnectionUrl(),
					userName,
					password);
			if (con != null)
				System.out.println("Connection Successful!");
		} catch (Exception e) {
			System.out.println("Database Connection Not Available");
			//e.printStackTrace();
			//System.out.println("Error Trace in getConnection() : " + e.getMessage());
		}
		return con;
	}
	private void closeConnection() {
		try {
			if (con != null)
				con.close();
			con = null;
		} catch (Exception e) {
			System.out.println("Failed to close connection!");
			e.printStackTrace();
		}
	}

	/** Deprecated
	 * @param playerID
	 * @return
	 */
	public int CreateGame(String playerID) {
		int gameID = 0;

		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"INSERT INTO Games(CreatedOn, CreatedBy, Started) VALUES (getdate(), ?, 1);SELECT @@IDENTITY");
				callstmt.setString(1, playerID);
				System.out.println("Batch statement successfully executed");
				callstmt.execute();

				int iUpdCount = callstmt.getUpdateCount();
				boolean bMoreResults = true;
				ResultSet rs = null;

				//While there are still more results or update counts
				//available, continue processing resultsets
				while (bMoreResults || iUpdCount != -1) {
					//NOTE: in order for output parameters to be available,
					//all resultsets must be processed

					rs = callstmt.getResultSet();

					//Use the following if using the batch statement instead of the stored procedure
					//if rs is not null, we know we can get the results from the SELECT @@IDENTITY

					if (rs != null) {
						rs.next();
						gameID = rs.getInt(1);
					}

					//get the next resultset, if there is one
					//this call also implicitly closes the previously obtained ResultSet
					bMoreResults = callstmt.getMoreResults();
					iUpdCount = callstmt.getUpdateCount();
				}

				System.out.println("@@IDENTITY is: " + gameID);
			}
		} catch (Exception e) {
			System.out.println("CreateGame Failed!");
			//e.printStackTrace();
		}
		return gameID;
	}
	
	/** Creates a guest player
	 * @return player ID
	 */
	public String CreateGuestPlayer() throws Exception{
		String playerID = null;
		java.sql.ResultSet rs = null;

		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"set nocount on;"
							+ "declare @newid uniqueidentifier; select @newid = NEWID();"
							+ "INSERT INTO GuestPlayers (PlayerID) VALUES (@newid);"
							+ "set nocount off;"
							+ "SELECT @newid");
				callstmt.execute();
				rs = callstmt.getResultSet();

				if (rs != null) {
					rs.next();
					playerID = rs.getObject(1).toString();
					System.out.print(
						"GUID: " + rs.getObject(1).toString() + " ");
				}

				rs.close();

				rs = null;
				closeConnection();
			} else
				System.out.println("Error: No active Connection");
		} catch (Exception e) {
			System.out.println("CreateGuestPlayer Failed!");
			//e.printStackTrace();
		}

		return playerID;

	}

	/** Checks if theere is an active game.If there is none, returns 0
	 * @return game ID
	 * @throws Exception
	 */
	public int GetCurrentGame() throws Exception {
		int gameID = 0;

		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"SET NOCOUNT ON;"
							+ "declare @gameID int;"
							+ "select @gameID = GameID from Games where started=1 and stoppedon is null;\n"
							+ "if @gameID is null\n"
							+ "select @gameID = 0;SET NOCOUNT OFF;select @gameID;");

				System.out.println("Batch statement successfully executed");
				callstmt.execute();

				int iUpdCount = callstmt.getUpdateCount();
				boolean bMoreResults = true;
				ResultSet rs = null;

				//While there are still more results or update counts
				//available, continue processing resultsets
				while (bMoreResults || iUpdCount != -1) {
					//NOTE: in order for output parameters to be available,
					//all resultsets must be processed

					rs = callstmt.getResultSet();

					//Use the following if using the batch statement instead of the stored procedure
					//if rs is not null, we know we can get the results from the SELECT @@IDENTITY

					if (rs != null) {
						rs.next();
						gameID = rs.getInt(1);
					}

					//get the next resultset, if there is one
					//this call also implicitly closes the previously obtained ResultSet
					bMoreResults = callstmt.getMoreResults();
					iUpdCount = callstmt.getUpdateCount();
				}

				System.out.println("Value is: " + gameID);
			}
		} catch (Exception e) {
			System.out.println("GetCurrentGame Failed!");
			//e.printStackTrace();
			throw e;
		}
		return gameID;
	}
	
	/** Checks if theere is an active game.If there is none, the method creates a new game
	 * @param playerID
	 * @return game ID
	 */
	public int GetCurrentGameOrCreate(String playerID) {
		int gameID = 0;

		try {
			con = this.getConnection();
			if (con != null) {
				String sql =
					"SET NOCOUNT ON;"
						+ "declare @gameID int;"
						+ "SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n"
						+ "BEGIN TRANSACTION;\n"
						+ "select @gameID = GameID from Games where started=1 and stoppedon is null;\n"
						+ "if @gameID is null\n"
						+ "begin\n"
						+ "INSERT INTO Games(CreatedOn, CreatedBy, Started) VALUES (getdate(), ?, 1);\n"
						+ "select @gameID = SCOPE_IDENTITY();\n"
						+ "end\n"
						+ "COMMIT\n"
						+ "SET NOCOUNT OFF;select @gameID;";

				CallableStatement callstmt = con.prepareCall(sql);

				callstmt.setString(1, playerID);

				callstmt.execute();
				System.out.println("Batch statement successfully executed");

				int iUpdCount = callstmt.getUpdateCount();
				boolean bMoreResults = true;
				ResultSet rs = null;

				//While there are still more results or update counts
				//available, continue processing resultsets
				while (bMoreResults || iUpdCount != -1) {
					//NOTE: in order for output parameters to be available,
					//all resultsets must be processed

					rs = callstmt.getResultSet();

					//Use the following if using the batch statement instead of the stored procedure
					//if rs is not null, we know we can get the results from the SELECT @@IDENTITY

					if (rs != null) {
						rs.next();
						gameID = rs.getInt(1);
					}

					//get the next resultset, if there is one
					//this call also implicitly closes the previously obtained ResultSet
					bMoreResults = callstmt.getMoreResults();
					iUpdCount = callstmt.getUpdateCount();
				}

				System.out.println("Current Game ID is: " + gameID);
			}
		} catch (Exception e) {
			System.out.println("GetCurrentGameOrCreate Failed!");
			//e.printStackTrace();
		}
		return gameID;

	}

	/** The method writes the draw sequence to the DB
	 * @param sequence
	 * @param currentGame
	 * @throws Exception
	 */
	public void StoreSequence(String sequence, int currentGame)
		throws Exception {

		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"INSERT INTO GameDraws(GameID, Draws, CurrentDraw, CreatedOn) VALUES (?, ?, 0, getdate());");
				callstmt.setInt(1, currentGame);
				callstmt.setString(2, sequence);
				
				callstmt.execute();
				closeConnection();
			} else
				System.out.println("Error: No active Connection");
		} catch (Exception e) {
			if (!con.isClosed())
				closeConnection();
			System.out.println("StoreSequence Failed!");
			e.printStackTrace();
			throw e;
		}
	}

	/** Stores the last draw index sent to clients
	 * @param count -- draw number
	 * @param currentGame current game
	 * @throws Exception
	 */
	public void SetCounter(int count, int currentGame) throws Exception {

		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"Update GameDraws SET CurrentDraw = ? WHERE GameID = ?;");
				callstmt.setInt(1, count);
				callstmt.setInt(2, currentGame);
				callstmt.execute();
				int iUpdCount = callstmt.getUpdateCount();
				closeConnection();
				if (iUpdCount == 0)
					throw new Exception("SetCounter: No Game Found!");
			} else
				System.out.println("Error: No active Connection");
		} catch (Exception e) {
			if (!con.isClosed())
				closeConnection();
			System.out.println("SetCounter Failed!");
			throw e;
		}
	}

	/** Determines if a game is stopped
	 * @param gameID
	 * @return
	 */
	public boolean IsGameStopped(int gameID) throws Exception {
		boolean stopped = false;

		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"SET NOCOUNT ON;"
							+ "declare @gameID int;"
							+ "select @gameID = GameID from Games where GameID = ? and started=1 and stoppedon is not null;\n"
							+ "if @gameID is null\n"
							+ "select @gameID = 0;SET NOCOUNT OFF;select @gameID;");
				callstmt.setInt(1, gameID);

				callstmt.execute();
				System.out.println("Batch statement successfully executed");

				int iUpdCount = callstmt.getUpdateCount();
				boolean bMoreResults = true;
				ResultSet rs = null;

				//While there are still more results or update counts
				//available, continue processing resultsets
				while (bMoreResults || iUpdCount != -1) {
					//NOTE: in order for output parameters to be available,
					//all resultsets must be processed

					rs = callstmt.getResultSet();

					//Use the following if using the batch statement instead of the stored procedure
					//if rs is not null, we know we can get the results from the SELECT @@IDENTITY

					if (rs != null) {
						rs.next();
						int tempGameID = rs.getInt(1);
						if (tempGameID > 0)
							stopped = true;
					}

					//get the next resultset, if there is one
					//this call also implicitly closes the previously obtained ResultSet
					bMoreResults = callstmt.getMoreResults();
					iUpdCount = callstmt.getUpdateCount();
				}

			}
		} catch (Exception e) {
			if (!con.isClosed())
				closeConnection();
			System.out.println("IsGameStopped Failed!");
			//e.printStackTrace();
			throw e;
		}
		return stopped;

	}
	
	/** Stores the card of the player
	 * @param gameID
	 * @param playerID
	 * @param card
	 * @throws Exception
	 */
	public void SetCard(int gameID, String playerID, String card)
		throws Exception {

		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"INSERT INTO GameCards(GameID, PlayerID, CardNumbers) VALUES (?, ?, ?);");
				callstmt.setInt(1, gameID);
				callstmt.setString(2, playerID);
				callstmt.setString(3, card);
				callstmt.execute();
				closeConnection();
			} else
				System.out.println("Error: No active Connection");
		} catch (Exception e) {
			if (!con.isClosed())
				closeConnection();
			System.out.println("SetCard Failed!");
			throw e;
		}
	}

	/** Returns the game card of the player
	 * @param gameID
	 * @param playerID
	 * @return
	 */
	public String GetCard(int gameID, String playerID) {
		String card = null;

		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"SET NOCOUNT ON;declare @CardNumbers varchar(200);"
							+ "select @CardNumbers = CardNumbers from GameCards where GameID=? and PlayerID = ?;\n"
							+ "SET NOCOUNT OFF;"
							+ "select @CardNumbers");

				callstmt.setInt(1, gameID);
				callstmt.setString(2, playerID);
				callstmt.execute();
				System.out.println("Batch statement successfully executed");

				int iUpdCount = callstmt.getUpdateCount();
				boolean bMoreResults = true;
				ResultSet rs = null;

				//While there are still more results or update counts
				//available, continue processing resultsets
				while (bMoreResults || iUpdCount != -1) {
					//NOTE: in order for output parameters to be available,
					//all resultsets must be processed

					rs = callstmt.getResultSet();

					//Use the following if using the batch statement instead of the stored procedure
					//if rs is not null, we know we can get the results from the SELECT @@IDENTITY

					if (rs != null) {
						rs.next();
						card = rs.getString(1);
					}

					//get the next resultset, if there is one
					//this call also implicitly closes the previously obtained ResultSet
					bMoreResults = callstmt.getMoreResults();
					iUpdCount = callstmt.getUpdateCount();
				}

			}
		} catch (Exception e) {
			System.out.println("GetCard Failed!");
			//e.printStackTrace();
		}
		return card;
	}
	
	/** Returns the draws of the game stored by  StoreSequence method
	 * @param gameID
	 * @return
	 */
	public String GetDraws(int gameID) {
		String draws = null;

		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"SET NOCOUNT ON;declare @Draws varchar(550);"
							+ "select @Draws = Draws from GameDraws where GameID=?;\n"
							+ "SET NOCOUNT OFF;"
							+ "select @Draws");

				callstmt.setInt(1, gameID);

				callstmt.execute();
				System.out.println("Batch statement successfully executed");

				int iUpdCount = callstmt.getUpdateCount();
				boolean bMoreResults = true;
				ResultSet rs = null;

				//While there are still more results or update counts
				//available, continue processing resultsets
				while (bMoreResults || iUpdCount != -1) {
					//NOTE: in order for output parameters to be available,
					//all resultsets must be processed

					rs = callstmt.getResultSet();

					//Use the following if using the batch statement instead of the stored procedure
					//if rs is not null, we know we can get the results from the SELECT @@IDENTITY

					if (rs != null) {
						rs.next();
						draws = rs.getString(1);
						
						if (draws==null)
						draws="";
					}

					//get the next resultset, if there is one
					//this call also implicitly closes the previously obtained ResultSet
					bMoreResults = callstmt.getMoreResults();
					iUpdCount = callstmt.getUpdateCount();
				}

			}
		} catch (Exception e) {
			
			System.out.println("GetDraws Failed!");
			//e.printStackTrace();
		}
		return draws;
	}

	/** Returns the current draw index, set by SetCounter method
	 * @param gameID
	 * @return
	 */
	public int GetCurrentDraw(int gameID) {
		int draw = 0;

		try {
			con = this.getConnection();
			if (con != null) {
				String sql =
					"SET NOCOUNT ON;declare @Draw int;"
						+ "select @Draw = CurrentDraw from GameDraws where GameID=?;\n"
						+ "SET NOCOUNT OFF;"
						+ "select @Draw";

				CallableStatement callstmt = con.prepareCall(sql);

				callstmt.setInt(1, gameID);

				callstmt.execute();
				System.out.println("Batch statement successfully executed");

				int iUpdCount = callstmt.getUpdateCount();
				boolean bMoreResults = true;
				ResultSet rs = null;

				//While there are still more results or update counts
				//available, continue processing resultsets
				while (bMoreResults || iUpdCount != -1) {
					//NOTE: in order for output parameters to be available,
					//all resultsets must be processed

					rs = callstmt.getResultSet();

					//Use the following if using the batch statement instead of the stored procedure
					//if rs is not null, we know we can get the results from the SELECT @@IDENTITY

					if (rs != null) {
						rs.next();
						Object temp = rs.getObject(1);
						if (temp!=null)
							draw = rs.getInt(1);
						else
							draw=0;
					}

					//get the next resultset, if there is one
					//this call also implicitly closes the previously obtained ResultSet
					bMoreResults = callstmt.getMoreResults();
					iUpdCount = callstmt.getUpdateCount();
				}

			}
		} catch (Exception e) {
			draw=-1;
			System.out.println("GetCurrentDraw Failed!");
			//e.printStackTrace();
		}
		return draw;

	}
	
	/** Sets the winner of the game and stops the game
	 * @param gameID
	 * @param playerID
	 * @return
	 * @throws Exception
	 */
	public boolean SetWinner(int gameID, String playerID) throws Exception {
		boolean ok = false;
		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"INSERT INTO Winners(GameID, PlayerID) VALUES (?, ?);SELECT @@ROWCOUNT;"
							+ "SET NOCOUNT ON;"
							+ "UPDATE Games SET StoppedOn = getdate() WHERE GameID=?;"
							+ "SET NOCOUNT OFF;");
				callstmt.setInt(1, gameID);
				callstmt.setString(2, playerID);
				callstmt.setInt(3, gameID);

				callstmt.execute();
				int iUpdCount = callstmt.getUpdateCount();
				boolean bMoreResults = true;
				ResultSet rs = null;

				//While there are still more results or update counts
				//available, continue processing resultsets
				while (bMoreResults || iUpdCount != -1) {
					//NOTE: in order for output parameters to be available,
					//all resultsets must be processed

					rs = callstmt.getResultSet();

					//Use the following if using the batch statement instead of the stored procedure
					//if rs is not null, we know we can get the results from the SELECT @@IDENTITY

					if (rs != null) {
						rs.next();
						int recsaffected = rs.getInt(1);
						if (recsaffected > 0)
							ok = true;
					}

					//get the next resultset, if there is one
					//this call also implicitly closes the previously obtained ResultSet
					bMoreResults = callstmt.getMoreResults();
					iUpdCount = callstmt.getUpdateCount();
				}

			}
		} catch (Exception e) {
			if (!con.isClosed())
							closeConnection();
			System.out.println("SetWinner Failed!");
			throw e;
			//e.printStackTrace();
		}
		return ok;
	}

	/** Stops the game
	 * @param gameID
	 * @throws Exception
	 */
	public void StopGame(int gameID) throws Exception {
		
		try {
			con = this.getConnection();
			if (con != null) {
				CallableStatement callstmt =
					con.prepareCall(
						"UPDATE Games SET StoppedOn = getdate() WHERE GameID=?;");
				callstmt.setInt(1, gameID);
				callstmt.execute();
				closeConnection();
			} else
				System.out.println("Error: No active Connection");
		} catch (Exception e) {
			if (!con.isClosed())
				closeConnection();
			System.out.println("StopGame Failed!");
			throw e;
		}
	}

}
