/*
 * Created on 12.02.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package bingo.server; 

// AnsweringServerBean.java
//
// Last modified by Lawrence Bubba Beasley, 2/13/04

import java.rmi.RemoteException;
import java.util.*;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;
import javax.jms.*;
import javax.naming.*;
import javax.jms.Session;
import javax.jms.Connection;
import javax.jms.TextMessage;


/**
 * @author Bubba
 *
 * @ejb.bean name = "AnsweringServer"
 *           type = "Stateless"
 * 			 display-name = "Answering Server"
 *			 description = "come on"
 *			 view-type = "remote"
 *			 jndi-name = "server/bingo/AnsweringServer"
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

public class AnsweringServerBean implements SessionBean {

  public AnsweringServerBean() {
    super();

    // TODO further constructor procedures, if necessary

  }
  
  /* (non-Javadoc)
	   * @see javax.ejb.SessionBean#ejbActivate()
	   */
	  public void ejbActivate() throws EJBException, RemoteException {
		  // TODO Auto-generated method stub

	  }

	  /* (non-Javadoc)
	   * @see javax.ejb.SessionBean#ejbPassivate()
	   */
	  public void ejbPassivate() throws EJBException, RemoteException {
		  // TODO Auto-generated method stub

	  }

	  /* (non-Javadoc)
	   * @see javax.ejb.SessionBean#ejbRemove()
	   */
	  public void ejbRemove() throws EJBException, RemoteException {
		  // TODO Auto-generated method stub

	  }
	/* (non-Javadoc)
		 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
		 */
		public void setSessionContext(SessionContext arg0)
			throws EJBException, RemoteException {
			// TODO Auto-generated method stub

		}
	
		/**
			 * default create method
			 * @throws CreateException
			 * ejb.create-method
		*/
		public void ejbCreate() throws CreateException {}
	
	/**
	* @param name
	* @return
	* Client calls this method to join a new game
	* @ejb.interface-method view-type = "remote"
	*/
	public String Join() throws AnsweringServerException {

	 // Variable declarations and initializations.

	 String playerID = "";

	 int gameID = 0;

	 String card = "";

	 int cardArray[] = new int[25];
	 Random randomizer = new Random();
	 int a, b, c, d, e = 0;

	 boolean cardBool = false;

	 String draws = "";
	 int currentDraw = 0;

	 StringTokenizer drawToken;
	 String recentDraws = "";
 
	 String returnString = "";


	 // Get the PlayerID and GameID.

	 playerID = SetAndGetPlayerID();
         if (playerID == null) 
           throw new 
             AnsweringServerException("Database failure: SetAndGetPlayerID()");

	 gameID = GetAndPossiblySetGameID(playerID);
         if (gameID == 0)
           throw new
             AnsweringServerException("Database failure: GetAndPossiblySetGameID()");


	 // Create the array of randomly drawn numbers for the Bingo card.

	 for(int i=0; i<=4; i++) {

	   a = randomizer.nextInt(20) + 1;

	   b = a;
	   while (b == a)
		 b = randomizer.nextInt(20) + 1;

	   c = a;
	   while ((c == a) || (c == b))
		 c = randomizer.nextInt(20) + 1;

	   d = a;
	   while ((d == a) || (d == b) || (d == c))
		 d = randomizer.nextInt(20) + 1;

	   e = a;
	   while ((e == a) || (e == b) || (e == c) || (e == d))
		 e = randomizer.nextInt(20) + 1;
   
	   cardArray[5*i]     = 20*i + a;
	   cardArray[5*i + 1] = 20*i + b;
	   cardArray[5*i + 2] = 20*i + c;
	   cardArray[5*i + 3] = 20*i + d;
	   cardArray[5*i + 4] = 20*i + e;
	 }

	 //  Change the N3 spot on the Bingo card's array to 0.

	 cardArray[12] = 0;


	 //  Store the final version of the array in the string and database.

	 for(int i=0; i<=24; i++)
	   card = card + cardArray[i] + ",";

	 cardBool = SetCard(gameID, playerID, card);
         if (cardBool == false)
           throw new
             AnsweringServerException("Database failure: SetCard()");


	 //  Retrieve draws, currentDraw from the database.

	 draws = GetDraws(gameID);
         if (draws == null)
           throw new
             AnsweringServerException("Database failure: GetDraws()");


	 currentDraw = GetCurrentDraw(gameID);
         
         if (currentDraw == -1){
			throw new
			  AnsweringServerException("Database failure: GetCurrentDraw()");
			
         }


	 //  Parse out the first N draws, where N is the currentDraw.
 
	 drawToken = new StringTokenizer(draws, ",", false);

	 for(int i=0; i<currentDraw; i++){

	   if (drawToken.hasMoreTokens() == true)
             try{
               recentDraws = recentDraws + drawToken.nextToken() + ",";
             }
             catch (NoSuchElementException e1){
               //e1.printStackTrace();
             }
	 }

	 // Create final string, return.

	 returnString = "PlayerID:" + playerID + ";";
	 returnString = returnString + "GameID:" + gameID + ";";
	 returnString = returnString + "Card:" + card + ";";
	 returnString = returnString + "Draws:" + recentDraws + ";";

	 return returnString;
   }
   /**
	   * @param name
	   * @return
	   * 
	   * @ejb.interface-method view-type = "remote"
	   */
   public String GetSnapshot() throws AnsweringServerException {

	 // Variable declarations and initializations.

	 int gameID = 0;

	 String draws = "";
	 int currentDraw = 0;

	 StringTokenizer drawToken;
	 String recentDraws = "";

	 String returnString = "";


	 // Get the current GameID.

	 gameID = GetOldGameID();
         if (gameID == 0)
           throw new
             AnsweringServerException("Database failure: GetOldGameID()");


	 //  Retrieve draws, currentDraw from the database.

	 draws = GetDraws(gameID);
         if (draws == null)
           throw new
             AnsweringServerException("Database failure: GetDraws()");

	 currentDraw = GetCurrentDraw(gameID);
         if (currentDraw == -1)
           throw new
             AnsweringServerException("Database failure: GetCurrentDraw()");


	 //  Parse out the first N draws, where N is the currentDraw

	 drawToken = new StringTokenizer(draws, ",", false);

	 for(int i=0; i<currentDraw; i++){

	   if (drawToken.hasMoreTokens() == true)
             try{
               recentDraws = recentDraws + drawToken.nextToken() + ",";
             }
             catch (NoSuchElementException e){
               e.printStackTrace();
             }

	 }

	 // Create final string, return.

	 returnString = "Draws:" + recentDraws + ";";

	 return returnString;

   }
   /**
		* @param name
		* @return
		* 
		* @ejb.interface-method view-type = "remote"
		*/
   public int GetGameID(){

	 return GetOldGameID();

   }


   // The following function has this encoding for its return value:
   //   0 = no bingo
   //   1 = bingo, but not a winner (too late)
   //   2 = bingo and winner!

   /**
		* @param name
		* @return
		* 
		* @ejb.interface-method view-type = "remote"
		*/
   public int DeclareBingo(int gameID, String playerID) throws AnsweringServerException, NoSuchElementException {

	 // Variable declarations and initializations.
	
	
	 String draws = "";
	 int currentDraw = 0;

	 StringTokenizer drawToken;

	 int drawArray[] = new int[100];
	 int drawIndex;

	 String card = "";

	 StringTokenizer cardToken;

	 int cardArray[] = new int[25];

	 int markArray[] = new int[25];

	 int columnIndex = 0;

	 int tempSum = 0;
	 boolean hasBingo = false;

	 boolean isWinner = false;

	 int returnInt = 0;


	 //  Retrieve draws, currentDraw from the database.

	 draws = GetDraws(gameID);
         if (draws == null)
           throw new
             AnsweringServerException("Database failure: GetDraws()");

	
	
	 currentDraw = GetCurrentDraw(gameID);
         if (currentDraw == -1)
           throw new
             AnsweringServerException("Database failure: GetCurrentDraw()");

	

	 //  Parse out the first N draws, where N is the currentDraw
	 //  Save the draws in the drawArray.

	 drawToken = new StringTokenizer(draws, ",", false);
	 drawIndex = 0;

	 for(int i=0; i<currentDraw; i++){

	   if (drawToken.hasMoreTokens() == true){
		 drawIndex = i;
                 try{
		   drawArray[i] = Integer.parseInt(drawToken.nextToken());
                 }
                 catch (NoSuchElementException e){
                   throw e;
                 }
	   }

	 }

	System.out.println("point 1");
	 //  Retrieve the card from the database.

	 card = GetCard(gameID, playerID);


	 //  Parse out the 25 card values and save them in cardArray.

	 cardToken = new StringTokenizer(card, ",", false);

	 for(int i=0; i<25; i++){

	   if (drawToken.hasMoreTokens() == true)
                 try{
                   cardArray[i] = Integer.parseInt(cardToken.nextToken());
                 }
                 catch (NoSuchElementException  e){
                   e.printStackTrace();
                 }		 

	 }

	 // Initialize the markArray.

	 for(int i=0; i<25; i++)
	   markArray[i] = 0;

	 markArray[12] = 1; // Free spot in the center.


	 // If an element in the drawArray is in the cardArray,
	 // mark the corresponding element in markArray.

	 for(int i=0; i<=drawIndex; i++){

	   columnIndex = (drawArray[i] - 1) / 20;

	   for(int j=0; j<=4; j++){
		 if (drawArray[i] == cardArray[(5*columnIndex) + j])
		   markArray[(5*columnIndex) + j] = 1;
	   }
	 }

	System.out.println("point 2");
	 // Check the rows, columns, and major diagonals of markArray.
	 // Set hasBingo to true if any of them sum to 5.

	 hasBingo = false;

	 // Columns.

	 for(int i=0; i<=4; i++){

	   tempSum = 0;

	   for(int j=0; j<=4; j++)
		 tempSum = tempSum + markArray[5*i + j];

	   if(tempSum == 5)
		 hasBingo = true;
	 }
	System.out.println("point 3");
	 // Rows.

	 for(int i=0; i<=4; i++){

	   tempSum = 0;

	   for(int j=0; j<=4; j++)
		 tempSum = tempSum + markArray[i + 5*j];

	   if(tempSum == 5)
		 hasBingo = true;
	 }
	System.out.println("point 4");
	 // Diagonals.

	 tempSum = markArray[0] + markArray[6] + markArray[12] +
				 markArray[18] + markArray[24];

	 if(tempSum == 5)
	   hasBingo = true;


	 tempSum = markArray[4] + markArray[8] + markArray[12] +
				 markArray[16] + markArray[20];

	 if(tempSum == 5)
	   hasBingo = true;

	System.out.println("point 5");
	 //  If hasBingo is true, try to register the winner.
	 //  If someone else has already won, set isWinner to false.

	 isWinner = false;

	 if(hasBingo == true)
	   try {
		isWinner = SetWinner(gameID, playerID);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
                        throw new
                         AnsweringServerException("Database failure: SetWinner()");
		}


	 //  Determine what integer to return and return it.

	 if(hasBingo == false)
	   returnInt = 0;
	 else{

	   if(isWinner == false)
		 returnInt = 1;
	   else
		 returnInt = 2;
	 }

	 return returnInt;

   }


   
   /** null is returned if the call to the database fails
 	* @return PlayerID
 	*/
   private String SetAndGetPlayerID() {

	 String localPlayerID = null;

	 BingoDB db = new BingoDB();
	 try {
		localPlayerID = db.CreateGuestPlayer();
	} catch (Exception e) {
		
	}
	 

	 return localPlayerID;
   }

   /** 0 is returned if the call to the database fails 
	 * @param playerID
	 * @return GameID
	 */
	private int GetAndPossiblySetGameID(String playerID) {

		int localGameID = 0;

		BingoDB db = new BingoDB();
		localGameID = db.GetCurrentGameOrCreate(playerID);

	 	return localGameID;
   }

   /** 0 is returned if the call to the database fails 
	 * @return GameID
	 */
	private int GetOldGameID() {

	 int localGameID = 0;

		BingoDB db = new BingoDB();
		try {
			localGameID = db.GetCurrentGame();
		} catch (Exception e) {
			
		}

	 return localGameID;
   }

   /** false is returned if the call to the database fails
 * @param gameID
 * @param playerID
 * @param card
 * @return
 */
private boolean SetCard(int gameID, String playerID, String card) {

	 boolean returnBool = false;

	BingoDB db = new BingoDB();

	 try {
		db.SetCard(gameID, playerID, card);
		returnBool = true;
	} catch (Exception e) {
		// SetCard failed
	}

	 return returnBool;
   }

   /** null is returned if the call to the database fails
 * @param gameID
 * @param playerID
 * @return
 */
private String GetCard(int gameID, String playerID) {

	 String localCard = "";

	BingoDB db = new BingoDB();
	localCard = db.GetCard(gameID, playerID);

	 return localCard;
   }

   /** null is returned if the call to the database fails
 * @param gameID
 * @return
 */
private String GetDraws(int gameID) {

	 String localDraws = "";

	BingoDB db = new BingoDB();
	localDraws = db.GetDraws(gameID);

	 return localDraws;
   }

   /** -1 is returned if the call to the database fails
 * @param gameID
 * @return
 */
private int GetCurrentDraw(int gameID) {

	 int localCurrentDraw = 0;

	BingoDB db = new BingoDB();
	localCurrentDraw = db.GetCurrentDraw(gameID);

	 return localCurrentDraw;
   }

   private boolean SetWinner(int gameID, String playerID) throws Exception {

	 boolean returnBool = false;

	 // if there's no match with gameID and Winners.GameID
	 //   - create a new Winners entry with the parameters above
	 //   - set returnBool to true
	 // else (if there's already an entry)
	 //   - do nothing (keep returnBool false)
	 // or if the call fails, it returns false

	BingoDB db = new BingoDB();
	returnBool = db.SetWinner(gameID, playerID);
	 return returnBool;

   }

 }
