/*
 * Decompiled with CFR 0.152.
 */
package bingo.server;

import bingo.server.BingoDB;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HostServerBean
implements SessionBean {
    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
    }

    public void ejbCreate() throws CreateException {
        TopicConnection connection = null;
        TopicConnectionFactory connectionFactory = null;
        TopicPublisher publisher = null;
        TextMessage message = null;
        Topic Dest = null;
        TopicSession session = null;
        String sequence = "";
        int currentGame = 0;
        try {
            Context ctx = this.getLocalCxt();
            connectionFactory = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            connection = connectionFactory.createTopicConnection();
            session = connection.createTopicSession(false, 1);
            Dest = (Topic)ctx.lookup("topic/BingoTopic1");
            publisher = session.createPublisher(Dest);
        }
        catch (NamingException e1) {
            System.out.println("NamingException\n");
            System.out.println(e1.getExplanation());
        }
        catch (JMSException e2) {
            System.out.println("JMS Exception, ErrorCode:");
            System.out.println(e2.getErrorCode());
        }
        try {
            message = session.createTextMessage();
        }
        catch (JMSException e3) {
            System.out.println("JMSException while creating TextMessageHolder, ErrorCode:\n");
            System.out.println(e3.getErrorCode());
        }
        while (true) {
            currentGame = this.Wait(publisher, message, currentGame);
            sequence = this.Prepare(publisher, message, currentGame);
            this.Play(publisher, message, sequence, currentGame);
            currentGame = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void Play(TopicPublisher publisher, TextMessage message, String sequence, int currentGame) {
        int count = 1;
        String messageText = "";
        String currentMsg = "GID:" + currentGame + ";";
        try {
            while (!this.isGameStopped(currentGame) && count <= 100) {
                messageText = currentMsg;
                messageText = String.valueOf(messageText) + "MID:" + count + ";";
                messageText = String.valueOf(messageText) + "DRAW:" + sequence.substring(0, sequence.indexOf(",")) + ";";
                sequence = sequence.substring(sequence.indexOf(",") + 1, sequence.length());
                try {
                    message.setText(messageText);
                    publisher.publish((Message)message);
                    System.out.println("Sending message: " + message.getText());
                    this.setCounter(count, currentGame);
                    ++count;
                    Thread.sleep(1000L);
                }
                catch (JMSException e1) {
                    System.out.println("JMS Exception, ErrorCode:");
                    System.out.println(e1.getErrorCode());
                }
                catch (InterruptedException e2) {
                    System.out.println("Sleep interrupted, continue execution.\n");
                }
                catch (Exception e3) {
                    System.out.println("Failed to store draw counter in DB, stopping...\n");
                    try {
                        message.setText("ERROR:DATABASE_ERROR;");
                        publisher.publish((Message)message);
                    }
                    catch (JMSException e) {
                        System.out.println("JMSException while creating TextMessageHolder, ErrorCode:\n");
                        System.out.println(e.getErrorCode());
                    }
                }
            }
        }
        catch (Exception e1) {
            try {
                message.setText("ERROR:DATABASE_ERROR;");
                publisher.publish((Message)message);
            }
            catch (JMSException e) {
                System.out.println("JMSException while creating TextMessageHolder, ErrorCode:\n");
                System.out.println(e.getErrorCode());
            }
        }
        try {
            if (this.isGameStopped(currentGame)) {
                messageText = currentMsg;
                messageText = String.valueOf(messageText) + "MID:0;DRAW:0;";
                try {
                    message.setText(messageText);
                    publisher.publish((Message)message);
                    System.out.println("Sending message: " + message.getText());
                }
                catch (JMSException e1) {
                    System.out.println("JMS Exception, ErrorCode:");
                    System.out.println(e1.getErrorCode());
                }
            }
        }
        catch (Exception e1) {
            try {
                message.setText("ERROR:DATABASE_ERROR;");
                publisher.publish((Message)message);
            }
            catch (JMSException e) {
                System.out.println("JMSException while creating TextMessageHolder, ErrorCode:\n");
                System.out.println(e.getErrorCode());
            }
        }
        try {
            if (this.isGameStopped(currentGame)) return;
            BingoDB db = new BingoDB();
            db.StopGame(currentGame);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String Prepare(TopicPublisher publisher, TextMessage message, int currentGame) {
        String sequence = this.getRandomString(100, 100);
        try {
            this.storeSequence(sequence, currentGame);
        }
        catch (Exception e1) {
            try {
                message.setText("ERROR:DATABASE_ERROR;");
                publisher.publish((Message)message);
            }
            catch (JMSException e) {
                System.out.println("JMSException while creating TextMessageHolder, ErrorCode:\n");
                System.out.println(e.getErrorCode());
            }
        }
        return sequence;
    }

    private int Wait(TopicPublisher publisher, TextMessage message, int currentGame) {
        while (currentGame == 0) {
            try {
                currentGame = this.getCurrentGame();
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                System.out.println("Sleep interrupted, ignore and continue execution.\n");
            }
            catch (Exception e2) {
                System.out.println("Failed to get current game, HostServer stopping...\n");
                try {
                    message.setText("ERROR:DATABASE_ERROR;");
                    publisher.publish((Message)message);
                }
                catch (JMSException e) {
                    System.out.println("JMSException while creating TextMessageHolder, ErrorCode:\n");
                    System.out.println(e.getErrorCode());
                }
            }
        }
        return currentGame;
    }

    private int getCurrentGame() throws Exception {
        BingoDB db = new BingoDB();
        return db.GetCurrentGame();
    }

    private void storeSequence(String sequence, int currentGame) throws Exception {
        System.out.println("db.StoreSequence(sequence, currentGame);");
        BingoDB db = new BingoDB();
        db.StoreSequence(sequence, currentGame);
    }

    private void setCounter(int count, int currentGame) throws Exception {
        BingoDB db = new BingoDB();
        db.SetCounter(count, currentGame);
    }

    private boolean isGameStopped(int currentGame) throws Exception {
        BingoDB db = new BingoDB();
        return db.IsGameStopped(currentGame);
    }

    private String getRandomString(int pool, int candidates) {
        String result = "";
        Vector<Integer> poolVec = new Vector<Integer>(pool);
        int i = 1;
        while (i <= pool) {
            poolVec.addElement(new Integer(i));
            ++i;
        }
        Random seed = new Random();
        int i2 = pool;
        while (i2 > pool - candidates) {
            result = String.valueOf(result) + poolVec.remove(seed.nextInt(i2)) + ",";
            --i2;
        }
        return result;
    }

    public String StartServer() {
        return "Server Started\n";
    }

    private Context getLocalCxt() throws NamingException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        props.put("java.naming.provider.url", "localhost:1099");
        return new InitialContext(props);
    }
}

