/*
 * Decompiled with CFR 0.152.
 */
package bingo.server;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;

public class BingoDB {
    private Connection con = null;
    private final String url = "jdbc:microsoft:sqlserver://";
    private final String serverName = "msepc21.sp.cs.cmu.edu";
    private final String portNumber = "1433";
    private final String databaseName = "Bingo";
    private final String userName = "sa";
    private final String password = "1234";
    private final String selectMethod = "cursor";

    private String getConnectionUrl() {
        String fullUrl = "";
        fullUrl = "jdbc:microsoft:sqlserver://msepc21.sp.cs.cmu.edu:1433;databaseName=Bingo;selectMethod=cursor;";
        return fullUrl;
    }

    private String getConnectionUrlFromFile() {
        String url = "";
        try {
            String currentDirectory = System.getProperty("user.dir");
            System.out.println("user.dir: " + currentDirectory);
            BufferedReader br = new BufferedReader(new FileReader("connectionurl.txt"));
            url = br.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    private Connection getConnection() {
        try {
            Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            this.con = DriverManager.getConnection(this.getConnectionUrl(), "sa", "1234");
            if (this.con != null) {
                System.out.println("Connection Successful!");
            }
        }
        catch (Exception e) {
            System.out.println("Database Connection Not Available");
        }
        return this.con;
    }

    private void closeConnection() {
        try {
            if (this.con != null) {
                this.con.close();
            }
            this.con = null;
        }
        catch (Exception e) {
            System.out.println("Failed to close connection!");
            e.printStackTrace();
        }
    }

    public int CreateGame(String playerID) {
        int gameID = 0;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("INSERT INTO Games(CreatedOn, CreatedBy, Started) VALUES (getdate(), ?, 1);SELECT @@IDENTITY");
                callstmt.setString(1, playerID);
                System.out.println("Batch statement successfully executed");
                callstmt.execute();
                int iUpdCount = callstmt.getUpdateCount();
                boolean bMoreResults = true;
                ResultSet rs = null;
                while (bMoreResults || iUpdCount != -1) {
                    rs = callstmt.getResultSet();
                    if (rs != null) {
                        rs.next();
                        gameID = rs.getInt(1);
                    }
                    bMoreResults = callstmt.getMoreResults();
                    iUpdCount = callstmt.getUpdateCount();
                }
                System.out.println("@@IDENTITY is: " + gameID);
            }
        }
        catch (Exception e) {
            System.out.println("CreateGame Failed!");
        }
        return gameID;
    }

    public String CreateGuestPlayer() throws Exception {
        String playerID = null;
        ResultSet rs = null;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("set nocount on;declare @newid uniqueidentifier; select @newid = NEWID();INSERT INTO GuestPlayers (PlayerID) VALUES (@newid);set nocount off;SELECT @newid");
                callstmt.execute();
                rs = callstmt.getResultSet();
                if (rs != null) {
                    rs.next();
                    playerID = rs.getObject(1).toString();
                    System.out.print("GUID: " + rs.getObject(1).toString() + " ");
                }
                rs.close();
                rs = null;
                this.closeConnection();
            } else {
                System.out.println("Error: No active Connection");
            }
        }
        catch (Exception e) {
            System.out.println("CreateGuestPlayer Failed!");
        }
        return playerID;
    }

    public int GetCurrentGame() throws Exception {
        int gameID = 0;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("SET NOCOUNT ON;declare @gameID int;select @gameID = GameID from Games where started=1 and stoppedon is null;\nif @gameID is null\nselect @gameID = 0;SET NOCOUNT OFF;select @gameID;");
                System.out.println("Batch statement successfully executed");
                callstmt.execute();
                int iUpdCount = callstmt.getUpdateCount();
                boolean bMoreResults = true;
                ResultSet rs = null;
                while (bMoreResults || iUpdCount != -1) {
                    rs = callstmt.getResultSet();
                    if (rs != null) {
                        rs.next();
                        gameID = rs.getInt(1);
                    }
                    bMoreResults = callstmt.getMoreResults();
                    iUpdCount = callstmt.getUpdateCount();
                }
                System.out.println("Value is: " + gameID);
            }
        }
        catch (Exception e) {
            System.out.println("GetCurrentGame Failed!");
            throw e;
        }
        return gameID;
    }

    public int GetCurrentGameOrCreate(String playerID) {
        int gameID = 0;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                String sql = "SET NOCOUNT ON;declare @gameID int;SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nBEGIN TRANSACTION;\nselect @gameID = GameID from Games where started=1 and stoppedon is null;\nif @gameID is null\nbegin\nINSERT INTO Games(CreatedOn, CreatedBy, Started) VALUES (getdate(), ?, 1);\nselect @gameID = SCOPE_IDENTITY();\nend\nCOMMIT\nSET NOCOUNT OFF;select @gameID;";
                CallableStatement callstmt = this.con.prepareCall(sql);
                callstmt.setString(1, playerID);
                callstmt.execute();
                System.out.println("Batch statement successfully executed");
                int iUpdCount = callstmt.getUpdateCount();
                boolean bMoreResults = true;
                ResultSet rs = null;
                while (bMoreResults || iUpdCount != -1) {
                    rs = callstmt.getResultSet();
                    if (rs != null) {
                        rs.next();
                        gameID = rs.getInt(1);
                    }
                    bMoreResults = callstmt.getMoreResults();
                    iUpdCount = callstmt.getUpdateCount();
                }
                System.out.println("Current Game ID is: " + gameID);
            }
        }
        catch (Exception e) {
            System.out.println("GetCurrentGameOrCreate Failed!");
        }
        return gameID;
    }

    public void StoreSequence(String sequence, int currentGame) throws Exception {
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("INSERT INTO GameDraws(GameID, Draws, CurrentDraw, CreatedOn) VALUES (?, ?, 0, getdate());");
                callstmt.setInt(1, currentGame);
                callstmt.setString(2, sequence);
                callstmt.execute();
                this.closeConnection();
            } else {
                System.out.println("Error: No active Connection");
            }
        }
        catch (Exception e) {
            if (!this.con.isClosed()) {
                this.closeConnection();
            }
            System.out.println("StoreSequence Failed!");
            e.printStackTrace();
            throw e;
        }
    }

    public void SetCounter(int count, int currentGame) throws Exception {
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("Update GameDraws SET CurrentDraw = ? WHERE GameID = ?;");
                callstmt.setInt(1, count);
                callstmt.setInt(2, currentGame);
                callstmt.execute();
                int iUpdCount = callstmt.getUpdateCount();
                this.closeConnection();
                if (iUpdCount == 0) {
                    throw new Exception("SetCounter: No Game Found!");
                }
            } else {
                System.out.println("Error: No active Connection");
            }
        }
        catch (Exception e) {
            if (!this.con.isClosed()) {
                this.closeConnection();
            }
            System.out.println("SetCounter Failed!");
            throw e;
        }
    }

    public boolean IsGameStopped(int gameID) throws Exception {
        boolean stopped = false;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("SET NOCOUNT ON;declare @gameID int;select @gameID = GameID from Games where GameID = ? and started=1 and stoppedon is not null;\nif @gameID is null\nselect @gameID = 0;SET NOCOUNT OFF;select @gameID;");
                callstmt.setInt(1, gameID);
                callstmt.execute();
                System.out.println("Batch statement successfully executed");
                int iUpdCount = callstmt.getUpdateCount();
                boolean bMoreResults = true;
                ResultSet rs = null;
                while (bMoreResults || iUpdCount != -1) {
                    rs = callstmt.getResultSet();
                    if (rs != null) {
                        rs.next();
                        int tempGameID = rs.getInt(1);
                        if (tempGameID > 0) {
                            stopped = true;
                        }
                    }
                    bMoreResults = callstmt.getMoreResults();
                    iUpdCount = callstmt.getUpdateCount();
                }
            }
        }
        catch (Exception e) {
            if (!this.con.isClosed()) {
                this.closeConnection();
            }
            System.out.println("IsGameStopped Failed!");
            throw e;
        }
        return stopped;
    }

    public void SetCard(int gameID, String playerID, String card) throws Exception {
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("INSERT INTO GameCards(GameID, PlayerID, CardNumbers) VALUES (?, ?, ?);");
                callstmt.setInt(1, gameID);
                callstmt.setString(2, playerID);
                callstmt.setString(3, card);
                callstmt.execute();
                this.closeConnection();
            } else {
                System.out.println("Error: No active Connection");
            }
        }
        catch (Exception e) {
            if (!this.con.isClosed()) {
                this.closeConnection();
            }
            System.out.println("SetCard Failed!");
            throw e;
        }
    }

    public String GetCard(int gameID, String playerID) {
        String card = null;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("SET NOCOUNT ON;declare @CardNumbers varchar(200);select @CardNumbers = CardNumbers from GameCards where GameID=? and PlayerID = ?;\nSET NOCOUNT OFF;select @CardNumbers");
                callstmt.setInt(1, gameID);
                callstmt.setString(2, playerID);
                callstmt.execute();
                System.out.println("Batch statement successfully executed");
                int iUpdCount = callstmt.getUpdateCount();
                boolean bMoreResults = true;
                ResultSet rs = null;
                while (bMoreResults || iUpdCount != -1) {
                    rs = callstmt.getResultSet();
                    if (rs != null) {
                        rs.next();
                        card = rs.getString(1);
                    }
                    bMoreResults = callstmt.getMoreResults();
                    iUpdCount = callstmt.getUpdateCount();
                }
            }
        }
        catch (Exception e) {
            System.out.println("GetCard Failed!");
        }
        return card;
    }

    public String GetDraws(int gameID) {
        String draws = null;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("SET NOCOUNT ON;declare @Draws varchar(550);select @Draws = Draws from GameDraws where GameID=?;\nSET NOCOUNT OFF;select @Draws");
                callstmt.setInt(1, gameID);
                callstmt.execute();
                System.out.println("Batch statement successfully executed");
                int iUpdCount = callstmt.getUpdateCount();
                boolean bMoreResults = true;
                ResultSet rs = null;
                while (bMoreResults || iUpdCount != -1) {
                    rs = callstmt.getResultSet();
                    if (rs != null) {
                        rs.next();
                        draws = rs.getString(1);
                        if (draws == null) {
                            draws = "";
                        }
                    }
                    bMoreResults = callstmt.getMoreResults();
                    iUpdCount = callstmt.getUpdateCount();
                }
            }
        }
        catch (Exception e) {
            System.out.println("GetDraws Failed!");
        }
        return draws;
    }

    public int GetCurrentDraw(int gameID) {
        int draw = 0;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                String sql = "SET NOCOUNT ON;declare @Draw int;select @Draw = CurrentDraw from GameDraws where GameID=?;\nSET NOCOUNT OFF;select @Draw";
                CallableStatement callstmt = this.con.prepareCall(sql);
                callstmt.setInt(1, gameID);
                callstmt.execute();
                System.out.println("Batch statement successfully executed");
                int iUpdCount = callstmt.getUpdateCount();
                boolean bMoreResults = true;
                ResultSet rs = null;
                while (bMoreResults || iUpdCount != -1) {
                    rs = callstmt.getResultSet();
                    if (rs != null) {
                        rs.next();
                        Object temp = rs.getObject(1);
                        draw = temp != null ? rs.getInt(1) : 0;
                    }
                    bMoreResults = callstmt.getMoreResults();
                    iUpdCount = callstmt.getUpdateCount();
                }
            }
        }
        catch (Exception e) {
            draw = -1;
            System.out.println("GetCurrentDraw Failed!");
        }
        return draw;
    }

    public boolean SetWinner(int gameID, String playerID) throws Exception {
        boolean ok = false;
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("INSERT INTO Winners(GameID, PlayerID) VALUES (?, ?);SELECT @@ROWCOUNT;SET NOCOUNT ON;UPDATE Games SET StoppedOn = getdate() WHERE GameID=?;SET NOCOUNT OFF;");
                callstmt.setInt(1, gameID);
                callstmt.setString(2, playerID);
                callstmt.setInt(3, gameID);
                callstmt.execute();
                int iUpdCount = callstmt.getUpdateCount();
                boolean bMoreResults = true;
                ResultSet rs = null;
                while (bMoreResults || iUpdCount != -1) {
                    rs = callstmt.getResultSet();
                    if (rs != null) {
                        rs.next();
                        int recsaffected = rs.getInt(1);
                        if (recsaffected > 0) {
                            ok = true;
                        }
                    }
                    bMoreResults = callstmt.getMoreResults();
                    iUpdCount = callstmt.getUpdateCount();
                }
            }
        }
        catch (Exception e) {
            if (!this.con.isClosed()) {
                this.closeConnection();
            }
            System.out.println("SetWinner Failed!");
            throw e;
        }
        return ok;
    }

    public void StopGame(int gameID) throws Exception {
        try {
            this.con = this.getConnection();
            if (this.con != null) {
                CallableStatement callstmt = this.con.prepareCall("UPDATE Games SET StoppedOn = getdate() WHERE GameID=?;");
                callstmt.setInt(1, gameID);
                callstmt.execute();
                this.closeConnection();
            } else {
                System.out.println("Error: No active Connection");
            }
        }
        catch (Exception e) {
            if (!this.con.isClosed()) {
                this.closeConnection();
            }
            System.out.println("StopGame Failed!");
            throw e;
        }
    }
}

