/*
 * Created on 06.02.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package bingo.client;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import bingo.server.*;


import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;


import javax.jms.*;

/**
 * @author Alexander
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Client {
	
	private static int clock = 0;
	
	private TopicConnection connect = null;

	private int GameID;
	private String PlayerID;
	private int[] Card;
	private Vector Draws;
	
	private int LastMsgRecvAt = 0;
	private int LastMID = 0;
	private boolean bMissingMsg = false;
	
	
	private bingo.server.HostServerHome getHostHome() throws NamingException {
		return (bingo.server.HostServerHome) getContext().lookup(
			bingo.server.HostServerHome.JNDI_NAME);
		// old: "server/bingo/HostServer"
	}
	private bingo.server.AnsweringServerHome getASHome() throws NamingException {
			return (bingo.server.AnsweringServerHome) getContext().lookup(
				bingo.server.AnsweringServerHome.JNDI_NAME);
	}
	private InitialContext getContext() throws NamingException {
		Hashtable props = new Hashtable();

		props.put(
			InitialContext.INITIAL_CONTEXT_FACTORY,
			"org.jnp.interfaces.NamingContextFactory");
		props.put(InitialContext.PROVIDER_URL, "jnp://127.0.0.1:1099");

		// This establishes the security for authorization/authentication
		// props.put(InitialContext.SECURITY_PRINCIPAL,"username");
		// props.put(InitialContext.SECURITY_CREDENTIALS,"password");

		InitialContext initialContext = new InitialContext(props);
		return new InitialContext();
	}
	
	public void Join() {
		System.out.println("Joining a game...");
		try {
			bingo.server.AnsweringServer server = getASHome().create();

			String result;
			result = server.Join();
			System.out.println("client.Join(): "+result);
			
			String sPID = parseMsg(result, "PlayerID:");
			String sGID = parseMsg(result, "GameID:");
			String sCard = parseMsg(result, "Card:");
			String sDraws = parseMsg(result, "Draws:");
			
			GameID = Integer.parseInt(sGID);
			PlayerID = sPID;
			
			//parse out the game card:
			String[] arrayCard = sCard.split(",");
			if (arrayCard.length != 25) {
				QuitClient("[Error] Size of card (" + arrayCard.length +
						   ") sent from the server is not 25.");
			}
			for (int i=0; i<arrayCard.length; i++) {
				Card[i] = Integer.parseInt(arrayCard[i]);
			}
			
			//parse out the current draws:
			Draws.clear();
			String[] arrayDraws = sDraws.split(",");
			if (arrayDraws.length > 100) {
				QuitClient("[Error] Size of draws (" + arrayDraws.length +
						   ") sent from the server is greater than 100.");
			}
			for (int i=0; i<arrayDraws.length; i++) {
				Draws.add(arrayDraws[i]);			
			}
		} catch (RemoteException e) {
			QuitClient("[Exception] Communication problem occurred in Join().");
		} catch (CreateException e) {
			QuitClient("[Exception] Failed to create EJB in Join().");
		} catch (NamingException e) {
			QuitClient("[Exception] Naming exception occured in Join().");
		} catch (AnsweringServerException e1) {
		
			QuitClient(e1.getMessage());		
			//QuitClient("[Exception] Answering Server - Database call failed.");
		}
		
		System.out.println("PlayerID="+this.PlayerID+", GameID="+this.GameID);
	}
	private MessageListener mlistener = new MsgListener();	
	private void subscribeTopic() {
		/*
		 * From here to the line "connect.start()" is to subscribe to
		 * JBOSS built-in topic, topic/testTopic.  When a new message is sent
		 * to testTopic, the onMessage() is activiated and process the message
		 */

		//Define connection
		//TopicConnection connection = null;
				
		//Get JNDI context, you should include the jndi.properties in your
		//classpath.  Copy&paste the following lines(without comment) and save
		//as a text file.  You should be able to replace localhost with other 
		//server name if you intend to run this client in a different computer
		/*
		*  java.naming.factory.initial=org.jnp.interfaces.NamingContextFactory
		*  java.naming.factory.url.pkgs=org.jboss.naming:org.jnp.interfaces
		*  java.naming.provider.url=localhost:1099
		*/
		Context initial;
		TopicConnectionFactory factory;
//		TopicConnection connect = null;
		Topic topic;
		TopicSession session;
		TopicSubscriber subscriber;
		
		try {
			//Subscribe and connect to the message queue.
			initial = getContext();
			factory = (TopicConnectionFactory) initial.lookup("ConnectionFactory");
			connect = factory.createTopicConnection();
			//Find the topic in the JNDI server
			topic = (Topic) initial.lookup("topic/BingoTopic1");
			session = connect.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
			subscriber = session.createSubscriber(topic);
			//Register itself to the topic
			subscriber.setMessageListener(mlistener);
			System.out.println("Listening for messages on topic/testTopic");
			
			//Ready to receive message
			connect.start();
			
			//reset the LastMsgRecvAt to be current time to give some time for subscribing/connecting
			//and receives the first broadcasted message.
			LastMsgRecvAt = clock;
		}
		catch (NamingException e) {
			System.out.println("Connection problems!");
		}
		catch (JMSException e1) {
			System.out.println("JMS problems!");
		}
		catch (Exception ex) {
			System.err.println("Caught an unexpected exception!");
			ex.printStackTrace();
		} 
//		finally {
//			// This "finally" block close the connection to the topic
//			// subscribed if it's still open.
//			System.out.println("closing connection...");
//			if (connect != null) {
//				try {
//					connect.close();
//				} catch (JMSException e2) {
//					// TODO Auto-generated catch block
//					e2.printStackTrace();
//				}
//			}
//		}
	}
	
	/**
	 * 
	 */
	public Client() {
		GameID = -1;
		PlayerID = "fakeID";
		Draws = new Vector();
		Card = new int[25];

		for (int i=0; i<25; i++) Card[i]=i*4+1;
	}

	private class MsgListener implements MessageListener {
	
	/*
	 *  (non-Javadoc)
	 * onMessage is activiated when a new message arrives in the topic message
	 * queue.  It will then parse the message and print it out.
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 */	
		public void onMessage(Message message) {
			try {
				LastMsgRecvAt = clock;
	
				TextMessage textMsg = (TextMessage)message;
				String text = textMsg.getText();
				
				String sERROR = parseMsg(text, "ERROR:");
				if (sERROR.length() > 0) {
					QuitClient(sERROR);
				}
				
				String sGID = parseMsg(text, "GID:");
				String sMID = parseMsg(text, "MID:");
				String sDRAW = parseMsg(text, "DRAW:");
				
				int MID = Integer.parseInt(sMID);
				
				System.out.println("\n..Message received at "+LastMsgRecvAt
									+": GID="+sGID+"; MID="+sMID+"; DRAW="+sDRAW);
				
				if (!sGID.equals(GameID+"") && GameID!=-1) {
					//GameID doesn't match the local one: a new game has started.
					QuitClient("[GAMEOVER] A new game has started. New GameID="+sGID);
				}
				
				if (sMID.equals("0")) {
					//The current game is over:
					QuitClient("[GAMEOVER] The current game is over, triggered by MID:0.");
				}
				
				//Wrong order or MID sequence occurred, meaning at least one new game has started
				if (MID <= LastMID) {
					QuitClient("[GAMEOVER] The current game is over, message from the new game has arrived.");
				}
				
				//The current message is a valid one even if we may have missed some other messages.
				LastMID = MID;
				if (!Draws.contains(sDRAW)) {
					Draws.add(sDRAW);
					printAllDraws();
				}

				//Some message(s) have been missed:
				if (MID > LastMID+1) {
					System.out.println("[NOTE] Some messages (MID: " + (LastMID+1) + "~" + (MID-1) +
									   ") have been missed. Getting snapshot from the server...");
					//GetSnapshot();
					//raise the flag to indicate the main thread that messages have been missed,
					//and it will call GetSnapshot().
					bMissingMsg = true;
				}

			}
			catch (NumberFormatException e) { 
			}
			catch (JMSException jmsE) {
				jmsE.printStackTrace();
			}
		}
	}
	
	public void StartServer() {

		HostServer server = null;
		try {
			server = getHostHome().create();
			System.out.println(server.StartServer());
		} catch (RemoteException e) {
			QuitClient("[Exception] Communication problem occurred in StartServer()");
		} catch (CreateException e) {
			QuitClient("[Exception] Failed to create EJB in StartServer()");
		} catch (NamingException e) {
			QuitClient("[Exception] Naming exception occurred in StartServer()");
		}
	}
	
	public String parseMsg(String msg, String key) {
		String sVal;
		int idxStart = msg.indexOf(key);
		int idxEnd;
		
		if (idxStart < 0) return "";
		
		try {
			idxStart += key.length();
			idxEnd = msg.indexOf(";", idxStart);
			sVal = msg.substring(idxStart, idxEnd);
		} catch (IndexOutOfBoundsException e) {
			sVal = "";
		}
		
		return sVal;
	}
	
	public void printAllDraws() {
		System.out.print("\nCurrent Draws: ");
		for (int i=0; i<Draws.size(); i++) {
			System.out.print(Draws.get(i)+",");
		}
		System.out.println("\n");
	}
	
	public void printCard() {
		System.out.println("B\tI\tN\tG\tO");
		for (int i=0; i<5; i++) {
			String str = "";
			for (int j=0; j<5; j++) {
				str += this.Card[j*5+i] + "\t";
			}
			System.out.println(str);
		}
	}
	
	public boolean foundBingo() {
		if (clock > 10) return true;
		
		return false;
	}
	
	public void DeclareBingo() {
		bingo.server.AnsweringServer server = null;
		int result = -1;
		try {
			server = getASHome().create();
			result = server.DeclareBingo(GameID, PlayerID);
		} catch (RemoteException e) {
			QuitClient("[Exception] Communication problem occurred in DeclareBingo()");
		} catch (CreateException e) {
			QuitClient("[Exception] Failed to create EJB in DeclareBingo()");
		} catch (NamingException e) {
			QuitClient("[Exception] Naming exception occurred in DeclareBingo()");
		} catch (AnsweringServerException e1) {
		// TODO Auto-generated catch block
		e1.printStackTrace();
		}
		
		switch (result) {
			case 2:
				QuitClient("[GAMEOVER] You are the WINNER!");
				break;
			case 1:
				QuitClient("[GAMEOVER] Somebody has declared a Bingo before you did.");
			case 0:
				System.out.println("\n[WARNING] Your Bingo is invalid.");
				break;
			default:
				System.out.println("\n(DeclareBingo failed because of exceptions.)");
		}
	}
	
	public void disconnect() {
		try {
			connect.close();
		} catch (JMSException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void GetSnapshot() {
		System.out.println("\nGetting snapshot from the server...");
		bingo.server.AnsweringServer server=null;
		try {
			server = getASHome().create();
			String result;
			result = server.GetSnapshot();
			
			String sGID = parseMsg(result, "GameID:");
			if (!sGID.equals(GameID+"")) {
				QuitClient("[GAMEOVER] A new game ("+sGID+") has been started.");
			}
			
			//update the current draws
			String sDraws = parseMsg(result, "Draws:");
			String[] arrayDraws = sDraws.split(",");
			for (int i=0; i<arrayDraws.length; i++) {
				if (!Draws.contains(arrayDraws[i])) {
					Draws.add(arrayDraws[i]);
				}
			}
			printAllDraws();
		} catch (RemoteException e) {
			QuitClient("[Exception] Communication problem occurred in GetSnapshot().");
		} catch (CreateException e) {
			QuitClient("[Exception] Failed to create EJB in GetSnapshot()");
		} catch (NamingException e) {
			QuitClient("[Exception] Naming exception occurred in GetSnapshot()");
		}  catch (AnsweringServerException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}
	
	public boolean MessageTimeOut() {
		if (clock - this.LastMsgRecvAt > 60) {
			return true;
		} else {
			return false;
		}
	}
	
	public static void main(String[] args) {
		
		System.out.println("<Client starts>");
		Client client = new Client();
		
		client.subscribeTopic();
		
		/* ********************************************************************
		 * As a work-around, the FIRST client should call client.StartServer()
		 * to start the ejbCreate().
		 * All the following "real" client should NOT call startserver() again.
		 */
		//client.StartServer();
		/* ***************************************************************** */
		
		
		client.Join();
		
		while (true) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				QuitClient("[Exception] Main thread failed.");
			}
			
			clock++;
			
			if (client.foundBingo()) {
				client.DeclareBingo();
			}
			
			if (client.MessageTimeOut()) {
				// Assuming the connection to the JMS server died:
				System.out.println("onMessage() timeout! Getting snapshot...");
				
				//disconnect from the JMS server and subscribe to the topic again.
				client.disconnect();
				client.subscribeTopic();
				
				client.GetSnapshot();
			}
			if (clock > 100)
			QuitClient("Quitting"); 
			if (clock % 10 == 0) System.out.println("clock="+clock);
		}
	}
	
	public static void QuitClient(String msg) {
		System.out.println("\n"+msg);
		System.out.println("Existing the client application... BYE!");
		System.exit(-1);
	}
}
