#ifndef __SAC_ENCODER_C__
#define __SAC_ENCODER_C__

#include "SAC.h"
#include "SAC_Cumf.h"

symbol::symbol() {
	q1 = 16384;
	q2 = 32768;
	q3 = 49152;
	top = 65535;
	low = 0;
	high = top;
	opposite_bits = 0;
	bit = 0;
	length = 0;
	code_value = 0;
	cum = 0;
	i = 0;
	last = 0;
	reset = false;
};

symbol::~symbol() {};

void symbol::init() {
	low = 0;
	high = top;
	opposite_bits = 0;
}


bool * symbol::encode(int cumul_freq[], int index, int & j, bool * ptr_b)
{
	length = high - low + 1;
	high = low - 1 + (length * cumul_freq[index]) / cumul_freq[0];
	low += (length * cumul_freq[index+1]) / cumul_freq[0];
	for ( ; ; ) {
		if (high < q2) {
			*ptr_b++ = false;
			j++;
			while (opposite_bits > 0) { 
				*ptr_b++ = true;
				j++;
				opposite_bits--;
			}
		}
		else if (low >= q2) {
			*ptr_b++ = true;
			j++;
			while (opposite_bits > 0) { 
				*ptr_b++ = false;
				j++;
				opposite_bits--; 
			}
			low -= q2; 
			high -= q2;
		}
		else if (low >= q1 && high < q3) {
			opposite_bits += 1; 
			low -= q1; 
			high -= q1;
		}
		else break;
		low *= 2; 
		high = 2 * high+1;
	}
	return ptr_b;
};

bool * symbol::encoder_flush(int & j, bool * ptr_b)
{
	if (EDEBUG) fprintf(stdout, "Encoder Flush: ");
	opposite_bits++;
	if (low < q1) {
		*ptr_b++ = false;
		if (EDEBUG) fprintf(stdout, "0");
		j++;
		while (opposite_bits > 0) {
			*ptr_b++ = true;
			if (EDEBUG) fprintf(stdout, "1");
			j++;
			opposite_bits--;
		}
		// Extra bits added to make it work
//		*ptr_b++ = false;j++;
//		*ptr_b++ = true;j++;
//		*ptr_b++ = false;j++;
		// Extra bits added to make it work
	}
	else {
		*ptr_b++ = true;
		if (EDEBUG) fprintf(stdout, "1");
		j++;
		while (opposite_bits > 0) { 
			*ptr_b++ = false;
			if (EDEBUG) fprintf(stdout, "0");
			j++;
			opposite_bits--;
		}
		// Extra bits added to make it work
//		*ptr_b++ = true;j++;
//		*ptr_b++ = false;j++;
//		*ptr_b++ = true;j++;
		// Extra bits added to make it work
	}
	low = 0; 
	high = top;
	if (EDEBUG) fprintf(stdout, "\n");

	return ptr_b;
};

#endif
