
#include "frameq.h"

StoredFrame::StoredFrame(unsigned char *newframe, int size){
	next = prev = NULL;
	frame = new unsigned char[size];
	memcpy(frame, newframe, size);
}

StoredFrame::~StoredFrame() {
	delete[] frame;
}

FrameQueue::FrameQueue(int max) {
	head = tail = NULL;
	frame_count = 0;
	max_frame = max;
}

FrameQueue::~FrameQueue() {
	while (frame_count != 0) DeleteLast();
}

void FrameQueue::DeleteLast(void) {
	StoredFrame *last = tail;
	if(!last) return;

	StoredFrame *secondlast = tail->prev;
	if (secondlast) {
		secondlast->next = NULL;
		tail = secondlast;
		delete last; 
		frame_count--;
	}
	else {
		head = tail = NULL;
		delete last;
		frame_count--;
	}
}

void FrameQueue::Insert(unsigned char *frame, int size) {
	StoredFrame *nf = new StoredFrame(frame, size);
	
	if (frame_count == max_frame) DeleteLast();
	
	if (head == NULL) {
		head = tail = nf;
		frame_count++;
	}
	else {
		nf->next = head;
		head->prev = nf;
		head = nf;
		frame_count++;
	}
}

unsigned char *FrameQueue::GetFrame(int pos) { // pos > 0;
	if (pos == 0) {
		if (head == NULL) {
			cout << "FrameQ: Head for Frame Queue does not exist" << endl;
			return NULL;
		}
		return head->frame; // Return the last decoded frame is pos is 0
	}
	if (pos > frame_count) {
		cout << "FrameQ: The index is larger than the number of frames that we have!!\n";
		return NULL;
	}
	else {
		int count = 1;
		StoredFrame *toget = head;
		while (count < pos) {
			toget = toget->next;
			count++;
		}
		return toget->frame;
	}
}
