
#ifndef __D_SLICE_ENCODE_SLICE_C__
#define __D_SLICE_ENCODE_SLICE_C__

#include "D_Slice.h"


/*
 * void D_Slice::Encode_Slice(void)
 * 
 * Intiates Slice encoding, which will call D_Macroblock::Encode_MB()
 * This is a public method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		call D_Macroblock::Encode_MB() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_Slice::Encode_Slice(void)
{
	D_Macroblock *ptr_MB;
	int i, j;
	
	ptr_MB = _MB_list;
	j = *_MB_this_slice;
	for (i=0; i<j; i++) {
		ptr_MB->Encode_MB();
		ptr_MB++;
	}
}


/*
 * void D_GOB::Encode_GOB(bool P_picture)
 * 
 * Intiates GOB encoding, which will call D_Macroblock::Encode_MB()
 * This is a public method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		call D_Macroblock::Encode_MB() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_Slice::Encode_Slice(bool P_picture)
{
	D_Macroblock *ptr_MB;
	int i, j;
	
	ptr_MB = _MB_list;
	j = *_MB_this_slice;
	for (i=0; i<j; i++) {
		ptr_MB->Encode_MB(P_picture);
		ptr_MB++;
	}
}


#endif

