
#ifndef __D_MACROBLOCK_SAC_C__
#define __D_MACROBLOCK_SAC_C__

#include "D_Macroblock.h"
#include "SAC.h"
/*
 * void D_Macroblock::SAC_Encoder(PSC_Fifo &bit_ostream, symbol *sac)
 * 
 * Syntax based Arithmetic encoding of the current macroblock, 
 * then call D_Block::SAC_Encoder() for 6 blocks pointed by _BLK_list
 * This is a public method
 *
 * Requires:	Encode_MB() is called before evoking this method from the GOB layer
 * Modifies:	bit_ostream
 * Ensures:		Entropy encode the macroblock header according to the standard
 *
 * Warning:		baseline implementation
 */
void D_Macroblock::SAC_Encoder(PSC_Fifo &bit_ostream, symbol *sac, bool plusptype)
{
	int i, bitcount, k;
	int mtype, mcbpy, mcbpc, modb;
	double median_x0, median_y0,
		median_x1, median_y1,
		median_x2, median_y2,
		median_x3, median_y3, tx, ty;
	bool bits[160];
	bool *ptr_b;
	D_Block *ptr_BLK;

	bitcount = 0;
	ptr_b = bits;

	mtype = *_mtype;
	mcbpy = *_mcbpy;
	mcbpc = *_mcbpc;

// RESTART:

	// COD - Coded Macroblock Indication - CMI - 1 bit
	if (_inter_frame_mode == true) {
		ptr_b = sac->encode(cumf_COD, *_cmi, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "COD %d\n", *_cmi); fflush(stdout); }
		if (*_cmi == true) {	// No more information is sent
			if (EDEBUG) {
				ptr_b = bits;
				fprintf(stdout, "Block Bits: ");
				for (i=0; i < bitcount; i++) {
					if (*ptr_b++) fprintf(stdout, "1");
					else fprintf(stdout, "0");
				}
				fprintf(stdout, "\n");
				fflush(stdout);
			}
			bit_ostream.WriteNBits(bits, bitcount);
			return;
		}
	}

	// MCBPC - Macroblock type & Coded block pattern for chrominance (MCBPC) - (Variable Length)
	if (_inter_frame_mode) {		// ** no stuffing yet
		k = (mtype << 2) + mcbpc;	// MCBPC in INTER frame
		if (mtype == 5) k++;		// Index 20 is already reserved for *stuffing*
		if (plusptype && _advanced_prediction_mode) // later, must add DF to the conditional
			ptr_b = sac->encode(cumf_MCBPC_4MVQ, k, bitcount, ptr_b);
		else 
			ptr_b = sac->encode(cumf_MCBPC_no4MVQ, k, bitcount, ptr_b);
	}
	else {
		k = mcbpc;					// MCBPC in INTRA frame
		if (mtype == INTRAQ) k += 4;
		ptr_b = sac->encode(cumf_MCBPC_intra, k, bitcount, ptr_b);
	}
	if (EDEBUG) { fprintf(stdout, "MTYPE %d\n", mtype); fflush(stdout); }
	if (EDEBUG) { fprintf(stdout, "CBPC %d%d\n", (mcbpc&2) > 0, (mcbpc&1) > 0); fflush(stdout); }

	// MODB - Macroblock mode for B-blocks - (Variable Length)
	modb = 0;
	if (_PB_Ppicture_flag) {	// Only for PB-frames
		if (*_mcbpb != 0) modb = 2;	// If CBPB & no MVDB, send 0 for MVDBs
		else modb = _coded_mvd_flag;
		ptr_b = sac->encode(cumf_MODB_G, modb, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "MODB %d\n", modb); fflush(stdout); }

		// CBPB - Coded block pattern for B-blocks - 6 bits
		if (modb == 2) {	// Sent if MODB says so
			k = *_mcbpb;
			if (EDEBUG) { fprintf(stdout, "CBPB "); fflush(stdout); }
			for (i=0; i<4; i++, k<<=1) {
				if (k & 32) {
					ptr_b= sac->encode(cumf_YCBPB, 1, bitcount, ptr_b);
					if (EDEBUG) { fprintf(stdout, "1"); fflush(stdout); }
				}
				else {
					ptr_b= sac->encode(cumf_YCBPB, 0, bitcount, ptr_b);
					if (EDEBUG) { fprintf(stdout, "0"); fflush(stdout); }
				}
			}
			for (i=0; i<2; i++, k<<=1) {
				if (k & 32) {
					ptr_b= sac->encode(cumf_UVCBPB, 1, bitcount, ptr_b);
					if (EDEBUG) { fprintf(stdout, "1"); fflush(stdout); }
				}
				else {
					ptr_b= sac->encode(cumf_UVCBPB, 0, bitcount, ptr_b);
					if (EDEBUG) { fprintf(stdout, "0"); fflush(stdout); }
				}
			}
			if (EDEBUG) { fprintf(stdout, "\n"); fflush(stdout); }
		}
	}

	// CBPY - Coded Block Pattern for Luminance - (Variable Length)
	if (mtype <= 2 || mtype == 5) { // INTER Macroblocks
		ptr_b = sac->encode(cumf_CBPY, 15 - mcbpy, bitcount, ptr_b); 
	}
	else {		// MCBPY (Intra) in INTRA frame
		ptr_b = sac->encode(cumf_CBPY_intra, mcbpy, bitcount, ptr_b); 
	}
	if (EDEBUG) { fprintf(stdout, "CBPY %d%d%d%d\n",
		(mcbpy&8) > 0, (mcbpy&4) > 0, (mcbpy&2) > 0, (mcbpy&1) > 0); fflush(stdout); }

	// DQUANT - Quantizer Information - 2 bits/(Variable length)
	// Waiting for future...
	// if (mtype == 1 || mtype >= 4)
	// if (EDEBUG) fprintf(stdout, "DQUANT %d\n", _dquant);

	// MVD - Motion Vector Data - (Variable Length)
	if (mtype <= 2 || mtype == 5 || _PB_Ppicture_flag) { // PB mode always has MVDs
		if (mtype == INTER4V || mtype == INTER4VQ) {
			Median_Predictor(&median_x0, &median_y0,
				&median_x1, &median_y1, &median_x2, &median_y2,
				&median_x3, &median_y3);
		}
		else Median_Predictor(&median_x0, &median_y0, false);

		tx = *_mv_x1;
		ty = *_mv_y1;

		if ((*_mv_type1 == 2) || (*_mv_type1 == 4) )  tx += 0.5;
		if (*_mv_type1 > 2) ty += 0.5;

		if (EDEBUG) { fprintf(stdout, "MVD %g,%g TYPE%d - Median %g,%g\n",
			tx, ty, *_mv_type1, median_x0, median_y0); fflush(stdout); }

		tx -= median_x0;
		ty -= median_y0;

		if (EDEBUG) { fprintf(stdout, "MVD sent %g,%g\n", tx, ty); fflush(stdout); }

		k = (int)(tx*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "MVDx SAC %d\n", k); fflush(stdout); }

		k = (int)(ty*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "MVDy SAC %d\n", k); fflush(stdout); }
	}

	// MVD2-4 - Motion Vector Data - (Variable Length)
	if (mtype == INTER4V || mtype == INTER4VQ) {
		// MVD2
		tx = *_mv_x2;
		ty = *_mv_y2;
		
		if ((*_mv_type2 == 2) || (*_mv_type2 == 4) )  tx += 0.5;
		if (*_mv_type2 > 2) ty += 0.5;

		if (EDEBUG) { fprintf(stdout, "MVD2 %g,%g TYPE%d - Median %g,%g\n",
			tx, ty, *_mv_type2, median_x1, median_y1); fflush(stdout); }

		tx -= median_x1;
		ty -= median_y1;

		if (EDEBUG) { fprintf(stdout, "MVD2 sent %g,%g\n", tx, ty); fflush(stdout); }

		k = (int)(tx*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "MVD2x SAC %d\n", k); fflush(stdout); }

		k = (int)(ty*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "MVD2y SAC %d\n", k); fflush(stdout); }

		// MVD3
		tx = *_mv_x3;
		ty = *_mv_y3;
		
		if ((*_mv_type3 == 2) || (*_mv_type3 == 4) )  tx += 0.5;
		if (*_mv_type3 > 2) ty += 0.5;

		if (EDEBUG) { fprintf(stdout, "MVD3 %g,%g TYPE%d - Median %g,%g\n",
			tx, ty, *_mv_type3, median_x2, median_y2); fflush(stdout); }
		
		tx -= median_x2;
		ty -= median_y2;

		if (EDEBUG) { fprintf(stdout, "MVD3 sent %g,%g\n", tx, ty); fflush(stdout); }

		k = (int)(tx*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "MVD3x SAC %d\n", k); fflush(stdout); }

		k = (int)(ty*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "MVD3y SAC %d\n", k); fflush(stdout); }

		// MVD4
		tx = *_mv_x4;
		ty = *_mv_y4;
		
		if ((*_mv_type4 == 2) || (*_mv_type4 == 4) )  tx += 0.5;
		if (*_mv_type4 > 2) ty += 0.5;

		if (EDEBUG) { fprintf(stdout, "MVD4 %g,%g TYPE%d - Median %g,%g\n",
			tx, ty, *_mv_type4, median_x3, median_y3); fflush(stdout); }
		
		tx -= median_x3;
		ty -= median_y3;

		if (EDEBUG) { fprintf(stdout, "MVD4 sent %g,%g\n", tx, ty); fflush(stdout); }

		k = (int)(tx*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "MVD4x SAC %d\n", k); fflush(stdout); }

		k = (int)(ty*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
		if (EDEBUG) { fprintf(stdout, "MVD4y SAC %d\n", k); fflush(stdout); }
	}

	// MVDB - Motion Vector Data for B-macroblock - (Variable Length)
	if (modb >= 1) {	// If MODB says MVDB is present
		if (_coded_mvd_flag) {
			Median_Predictor(&median_x0, &median_y0, true);
			
			tx = *_mvd_x;
			ty = *_mvd_y;
			
			if ((*_mvd_type == 2) || (*_mvd_type == 4) ) tx += 0.5;
			if (*_mvd_type > 2) ty += 0.5;
			
			if (EDEBUG) { fprintf(stdout, "MVDB %g,%g TYPE%d - Median %g,%g\n",
				tx, ty, *_mvd_type, median_x0, median_y0); fflush(stdout); }
			
			tx -= median_x0;
			ty -= median_y0;

			if (EDEBUG) { fprintf(stdout, "MVDB sent %g,%g\n", tx, ty); fflush(stdout); }

			k = (int)(tx*2);
			if (k >= 32) k -= 32;
			else if (k <= -33) k += 96;
			else k += 32;
			ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
			if (EDEBUG) { fprintf(stdout, "MVDBx SAC %d\n", k); fflush(stdout); }
			
			k = (int)(ty*2);
			if (k >= 32) k -= 32;
			else if (k <= -33) k += 96;
			else k += 32;
			ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
			if (EDEBUG) { fprintf(stdout, "MVDBy SAC %d\n", k); fflush(stdout); }
		}
		else {
			k = 32;
			ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
			ptr_b = sac->encode(cumf_MVD, k, bitcount, ptr_b);
			if (EDEBUG) { fprintf(stdout, "MVDB 0,0 TYPE1 - Median 0,0\n"); fflush(stdout); }
		}
	}

	if (EDEBUG) {
		ptr_b = bits;
		fprintf(stdout, "Block Bits: ");
		for (i=0; i < bitcount; i++) {
			if (*ptr_b++) fprintf(stdout, "1");
			else fprintf(stdout, "0");
		}
		fprintf(stdout, "\n");
		fflush(stdout);
	}
	bit_ostream.WriteNBits(bits, bitcount);

	// Encode Block Layer
	if (_PB_Ppicture_flag) ptr_BLK = _BLK_list_PB;
	else ptr_BLK = _BLK_list;
	// If it is an INTRA block, we still have to encode the DC component
	if ((mtype == INTRA) || (mtype == INTRAQ)) {
		for (i=0; i<_BLK_per_mb; i++) {
			if (EDEBUG) { fprintf(stdout, "Intra BLOCK %d -> ", i); fflush(stdout); }
			ptr_BLK->SAC_Encoder(bit_ostream, sac);
			ptr_BLK++;
		}
	}
	// If it is an INTER block, we have to examine the Coded Block Pattern
	else {
		k = (mcbpy << 2) + mcbpc;
		for (i=0; i<_BLK_per_mb; i++) {
			if (k & 32) {
				if (EDEBUG) { fprintf(stdout, "Inter BLOCK %d -> ", i); fflush(stdout); }
				ptr_BLK->SAC_Encoder(bit_ostream, sac);
			}
			ptr_BLK++;
			k <<= 1;
		}
	}

	// If PB_frame mode is on, output the B-frame
	if (_PB_Ppicture_flag) {
		ptr_BLK = _BLK_list;
		k = *_mcbpb;
		for (i=0; i<_BLK_per_mb; i++) {
			if (k & 32) {
				if (EDEBUG) { fprintf(stdout, "B-frame BLOCK %d -> ", i+6); fflush(stdout); }
				ptr_BLK->_PB_B_frame = true;
				ptr_BLK->SAC_Encoder(bit_ostream, sac);
				ptr_BLK->_PB_B_frame = false;
			}
			ptr_BLK++;
			k <<= 1;
		}
	}
}


#endif
