
#ifndef __D_FRAME_UPDATE_SEGMENT_C__
#define __D_FRAME_UPDATE_SEGMENT_C__

#include "D_Frame.h"


/*
 * void D_Frame::Update_Segment(void)
 * 
 * Prepare update segment resources for video/entropy encoder/decoder
 *
 * Requires:	_MB_per_gob and _GOB_per_frame, _seg_id, _right_span, _left_span
 * Modifies:	_seg_x_high, _seg_x_low, _seg_y_high, _seg_y_low
 * Ensures:		Accouting for segment, compute the legal range for motion vectors for each macroblock
 *
 * Warning:		
 */
void D_Frame::Update_Segment(void)
{
	int i, j, k, s, t, a, b, c;
	int xlow, xhigh, ylow, yhigh;
	int xlow2, xhigh2, ylow2, yhigh2;
	const short *ptr_slice_size;
	const short *ptr_seg_ID, *ptr_seg_size;
	const short *ptr_right_span, *ptr_left_span;
	short *ptr_x_bound_high, *ptr_x_bound_low;
	short *ptr_y_bound_high, *ptr_y_bound_low;

	short *ptr_mvx0_high, *ptr_mvx0_low;
	short *ptr_mvx1_high, *ptr_mvx1_low;
	short *ptr_mvx2_high, *ptr_mvx2_low;
	short *ptr_mvx3_high, *ptr_mvx3_low;
	short *ptr_mvx4_high, *ptr_mvx4_low;
	short *ptr_mvy0_high, *ptr_mvy0_low;
	short *ptr_mvy1_high, *ptr_mvy1_low;
	short *ptr_mvy2_high, *ptr_mvy2_low;
	short *ptr_mvy3_high, *ptr_mvy3_low;
	short *ptr_mvy4_high, *ptr_mvy4_low;
	const bool *ptr_cgi;
	bool *ptr_mvx_border_high, *ptr_mvx_border_low;
	bool *ptr_mvy_border_high, *ptr_mvy_border_low;


	// We are assuming that segment decisions are stored in macroblock segment ID
	ptr_cgi = _cgi;
	ptr_slice_size = _slice_size;
	ptr_seg_ID = _seg_ID; ptr_seg_size = _seg_size;
	ptr_right_span = _right_span; ptr_left_span = _left_span;

	// Values to be set
	ptr_x_bound_high = _x_bound_high; ptr_x_bound_low = _x_bound_low;
	ptr_y_bound_high = _y_bound_high; ptr_y_bound_low = _y_bound_low;

	ptr_mvx0_high = _mvx0_high; ptr_mvx0_low = _mvx0_low; 
	ptr_mvx1_high = _mvx1_high; ptr_mvx1_low = _mvx1_low; 
	ptr_mvx2_high = _mvx2_high; ptr_mvx2_low = _mvx2_low; 
	ptr_mvx3_high = _mvx3_high; ptr_mvx3_low = _mvx3_low; 
	ptr_mvx4_high = _mvx4_high; ptr_mvx4_low = _mvx4_low; 
	ptr_mvy0_high = _mvy0_high; ptr_mvy0_low = _mvy0_low;
	ptr_mvy1_high = _mvy1_high; ptr_mvy1_low = _mvy1_low;
	ptr_mvy2_high = _mvy2_high; ptr_mvy2_low = _mvy2_low;
	ptr_mvy3_high = _mvy3_high; ptr_mvy3_low = _mvy3_low;
	ptr_mvy4_high = _mvy4_high; ptr_mvy4_low = _mvy4_low;
	ptr_mvx_border_high = _mvx_border_high; ptr_mvx_border_low = _mvx_border_low;
	ptr_mvy_border_high = _mvy_border_high; ptr_mvy_border_low = _mvy_border_low;


	// the caller must guarantee slice is in rectangular submode if in ISD mode
	// if not, no video segment boundary values will be set
	// Segment boundary values are ONLY used in combination of slice rectangular mode + ISD
	if (_independent_segment_mode) {
		
		if (_slice_mode && _rectangular_submode) {

			for (i=0, s=-1, t=0; i<_SLICE_per_frame; i++) {
				k = *ptr_slice_size++;
				a = t / _MB_per_gob;
				b = t % _MB_per_gob;
				t += k;					// at beginning of next segment
				s += k;					// at end of current segment
				c = s % _MB_per_gob;
				
				ylow = a << 4;
				yhigh = ylow + 15;
				xlow = b << 4;
				xhigh = (c << 4) + 15;
				
				for (j=0; j<k; j++) {
					*ptr_y_bound_low++ =	(short) ylow;
					*ptr_y_bound_high++ =	(short) yhigh;
					*ptr_x_bound_low++ =	(short) xlow;
					*ptr_x_bound_high++ =	(short) xhigh;
				}
//				fprintf(stdout, " Slice %2i: xl=%3i xh=%3i yl=%3i yh=%3i\n", i, xlow, xhigh, ylow, yhigh);
			}	// for (i=0, s=-1, t=0; i<_Slice_per_frame; i++) {

		}	// if (_slice_mode && _rectangular_submode) {
		else {	// just IDS

			xlow = 0; ylow = 0;
			xhigh = _frame_xsize - 1;
			s = 0; t = -1;
			
			for (i=0; i<_Segment_per_frame; i++) {
				t += 1;
				while (true) {
					if (s++ >= _GOB_per_frame) break;
					if (*ptr_cgi++ == false) t++;
					else break;
				}
				
				yhigh = (short) (ylow + (t << 4) - 1);
				for (j=0; j<t; j++) {
					for (k=0; k<_MB_per_gob; k++) {
						*ptr_y_bound_low++ =	(short) ylow;
						*ptr_y_bound_high++ =	(short) yhigh;
						*ptr_x_bound_low++ =	(short) xlow;
						*ptr_x_bound_high++ =	(short) xhigh;
					}
				}
//				fprintf(stdout, " Segment %2i: xl=%3i xh=%3i yl=%3i yh=%3i\n", i, xlow, xhigh, ylow, yhigh);
				ylow = (short) (ylow + (t << 4));
				t = 0;
			}	// for (i=0; i<_Segment_per_frame; i++) {

		}	// else {	// just IDS

	}	// if (_independent_segment_mode) {


	// No pathological case of simultaneous Slice and ISD mode
	// UNLESS Slice is in rectangular slice submode

	// Compute range of legal motion vector values for each macroblock
	// Currently, only ISD requires special handling

	// MOTION VECTORS!!!
	ptr_x_bound_high = _x_bound_high; ptr_x_bound_low = _x_bound_low;
	ptr_y_bound_high = _y_bound_high; ptr_y_bound_low = _y_bound_low;

	if (_independent_segment_mode) {

		// Basic case -> video segment adaptation

		if (_slice_mode == false) {

			for (i=0; i<_GOB_per_frame; i++) {

				xlow = 0; xhigh = 15;
				ylow = yhigh = i << 4;
				if (*ptr_y_bound_low < ylow) ylow -= 16;
				if ((*ptr_y_bound_high - 15) > yhigh) yhigh += 15;

				// First Macroblock
				*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
				*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
				xhigh += 16;
				
				// Sandwiched Macroblocks
				for (j=2; j<_MB_per_gob; j++) {
					*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
					*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
					xlow += 16; xhigh += 16;
				}
				
				// Last Macroblock
				xhigh -= 15;
				*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
				*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
				ptr_y_bound_low += _MB_per_gob;
				ptr_y_bound_high += _MB_per_gob;
			}
/*			
			// *** Test code ***
			ptr_mvx0_high = _mvx0_high; ptr_mvx0_low = _mvx0_low; 
			ptr_mvy0_high = _mvy0_high; ptr_mvy0_low = _mvy0_low; 
			fprintf(stdout, "\n(MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx0_low++, *ptr_mvx0_high++,
						*ptr_mvy0_low++, *ptr_mvy0_high++);
				}
				fprintf(stdout, "\n");
			}
			fflush(stdout);
*/
		}	// if (_slice_mode == false) {
		else {	// Slice structure, ouch!

			for (i=0; i<_GOB_per_frame; i++) {
				ylow = yhigh = i << 4;
				for (j=0; j<_MB_per_gob; j++) {
					xlow = xhigh = j << 4;
					if (*ptr_x_bound_low++ < xlow) xlow -= 16;
					if ((*ptr_x_bound_high++ - 15) > xhigh) xhigh += 15;
					*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
					*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
				}
			}
/*
			// *** Test code ***
			ptr_mvx0_high = _mvx0_high; ptr_mvx0_low = _mvx0_low; 
			ptr_mvy0_high = _mvy0_high; ptr_mvy0_low = _mvy0_low; 
			fprintf(stdout, "\nSlice (MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx0_low++, *ptr_mvx0_high++,
						*ptr_mvy0_low++, *ptr_mvy0_high++);
				}
				fprintf(stdout, "\n");
			}
			fflush(stdout);
*/
		}

		if (_advanced_prediction_mode) {

			ylow = -16; yhigh = 15; ylow2 = -8; yhigh2 = 23;
			for (i=0; i<_GOB_per_frame; i++) {
				xlow = -16; xhigh = 15; xlow2 = -8; xhigh2 = 23;
				for (j=0; j<_MB_per_gob; j++) {
					// x part
					*ptr_mvx1_low++	= (short) xlow;	 *ptr_mvx1_high++ =	(short) xhigh;
					*ptr_mvx2_low++	= (short) xlow2; *ptr_mvx2_high++ =	(short) xhigh2;
					*ptr_mvx3_low++	= (short) xlow;  *ptr_mvx3_high++ =	(short) xhigh;
					*ptr_mvx4_low++	= (short) xlow2; *ptr_mvx4_high++ =	(short) xhigh2;
					// y part
					*ptr_mvy1_low++	= (short) ylow;	 *ptr_mvy1_high++ = (short) yhigh;
					*ptr_mvy2_low++	= (short) ylow;	 *ptr_mvy2_high++ = (short) yhigh;
					*ptr_mvy3_low++	= (short) ylow2; *ptr_mvy3_high++ = (short) yhigh2;
					*ptr_mvy4_low++	= (short) ylow2; *ptr_mvy4_high++ = (short) yhigh2;
					xlow += 16; xhigh += 16; xlow2 += 16; xhigh2 += 16;
				}
				ylow += 16; yhigh += 16; ylow2 += 16; yhigh2 += 16;
			}
/*
			// *** Test code ***
			ptr_mvx1_high = _mvx1_high; ptr_mvx1_low = _mvx1_low; 
			ptr_mvx2_high = _mvx2_high; ptr_mvx2_low = _mvx2_low; 
			ptr_mvx3_high = _mvx3_high; ptr_mvx3_low = _mvx3_low; 
			ptr_mvx4_high = _mvx4_high; ptr_mvx4_low = _mvx4_low; 
			ptr_mvy1_high = _mvy1_high; ptr_mvy1_low = _mvy1_low;
			ptr_mvy2_high = _mvy2_high; ptr_mvy2_low = _mvy2_low;
			ptr_mvy3_high = _mvy3_high; ptr_mvy3_low = _mvy3_low;
			ptr_mvy4_high = _mvy4_high; ptr_mvy4_low = _mvy4_low;
			fprintf(stdout, "\n Y1 MV (MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx1_low++, *ptr_mvx1_high++,
						*ptr_mvy1_low++, *ptr_mvy1_high++);
				}
				fprintf(stdout, "\n");
			}
			fprintf(stdout, "\n Y2 MV (MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx2_low++, *ptr_mvx2_high++,
						*ptr_mvy2_low++, *ptr_mvy2_high++);
				}
				fprintf(stdout, "\n");
			}
			fprintf(stdout, "\n Y3 MV (MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx3_low++, *ptr_mvx3_high++,
						*ptr_mvy3_low++, *ptr_mvy3_high++);
				}
				fprintf(stdout, "\n");
			}
			fprintf(stdout, "\n Y4 MV (MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx4_low++, *ptr_mvx4_high++,
						*ptr_mvy4_low++, *ptr_mvy4_high++);
				}
				fprintf(stdout, "\n");
			}
			fflush(stdout);
*/
		}

	}
	else {	// Non-ISD code

		// Baseline code always gets to run 
		// (?) Necessary to support mode switching inside video sequences

		xlow = 0; xhigh = 15;
		ylow = 0; yhigh = 15;
		// No need to distinguish GOB vs. Slice
		// First GOB
		// First Macroblock
		*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
		*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
		xhigh += 16;
		
		// Sandwiched Macroblocks
		for (i=2; i<_MB_per_gob; i++) {
			*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
			*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
			xlow += 16; xhigh += 16;
		}
		
		// Last Macroblock
		xhigh -= 15;
		*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
		*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
		
		// Sandwiched GOBs
		yhigh += 16;
		for (j=2; j<_GOB_per_frame; j++) {
			
			xlow = 0; xhigh = 15;
			// First Macroblock
			*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
			*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
			xhigh += 16;
			
			// Sandwiched Macroblocks
			for (i=2; i<_MB_per_gob; i++) {
				*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
				*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
				xlow += 16; xhigh += 16;
			}
			
			// Last Macroblock
			xhigh -= 15;
			*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
			*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
			
			// Move to next GOB position
			ylow += 16; yhigh += 16;
		}
		
		// Last GOB
		yhigh -= 15;
		xlow = 0; xhigh = 15;
		// First Macroblock
		*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
		*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
		xhigh += 16;
		
		// Sandwiched Macroblocks
		for (i=2; i<_MB_per_gob; i++) {
			*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
			*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;
			xlow += 16; xhigh += 16;
		}
		
		// Last Macroblock
		xhigh -= 15;
		*ptr_mvx0_low++	= (short) xlow; *ptr_mvx0_high++ = (short) xhigh;
		*ptr_mvy0_low++	= (short) ylow; *ptr_mvy0_high++ = (short) yhigh;

/*		// *** Test Code ***
		ptr_mvx0_high = _mvx0_high; ptr_mvx0_low = _mvx0_low; 
		ptr_mvy0_high = _mvy0_high; ptr_mvy0_low = _mvy0_low; 
		fprintf(stdout, "\n(MB_Index, xlow, xhigh, ylow, yhigh)\n");
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx0_low++, *ptr_mvx0_high++,
					*ptr_mvy0_low++, *ptr_mvy0_high++);
			}
			fprintf(stdout, "\n");
		}
		fflush(stdout);
*/
		// 4 motion vectors: Advanced Prediction
		if (_advanced_prediction_mode) {

			ylow = -16; yhigh = 15; ylow2 = -8; yhigh2 = 23;
			for (i=0; i<_GOB_per_frame; i++) {
				xlow = -16; xhigh = 15; xlow2 = -8; xhigh2 = 23;
				for (j=0; j<_MB_per_gob; j++) {
					// x part
					*ptr_mvx1_low++	= (short) xlow;	 *ptr_mvx1_high++ =	(short) xhigh;
					*ptr_mvx2_low++	= (short) xlow2; *ptr_mvx2_high++ =	(short) xhigh2;
					*ptr_mvx3_low++	= (short) xlow;  *ptr_mvx3_high++ =	(short) xhigh;
					*ptr_mvx4_low++	= (short) xlow2; *ptr_mvx4_high++ =	(short) xhigh2;
					// y part
					*ptr_mvy1_low++	= (short) ylow;	 *ptr_mvy1_high++ = (short) yhigh;
					*ptr_mvy2_low++	= (short) ylow;	 *ptr_mvy2_high++ = (short) yhigh;
					*ptr_mvy3_low++	= (short) ylow2; *ptr_mvy3_high++ = (short) yhigh2;
					*ptr_mvy4_low++	= (short) ylow2; *ptr_mvy4_high++ = (short) yhigh2;
					xlow += 16; xhigh += 16; xlow2 += 16; xhigh2 += 16;
				}
				ylow += 16; yhigh += 16; ylow2 += 16; yhigh2 += 16;
			}
/*
			// *** Test code ***
			ptr_mvx1_high = _mvx1_high; ptr_mvx1_low = _mvx1_low; 
			ptr_mvx2_high = _mvx2_high; ptr_mvx2_low = _mvx2_low; 
			ptr_mvx3_high = _mvx3_high; ptr_mvx3_low = _mvx3_low; 
			ptr_mvx4_high = _mvx4_high; ptr_mvx4_low = _mvx4_low; 
			ptr_mvy1_high = _mvy1_high; ptr_mvy1_low = _mvy1_low;
			ptr_mvy2_high = _mvy2_high; ptr_mvy2_low = _mvy2_low;
			ptr_mvy3_high = _mvy3_high; ptr_mvy3_low = _mvy3_low;
			ptr_mvy4_high = _mvy4_high; ptr_mvy4_low = _mvy4_low;
			fprintf(stdout, "\n Y1 MV (MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx1_low++, *ptr_mvx1_high++,
						*ptr_mvy1_low++, *ptr_mvy1_high++);
				}
				fprintf(stdout, "\n");
			}
			fprintf(stdout, "\n Y2 MV (MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx2_low++, *ptr_mvx2_high++,
						*ptr_mvy2_low++, *ptr_mvy2_high++);
				}
				fprintf(stdout, "\n");
			}
			fprintf(stdout, "\n Y3 MV (MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx3_low++, *ptr_mvx3_high++,
						*ptr_mvy3_low++, *ptr_mvy3_high++);
				}
				fprintf(stdout, "\n");
			}
			fprintf(stdout, "\n Y4 MV (MB_Index, xlow, xhigh, ylow, yhigh)\n");
			for (i=0; i<_GOB_per_frame; i++) {
				for (j=0; j<_MB_per_gob; j++) {
					fprintf(stdout, "(%i %3i %3i %3i %3i) ", j, *ptr_mvx4_low++, *ptr_mvx4_high++,
						*ptr_mvy4_low++, *ptr_mvy4_high++);
				}
				fprintf(stdout, "\n");
			}
			fflush(stdout);
*/
		}	// if (_advanced_prediction_mode)

	}	// else {	// Non-ISD code
		
}


#endif

