
#ifndef __D_FRAME_SET_MCBPB_C__
#define __D_FRAME_SET_MCBPB_C__

#include "D_Frame.h"


/*
 * void D_Frame::Set_MCBPB(void)
 * 
 * Set up macroblock control information
 * For INTER-coded macroblock, if the block energy of the residue is less than camera noise
 * threshold, then the macroblock CBP (coded block pattern) is set to 0.
 * If all 6 blocks in the macroblock are all not coded, coded macroblock indicator (ptr_cmi) will
 * be set to 1 if the motion vector is zero (ptr_flag_zero_mv == true)
 * For INTRA-coded macroblock, coded block patterns for all 6 blocks are set to 1.
 * NOTE: these cbp values are not final. It is double checked after DCT-Quantization step.
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	_mcbpb
 * Ensures:		Set up B-picture's coded block pattern
 *
 * Warning:		
 */
void D_Frame::Set_MCBPB(void)
{
	int i, j, k, m, temp;
	short *ptr_fast_Y_s, *ptr_fast_U_s, *ptr_fast_V_s;
	short *ptr_mcbpb;
	
	ptr_fast_Y_s = _fast_frame;
	ptr_fast_U_s = _fast_frame + _picture_size;
	ptr_fast_V_s = _fast_frame + _picture_size + _picture_size_quarter;
	
	ptr_mcbpb = _mcbpb;
	

	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {

			// Compute block residue energy for INTER macroblocks, then
			// and compare with _thresh_no_residue 
			// Y blocks
			*ptr_mcbpb = 0;
			for (k=0; k<4; k++) {
				temp = 0;
				*ptr_mcbpb <<= 1;
				for (m=0; m<64; m++) temp += abs(*ptr_fast_Y_s++);
				if (temp > (_thresh_no_residue >> 2)) *ptr_mcbpb |= 1;
			}

			// U Block
			temp = 0;
			*ptr_mcbpb <<= 1;
			for (k=0; k<64; k++) temp += abs(*ptr_fast_U_s++);
			if (temp > (_thresh_no_residue >> 2)) *ptr_mcbpb |= 1;

			// V Block
			temp = 0;
			*ptr_mcbpb <<= 1;
			for (k=0; k<64; k++) temp += abs(*ptr_fast_V_s++);
			if (temp > (_thresh_no_residue >> 2)) *ptr_mcbpb += 1;

			ptr_mcbpb++;

		} //for(j=0;j<MB_per_gob;j++)
	} //for(i=0;i<_GOB_per_frame;i++)

}


#endif

