#ifndef __D_FRAME_PICTURE_SELECTION_C__
#define __D_FRAME_PICTURE_SELECTION_C__

#include "D_Frame.h"

/*
	void AssignPrevFrame(void);
	void StoreDecodedFrame(void);
	int _max_frame_stored, _frame_count;
	unsigned char **prev_frames;
*/

/*
 * void D_Frame::AssignPrevFrame(int frame_num)
 * 
 * Choose which of the stored previous frames to be used in motion estimation
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	_decoded_frame
 * Ensures:		
 * Warning:		
 */
void D_Frame::AssignReferenceFrames(void)
{

	int frame_to_refer = GetReferenceIndex();

	if (_frame_count < frame_to_refer) {
		cout << "The frame in that index is not available yet.. returning\n";
		return;
	}
	else {
		memcpy(_decoded_frame, _prev_frames->GetFrame(frame_to_refer), _buffer_size);
		memcpy(_decoded_frame_half_full, _prev_half_full->GetFrame(frame_to_refer), _buffer_size);
		memcpy(_decoded_frame_full_half, _prev_full_half->GetFrame(frame_to_refer), _buffer_size);
		memcpy(_decoded_frame_half_half, _prev_half_half->GetFrame(frame_to_refer), _buffer_size);

	}
}


/*
 * void D_Frame::StoreDecodedFrame(void)
 *
 * Store the current decoded frame
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	
 * Ensures:
 * Warning:		
 */
void D_Frame::StoreDecodedFrames(void)
{
	_prev_frames->Insert(_decoded_frame, _buffer_size);
	_prev_half_full->Insert(_decoded_frame_half_full, _buffer_size);
	_prev_full_half->Insert(_decoded_frame_full_half, _buffer_size);
	_prev_half_half->Insert(_decoded_frame_half_half, _buffer_size);
	if (_frame_count < _max_frame_stored) _frame_count++;

	// VerifyContent();
}


/*
 * void D_Frame::GetReferenceIndex(void)
 *
 * Return the index of the frame to be referred to
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	
 * Ensures:
 * Warning:		
 */
int D_Frame::GetReferenceIndex(void)
{
	int ref_index = (rand()%(_frame_count+1));
	//int ref_index = 1;
	return ref_index;
}

void D_Frame::VerifyContent(void)
{
	// Check whether the contents are still the same
	for (int i = 0; i < _buffer_size; i++) {
		if (_decoded_frame[i] != _prev_frames->GetFrame(1)[i]) exit(-1);
		if (_decoded_frame_half_full[i] != _prev_half_full->GetFrame(1)[i]) exit(-1);
		if (_decoded_frame_full_half[i] != _prev_full_half->GetFrame(1)[i]) exit(-1);
		if (_decoded_frame_half_half[i] != _prev_half_half->GetFrame(1)[i]) exit(-1);
	}
}

#endif