/***************************************

 A class for YUV-format video.
 
***************************************/


#ifndef YUV_VIDEO_H
#define YUV_VIDEO_H    /*+ To stop multiple inclusions. +*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

class yuv_video {

private:
	unsigned char *_y;
	unsigned char *_u;
	unsigned char *_v;

	bool     _initialized;	
	int      _writing;		// reading or writing

	int      _horiz;		// pixels per line
	int      _vert;			// lines per frame
	int      _size;			// frame size (Y+U+V)
	int      _cur_frame;	// frame index in a picture
	bool	 _first_write;

	char    *_filename;
	FILE    *_fp;
	
	void Init(void);
	void ReadVideo(void);
	void WriteVideo(void);
	void FetchFrame(const int frame_index);
	void DumpFrame(const int frame_index);
	
public:
	
	yuv_video(const char *filename, const int x=-1, const int y=-1, const bool write=false);
	yuv_video(const int x, const int y);
	yuv_video(const bool write);
	yuv_video(void);
	yuv_video(const yuv_video &y);
	~yuv_video();
	
	// Initialization functions, in case you
	// don't want to use the constructors.
	void SetFile(const char *filename, const bool writing = false);
	void SetXY(const int x, const int y);
	
	// Return the data from the given frame.
	unsigned char *Get_Y(const int frame_index);
	unsigned char *Get_U(const int frame_index);
	unsigned char *Get_V(const int frame_index);
	
	// Return the data at (x,y) position of the given frame
	unsigned char Get_Y(const int frame_index, const int x, const int y);
	unsigned char Get_U(const int frame_index, const int x, const int y);
	unsigned char Get_V(const int frame_index, const int x, const int y);
	
	// Set the value at (x,y) position of the given frame
	void Put_Y(const int frame_index, const int x, const int y, const unsigned char val);
	void Put_U(const int frame_index, const int x, const int y, const unsigned char val);
	void Put_V(const int frame_index, const int x, const int y, const unsigned char val);
	
	// Set the data in the given frame
	void Set_Y(const int frame_index, const unsigned char *y);
	void Set_U(const int frame_index, const unsigned char *u);
	void Set_V(const int frame_index, const unsigned char *v);
};

#endif /* YUV_VIDEO_H */
