
#ifndef TREE_H
#define TREE_H		/* To stop multiple inclusions */

#define debug

#include <iostream.h>
#include <string.h>
#include "PSC_Fifo.h"

/*
 * Class Tree
 *
 * This class takes a table of VLC codes and converts the table into
 * a binary search tree from which each unique VLC code has an entry at the
 * leaf (typically the index of the table)
 *
 */

class Tree {
private:
	Tree* child[2];			// child index refers to actual bit branch
	bool _isvalid;			// is there an entry in this node?
	short int entry;		// the index of the table (should only exist at leaves)

public:
	Tree(const short int value, const char* ptr_c);			// Constructor given string
	Tree(const char** const table, const int num_values);	// Constructor given table
	~Tree();

	// Traverses through tree until it needs to call a constructor to deposit an entry
	void Insert_Entry(const short int value, const char* ptr_c);
	
	// Traverses through tree to reach an entry given input bits
	bool Read_Entry(short int *value, PSC_Fifo &input);
};

#endif
