
#include "Constants.h"
#include "Serialencoder.h"
#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

/*
    Prototypes for functions called only in this file
*/
BOOL CALLBACK TransferYUVDlgProc( HWND, UINT, WPARAM, LPARAM );
void InitTransferYUVDlg( HWND );
void SaveTransferYUVDlg( HWND );

void FillComboBox( HWND, char ** szString, DWORD *, WORD, DWORD );
void SetComboBox( HWND, WORD, DWORD);
DWORD GetdwTTYItem( HWND, int, char **, DWORD *, int );

extern HINSTANCE ghInst;
extern EncoderParams EncoderInfo;
extern HWND ghWndTTY;

char * szBQuant[] = { "0", "1", "2", "3" };

DWORD  BQuantTable[] = { 0,1,2,3 };

char * szQuant[] = { "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11",
"12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24",
"25", "26", "27", "28", "29", "30", "31" };

DWORD  QuantTable[] = { 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,27,28,29,30,31};

char * szSFormat[] = { "SQCIF", "QCIF" };

DWORD SFormatTable[] = { 0,1 };

/*-----------------------------------------------------------------------------

FUNCTION: CmdTransfer( HWND )

PARAMETERS:
    hwnd - Owner of the window

PURPOSE: Creates the modal About dialog

-----------------------------------------------------------------------------*/
BOOL CmdTransferYUV(HWND hwnd)
{
    DialogBox(ghInst, MAKEINTRESOURCE(IDD_ENCODERSETTINGS), hwnd, TransferYUVDlgProc);
    return 0;
}

/*-----------------------------------------------------------------------------

FUNCTION: InitAboutDlg( HWND )

PURPOSE: Initializes the modal About dialog

PARMATETERS:
    hDlg - Dialog window handle

COMMENTS: Sets the icon animation timer and the version info.

HISTORY:   Date:      Author:     Comment:
           10/27/95   AllenD      Wrote it

-----------------------------------------------------------------------------*/
void InitTransferYUVDlg(HWND hDlg)
{
	/* Initialize Check boxes */
	CheckDlgButton(hDlg, IDC_MODE, TRUE);
	CheckDlgButton(hDlg, IDC_AP, FALSE);
	CheckDlgButton(hDlg, IDC_ES, FALSE);
	CheckDlgButton(hDlg, IDC_ISD, FALSE);
	CheckDlgButton(hDlg, IDC_RPS, FALSE);
	CheckDlgButton(hDlg, IDC_SAC, FALSE);
	CheckDlgButton(hDlg, IDC_UMV, FALSE);
	CheckDlgButton(hDlg, IDC_PB, FALSE);
	CheckDlgButton(hDlg, IDC_SLICE, FALSE);

	FillComboBox( GetDlgItem( hDlg, IDC_QUANT ),
		 szQuant, QuantTable,
		 sizeof( QuantTable) / sizeof( QuantTable[0] ),
		 (DWORD) 4 );
	
	FillComboBox( GetDlgItem( hDlg, IDC_PSIZE ),
		 szSFormat, SFormatTable,
		 sizeof( SFormatTable ) / sizeof( SFormatTable[0] ),
		 (DWORD) 1 );

	FillComboBox( GetDlgItem( hDlg, IDC_BQUANT ),
		szBQuant, BQuantTable,
		sizeof( BQuantTable ) / sizeof( BQuantTable[0] ),
		(DWORD) 0 );
	EnableWindow(GetDlgItem(hDlg, IDC_BQUANT), FALSE);

	CheckDlgButton(hDlg, IDC_SLICERECT, FALSE);
	CheckDlgButton(hDlg, IDC_SLICEARB, FALSE);
	EnableWindow(GetDlgItem(hDlg, IDC_SLICERECT), FALSE);
	EnableWindow(GetDlgItem(hDlg, IDC_SLICEARB), FALSE);

	SetDlgItemInt(hDlg, IDC_EDITPIC, 0, FALSE);
	SetDlgItemInt(hDlg, IDC_EDITSKIP, 0, FALSE);
	SetDlgItemText(hDlg, IDC_EDITYUVFILE, "");
    return;
}

/*-----------------------------------------------------------------------------

FUNCTION: SaveFlowControlDlg(HWND)

PURPOSE: Sets TTY flow control settings based on dlg controls

PARAMETERS:
    hdlg - Dialog window handle

HISTORY:   Date:      Author:     Comment:
	   10/27/95   AllenD      Wrote it

-----------------------------------------------------------------------------*/
void SaveTransferYUVDlg( HWND hdlg )
{
    BOOL fSuccess;

    //
    // update EncoderInfo
    //
	EncoderInfo.arod_submode = IsDlgButtonChecked( hdlg, IDC_SLICEARB );
	EncoderInfo.dbquant      = GetDlgItemInt( hdlg, IDC_BQUANT, &fSuccess, FALSE );
	EncoderInfo.flag_ap      = IsDlgButtonChecked( hdlg, IDC_AP);
	EncoderInfo.flag_es      = IsDlgButtonChecked( hdlg, IDC_ES);
	EncoderInfo.flag_fec     = FALSE;
	EncoderInfo.flag_isd     = IsDlgButtonChecked( hdlg, IDC_ISD );
	EncoderInfo.flag_pb      = IsDlgButtonChecked( hdlg, IDC_PB );
	EncoderInfo.flag_rps     = IsDlgButtonChecked( hdlg, IDC_RPS );
	EncoderInfo.flag_sac     = IsDlgButtonChecked( hdlg, IDC_SAC );
	EncoderInfo.flag_sl      = IsDlgButtonChecked( hdlg, IDC_SLICE );
	EncoderInfo.flag_umv     = IsDlgButtonChecked( hdlg, IDC_UMV );
	EncoderInfo.me_enable    = IsDlgButtonChecked( hdlg, IDC_MODE );
	EncoderInfo.num_pic      = GetDlgItemInt( hdlg, IDC_EDITPIC, &fSuccess, FALSE );
	EncoderInfo.quant        = GetDlgItemInt( hdlg, IDC_QUANT, &fSuccess, FALSE );
	EncoderInfo.rect_submode = IsDlgButtonChecked( hdlg, IDC_SLICERECT );
	{
		DWORD sformat;
		sformat = GetdwTTYItem( hdlg, IDC_PSIZE, 
			szSFormat, SFormatTable,
			sizeof(SFormatTable)/sizeof(SFormatTable[0]));
		EncoderInfo.sformat  = sformat;
	}				
	EncoderInfo.skip         = GetDlgItemInt( hdlg, IDC_EDITSKIP, &fSuccess, FALSE );
	GetDlgItemText( hdlg, IDC_EDITYUVFILE, EncoderInfo.yuvfile, MAX_PATH );

    return;
}

/*-----------------------------------------------------------------------------

FUNCTION: AboutDlgProc(HWND, UINT, WPARAM, LPARAM)

PURPOSE: Dialog procedure for the "About Box"

PARAMETERS:
    hdlg     - dialog window handle
    uMessage - window message
    wparam   - message parameter (depends on message value)
    lparam   - message prarmeter (depends on message value)

HISTORY:    Date:      Author:     Comment:
            10/27/95   AllenD      Wrote it

-----------------------------------------------------------------------------*/
BOOL CALLBACK TransferYUVDlgProc(HWND hdlg, UINT uMessage, WPARAM wparam, LPARAM lparam)
{
    static char szFileName[MAX_PATH] = {0};

    switch(uMessage)
	{
	case WM_INITDIALOG:     // init controls
		InitTransferYUVDlg(hdlg);
		break;
		
	case WM_COMMAND:
		switch(LOWORD(wparam))
		{
		case IDOK:
			SaveTransferYUVDlg(hdlg);
			TransferFileTextStart(szFileName);
			
			//
			// FALL THROUGH
			//
			
		case IDCANCEL:
			EndDialog(hdlg, LOWORD(wparam));
			return TRUE;
			
		case IDC_PB:
			EnableWindow(GetDlgItem(hdlg, IDC_BQUANT), IsDlgButtonChecked(hdlg, IDC_PB));
			return TRUE;
			
		case IDC_SLICE:
			EnableWindow(GetDlgItem(hdlg, IDC_SLICERECT),  IsDlgButtonChecked(hdlg, IDC_SLICE));
			EnableWindow(GetDlgItem(hdlg, IDC_SLICEARB),  IsDlgButtonChecked(hdlg, IDC_SLICE));
			return TRUE;
			
		case IDC_BROWSEYUV:
			{
				char * szFilter = "YUV Video File\0*.YUV\0";
				int fs, k,l;
				struct _stat _buf;
				OPENFILENAME ofn = {0};
				
				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hdlg;
				ofn.lpstrFilter = szFilter;
				ofn.lpstrFile = szFileName;
				ofn.nMaxFile = MAX_PATH;
				ofn.lpstrTitle = "Browse YUV File";
				ofn.Flags = OFN_FILEMUSTEXIST;
				
				if (!GetOpenFileName(&ofn))
					return FALSE;
				
				SetDlgItemText(hdlg, IDC_EDITYUVFILE, ofn.lpstrFile);
				{
					DWORD sformat;
					sformat = GetdwTTYItem( hdlg, IDC_PSIZE, 
						szSFormat, SFormatTable,
						sizeof(SFormatTable)/sizeof(SFormatTable[0]));
					
					switch (sformat) {
					case (0):
						k = SQCIFX * SQCIFY + ((SQCIFX * SQCIFY) >> 1);
						break;
					case (1):
						k = QCIFX * QCIFY + ((QCIFX * QCIFY) >> 1);
						break;
					}
				}				
				fs = _open(szFileName, _O_RDONLY | _O_BINARY);
				_fstat(fs, &_buf);
				_close(fs);

				l = _buf.st_size;
				
				if (l%k != 0) {
					OutputABufferToWindow(ghWndTTY, (CHAR *) "Corrupt YUV file: incomplete frame detected\n\0" , 44);
				}
				
				SetDlgItemInt(hdlg, IDC_EDITPIC, l/k, FALSE);
			}
			return TRUE;
		}
		break;
    }
	
    return FALSE;
}

