
#include <iostream.h>
#include <fstream.h>
#include <windows.h>

#include "Serialencoder.h"
#include "Constants.h"
#include "D_Frame.h"
#include "D_System.h"
#include "PSC_Fifo.h"
#include "yuv_video.h"

int D_Frame::_sformat;
int D_Frame::_pskipped;
bool Encoder_Abort;

extern EncoderParams EncoderInfo;
extern HWND ghWndTTY;

bool H263_Encoder(void) {
	D_Frame *Codec;
	ofstream outstream;
	PSC_Fifo *bitstream_out;
	yuv_video *yuv_ante, *yuv_post;

	int i, j, k, l;
	char *fname1, *fname2;
	char output[150];

	D_Frame::_sformat = EncoderInfo.sformat;	// default picture format to QCIF
	D_Frame::_pskipped = 0;

	Encoder_Abort = false;

	// Just here to get rid of warning in release mode
	k = 0;
	yuv_post = NULL; yuv_ante = NULL;

	sprintf(output, "\n\rCMU H.263 Encoder v3.1\n\r");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	
	// Create output file names by affixing _enc/.bits to infile name
	k = strrchr(EncoderInfo.yuvfile, (int) '.') - EncoderInfo.yuvfile;
	fname1 = new char[strlen(EncoderInfo.yuvfile)+5];
	fname2 = new char[strlen(EncoderInfo.yuvfile)+2];
	strncpy(fname1, EncoderInfo.yuvfile, k);
	strncpy(fname2, EncoderInfo.yuvfile, k);
	strcpy(fname1+k, "_enc");
	strcpy(fname2+k, ".bits");
	strcat(fname1, EncoderInfo.yuvfile+k);


	// Constructor for yuv_ante reads in 1st frame, or "0th" frame in C++ matrix speak
	// yuv_ante: input YUV object
	// yuv_post: output YUV object
	switch (D_Frame::_sformat) {
	case (SQCIF):
		sprintf(output,"Encoding SQCIF file\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		yuv_ante = new yuv_video(EncoderInfo.yuvfile, SQCIFX, SQCIFY, 0);
		yuv_post = new yuv_video(SQCIFX, SQCIFY);
		break;
	case (QCIF):
		sprintf(output,"Encoding QCIF file\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		yuv_ante = new yuv_video(EncoderInfo.yuvfile, QCIFX, QCIFY, 0);
		yuv_post = new yuv_video(QCIFX, QCIFY);
		break;
	default:
		sprintf(output,"Invalid Source Format specified\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		delete [] fname1;
		delete [] fname2;
		return false;
	}
	yuv_post->SetFile(fname1, true);
	sprintf(output,"Outputting Encoded YUV file to %s\n\r", fname1);
	OutputABufferToWindow(ghWndTTY, output, strlen(output));

	outstream.open(fname2, ios::out | ios::binary);
	if (!outstream.is_open()) {
		sprintf(output,"Can't write file %s\n\r", fname2);
		OutputABufferToWindow(ghWndTTY, output, strlen(output));

		delete[] fname1;
		delete[] fname2;
		delete yuv_ante;
		delete yuv_post;
		return false;
	}

	delete [] fname1;
	delete [] fname2;

	// Create Bitstream and Frame object 
	bitstream_out = new PSC_Fifo(&outstream);
	Codec = new D_Frame();
	
	// Check for the advanced optional modes
	if (EncoderInfo.flag_ap) {
		Codec->Enable_AP_Mode();
		sprintf(output,"Advanced Prediction Mode is on\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}
	if (EncoderInfo.flag_fec) {
		Codec->Enable_FEC_Mode();
		sprintf(output,"Forward Error Correction Mode is on\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}
	if (EncoderInfo.flag_isd) {
		Codec->Enable_ISD_Mode();
		sprintf(output,"Independent Segment Decoding Mode is on\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}
	if (EncoderInfo.flag_rps) {
		Codec->Enable_RPS_Mode();
		sprintf(output,"Reference Picture Selection Mode is on\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}
	if (EncoderInfo.flag_sl) {
		Codec->Enable_SLICE_Mode(EncoderInfo.rect_submode, EncoderInfo.arod_submode);
		sprintf(output,"Slice Mode is on");
		if (EncoderInfo.rect_submode) sprintf(output,"%s with Rectangular Sub-mode", output);
		if (EncoderInfo.arod_submode) sprintf(output,"%s with Arbitrary Order", output);
		sprintf(output,"%s\n\r", output);
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}
	if (EncoderInfo.flag_sac) {
		Codec->Enable_SAC_Mode();
		sprintf(output,"Syntax Arithmetic Coding Mode is on\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}
	if (EncoderInfo.flag_umv) {
		Codec->Enable_UMV_Mode();
		sprintf(output,"Unrestricted Motion Vectors is on\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}

	// Special: need to be placed here
	if (EncoderInfo.flag_pb) {
		Codec->Enable_PB_Mode();
		sprintf(output,"PB-frames mode is on\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}

	// ** All advanced modes must be called before the next line **
	if (EncoderInfo.flag_es) {
		Codec->Enable_ES_Mode();
		sprintf(output,"Enhanced Speed Mode is on\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}
	// Set up all data structures
	Codec->Create_Data_Structure(true);
	Codec->Set_Skip(EncoderInfo.skip);
	if (EncoderInfo.skip > 0) {
		sprintf(output,"Skipping %d frames\n\r", EncoderInfo.skip);
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}

	// Starting Encoding ...
	// First picture is specially coded as reference INTRA frame
	Codec->Disable_ME();
	Codec->Set_PQuant(EncoderInfo.quant, EncoderInfo.dbquant);
	Codec->Encode_Frame(yuv_post, yuv_ante, *bitstream_out, 0);

	// Process all other pictures, use prediction whenever possible
	if (EncoderInfo.me_enable) {
		Codec->Enable_ME();
		Codec->Set_Frame_Mode_INTER();
		sprintf(output,"Motion Estimation Enabled\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}
	
	if (EncoderInfo.flag_pb && (!EncoderInfo.flag_es)) {	// PB frame mode
		
		Codec->Formal_Verify_PB_Preconditions();
		// total number of PB frames we have
		k = (EncoderInfo.num_pic - 1) / (2 + EncoderInfo.skip);
		// the last frame may need to be coded as P frame
		l = (EncoderInfo.num_pic - 1) % (2 + EncoderInfo.skip);
		
		// Skip override parameter must be less than 6. -1 to give encoder full control.
		for (i=0, j=(2+EncoderInfo.skip); (i<k) && !Encoder_Abort; i++, j+=(2+EncoderInfo.skip)) 
			Codec->Encode_Frame(yuv_post, yuv_ante, *bitstream_out, -1, j);			
		
		// Remaining default back to normal operation
		// ?Codec->Disable_ES_Mode();
		for (i=0, j-=(1+EncoderInfo.skip); (i<l) && !Encoder_Abort; i++, j++)
			Codec->Encode_Frame(yuv_post, yuv_ante, *bitstream_out, j);
		
	}
	else {			// P frame mode (regular)
		
		for (i=1; (i<EncoderInfo.num_pic) && !Encoder_Abort; i++)
			Codec->Encode_Frame(yuv_post, yuv_ante, *bitstream_out, i);
	}

	// End Encoding... Clean up	
	delete bitstream_out;
	if (outstream.is_open()) outstream.close();
	
	if (Encoder_Abort) sprintf(output,"\n\rEncoding aborting... Please wait for transfer to finish\n\r");
	else sprintf(output,"\n\rEncoding complete... Please wait for transfer to finish\n\r");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));

	delete yuv_ante;
	delete yuv_post;
	delete Codec;

	return Encoder_Abort;
}

