/***************************************
 *
 *
 * D_System.h:	system-specific code
 *
 *
 **************************************/

#ifndef D_SYSTEM_H
#define D_SYSTEM_H

#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>


class File_Stat {
protected:
	struct _stat _buf;

public:
	File_Stat(const char *const filename) {
		int fh;

		fh = _open(filename, _O_RDONLY | _O_BINARY);
		if (fh == -1) perror("\nopen failed on input file\n" );
		if (-1 == _fstat(fh, &_buf)) perror("\ninvalid file handle\n");
		_close(fh);
	}

	~File_Stat() {
	}
	
	inline int Get_File_Size() {
		return _buf.st_size;
	}

	inline int Get_File_Create_Time() {
		return _buf.st_ctime;
	}
	
	inline int Get_File_Modify_Time() {
		return _buf.st_mtime;
	}

	inline int Get_File_Access_Time() {
		return _buf.st_atime;
	}

	inline char Get_Drive_Letter() {
		return (char) (_buf.st_dev + 'A');
	}
};

#endif
