
#ifndef __D_SLICE_ENTROPY_ENCODER_C__
#define __D_SLICE_ENTROPY_ENCODER_C__

#include "D_Slice.h"

extern bool Encoder_Abort;

/*
 * void D_Slice::Entropy_Encoder(PSC_Fifo &bit_ostream)
 * 
 * Entropy encode the current GOB,
 * then call D_Macroblock::Entropy_Encoder() of macroblocks pointed by _MB_list
 * This is a public method
 *
 * Requires:	Encode_GOB() is called before evoking this method from the Frame layer
 * Modifies:	bit_ostream
 * Ensures:		Entropy encode the GOB header according to the standard
 *
 * Warning:		baseline implementation
 */
void D_Slice::Entropy_Encoder(PSC_Fifo &bit_ostream, bool first_sent)
{
	static int MBA_Length[5] = { 6, 7, 9, 11, 13 };
	static int SWI_Length[5] = { 4, 4, 5, 6, 7 };

	bool bits[83];	// SSTUF(7)+SSC(17)+SEPB1(1)+SSBI(4)+MBA(14)+SEPB2(1)+SQUANT(5)+SWI(7)+
	bool *ptr_b;	// SEPB3(1)+GFID(2)+TRI(1)+TR(10)+TRPI(1)+TRP(10)+BCI(2)+BCM(0)=83
	int i, k, m, bitcount;
	D_Macroblock *ptr_MB;

	ptr_b = bits;

	// SSC - Slice Start Code - 17 bits
	if (!first_sent) {
		bitcount = 17;
		for (i=0; i<16; i++) *ptr_b++ = false;
		*ptr_b++ = true;
	}
	else bitcount = 0;

	// SEPB1 - Slice Emulation Prevention Bit 1 - 1 bit
	bitcount++;
	*ptr_b++ = true;

	// SSBI - Slice Sub-Bitstream Indicator - 4 bits

	// MBA - Macroblock Address - 5/6/7/9/11/12/13/14 bits
	k = *_mba;
	i = MBA_Length[_sformat];
	bitcount += i;
	for (m = 1 << (i-1); i > 0; i--, k<<=1) {
		if (k & m) *ptr_b++ = true;
		else *ptr_b++ = false;
	}
	if (EDEBUG) fprintf(stdout, "SMBA %d\n", *_mba);

	// SEPB2 - Slice Emulation Prevention Bit 2 - 1 bit
	if (first_sent && _rectangular_submode) {
		bitcount++;
		*ptr_b++ = true;
	}
	else if (MBA_Length[_sformat] > 11) {
		bitcount++;
		*ptr_b++ = true;
	}

	// SQUANT - Quantizer Information - 5 bits
	if (!first_sent) {
		k = *_squant;
		bitcount += 5;
		for (i=0; i<5; i++, k <<= 1) {
			if (k & 16) *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) fprintf(stdout, "SQUANT %d\n", *_squant);
	}

	// SWI - Slice Width Indication in Macroblocks - 3/4/5/6/7 bits
	if (_rectangular_submode) {
		k = *_MB_this_slice;
		i = SWI_Length[_sformat];
		bitcount += i;
		for (m = 1 << (i-1); i > 0; i--, k<<=1) {
			if (k & m) *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) fprintf(stdout, "SWI %d\n", *_MB_this_slice);
	}

	// SEPB3 - Slice Emulation Prevention Bit 3 - 1 bit
	bitcount++;
	*ptr_b++ = true;

	// GFID - GOB Frame ID - 2 bits
	bitcount += 2;	// GOB Frame ID, set according to frame mode
	*ptr_b++ = _PB_Ppicture_flag;
	*ptr_b++ = _inter_frame_mode;
	if (EDEBUG) fprintf(stdout, "GFID %d%d\n", _PB_Ppicture_flag, _inter_frame_mode);

	// Send Reference Picture Selection Mode info
	if (_reference_picture_selection) {
		// TRI - Temporal Reference Indicator - 1 bit
		bitcount++;
		*ptr_b++ = 0; // TR field is not present (BCM must be implemented)

		// TR - Temporal Reference - 8 bits
		// bitcount += 8;
		// k = *_fr_num;	// We're not supporting GOB's from previous frames yet
		// for (i=0; i<8; i++, k <<= 1) {
		// 	if (k & 128) *ptr_b++ = true;
		// 	else *ptr_b++ = false;
		// }
		// if (EDEBUG) fprintf(stdout, "GTR %d\n", (*(_fr_num) & 255));

		// TRPI - Temporal Reference for Prediction Indicator - 1 bit
		bitcount++;
		if (*_trp != 0) {
			*ptr_b++ = 1;
			
			bitcount += 10;
			// TRP - Temporal Reference for Prediction - 10 bits
			*ptr_b++ = 0;	// For Extended TR
			*ptr_b++ = 0;
			k = *_fr_num - *_trp;
			if (EDEBUG) fprintf(stdout, "GTRP %d - TRP %d\n", (k & 255), *_trp);
			for (i=0; i<8; i++, k <<= 1) {
				if (k & 128) *ptr_b++ = true;
				else *ptr_b++ = false;
			}
		}
		else *ptr_b++ = 0;

		// BCI - Back-Channel Message Indication - Variable Length
		bitcount += 2;
		*ptr_b++ = 0;	// Absence or the end of the video back-channel message field
		*ptr_b++ = 1;
	}

	bit_ostream.WriteNBits(bits, bitcount);
	
	ptr_MB = _MB_list;
	for (i=0; (i<*_MB_this_slice) && !Encoder_Abort; i++) {
		if (EDEBUG) fprintf(stdout, "--> MB %d\n", i+*_mba);
		ptr_MB->Entropy_Encoder(bit_ostream);
		ptr_MB++;
	}

}

#endif
