
#ifndef __D_MACROBLOCK_MEDIAN_PREDICTOR_C__
#define __D_MACROBLOCK_MEDIAN_PREDICTOR_C__

#include "D_Macroblock.h"


/*
 * void D_Macroblock::Median_Predictor(double *x, double *y, bool mvdb)
 * 
 * Find the median differential motion vector x and y indpendently
 * Handles median predictor for mvdb and normal motion vectors
 * This is a private method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	x, y
 * Ensures:		return median x motion vector in X, and median Y motion vector in Y
 *
 * Warning:		
 */
void D_Macroblock::Median_Predictor(double *x, double *y, bool mvdb)
{
	short this_ID;
	double x1, x2, x3, tx;
	double y1, y2, y3, ty;

	if (mvdb) {

		x1 = *_dmvd_x1; y1 = *_dmvd_y1;
		x2 = *_dmvd_x2; x3 = *_dmvd_x3;
		y2 = *_dmvd_y2; y3 = *_dmvd_y3;
		
		if ((*_dmvd_type1 == 2) || (*_dmvd_type1 == 4))  x1 += 0.5; 
		if ((*_dmvd_type2 == 2) || (*_dmvd_type2 == 4))  x2 += 0.5;
		if ((*_dmvd_type3 == 2) || (*_dmvd_type3 == 4))  x3 += 0.5;
		
		if (*_dmvd_type1 > 2) y1 += 0.5;
		if (*_dmvd_type2 > 2) y2 += 0.5;
		if (*_dmvd_type3 > 2) y3 += 0.5;

		if (_independent_segment_mode || _slice_mode) {
			this_ID = *_seg_ID;

			if (*_dmvd_ID1 != this_ID) {
				x1 = 0; y1 = 0;
			}
			if (*_dmvd_ID2 != this_ID) {
				x2 = x1; y2 = y1;
			}
			if (*_dmvd_ID3 != this_ID) {
				x3 = x1; y3 = y1;
			}
		}
		else if (*_cgi == true) {
			x2 = x1; x3 = x1;
			y2 = y1; y3 = y1;
		}

	}	
	else {
		x1 = *_dmv_x01; y1 = *_dmv_y01;
		x2 = *_dmv_x02; x3 = *_dmv_x03;
		y2 = *_dmv_y02; y3 = *_dmv_y03;

		if ((*_dmv_type01 == 2) || (*_dmv_type01 == 4))  x1 += 0.5; 
		if ((*_dmv_type02 == 2) || (*_dmv_type02 == 4))  x2 += 0.5;
		if ((*_dmv_type03 == 2) || (*_dmv_type03 == 4))  x3 += 0.5;

		if (*_dmv_type01 > 2) y1 += 0.5;
		if (*_dmv_type02 > 2) y2 += 0.5;
		if (*_dmv_type03 > 2) y3 += 0.5;
		
		if (_independent_segment_mode || _slice_mode) {
			this_ID = *_seg_ID;

			if (*_dmv_ID01 != this_ID) {
				x1 = 0; y1 = 0;
			}
			if (*_dmv_ID02 != this_ID) {
				x2 = x1; y2 = y1;
			}
			if (*_dmv_ID03 != this_ID) {
				x3 = x1; y3 = y1;
			}
		}
		else if (*_cgi == true) {
			x2 = x1; x3 = x1;
			y2 = y1; y3 = y1;
		}
	}

	// Calculate X median
	if (x1 > x2) {
		tx = x1;
		x1 = x2;
		x2 = tx;
	}
	if (x1 > x3) {
		tx = x1;
		x1 = x3;
		x3 = tx;
	}
	if (x2 > x3) {
		tx = x3;
		x2 = x3;
		x3 = tx;
	}
	// Calculate Y median
	if (y1 > y2) {
		ty = y1;
		y1 = y2;
		y2 = ty;
	}
	if (y1 > y3) {
		ty = y1;
		y1 = y3;
		y3 = ty;
	}
	if (y2 > y3) {
		ty = y3;
		y2 = y3;
		y3 = ty;
	}
	
	*x = x2;
	*y = y2;
}

/* Overloaded function 
 * void D_Macroblock::Median_Predictor(double *x0, double *y0, double *x1,
									double *y1, double *x2, double *y2,
									double *x3, double *y3)
 * 
 * Find the median differential motion vector x and y indpendently
 * This is a private method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	
 * Ensures:		return median x motion vector in X, and median Y motion vector in Y
 *
 * Warning:		
 */
void D_Macroblock::Median_Predictor(double *x0, double *y0, double *x1,
									double *y1, double *x2, double *y2,
									double *x3, double *y3)
{
	double tx, ty;
	double x01, x02, x03;
	double y01, y02, y03;
	double x11, x12, x13;
	double y11, y12, y13;
	double x21, x22, x23;
	double y21, y22, y23;
	double x31, x32, x33;
	double y31, y32, y33;
	short this_ID;
	
	x01 = *_dmv_x11; y01 = *_dmv_y11;
	x02 = *_dmv_x12; y02 = *_dmv_y12;
	x03 = *_dmv_x13; y03 = *_dmv_y13;
	
	x11 = *_dmv_x21; y11 = *_dmv_y21;
	x12 = *_dmv_x22; y12 = *_dmv_y22;
	x13 = *_dmv_x23; y13 = *_dmv_y23;
	
	x21 = *_dmv_x31; y21 = *_dmv_y31;
	x22 = *_dmv_x32; y22 = *_dmv_y32;
	x23 = *_dmv_x33; y23 = *_dmv_y33;
	
	x31 = *_dmv_x41; y31 = *_dmv_y41;
	x32 = *_dmv_x42; y32 = *_dmv_y42;	 
	x33 = *_dmv_x43; y33 = *_dmv_y43;	 

	if ((*_dmv_type11 == 2) || (*_dmv_type11 == 4))  x01 += 0.5; 
	if ((*_dmv_type12 == 2) || (*_dmv_type12 == 4))  x02 += 0.5;
	if ((*_dmv_type13 == 2) || (*_dmv_type13 == 4))  x03 += 0.5;

	if ((*_dmv_type21 == 2) || (*_dmv_type21 == 4))  x11 += 0.5; 
	if ((*_dmv_type22 == 2) || (*_dmv_type22 == 4))  x12 += 0.5;
	if ((*_dmv_type23 == 2) || (*_dmv_type23 == 4))  x13 += 0.5;

	if ((*_dmv_type31 == 2) || (*_dmv_type31 == 4))  x21 += 0.5; 
	if ((*_dmv_type32 == 2) || (*_dmv_type32 == 4))  x22 += 0.5;
	if ((*_dmv_type33 == 2) || (*_dmv_type33 == 4))  x23 += 0.5;

	if ((*_dmv_type41 == 2) || (*_dmv_type41 == 4))  x31 += 0.5; 
	if ((*_dmv_type42 == 2) || (*_dmv_type42 == 4))  x32 += 0.5;
	if ((*_dmv_type43 == 2) || (*_dmv_type43 == 4))  x33 += 0.5;
	
	if (*_dmv_type11 > 2) y01 += 0.5;
	if (*_dmv_type12 > 2) y02 += 0.5;
	if (*_dmv_type13 > 2) y03 += 0.5;

	if (*_dmv_type21 > 2) y11 += 0.5;
	if (*_dmv_type22 > 2) y12 += 0.5;
	if (*_dmv_type23 > 2) y13 += 0.5;

	if (*_dmv_type31 > 2) y21 += 0.5;
	if (*_dmv_type32 > 2) y22 += 0.5;
	if (*_dmv_type33 > 2) y23 += 0.5;

	if (*_dmv_type41 > 2) y31 += 0.5;
	if (*_dmv_type42 > 2) y32 += 0.5;
	if (*_dmv_type43 > 2) y33 += 0.5;


	if (_independent_segment_mode || _slice_mode) {
		this_ID = *_seg_ID;
		
		if (*_dmv_ID11 != this_ID) {
			x01 = 0; y01 = 0;
		}
		if (*_dmv_ID12 != this_ID) {
			x02 = x01; y02 = y01;
		}
		if (*_dmv_ID13 != this_ID) {
			x03 = x01; y03 = y01;
		}

/*		if (*_dmv_ID21 != this_ID) {
			x11 = 0; y11 = 0;
		}
*/		if (*_dmv_ID22 != this_ID) {
			x12 = x11; y12 = y11;
		}
		if (*_dmv_ID23 != this_ID) {
			x13 = x11; y13 = y11;
		}

		if (*_dmv_ID31 != this_ID) {
			x21 = 0; y21 = 0;
		}
/*		if (*_dmv_ID32 != this_ID) {
			x22 = 0; y22 = 0;
		}
		if (*_dmv_ID33 != this_ID) {
			x23 = 0; y23 = 0;
		}

		if (*_dmv_ID41 != this_ID) {
			x31 = 0; y31 = 0;
		}
		if (*_dmv_ID42 != this_ID) {
			x32 = 0; y32 = 0;
		}
		if (*_dmv_ID43 != this_ID) {
			x33 = 0; y33 = 0;
		}
*/
	}
	else if (*_cgi == true) {
		x02 = x01; x03 = x01;
		y02 = y01; y03 = y01;
		x12 = x11; x13 = x11;
		y12 = y11; y13 = y11;
	}


	// Calculate X median
	if (x01 > x02) {
		tx = x01;
		x01 = x02;
		x02 = tx;
	}
	if (x01 > x03) {
		tx = x01;
		x01 = x03;
		x03 = tx;
	}
	if (x02 > x03) {
		tx = x03;
		x02 = x03;
		x03 = tx;
	}
	// Calculate Y median
	if (y01 > y02) {
		ty = y01;
		y01 = y02;
		y02 = ty;
	}
	if (y01 > y03) {
		ty = y01;
		y01 = y03;
		y03 = ty;
	}
	if (y02 > y03) {
		ty = y03;
		y02 = y03;
		y03 = ty;
	}
	
	*x0 = x02;
	*y0 = y02;
	// Calculate X median
	if (x11 > x12) {
		tx = x11;
		x11 = x12;
		x12 = tx;
	}
	if (x11 > x13) {
		tx = x11;
		x11 = x13;
		x13 = tx;
	}
	if (x12 > x13) {
		tx = x13;
		x12 = x13;
		x13 = tx;
	}
	// Calculate Y median
	if (y11 > y12) {
		ty = y11;
		y11 = y12;
		y12 = ty;
	}
	if (y11 > y13) {
		ty = y11;
		y11 = y13;
		y13 = ty;
	}
	if (y12 > y13) {
		ty = y13;
		y12 = y13;
		y13 = ty;
	}
	
	*x1 = x12;
	*y1 = y12;

	// Calculate X median
	if (x21 > x22) {
		tx = x21;
		x21 = x22;
		x22 = tx;
	}
	if (x21 > x23) {
		tx = x21;
		x21 = x23;
		x23 = tx;
	}
	if (x22 > x23) {
		tx = x23;
		x22 = x23;
		x23 = tx;
	}
	// Calculate Y median
	if (y21 > y22) {
		ty = y21;
		y21 = y22;
		y22 = ty;
	}
	if (y21 > y23) {
		ty = y21;
		y21 = y23;
		y23 = ty;
	}
	if (y22 > y23) {
		ty = y23;
		y22 = y23;
		y23 = ty;
	}
	
	*x2 = x22;
	*y2 = y22;

	// Calculate X median
	if (x31 > x32) {
		tx = x31;
		x31 = x32;
		x32 = tx;
	}
	if (x31 > x33) {
		tx = x31;
		x31 = x33;
		x33 = tx;
	}
	if (x32 > x33) {
		tx = x33;
		x32 = x33;
		x33 = tx;
	}
	// Calculate Y median
	if (y31 > y32) {
		ty = y31;
		y31 = y32;
		y32 = ty;
	}
	if (y31 > y33) {
		ty = y31;
		y31 = y33;
		y33 = ty;
	}
	if (y32 > y33) {
		ty = y33;
		y32 = y33;
		y33 = ty;
	}
	
	*x3 = x32;
	*y3 = y32;
}

/*
 * void D_Macroblock::Median_Predictor_1(double *x0, double *y0)
 * 
 * Find the median differential motion vector x and y indpendently
 * Handles median predictor for mvdb and normal motion vectors
 * This is a private method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	x, y
 * Ensures:		return median x motion vector in X, and median Y motion vector in Y
 *
 * Warning:		
 */
void D_Macroblock::Median_Predictor_1(double *x0, double *y0)
{
	double tx, ty;
	double x01, x02, x03;
	double y01, y02, y03;
	short this_ID;
	
	x01 = *_dmv_x11; y01 = *_dmv_y11;
	x02 = *_dmv_x12; y02 = *_dmv_y12;
	x03 = *_dmv_x13; y03 = *_dmv_y13;

	if ((*_dmv_type11 == 2) || (*_dmv_type11 == 4))  x01 += 0.5; 
	if ((*_dmv_type12 == 2) || (*_dmv_type12 == 4))  x02 += 0.5;
	if ((*_dmv_type13 == 2) || (*_dmv_type13 == 4))  x03 += 0.5;

	if (*_dmv_type11 > 2) y01 += 0.5;
	if (*_dmv_type12 > 2) y02 += 0.5;
	if (*_dmv_type13 > 2) y03 += 0.5;

	if (_independent_segment_mode || _slice_mode) {
		this_ID = *_seg_ID;
		
		if (*_dmv_ID11 != this_ID) {
			x01 = 0; y01 = 0;
		}
		if (*_dmv_ID12 != this_ID) {
			x02 = x01; y02 = y01;
		}
		if (*_dmv_ID13 != this_ID) {
			x03 = x01; y03 = y01;
		}
	}
	else if (*_cgi == true) {
		x02 = x01; x03 = x01;
		y02 = y01; y03 = y01;
	}

	// Calculate X median
	if (x01 > x02) {
		tx = x01;
		x01 = x02;
		x02 = tx;
	}
	if (x01 > x03) {
		tx = x01;
		x01 = x03;
		x03 = tx;
	}
	if (x02 > x03) {
		tx = x03;
		x02 = x03;
		x03 = tx;
	}
	// Calculate Y median
	if (y01 > y02) {
		ty = y01;
		y01 = y02;
		y02 = ty;
	}
	if (y01 > y03) {
		ty = y01;
		y01 = y03;
		y03 = ty;
	}
	if (y02 > y03) {
		ty = y03;
		y02 = y03;
		y03 = ty;
	}
	
	*x0 = x02;
	*y0 = y02;
}

/*
 * void D_Macroblock::Median_Predictor_2(short &mv_x0, short &mv_y0, short &mv_type0,
 *										 double *x1, double *y1)
 * 
 * Find the median differential motion vector x and y indpendently
 * Handles median predictor for mvdb and normal motion vectors
 * This is a private method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	x, y
 * Ensures:		return median x motion vector in X, and median Y motion vector in Y
 *
 * Warning:		
 */
void D_Macroblock::Median_Predictor_2(short &mv_x0, short &mv_y0, short &mv_type0,
									  double *x1, double *y1)
{
	double tx, ty;
	double x11, x12, x13;
	double y11, y12, y13;
	short this_ID;
	
	x11 = mv_x0; y11 = mv_y0;
	x12 = *_dmv_x22; y12 = *_dmv_y22;
	x13 = *_dmv_x23; y13 = *_dmv_y23;
	
	if ((mv_type0 == 2) || (mv_type0 == 4))  x11 += 0.5; 
	if ((*_dmv_type22 == 2) || (*_dmv_type22 == 4))  x12 += 0.5;
	if ((*_dmv_type23 == 2) || (*_dmv_type23 == 4))  x13 += 0.5;

	if (mv_type0 > 2) y11 += 0.5;
	if (*_dmv_type22 > 2) y12 += 0.5;
	if (*_dmv_type23 > 2) y13 += 0.5;

	if (_independent_segment_mode || _slice_mode) {
		this_ID = *_seg_ID;
		
		if (*_dmv_ID22 != this_ID) {
			x12 = x11; y12 = y11;
		}
		if (*_dmv_ID23 != this_ID) {
			x13 = x11; y13 = y11;
		}
	}
	else if (*_cgi == true) {
		x12 = x11; x13 = x11;
		y12 = y11; y13 = y11;
	}

	// Calculate X median
	if (x11 > x12) {
		tx = x11;
		x11 = x12;
		x12 = tx;
	}
	if (x11 > x13) {
		tx = x11;
		x11 = x13;
		x13 = tx;
	}
	if (x12 > x13) {
		tx = x13;
		x12 = x13;
		x13 = tx;
	}
	// Calculate Y median
	if (y11 > y12) {
		ty = y11;
		y11 = y12;
		y12 = ty;
	}
	if (y11 > y13) {
		ty = y11;
		y11 = y13;
		y13 = ty;
	}
	if (y12 > y13) {
		ty = y13;
		y12 = y13;
		y13 = ty;
	}
	
	*x1 = x12;
	*y1 = y12;
}

/*
 * void D_Macroblock::Median_Predictor_3(short &mv_x0, short &mv_y0, short &mv_type0,
 *										 short &mv_x1, short &mv_y1, short &mv_type1,
 *										 double *x2, double *y2)
 * 
 * Find the median differential motion vector x and y indpendently
 * Handles median predictor for mvdb and normal motion vectors
 * This is a private method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	x, y
 * Ensures:		return median x motion vector in X, and median Y motion vector in Y
 *
 * Warning:		
 */
void D_Macroblock::Median_Predictor_3(short &mv_x0, short &mv_y0, short &mv_type0,
									  short &mv_x1, short &mv_y1, short &mv_type1,
									  double *x2, double *y2)
{
	double tx, ty;
	double x21, x22, x23;
	double y21, y22, y23;
	short this_ID;
	
	x21 = *_dmv_x31; y21 = *_dmv_y31;
	x22 = mv_x0; y22 = mv_y0;
	x23 = mv_x1; y23 = mv_y1;

	if ((*_dmv_type31 == 2) || (*_dmv_type31 == 4))  x21 += 0.5; 
	if ((mv_type0 == 2) || (mv_type0 == 4))  x22 += 0.5;
	if ((mv_type1 == 2) || (mv_type1 == 4))  x23 += 0.5;
	
	if (*_dmv_type31 > 2) y21 += 0.5;
	if (mv_type0 > 2) y22 += 0.5;
	if (mv_type1 > 2) y23 += 0.5;

	if (_independent_segment_mode || _slice_mode) {
		this_ID = *_seg_ID;
		
		if (*_dmv_ID31 != this_ID) {
			x21 = 0; y21 = 0;
		}
	}

	// Calculate X median
	if (x21 > x22) {
		tx = x21;
		x21 = x22;
		x22 = tx;
	}
	if (x21 > x23) {
		tx = x21;
		x21 = x23;
		x23 = tx;
	}
	if (x22 > x23) {
		tx = x23;
		x22 = x23;
		x23 = tx;
	}
	// Calculate Y median
	if (y21 > y22) {
		ty = y21;
		y21 = y22;
		y22 = ty;
	}
	if (y21 > y23) {
		ty = y21;
		y21 = y23;
		y23 = ty;
	}
	if (y22 > y23) {
		ty = y23;
		y22 = y23;
		y23 = ty;
	}
	
	*x2 = x22;
	*y2 = y22;
}

/*
 * void D_Macroblock::Median_Predictor_4(short &mv_x0, short &mv_y0, short &mv_type0,
 *										 short &mv_x1, short &mv_y1, short &mv_type1,
 *										 short &mv_x2, short &mv_y2, short &mv_type2,
 *										 double *x3, double *y3)
 * 
 * Find the median differential motion vector x and y indpendently
 * Handles median predictor for mvdb and normal motion vectors
 * This is a private method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	x, y
 * Ensures:		return median x motion vector in X, and median Y motion vector in Y
 *
 * Warning:		
 */
void D_Macroblock::Median_Predictor_4(short &mv_x0, short &mv_y0, short &mv_type0,
									  short &mv_x1, short &mv_y1, short &mv_type1,
									  short &mv_x2, short &mv_y2, short &mv_type2,
									  double *x3, double *y3)
{
	double tx, ty;
	double x31, x32, x33;
	double y31, y32, y33;
	
	x31 = mv_x2; y31 = mv_y2;
	x32 = mv_x0; y32 = mv_y0;	 
	x33 = mv_x1; y33 = mv_y1;	 

	if ((mv_type2 == 2) || (mv_type2 == 4))  x31 += 0.5; 
	if ((mv_type0 == 2) || (mv_type0 == 4))  x32 += 0.5;
	if ((mv_type1 == 2) || (mv_type1 == 4))  x33 += 0.5;
	
	if (mv_type2 > 2) y31 += 0.5;
	if (mv_type0 > 2) y32 += 0.5;
	if (mv_type1 > 2) y33 += 0.5;

	// Calculate X median
	if (x31 > x32) {
		tx = x31;
		x31 = x32;
		x32 = tx;
	}
	if (x31 > x33) {
		tx = x31;
		x31 = x33;
		x33 = tx;
	}
	if (x32 > x33) {
		tx = x33;
		x32 = x33;
		x33 = tx;
	}
	// Calculate Y median
	if (y31 > y32) {
		ty = y31;
		y31 = y32;
		y32 = ty;
	}
	if (y31 > y33) {
		ty = y31;
		y31 = y33;
		y33 = ty;
	}
	if (y32 > y33) {
		ty = y33;
		y32 = y33;
		y33 = ty;
	}
	
	*x3 = x32;
	*y3 = y32;
}

#endif

