
#ifndef __D_MACROBLOCK_ENCODE_MB_C__
#define __D_MACROBLOCK_ENCODE_MB_C__

#include "D_Macroblock.h"


/*
 * void D_Macroblock::Encode_MB(void)
 * 
 * Intiates macroblock encoding, which will call D_Block::Encode_BLK()
 * and D_Block_Pattern_Analyzer() after that, for each blocks pointed by _BLK_list
 * This is a public method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	6 blocks pointed by _BLK_list, _mcbpy, _mcbpc
 * Ensures:		call D_Block::Encode_BLK() and then D_Block::Block_Pattern_Analyzer() for 6 blocks pointed by _BLK_list
 *				MCBPC and MCBPC of INTER-coded blocks will be double checked again and reset if necessary
 *
 * Warning:		
 */
void D_Macroblock::Encode_MB(void)
{
	int i, j, k, mtype;
	D_Block *ptr_BLK;
	
	_clock++;
	j = *_mquant;
	mtype = *_mtype;
	ptr_BLK = _BLK_list;
	k = (*_mcbpy) << 2;
	k += *_mcbpc;
	
	if (*_cmi == true) return;		

	for (i=0; i<_BLK_per_mb; i++) {
		if (k & 32) ptr_BLK->Encode_BLK(j, false);
		ptr_BLK++;
		k <<= 1;
	}

	// Need to double check MCBP values
	ptr_BLK = _BLK_list;
	if ((mtype == INTRA) || (mtype == INTRAQ)) {	// INTRA 
		k = 0;
		for (i=0; i<4; i++) {
			k <<= 1;
			k |= ptr_BLK->Block_Pattern_Analyzer();
			ptr_BLK++;
		}
		*_mcbpy = (short) k;
	
		k = 0;
		for (i=0; i<2; i++) {
			k <<= 1;
			k |= ptr_BLK->Block_Pattern_Analyzer();
			ptr_BLK++;
		}
		*_mcbpc = (short) k;
	}
	else {											// INTER case
		k = *_mcbpy;
		for (i=0; i<4; i++) {
			if (k & 8) {
				if (0 == ptr_BLK->Block_Pattern_Analyzer())
					k ^= 8;
			}
			else ptr_BLK->Block_Pattern_Analyzer();
			ptr_BLK++;
			k <<= 1;
		}
		*_mcbpy = (short) (k >> 4);

		k = *_mcbpc;
		for (i=0; i<2; i++) {
			if (k & 2) {
				if (0 == ptr_BLK->Block_Pattern_Analyzer())
					k ^= 2;
			}
			else ptr_BLK->Block_Pattern_Analyzer();
			ptr_BLK++;
			k <<= 1;
		}
		*_mcbpc = (short) (k >> 2);

		// RARE case: need to reset cmi
		if ((!_PB_Ppicture_flag) && (*_mcbpy == 0) && (*_mcbpc == 0) &&
			(*_mv_type1 == 1) && (*_mv_x1 == 0) && (*_mv_y1 == 0)) {
			if(_advanced_prediction_mode) {
				if((*_mv_type2 == 1) && (*_mv_x2 == 0) && (*_mv_y2== 0) &&
					(*_mv_type3 == 1) && (*_mv_x3 == 0) && (*_mv_y3 == 0) &&
					(*_mv_type4 == 1) && (*_mv_x4 == 0) && (*_mv_y4 == 0))
					*_cmi = true;
			}
			else *_cmi = true;
		}
	}
}


/*
 * void D_Macroblock::Encode_MB(bool P_picture)
 * 
 * Intiates macroblock encoding, which will call D_Block::Encode_BLK()
 * and D_Block_Pattern_Analyzer() after that, for each blocks pointed by _BLK_list
 * This is a public method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	6 blocks pointed by _BLK_list, _mcbpy, _mcbpc
 * Ensures:		call D_Block::Encode_BLK() and then D_Block::Block_Pattern_Analyzer() for 6 blocks pointed by _BLK_list
 *				MCBPC and MCBPC of INTER-coded blocks will be double checked again and reset if necessary
 *
 * Warning:		
 */
void D_Macroblock::Encode_MB(bool P_picture)
{
	int i, j, k, mtype;
	D_Block *ptr_BLK;

	_clock++;
	if (P_picture) {
		j = *_mquant;
		mtype = *_mtype;
		k = (*_mcbpy) << 2;
		k += *_mcbpc;
		
		ptr_BLK = _BLK_list_PB;
		for (i=0; i<_BLK_per_mb; i++) {
			if (k & 32) ptr_BLK->Encode_BLK(j, false);
			ptr_BLK++;
			k <<= 1;
		}
		
		// Need to double check MCBP values
		ptr_BLK = _BLK_list_PB;
		if ((mtype == INTRA) || (mtype == INTRAQ)) {	// INTRA 

			k = 0;
			for (i=0; i<4; i++) {
				k <<= 1;
				k |= ptr_BLK->Block_Pattern_Analyzer();
				ptr_BLK++;
			}
			*_mcbpy = (short) k;
			
			k = 0;
			for (i=0; i<2; i++) {
				k <<= 1;
				k |= ptr_BLK->Block_Pattern_Analyzer();
				ptr_BLK++;
			}
			*_mcbpc = (short) k;

		}
		else {											// INTER case
			k = *_mcbpy;
			for (i=0; i<4; i++) {
				if (k & 8) {
					if (0 == ptr_BLK->Block_Pattern_Analyzer())
						k ^= 8;
				}
				else ptr_BLK->Block_Pattern_Analyzer();
				ptr_BLK++;
				k <<= 1;
			}
			*_mcbpy = (short) (k >> 4);
			
			k = *_mcbpc;
			for (i=0; i<2; i++) {
				if (k & 2) {
					if (0 == ptr_BLK->Block_Pattern_Analyzer())
						k ^= 2;
				}
				else ptr_BLK->Block_Pattern_Analyzer();
				ptr_BLK++;
				k <<= 1;
			}
			*_mcbpc = (short) (k >> 2);
			
		}

	}	// if (P_picture) {
	else {	// B Picture part

		j = *_bquant;
		k = *_mcbpb;
		
		ptr_BLK = _BLK_list;
		for (i=0; i<_BLK_per_mb; i++) {
			if (k & 32) ptr_BLK->Encode_BLK(j, true);
			ptr_BLK++;
			k <<= 1;
		}
		
		// Need to double check MCBPB values
		k = *_mcbpb;
		ptr_BLK = _BLK_list;
		for (i=0; i<4; i++) {
			if (k & 32) {
				if (0 == ptr_BLK->Block_Pattern_Analyzer())
					k ^= 32;
			}
			else ptr_BLK->Block_Pattern_Analyzer();
			ptr_BLK++;
			k <<= 1;
		}
		
		for (i=0; i<2; i++) {
			if (k & 32) {
				if (0 == ptr_BLK->Block_Pattern_Analyzer())
					k ^= 32;
			}
			else ptr_BLK->Block_Pattern_Analyzer();
			ptr_BLK++;
			k <<= 1;
		}
		*_mcbpb = (short) (k >> 6);
		
		// RARE case: need to reset cmi
		if ((*_mcbpy == 0) && (*_mcbpc == 0) && (*_mcbpb == 0) &&
			(*_mv_type1 == 1) && (*_mv_x1 == 0) && (*_mv_y1 == 0) &&
			(*_mv_type2 == 1) && (*_mv_x2 == 0) && (*_mv_y2 == 0) &&
			(*_mv_type3 == 1) && (*_mv_x3 == 0) && (*_mv_y3 == 0) &&
			(*_mv_type4 == 1) && (*_mv_x4 == 0) && (*_mv_y4 == 0) &&
			(*_mvd_type == 1) && (*_mvd_x == 0) && (*_mvd_y == 0)) {
			*_cmi = true;
		}

	}
}


#endif

