
#ifndef __D_MACROBLOCK_DECODE_MB_C__
#define __D_MACROBLOCK_DECODE_MB_C__

#include "D_Macroblock.h"


/*
 * void D_Macroblock::Decode_MB(void)
 * 
 * Intiates macroblock macroblock decoding, which will call D_Block::Decode_BLK()
 * This is a public method
 *
 * Requires:	Entropy_Encoder is called before invoking this method
 * Modifies:	6 blocks pointed by _BLK_list
 * Ensures:		call D_Block::Decode_BLK() 6 blocks pointed by _BLK_list
 *
 * Warning:		
 */
void D_Macroblock::Decode_MB(void)
{
	int i, j, k, mtype;
	D_Block *ptr_BLK;
	
	_clock++;
	j = *_mquant;
	mtype = *_mtype;
	ptr_BLK = _BLK_list;

	if (*_cmi == true) return; 
	
	// INTRA case
	if ( (mtype == INTRA) || (mtype == INTRAQ) ) {
		
		for (i=0; i<_BLK_per_mb; i++) {
			ptr_BLK->Decode_BLK(j, false);
			ptr_BLK++;
		}
	}
	else {	// INTER case

		k = (*_mcbpy) << 2;
		k += *_mcbpc;
		for (i=0; i<_BLK_per_mb; i++) {
			if (k & 32) ptr_BLK->Decode_BLK(j,false);
			ptr_BLK++;
			k <<= 1;
		}
	}
}


/*
 * void D_Macroblock::Decode_MB(bool P_picture)
 * 
 * Intiates macroblock macroblock decoding, which will call D_Block::Decode_BLK()
 * This is a public method
 *
 * Requires:	Entropy_Encoder is called before invoking this method
 * Modifies:	6 blocks pointed by _BLK_list
 * Ensures:		call D_Block::Decode_BLK() 6 blocks pointed by _BLK_list
 *
 * Warning:		
 */
void D_Macroblock::Decode_MB(bool P_picture)
{
	int i, j, k, mtype;
	D_Block *ptr_BLK;
	
	_clock++;
	if (*_cmi == true) return; 
	
	if (P_picture) {

		j = *_mquant;
		mtype = *_mtype;

		ptr_BLK = _BLK_list_PB;
		// INTRA case
		if ((mtype == INTRA) || (mtype == INTRAQ)) {
			
			for (i=0; i<_BLK_per_mb; i++) {
				ptr_BLK->Decode_BLK(j, false);
				ptr_BLK++;
			}

		}
		else {	// INTER case
			
			k = (*_mcbpy) << 2;
			k += *_mcbpc;
			for (i=0; i<_BLK_per_mb; i++) {
				if (k & 32) ptr_BLK->Decode_BLK(j, false);
				ptr_BLK++;
				k <<= 1;
			}
		}
		
	}	// if (P_picture) {
	else {	// B picture
		
		j = *_bquant;
		k = *_mcbpb;

		ptr_BLK = _BLK_list;
		for (i=0; i<_BLK_per_mb; i++) {
			if (k & 32) ptr_BLK->Decode_BLK(j, true);
			ptr_BLK++;
			k <<= 1;
		}
		
	}	// else {	// B picture

}


#endif

