
#ifndef __D_GOB_DECODE_GOB_C__
#define __D_GOB_DECODE_GOB_C__

#include "D_GOB.h"


/*
 * void D_GOB::Decode_GOB(void)
 * 
 * Intiates GOB decoding, which will call D_Macroblock::Decode_MB()
 * This is a public method
 *
 * Requires:	Entropy_Encoder is called before invoking this method
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		call D_Macroblock::Decode_MB() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Decode_GOB(void)
{
	D_Macroblock *ptr_MB;
	int i;
	
	// this part of the code is to be something else
	ptr_MB = _MB_list;
	for (i=0; i<_MB_per_gob; i++) {
		ptr_MB->Decode_MB();
		ptr_MB++;
	}
}


/*
 * void D_GOB::Decode_GOB(bool P_picture)
 * 
 * Intiates GOB decoding, which will call D_Macroblock::Decode_MB()
 * This is a public method
 *
 * Requires:	Entropy_Encoder is called before invoking this method
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		call D_Macroblock::Decode_MB() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Decode_GOB(bool P_picture)
{
	D_Macroblock *ptr_MB;
	int i;
	
	// this part of the code is to be something else
	ptr_MB = _MB_list;
	for (i=0; i<_MB_per_gob; i++) {
		ptr_MB->Decode_MB(P_picture);
		ptr_MB++;
	}
}

#endif

