
#ifndef __D_FRAME_TEMPORAL_PREDICTION_MODULE_C__
#define __D_FRAME_TEMPORAL_PREDICTION_MODULE_C__

#include "D_Frame.h"


/*
 * void D_Frame::Temporal_Prediction_Module(void)
 * 
 * Create prediction frame
 * This is a private method
 *
 * Requires:	D_Frame::Motion_Estimation is called first before this can be invoked
 * Modifies:	_shift_frame
 * Ensures:		Create prediction frame, based on motion vectors produced for the current frame
 *
 * Warning:		
 */
void D_Frame::Temporal_Prediction_Module(void)
{
	double tempx, tempy;
	int i, j, k, l, m, n, o;
	int dx, dy, t1, offset, residuex, residuey;
	int dx0, dy0, dx1, dy1, dx2, dy2, dx3, dy3;
	int Y_frame_disp0, Y_frame_disp1, Y_frame_disp2, Y_frame_disp3;
	short *ptr_mv_type1, *ptr_mv_x1, *ptr_mv_y1;
	short *ptr_mv_type2, *ptr_mv_x2, *ptr_mv_y2;
	short *ptr_mv_type3, *ptr_mv_x3, *ptr_mv_y3;
	short *ptr_mv_type4, *ptr_mv_x4, *ptr_mv_y4;
	unsigned char *ptr_prev_Y_c0, *ptr_prev_Y_c1, *ptr_prev_Y_c2, *ptr_prev_Y_c3;
	unsigned char *ptr_shift_Y_c, *ptr_shift_U_c, *ptr_shift_V_c; 
	unsigned char *ptr_prev_Y_c, *ptr_prev_U_c, *ptr_prev_V_c;


	// Variables to support rps and slice
	int slicenum = 0, slicesize = 0, slicecount = 0;

	offset = 0;
	if (_PB_Ppicture_flag) offset = _PB_offset;

	ptr_shift_Y_c = _shift_frame + offset;
	ptr_shift_U_c = _shift_frame + _picture_size + offset;
	ptr_shift_V_c = _shift_frame + _picture_size + _picture_size_quarter + offset;

	ptr_mv_type1 = _mv_type1; ptr_mv_x1 = _mv_x1; ptr_mv_y1 = _mv_y1;
	ptr_mv_type2 = _mv_type2; ptr_mv_x2 = _mv_x2; ptr_mv_y2 = _mv_y2;
	ptr_mv_type3 = _mv_type3; ptr_mv_x3 = _mv_x3; ptr_mv_y3 = _mv_y3;
	ptr_mv_type4 = _mv_type4; ptr_mv_x4 = _mv_x4; ptr_mv_y4 = _mv_y4;

	// Code fragments to rid of compiler warnings
	ptr_prev_Y_c = ptr_prev_U_c = ptr_prev_V_c = NULL;
	ptr_prev_Y_c0 = ptr_prev_Y_c1 = ptr_prev_Y_c2 = ptr_prev_Y_c3 = NULL;

	
	if (!(_advanced_prediction_mode || _PB_frame_mode)) {	// Baseline case	

		for (i=0; i<_GOB_per_frame; i++) {

			if (_reference_picture_selection && !_slice_mode) _ref_index = _trp[i];
			for (j=0; j<_MB_per_gob; j++) {

				if (_reference_picture_selection && _slice_mode) {
					if (slicecount == slicesize) {
						slicesize = _slice_size[slicenum];
						slicenum++; slicecount = 0;
						_ref_index = _trp[i];
					}
					slicecount++;
				}
				
				// Y displacement stored in n
				dx = (j << 4) + *ptr_mv_x1;
				dy = (i << 4) + *ptr_mv_y1;
				n = dx + (dy * _frame_xsize);
				
				// UV adjusted displacement stored in o
				tempx = (float) (*ptr_mv_x1++ + ((*ptr_mv_type1 + 1) % 2) * 0.5);
				tempy = (float) (*ptr_mv_y1++ + ((*ptr_mv_type1 - 1) >> 1) * 0.5);
				tempx /= 2;
				tempy /= 2;
				t1 = 1;
				if (tempx != (int) tempx) t1 = 2;
				if (tempy != (int) tempy) t1 += 2;
				o = (int) (floor(tempx) + (floor(tempy) * _frame_xsize_half));
				o += (j << 3) + ((i << 3) * _frame_xsize_half);
				
				// Based on the mv_type0 the corresponding sub-pixel interpolated frame 
				// is picked
				switch (*ptr_mv_type1++) {
				case 1:
					if (_reference_picture_selection) ptr_prev_Y_c = _prev_frames->GetFrame(_ref_index);
					else ptr_prev_Y_c = _decoded_frame;
					break;
				case 2:
					if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_full->GetFrame(_ref_index);
					else ptr_prev_Y_c = _decoded_frame_half_full;
					break;
				case 3:
					if (_reference_picture_selection) ptr_prev_Y_c = _prev_full_half->GetFrame(_ref_index);
					else ptr_prev_Y_c = _decoded_frame_full_half;
					break;
				case 4:
					if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_half->GetFrame(_ref_index);
					else ptr_prev_Y_c = _decoded_frame_half_half;
					break;
				default:
					fprintf(stdout, "Invalid MVTYPE\n");
					exit(-1);
				}
				

				// Even if the motion vectors for the Y are integers, when they are
				// propagated to the U and V frames, they may not remain integers. Hence
				// there may be a different choice of the sub-pixel interpolated frame
				// for U and V as compared to y

				switch (t1) {			
				case 1:
					if (_reference_picture_selection) {
						ptr_prev_U_c = _prev_frames->GetFrame(_ref_index) + _picture_size;
						ptr_prev_V_c = _prev_frames->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
					}
					else {
						ptr_prev_U_c = _decoded_frame + _picture_size;
						ptr_prev_V_c = _decoded_frame + _picture_size + _picture_size_quarter;
					}
					break;
				case 2:
					if (_reference_picture_selection) {
						ptr_prev_U_c = _prev_half_full->GetFrame(_ref_index) + _picture_size;
						ptr_prev_V_c = _prev_half_full->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
					}
					else {
						ptr_prev_U_c = _decoded_frame_half_full + _picture_size;
						ptr_prev_V_c = _decoded_frame_half_full + _picture_size + _picture_size_quarter;
					}
					break;
				case 3:
					if (_reference_picture_selection) {
						ptr_prev_U_c = _prev_full_half->GetFrame(_ref_index) + _picture_size;
						ptr_prev_V_c = _prev_full_half->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
					}
					else {
						ptr_prev_U_c = _decoded_frame_full_half + _picture_size;
						ptr_prev_V_c = _decoded_frame_full_half + _picture_size + _picture_size_quarter;
					}
					break;
				case 4:
					if (_reference_picture_selection) {
						ptr_prev_U_c = _prev_half_half->GetFrame(_ref_index) + _picture_size;
						ptr_prev_V_c = _prev_half_half->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
					}
					else {
						ptr_prev_U_c = _decoded_frame_half_half + _picture_size;
						ptr_prev_V_c = _decoded_frame_half_half + _picture_size + _picture_size_quarter;
					}
					break;
				default:
					exit(-1);
				}
				
				ptr_prev_Y_c += n;
				ptr_prev_U_c += o;
				ptr_prev_V_c += o;
				
				// Copy shifted pixel values for Y blocks to shift_frame, 1-D representation
				for (k=0; k<2; k++) {
					for (l=0; l<8; l++) {
						for (m=0; m<8; m++) {
							*ptr_shift_Y_c++ = *ptr_prev_Y_c++;
						}
						ptr_prev_Y_c += (_frame_xsize - 8);
					}
					ptr_shift_Y_c += 64;
				}
				
				ptr_shift_Y_c -= (64 * 3);
				ptr_prev_Y_c -= ((_frame_xsize << 4) - 8);
				
				for (k=0; k<2; k++) {
					for (l=0; l<8; l++) {
						for (m=0; m<8; m++) {
							*ptr_shift_Y_c++ = *ptr_prev_Y_c++;
						}
						ptr_prev_Y_c += (_frame_xsize - 8);
					}
					ptr_shift_Y_c += 64;
				}
				ptr_shift_Y_c -= 64;
				
				// Copy shifted pixel values for U and V blocks to shift_frame, 1-D representation	
				for (l=0; l<8; l++) {
					for (m=0; m<8; m++) {
						*ptr_shift_U_c++ = *ptr_prev_U_c++;
						*ptr_shift_V_c++ = *ptr_prev_V_c++;
					}
					ptr_prev_U_c += (_frame_xsize_half - 8);
					ptr_prev_V_c += (_frame_xsize_half - 8);
				}


			} // for (j=0; j<_MB_xcount; j++)
		} // (i=0; i<_MB_ycount; i++)

	}	// if(!_advanced_predciction_mode)	// Baseline case

	else {		// Advaced Prediction Mode routine

		for (i=0; i<_GOB_per_frame; i++) {
			if (_reference_picture_selection) _ref_index = _trp[i];
			for (j=0; j<_MB_per_gob; j++) {
				
				// Y displacement for Block 0
				dx0 = (j << 4) + *ptr_mv_x1;
				dy0 = (i << 4) + *ptr_mv_y1;
				Y_frame_disp0 = dx0 + (dy0 * _frame_xsize);

				// Y displacement forBlock 1
				dx1 = (j << 4) + 8 + *ptr_mv_x2;
				dy1 = (i << 4) + *ptr_mv_y2;
				Y_frame_disp1 = dx1 + (dy1 * _frame_xsize);

				// Y displacement forBlock 2
				dx2 = (j << 4) + *ptr_mv_x3;
				dy2 = (i << 4) + 8 + *ptr_mv_y3;
				Y_frame_disp2 = dx2 + (dy2 * _frame_xsize);

				// Y displacement forBlock 3
				dx3 = (j << 4) + 8 + *ptr_mv_x4;
				dy3 = (i << 4) + 8 + *ptr_mv_y4;
				Y_frame_disp3 = dx3 + (dy3 * _frame_xsize);
				
				// UV adjusted displacement stored in o
				tempx = (float) (*ptr_mv_x1++ + ((*ptr_mv_type1 + 1) % 2) * 0.5);
				tempx += (float) (*ptr_mv_x2++ + ((*ptr_mv_type2 + 1) % 2) * 0.5);
				tempx += (float) (*ptr_mv_x3++ + ((*ptr_mv_type3 + 1) % 2) * 0.5);
				tempx += (float) (*ptr_mv_x4++ + ((*ptr_mv_type4 + 1) % 2) * 0.5);
				
				tempy = (float) (*ptr_mv_y1++ + ((*ptr_mv_type1 - 1) >> 1) * 0.5);
				tempy += (float) (*ptr_mv_y2++ + ((*ptr_mv_type2 - 1) >> 1) * 0.5);
				tempy += (float) (*ptr_mv_y3++ + ((*ptr_mv_type3 - 1) >> 1) * 0.5);
				tempy += (float) (*ptr_mv_y4++ + ((*ptr_mv_type4 - 1) >> 1) * 0.5);
				
				residuex = (int)(2 * tempx) % 16;
				residuey = (int)(2 * tempy) % 16;
				
				tempx /= 8;
				tempy /= 8;

				// Table F.1 implemented below. Check efficiency !
				t1 = 1;
				if (residuex >= 0) {
					if (residuex <= 2) tempx = floor(tempx);
					else if(residuex >= 14) tempx = ceil(tempx);
					else {
						tempx = floor(tempx);
						t1 = 2;
					}
				}
				else {
					if (residuex >= -2) tempx = ceil(tempx);
					else if (residuex <= -14) tempx = floor(tempx);
					else {
						tempx = floor(tempx);
						t1 = 2;
					}
				}

				if (residuey >= 0) {
					if(residuey <= 2) tempy = floor(tempy);
					else if (residuey >= 14) tempy = ceil(tempy);
					else {
						tempy = floor(tempy);
						t1 += 2;
					}
				}
				else {
					if (residuey >= -2) tempy = ceil(tempy);
					else if (residuey <= -14) tempy = floor(tempy);
					else {
						tempy = floor(tempy);
						t1 += 2;
					}
				}
				
				o = ((int) (tempx)) + ((int) (tempy)) * _frame_xsize_half;
				o += (j << 3) + ((i << 3) * _frame_xsize_half);
				
				// Based on the mv_type0 the corresponding sub-pixel interpolated frame 
				// is picked
				switch (*ptr_mv_type1++) {
				case 1:
					if (_reference_picture_selection) ptr_prev_Y_c0 = _prev_frames->GetFrame(_ref_index);
					else ptr_prev_Y_c0 = _decoded_frame;
					break;
				case 2:
					if (_reference_picture_selection) ptr_prev_Y_c0 = _prev_half_full->GetFrame(_ref_index);
					else ptr_prev_Y_c0 = _decoded_frame_half_full;
					break;
				case 3:
					if (_reference_picture_selection) ptr_prev_Y_c0 = _prev_full_half->GetFrame(_ref_index);
					else ptr_prev_Y_c0 = _decoded_frame_full_half;
					break;
				case 4:
					if (_reference_picture_selection) ptr_prev_Y_c0 = _prev_half_half->GetFrame(_ref_index);
					else ptr_prev_Y_c0 = _decoded_frame_half_half;
					break;
				default:
					fprintf(stdout, "Invalid MVTYPE\n");
					exit(-1);
				}

				// Based on the mv_type1 the corresponding sub-pixel interpolated frame 
				// is picked
				switch (*ptr_mv_type2++) {
				case 1:
					if (_reference_picture_selection) ptr_prev_Y_c1 = _prev_frames->GetFrame(_ref_index);
					else ptr_prev_Y_c1 = _decoded_frame;
					break;
				case 2:
					if (_reference_picture_selection) ptr_prev_Y_c1 = _prev_half_full->GetFrame(_ref_index);
					else ptr_prev_Y_c1 = _decoded_frame_half_full;
					break;
				case 3:
					if (_reference_picture_selection) ptr_prev_Y_c1 = _prev_full_half->GetFrame(_ref_index);
					else ptr_prev_Y_c1 = _decoded_frame_full_half;
					break;
				case 4:
					if (_reference_picture_selection) ptr_prev_Y_c1 = _prev_half_half->GetFrame(_ref_index);
					else ptr_prev_Y_c1 = _decoded_frame_half_half;
					break;
				default:
					fprintf(stdout, "Invalid MVTYPE\n");
					exit(-1);
				}

				// Based on the mv_type2 the corresponding sub-pixel interpolated frame 
				// is picked
				switch (*ptr_mv_type3++) {
				case 1:
					if (_reference_picture_selection) ptr_prev_Y_c2 = _prev_frames->GetFrame(_ref_index);
					else ptr_prev_Y_c2 = _decoded_frame;
					break;
				case 2:
					if (_reference_picture_selection) ptr_prev_Y_c2 = _prev_half_full->GetFrame(_ref_index);
					else ptr_prev_Y_c2 = _decoded_frame_half_full;
					break;
				case 3:
					if (_reference_picture_selection) ptr_prev_Y_c2 = _prev_full_half->GetFrame(_ref_index);
					else ptr_prev_Y_c2 = _decoded_frame_full_half;
					break;
				case 4:
					if (_reference_picture_selection) ptr_prev_Y_c2 = _prev_half_half->GetFrame(_ref_index);
					else ptr_prev_Y_c2 = _decoded_frame_half_half;
					break;
				default:
					fprintf(stdout, "Invalid MVTYPE\n");
					exit(-1);
				}

				// Based on the mv_type3 the corresponding sub-pixel interpolated frame 
				// is picked
				switch (*ptr_mv_type4++) {
				case 1:
					if (_reference_picture_selection) ptr_prev_Y_c3 = _prev_frames->GetFrame(_ref_index);
					else ptr_prev_Y_c3 = _decoded_frame;
					break;
				case 2:
					if (_reference_picture_selection) ptr_prev_Y_c3 = _prev_half_full->GetFrame(_ref_index);
					else ptr_prev_Y_c3 = _decoded_frame_half_full;
					break;
				case 3:
					if (_reference_picture_selection) ptr_prev_Y_c3 = _prev_full_half->GetFrame(_ref_index);
					else ptr_prev_Y_c3 = _decoded_frame_full_half;
					break;
				case 4:
					if (_reference_picture_selection) ptr_prev_Y_c3 = _prev_half_half->GetFrame(_ref_index);
					else ptr_prev_Y_c3 = _decoded_frame_half_half;
					break;

				default:
					fprintf(stdout, "Invalid MVTYPE\n");
					exit(-1);
				}
				
				
				// The following part remains the same
				// Even if the motion vectors for the Y are integers, when they are
				// propagated to the U and V frames, they may not remain integers. Hence
				// there may be a different choice of the sub-pixel interpolated frame
				// for U and V as compared to y*/
				switch (t1) {			
				case 1:
					if (_reference_picture_selection) {
						ptr_prev_U_c = _prev_frames->GetFrame(_ref_index) + _picture_size;
						ptr_prev_V_c = _prev_frames->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
					}
					else {
						ptr_prev_U_c = _decoded_frame + _picture_size;
						ptr_prev_V_c = _decoded_frame + _picture_size + _picture_size_quarter;
					}
					break;
				case 2:
					if (_reference_picture_selection) {
						ptr_prev_U_c = _prev_half_full->GetFrame(_ref_index) + _picture_size;
						ptr_prev_V_c = _prev_half_full->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
					}
					else {
						ptr_prev_U_c = _decoded_frame_half_full + _picture_size;
						ptr_prev_V_c = _decoded_frame_half_full + _picture_size + _picture_size_quarter;
					}
					break;
				case 3:
					if (_reference_picture_selection) {
						ptr_prev_U_c = _prev_full_half->GetFrame(_ref_index) + _picture_size;
						ptr_prev_V_c = _prev_full_half->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
					}
					else {
						ptr_prev_U_c = _decoded_frame_full_half + _picture_size;
						ptr_prev_V_c = _decoded_frame_full_half + _picture_size + _picture_size_quarter;
					}
					break;
				case 4:
					if (_reference_picture_selection) {
						ptr_prev_U_c = _prev_half_half->GetFrame(_ref_index) + _picture_size;
						ptr_prev_V_c = _prev_half_half->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
					}
					else {
						ptr_prev_U_c = _decoded_frame_half_half + _picture_size;
						ptr_prev_V_c = _decoded_frame_half_half + _picture_size + _picture_size_quarter;
					}
					break;
				default:
					exit(-1);
				}

				ptr_prev_Y_c0 += Y_frame_disp0;
				ptr_prev_Y_c1 += Y_frame_disp1;
				ptr_prev_Y_c2 += Y_frame_disp2;
				ptr_prev_Y_c3 += Y_frame_disp3;
				ptr_prev_U_c += o;
				ptr_prev_V_c += o;
				
				// Copy shifted pixel values for Y0 block to shift_frame,
				// 1-D representation
				for (l=0; l<8; l++) {
					for (m=0; m<8; m++) {
						*ptr_shift_Y_c++ = *ptr_prev_Y_c0++;
					}
					ptr_prev_Y_c0 += (_frame_xsize - 8);
				}
				// Y1 block 
				for (l=0; l<8; l++) {
					for (m=0; m<8; m++) {
						*ptr_shift_Y_c++ = *ptr_prev_Y_c1++;
					}
					ptr_prev_Y_c1 += (_frame_xsize - 8);
				}
				// Y2 block
				for (l=0; l<8; l++) {
					for (m=0; m<8; m++) {
						*ptr_shift_Y_c++ = *ptr_prev_Y_c2++;
					}
					ptr_prev_Y_c2 += (_frame_xsize - 8);
				}
				// Y3 block
				for (l=0; l<8; l++) {
					for (m=0; m<8; m++) {
						*ptr_shift_Y_c++ = *ptr_prev_Y_c3++;
					}
					ptr_prev_Y_c3 += (_frame_xsize - 8);
				}
				
				// Copy shifted pixel values for U and V blocks to shift_frame, 1-D representation	
				for (l=0; l<8; l++) {
					for (m=0; m<8; m++) {
						*ptr_shift_U_c++ = *ptr_prev_U_c++;
						*ptr_shift_V_c++ = *ptr_prev_V_c++;
					}
					ptr_prev_U_c += (_frame_xsize_half - 8);
					ptr_prev_V_c += (_frame_xsize_half - 8);
				}

			} // for (j=0; j<_MB_xcount; j++)
		} // (i=0; i<_MB_ycount; i++)

	}	// else {		// Advaced Prediction Mode routine

}


/*
 * void D_Frame::Temporal_Prediction_Module(bool PB_AP)
 * 
 * Create prediction frame
 * This is a private method
 *
 * Requires:	
 * Modifies:	_shift_frame
 * Ensures:		Create prediction frame, based on ...
 *
 * Warning:		
 */
void D_Frame::Temporal_Prediction_Module(bool PB_AP)
{

	double tx, ty;
	int i, j, k, l, m, n, p, q, r, s;
	int dx, dy, disp1, disp2;
	unsigned char *ptr_shift_Y_c, *ptr_shift_U_c, *ptr_shift_V_c;
	unsigned char *ptr_prev_Y_c, *ptr_prev_U_c, *ptr_prev_V_c; 
	unsigned char *ptr_prev_pY_c, *ptr_prev_pU_c, *ptr_prev_pV_c;	// P for P-picture
	unsigned char buffer_1D[64], *ptr_c;

	// forward and backward motion vectors
	short *ptr_mv_type1_f, *ptr_mv_x1_f, *ptr_mv_y1_f;
	short *ptr_mv_type1_b, *ptr_mv_x1_b, *ptr_mv_y1_b;	
	short *ptr_mv_type2_f, *ptr_mv_x2_f, *ptr_mv_y2_f;
	short *ptr_mv_type2_b, *ptr_mv_x2_b, *ptr_mv_y2_b;	
	short *ptr_mv_type3_f, *ptr_mv_x3_f, *ptr_mv_y3_f;
	short *ptr_mv_type3_b, *ptr_mv_x3_b, *ptr_mv_y3_b;	
	short *ptr_mv_type4_f, *ptr_mv_x4_f, *ptr_mv_y4_f;
	short *ptr_mv_type4_b, *ptr_mv_x4_b, *ptr_mv_y4_b;	
	
	// Chrominance component
	short *ptr_mv_type_uv_f, *ptr_mv_uvx_f, *ptr_mv_uvy_f;	
	short *ptr_mv_type_uv_b, *ptr_mv_uvx_b, *ptr_mv_uvy_b;
	
	// Decoded Frame(s)
	ptr_prev_Y_c = NULL; ptr_prev_U_c = NULL; ptr_prev_V_c = NULL;
	ptr_prev_pY_c = NULL; ptr_prev_pU_c = NULL; ptr_prev_pV_c = NULL;

	// Prediction Frame
	ptr_shift_Y_c = _shift_frame;
	ptr_shift_U_c = _shift_frame + _picture_size;
	ptr_shift_V_c = _shift_frame + _picture_size + _picture_size_quarter;

	// Forward Motion Vectors
	ptr_mv_type1_f = _mv_type1_f; ptr_mv_x1_f = _mv_x1_f; ptr_mv_y1_f = _mv_y1_f;
	ptr_mv_type2_f = _mv_type2_f; ptr_mv_x2_f = _mv_x2_f; ptr_mv_y2_f = _mv_y2_f;
	ptr_mv_type3_f = _mv_type3_f; ptr_mv_x3_f = _mv_x3_f; ptr_mv_y3_f = _mv_y3_f;
	ptr_mv_type4_f = _mv_type4_f; ptr_mv_x4_f = _mv_x4_f; ptr_mv_y4_f = _mv_y4_f;

	// Backward Motion Vectors
	ptr_mv_type1_b = _mv_type1_b; ptr_mv_x1_b = _mv_x1_b; ptr_mv_y1_b = _mv_y1_b;
	ptr_mv_type2_b = _mv_type2_b; ptr_mv_x2_b = _mv_x2_b; ptr_mv_y2_b = _mv_y2_b;
	ptr_mv_type3_b = _mv_type3_b; ptr_mv_x3_b = _mv_x3_b; ptr_mv_y3_b = _mv_y3_b;
	ptr_mv_type4_b = _mv_type4_b; ptr_mv_x4_b = _mv_x4_b; ptr_mv_y4_b = _mv_y4_b;

	// Chrominance Motion Vectors
	ptr_mv_type_uv_f = _mv_type_uv_f; ptr_mv_uvx_f = _mv_uvx_f; ptr_mv_uvy_f = _mv_uvy_f;
	ptr_mv_type_uv_b = _mv_type_uv_b; ptr_mv_uvx_b = _mv_uvx_b; ptr_mv_uvy_b = _mv_uvy_b;


	if (PB_AP) ;

	for (i=0; i<_GOB_per_frame; i++) {
		if (_reference_picture_selection) _ref_index = _trp[i];
		for (j=0; j<_MB_per_gob; j++) {
			
			// First Y block
			dx = (int) ((j << 4) + *ptr_mv_x1_f);
			dy = (int) ((i << 4) + *ptr_mv_y1_f);
			disp1 = dx + (dy * _frame_xsize);

			tx = *ptr_mv_x1_b;
			ty = *ptr_mv_y1_b;
			dx = (int) ((j << 4) + tx);
			dy = (int) ((i << 4) + ty);
			disp2 = dx + (dy * _frame_xsize);

			m = (int) ((-tx + 1) / 2);
			if (m < 0) m = 0;
			n = 15 - (int) ((-tx + 1) / 2);
			if (n > 7) n = 7;
			
			p = (int) ((-ty + 1) / 2);
			if (p < 0) p = 0;
			q = 15 - (int) ((-ty + 1) / 2);
			if (q > 7) q = 7;

			switch (*ptr_mv_type1_f) {
			case 1:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_frames->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame;
				break;
			case 2:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_full->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_half_full;
				break;
			case 3:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_full_half->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_full_half;
				break;
			case 4:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_half->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_half_half;
				break;
			default:
				fprintf(stdout, "Invalid forward MVTYPE\n");
				exit(-1);
			}

			ptr_prev_Y_c += disp1;
			for (k=0; k< 8; k++) {
				for (l=0; l<8; l++) {
					*ptr_shift_Y_c++ = *ptr_prev_Y_c++;
				}
				ptr_prev_Y_c += (_frame_xsize - 8);
			}

			if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted

				switch (*ptr_mv_type1_b) {
				case 1:
					ptr_prev_pY_c = _decoded_frame + _PB_offset;
					break;
				case 2:
					ptr_prev_pY_c = _decoded_frame_half_full + _PB_offset;
					break;
				case 3:
					ptr_prev_pY_c = _decoded_frame_full_half + _PB_offset;
					break;
				case 4:
					ptr_prev_pY_c = _decoded_frame_half_half + _PB_offset;
					break;
				default:
					fprintf(stdout, "Invalid backward MVTYPE\n");
					exit(-1);
				}

				ptr_prev_pY_c += disp2;
				ptr_c = buffer_1D;
				for (k=0; k<8; k++) {
					for (l=0; l<8; l++) {
						*ptr_c++ = *ptr_prev_pY_c++;
					}
					ptr_prev_pY_c += (_frame_xsize - 8);
				}

				ptr_shift_Y_c -= 64;				
				ptr_c = buffer_1D;
				for (k=p; k<=q; k++) {
					r = k << 3;
					for (l=m, s=r+m; l<=n; l++, s++) {
						*(ptr_shift_Y_c + s) = (unsigned char)
							((*(ptr_shift_Y_c + s) + *(ptr_c + s)) / 2);
						}
				}

				ptr_shift_Y_c += 64;
			}
			
					
			// Second Y block
			dx = (int) ((j << 4) + 8 + *ptr_mv_x2_f);
			dy = (int) ((i << 4) + *ptr_mv_y2_f);
			disp1 = dx + (dy * _frame_xsize);

			tx = *ptr_mv_x2_b;
			ty = *ptr_mv_y2_b;
			dx = (int) ((j << 4) + 8 + tx);
			dy = (int) ((i << 4) + ty);
			disp2 = dx + (dy * _frame_xsize);

			m = (int) ((-tx + 1) / 2);
			if (m < 0) m = 0;
			n = 15 - (int) ((-tx + 1) / 2);
			if (n > 7) n = 7;

			p = (int) ((-ty + 1) / 2);
			if (p < 0) p = 0;
			q = 15 - (int) ((-ty + 1) / 2);
			if (q > 7) q = 7;

			switch (*ptr_mv_type2_f) {
			case 1:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_frames->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame;
				break;
			case 2:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_full->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_half_full;
				break;
			case 3:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_full_half->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_full_half;
				break;
			case 4:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_half->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_half_half;
				break;
			default:
				fprintf(stdout, "Invalid forward MVTYPE\n");
				exit(-1);
			}

			ptr_prev_Y_c += disp1;

			for (k=0; k< 8; k++) {
				for (l=0; l<8; l++) {
					*ptr_shift_Y_c++ = *ptr_prev_Y_c++;
				}
				ptr_prev_Y_c += (_frame_xsize - 8);
			}

			if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted

				switch (*ptr_mv_type2_b) {
				case 1:
					ptr_prev_pY_c = _decoded_frame + _PB_offset;
					break;
				case 2:
					ptr_prev_pY_c = _decoded_frame_half_full + _PB_offset;
					break;
				case 3:
					ptr_prev_pY_c = _decoded_frame_full_half + _PB_offset;
					break;
				case 4:
					ptr_prev_pY_c = _decoded_frame_half_half + _PB_offset;
					break;
				default:
					fprintf(stdout, "Invalid backward MVTYPE\n");
					exit(-1);
				}

				ptr_prev_pY_c += disp2;
				ptr_c = buffer_1D;
				for (k=0; k<8; k++) {
					for (l=0; l<8; l++) {
						*ptr_c++ = *ptr_prev_pY_c++;
					}
					ptr_prev_pY_c += (_frame_xsize - 8);
				}

				ptr_shift_Y_c -= 64;				
				ptr_c = buffer_1D;
				for (k=p; k<=q; k++) {
					r = k << 3;
					for (l=m, s=r+m; l<=n; l++, s++) {
						*(ptr_shift_Y_c + s) = (unsigned char)
							((*(ptr_shift_Y_c + s) + *(ptr_c + s)) / 2);
						}
				}

				ptr_shift_Y_c += 64;
			}


			// Third Y block
			dx = (int) ((j << 4) + *ptr_mv_x3_f);
			dy = (int) ((i << 4) + 8 + *ptr_mv_y3_f);
			disp1 = dx + (dy * _frame_xsize);

			tx = *ptr_mv_x3_b;
			ty = *ptr_mv_y3_b;
			dx = (int) ((j << 4) + tx);
			dy = (int) ((i << 4) + 8 + ty);
			disp2 = dx + (dy * _frame_xsize);

			m = (int) ((-tx + 1) / 2);
			if (m < 0) m = 0;
			n = 15 - (int) ((-tx + 1) / 2);
			if (n > 7) n = 7;

			p = (int) ((-ty + 1) / 2);
			if (p < 0) p = 0;
			q = 15 - (int) ((-ty + 1) / 2);
			if (q > 7) q = 7;

			switch (*ptr_mv_type3_f) {
			case 1:
				if(_reference_picture_selection) ptr_prev_Y_c = _prev_frames->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame;
				break;
			case 2:
				if(_reference_picture_selection) ptr_prev_Y_c = _prev_half_full->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_half_full;
				break;
			case 3:
				if(_reference_picture_selection) ptr_prev_Y_c = _prev_full_half->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_full_half;
				break;
			case 4:
				if(_reference_picture_selection) ptr_prev_Y_c = _prev_half_half->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_half_half;
				break;
			default:
				fprintf(stdout, "Invalid forward MVTYPE\n");
				exit(-1);
			}

			ptr_prev_Y_c += disp1;

			for (k=0; k< 8; k++) {
				for (l=0; l<8; l++) {
					*ptr_shift_Y_c++ = *ptr_prev_Y_c++;
				}
				ptr_prev_Y_c += (_frame_xsize - 8);
			}

			if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted

				switch (*ptr_mv_type3_b) {
				case 1:
					ptr_prev_pY_c = _decoded_frame + _PB_offset;
					break;
				case 2:
					ptr_prev_pY_c = _decoded_frame_half_full + _PB_offset;
					break;
				case 3:
					ptr_prev_pY_c = _decoded_frame_full_half + _PB_offset;
					break;
				case 4:
					ptr_prev_pY_c = _decoded_frame_half_half + _PB_offset;
					break;
				default:
					fprintf(stdout, "Invalid backward MVTYPE\n");
					exit(-1);
				}

				ptr_prev_pY_c += disp2;
				ptr_c = buffer_1D;
				for (k=0; k<8; k++) {
					for (l=0; l<8; l++) {
						*ptr_c++ = *ptr_prev_pY_c++;
					}
					ptr_prev_pY_c += (_frame_xsize - 8);
				}

				ptr_shift_Y_c -= 64;				
				ptr_c = buffer_1D;
				for (k=p; k<=q; k++) {
					r = k << 3;
					for (l=m, s=r+m; l<=n; l++, s++) {
						*(ptr_shift_Y_c + s) = (unsigned char)
							((*(ptr_shift_Y_c + s) + *(ptr_c + s)) / 2);
						}
				}

				ptr_shift_Y_c += 64;
			}
			

			// Fourth Y block
			dx = (int) ((j << 4) + 8 + *ptr_mv_x4_f);
			dy = (int) ((i << 4) + 8 + *ptr_mv_y4_f);
			disp1 = dx + (dy * _frame_xsize);

			tx = *ptr_mv_x4_b;
			ty = *ptr_mv_y4_b;
			dx = (int) ((j << 4) + 8 + tx);
			dy = (int) ((i << 4) + 8 + ty);
			disp2 = dx + (dy * _frame_xsize);

			m = (int) ((-tx + 1) / 2);
			if (m < 0) m = 0;
			n = 15 - (int) ((-tx + 1) / 2);
			if (n > 7) n = 7;

			p = (int) ((-ty + 1) / 2);
			if (p < 0) p = 0;
			q = 15 - (int) ((-ty + 1) / 2);
			if (q > 7) q = 7;

			switch (*ptr_mv_type4_f) {
			case 1:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_frames->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame;
				break;
			case 2:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_full->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_half_full;
				break;
			case 3:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_full_half->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_full_half;
				break;
			case 4:
				if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_half->GetFrame(_ref_index);
				else ptr_prev_Y_c = _decoded_frame_half_half;
				break;
			default:
				fprintf(stdout, "Invalid forward MVTYPE\n");
				exit(-1);
			}

			ptr_prev_Y_c += disp1;

			for (k=0; k< 8; k++) {
				for (l=0; l<8; l++) {
					*ptr_shift_Y_c++ = *ptr_prev_Y_c++;
				}
				ptr_prev_Y_c += (_frame_xsize - 8);
			}

			if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted

				switch (*ptr_mv_type4_b) {
				case 1:
					ptr_prev_pY_c = _decoded_frame + _PB_offset;
					break;
				case 2:
					ptr_prev_pY_c = _decoded_frame_half_full + _PB_offset;
					break;
				case 3:
					ptr_prev_pY_c = _decoded_frame_full_half + _PB_offset;
					break;
				case 4:
					ptr_prev_pY_c = _decoded_frame_half_half + _PB_offset;
					break;
				default:
					fprintf(stdout, "Invalid backward MVTYPE\n");
					exit(-1);
				}

				ptr_prev_pY_c += disp2;
				ptr_c = buffer_1D;
				for (k=0; k<8; k++) {
					for (l=0; l<8; l++) {
						*ptr_c++ = *ptr_prev_pY_c++;
					}
					ptr_prev_pY_c += (_frame_xsize - 8);
				}

				ptr_shift_Y_c -= 64;				
				ptr_c = buffer_1D;
				for (k=p; k<=q; k++) {
					r = k << 3;
					for (l=m, s=r+m; l<=n; l++, s++) {
						*(ptr_shift_Y_c + s) = (unsigned char)
							((*(ptr_shift_Y_c + s) + *(ptr_c + s)) / 2);
						}
				}

				ptr_shift_Y_c += 64;
			}


			// U block
			dx = (int) ((j << 3) + *ptr_mv_uvx_f);
			dy = (int) ((i << 3) + *ptr_mv_uvy_f);
			disp1 = dx + (dy * _frame_xsize_half);

			tx = *ptr_mv_uvx_b;
			ty = *ptr_mv_uvy_b;
			dx = (int) ((j << 3) + tx);
			dy = (int) ((i << 3) + ty);
			disp2 = dx + (dy * _frame_xsize_half);

			m = (int) ((-tx + 1) / 2);
			if (m < 0) m = 0;
			n = 7 - (int) ((-tx + 1) / 2);
			if (n > 7) n = 7;

			p = (int) ((-ty + 1) / 2);
			if (p < 0) p = 0;
			q = 7 - (int) ((-ty + 1) / 2);
			if (q > 7) q = 7;

			switch (*ptr_mv_type_uv_f) {
			case 1:
				if (_reference_picture_selection) ptr_prev_U_c = _prev_frames->GetFrame(_ref_index) + _picture_size;
				else ptr_prev_U_c = _decoded_frame + _picture_size;
				break;
			case 2:
				if (_reference_picture_selection) ptr_prev_U_c = _prev_half_full->GetFrame(_ref_index) + _picture_size;
				else ptr_prev_U_c = _decoded_frame_half_full + _picture_size;
				break;
			case 3:
				if (_reference_picture_selection) ptr_prev_U_c = _prev_full_half->GetFrame(_ref_index) + _picture_size;
				else ptr_prev_U_c = _decoded_frame_full_half + _picture_size;
				break;
			case 4:
				if (_reference_picture_selection) ptr_prev_U_c = _prev_half_half->GetFrame(_ref_index) + _picture_size;
				else ptr_prev_U_c = _decoded_frame_half_half + _picture_size;
				break;
			default:
				fprintf(stdout, "Invalid forward MVTYPE\n");
				exit(-1);
			}

			ptr_prev_U_c += disp1;

			for (k=0; k< 8; k++) {
				for (l=0; l<8; l++) {
					*ptr_shift_U_c++ = *ptr_prev_U_c++;
				}
				ptr_prev_U_c += (_frame_xsize_half - 8);
			}

			if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted

				switch (*ptr_mv_type_uv_b) {
				case 1:
					ptr_prev_pU_c = _decoded_frame + _picture_size + _PB_offset;
					break;
				case 2:
					ptr_prev_pU_c = _decoded_frame_half_full + _picture_size + _PB_offset;
					break;
				case 3:
					ptr_prev_pU_c = _decoded_frame_full_half + _picture_size + _PB_offset;
					break;
				case 4:
					ptr_prev_pU_c = _decoded_frame_half_half + _picture_size + _PB_offset;
					break;
				default:
					fprintf(stdout, "Invalid backward MVTYPE\n");
					exit(-1);
				}

				ptr_prev_pU_c += disp2;
				ptr_c = buffer_1D;
				for (k=0; k<8; k++) {
					for (l=0; l<8; l++) {
						*ptr_c++ = *ptr_prev_pU_c++;
					}
					ptr_prev_pU_c += (_frame_xsize_half - 8);
				}

				ptr_shift_U_c -= 64;				
				ptr_c = buffer_1D;
				for (k=p; k<=q; k++) {
					r = k << 3;
					for (l=m, s=r+m; l<=n; l++, s++) {
						*(ptr_shift_U_c + s) = (unsigned char)
							((*(ptr_shift_U_c + s) + *(ptr_c + s)) / 2);
						}
				}

				ptr_shift_U_c += 64;
			}


			// V block
			dx = (int) ((j << 3) + *ptr_mv_uvx_f);
			dy = (int) ((i << 3) + *ptr_mv_uvy_f);
			disp1 = dx + (dy * _frame_xsize_half);

			tx = *ptr_mv_uvx_b;
			ty = *ptr_mv_uvy_b;
			dx = (int) ((j << 3) + tx);
			dy = (int) ((i << 3) + ty);
			disp2 = dx + (dy * _frame_xsize_half);

			m = (int) ((-tx + 1) / 2);
			if (m < 0) m = 0;
			n = 7 - (int) ((-tx + 1) / 2);
			if (n > 7) n = 7;

			p = (int) ((-ty + 1) / 2);
			if (p < 0) p = 0;
			q = 7 - (int) ((-ty + 1) / 2);
			if (q > 7) q = 7;

			switch (*ptr_mv_type_uv_f) {
			case 1:
				if (_reference_picture_selection) 
					ptr_prev_V_c = _prev_frames->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
				else ptr_prev_V_c = _decoded_frame + _picture_size + _picture_size_quarter;
				break;
			case 2:
				if (_reference_picture_selection) 
					ptr_prev_V_c = _prev_half_full->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
				else ptr_prev_V_c = _decoded_frame_half_full + _picture_size + _picture_size_quarter;
				break;
			case 3:
				if (_reference_picture_selection) 
					ptr_prev_V_c = _prev_full_half->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
				else ptr_prev_V_c = _decoded_frame_full_half + _picture_size + _picture_size_quarter;
				break;
			case 4:
				if (_reference_picture_selection) 
					ptr_prev_V_c = _prev_half_half->GetFrame(_ref_index) + _picture_size + _picture_size_quarter;
				else ptr_prev_V_c = _decoded_frame_half_half + _picture_size + _picture_size_quarter;
				break;
			default:
				fprintf(stdout, "Invalid forward MVTYPE\n");
				exit(-1);
			}

			ptr_prev_V_c += disp1;

			for (k=0; k< 8; k++) {
				for (l=0; l<8; l++) {
					*ptr_shift_V_c++ = *ptr_prev_V_c++;
				}
				ptr_prev_V_c += (_frame_xsize_half - 8);
			}

			if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted

				switch (*ptr_mv_type_uv_b) {
				case 1:
					ptr_prev_pV_c = _decoded_frame + _picture_size + _picture_size_quarter + _PB_offset;
					break;
				case 2:
					ptr_prev_pV_c = _decoded_frame_half_full + _picture_size + _picture_size_quarter + _PB_offset;
					break;
				case 3:
					ptr_prev_pV_c = _decoded_frame_full_half + _picture_size + _picture_size_quarter + _PB_offset;
					break;
				case 4:
					ptr_prev_pV_c = _decoded_frame_half_half + _picture_size + _picture_size_quarter + _PB_offset;
					break;
				default:
					fprintf(stdout, "Invalid backward MVTYPE\n");
					exit(-1);
				}

				ptr_prev_pV_c += disp2;
				ptr_c = buffer_1D;
				for (k=0; k<8; k++) {
					for (l=0; l<8; l++) {
						*ptr_c++ = *ptr_prev_pV_c++;
					}
					ptr_prev_pV_c += (_frame_xsize_half - 8);
				}

				ptr_shift_V_c -= 64;				
				ptr_c = buffer_1D;
				for (k=p; k<=q; k++) {
					r = k << 3;
					for (l=m, s=r+m; l<=n; l++, s++) {
						*(ptr_shift_V_c + s) = (unsigned char)
							((*(ptr_shift_V_c + s) + *(ptr_c + s)) / 2);
						}
				}

				ptr_shift_V_c += 64;
			}

			
			// Massive pointer increments
			ptr_mv_type1_f++; ptr_mv_x1_f++; ptr_mv_y1_f++;
			ptr_mv_type1_b++; ptr_mv_x1_b++; ptr_mv_y1_b++;	
			ptr_mv_type2_f++; ptr_mv_x2_f++; ptr_mv_y2_f++;
			ptr_mv_type2_b++; ptr_mv_x2_b++; ptr_mv_y2_b++;	
			ptr_mv_type3_f++; ptr_mv_x3_f++; ptr_mv_y3_f++;
			ptr_mv_type3_b++; ptr_mv_x3_b++; ptr_mv_y3_b++;	
			ptr_mv_type4_f++; ptr_mv_x4_f++; ptr_mv_y4_f++;
			ptr_mv_type4_b++; ptr_mv_x4_b++; ptr_mv_y4_b++;	
			ptr_mv_type_uv_f++; ptr_mv_uvx_f++; ptr_mv_uvy_f++;
			ptr_mv_type_uv_b++; ptr_mv_uvx_b++; ptr_mv_uvy_b++;


		}	// for (j=0; j<_MB_per_gob; j++) {
	}	// for (i=0; i<_GOB_per_frame; i++) {
			
}



#endif

