
#ifndef __D_FRAME_TEMPORAL_COMPRESSION_CONTROL_C__
#define __D_FRAME_TEMPORAL_COMPRESSION_CONTROL_C__

#include "D_Frame.h"


/*
 * void D_Frame::Temporal_Compression_Control(void)
 * 
 * This calculates the coding mode decision (INTRA vs. INTER)
 * This is a private method
 *
 * Requires:	D_Frame::Motion_Vectored_Decoded_Frame() must be called first
 * Modifies:	_mtype
 * Ensures:		Set mtype decisions for each macroblock in the current frame
 *
 * This function does a mode decision. When the residue for the current block,
 * obtained after finding the best match using motion estimation, is too large
 * (as defined in the TMN8) the macroblock must be intra-coded (even if the 
 * frame itself is not intra).
 *
 * Warning:		
 */
void D_Frame::Temporal_Compression_Control(void) 
{
	int i, j, m, offset;
	int energy_residue, energy_block, mean, temp;
	short *ptr_mtype;
	short *ptr_predict_Y_s, *ptr_predict_U_s, *ptr_predict_V_s;
	unsigned char *ptr_this_Y_c, *ptr_this_U_c, *ptr_this_V_c;
	unsigned char *ptr_shift_Y_c, *ptr_shift_U_c, *ptr_shift_V_c; 
	
	ptr_predict_Y_s = _evil_predict_frame;
	ptr_predict_U_s = _evil_predict_frame + _picture_size;
	ptr_predict_V_s = _evil_predict_frame + _picture_size + _picture_size_quarter;
	
	offset = 0;
	if (_PB_Ppicture_flag) offset = _PB_offset;

	ptr_shift_Y_c = _shift_frame + offset;
	ptr_shift_U_c = _shift_frame + _picture_size + offset;
	ptr_shift_V_c = _shift_frame + _picture_size + _picture_size_quarter + offset;
	
	ptr_this_Y_c = _this_1D_frame + offset;
	ptr_this_U_c = _this_1D_frame + _picture_size + offset;
	ptr_this_V_c = _this_1D_frame + _picture_size + _picture_size_quarter + offset;
	
	ptr_mtype = _mtype;
	
	// Compression routine
	if (_evil_speed_mode) {		// Enhanced (evil) speed mode
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				
				// energy_residue : measure of the residue energy
				// energy_block : absolute sum of mean subtracted pixel values of
				// the macroblock
				energy_residue = 0;
				energy_block = 0;
				mean = 0;
				
				for (m=0; m<256; m++) mean += *ptr_this_Y_c++;
				for (m=0, mean/=256, ptr_this_Y_c-=256; m<256; m++) {
					temp = *ptr_this_Y_c++;
					energy_block += abs(temp - mean);
					energy_residue += abs(temp - *ptr_predict_Y_s++);
				}
				
				if (energy_residue - energy_block > _thresh_large) *ptr_mtype++ = INTRA;
				else *ptr_mtype++ = INTER;
				
			} // for (j=0; j<_MB_xcount; j++)
		} // for (i=0; i<_MB_ycount; i++)
	}

	else {						// Normal Operation		
	
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				
				// energy_residue : measure of the residue energy
				// energy_block : absolute sum of mean subtracted pixel values of
				// the macroblock
				energy_residue = 0;
				energy_block = 0;
				mean = 0;
				
				for (m=0; m<256; m++) mean += *ptr_this_Y_c++;
				for (m=0, mean/=256, ptr_this_Y_c-=256; m<256; m++) {
					temp = *ptr_this_Y_c++;
					energy_block += abs(temp - mean);
					energy_residue += abs(temp - *ptr_shift_Y_c++);
				}
				
				if (energy_residue - energy_block > _thresh_large) *ptr_mtype++ = INTRA;
				else *ptr_mtype++ = INTER;
				
			} // for (j=0; j<_MB_xcount; j++)
		} // for (i=0; i<_MB_ycount; i++)
	}	// else {

}


#endif

