
#ifndef __D_FRAME_SORT_SEGMENT_C__
#define __D_FRAME_SORT_SEGMENT_C__

#include "D_Frame.h"

/*
 * void D_Frame::Sort_Segment(void)
 * 
 * Sorts received _slice_size, _slice_MBA by increasing MBA
 *
 * Requires:	_slice_size, slice_MBA
 * Modifies:	_slice_size, slice_MBA
 * Ensures:		correct motion compensation
 *
 * Warning:		
 */
void D_Frame::Sort_Segment(int l, int r) {
	// void quicksort( int a[], int l, int r )
	int i, j;
	short temp;
	int temp2;
	short v;
	if (r > l) {
		v = _slice_MBA[r];
		i = l - 1;
		j = r;
		// for the whole section, put everything less than the pivot (j) 
		// to the left, and greater than the pivot to the right
		for (;;) {
			while (_slice_MBA[++i] < v);
			while (_slice_MBA[--j] > v);
			if (i >= j) break;
			temp = _slice_MBA[i];
			_slice_MBA[i] = _slice_MBA[j];
			_slice_MBA[j] = temp;
			temp = _slice_size[i];
			_slice_size[i] = _slice_size[j];
			_slice_size[j] = temp;
			if (_reference_picture_selection) {
				temp2 = _trp[i];
				_trp[i] = _trp[j];
				_trp[j] = temp2;
			}
		}
		temp = _slice_MBA[i];
		_slice_MBA[i] = _slice_MBA[r];
		_slice_MBA[r] = temp;
		temp = _slice_size[i];
		_slice_size[i] = _slice_size[r];
		_slice_size[r] = temp;
		if (_reference_picture_selection) {
			temp2 = _trp[i];
			_trp[i] = _trp[r];
			_trp[r] = temp2;
		}
		Sort_Segment(l, i-1);      // sort the left side
		Sort_Segment(i+1, r);      // sort the right side
	}
}

#endif