
#ifndef __D_FRAME_INITIALIZE_ENTROPY_DECODER_C__
#define __D_FRAME_INITIALIZE_ENTROPY_DECODER_C__

#include "D_Frame.h"


/*
 * D_Frame::Initialize_Entropy_Decoder()
 * Constructor, creates all the binary lookup trees required
 * for VLC lookup. Also initializes picture and gn blocks
 *
 * Requires: nothing
 * Modifies: _MBA_Tree, _MTYPE_Tree, _MVD_Tree, _CBP_Tree
 *           _TCOEFF_Tree for VLC lookup
 *           _ed_tr, _ed_last_tr, _ed_ptype, _ed_last_ptype
 * Ensures: Trees are initialized and ready for searches
 */
void D_Frame::Initialize_Entropy_Decoder() {
	// Initialize Search Trees
	_MCBPCI_Tree = new Tree(_MCBPCI_Table, 9);
	_MCBPCP_Tree = new Tree(_MCBPCP_Table, 25);
	_CBPY_Tree = new Tree(_CBPY_Table,16);
	_MVD_Tree = new Tree(_MVD_Table,64);  // For MVD VLC (still needs MV1 & MV2)
	_TCOEF_Tree = new Tree(_TCOEF_Table,103); // For TCOEF (still needs RunLevel)

	_ed_tr = -1; _ed_last_tr = -1; _ed_ptype = 0; _ed_last_ptype = -1;
	_ed_quant = -1;
}


#endif

