
#ifndef __D_FRAME_INIT_C__
#define __D_FRAME_INIT_C__

#include "D_Frame.h"


/*
 * void D_Frame::Init_Structure(void)
 * 
 * Initialize basic data structure
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	GOBs pointed to by _GOB_list
 * Ensures:		. call D_GOB::Init_Structure() of GOBs pointed to by _GOB_list
 *				. call D_Frame::Initializer()
 *				. call D_Frame::Fast_Structure()
 *
 * Warning:		
 */
void D_Frame::Init_Structure(void) 
{
	D_GOB *ptr_GOB;
	D_Macroblock *ptr_MB;
	D_Block *ptr_BLKa, *ptr_BLKb;
	int i, j, k;
	const unsigned char *y_this_GOB;
	const unsigned char *u_this_GOB;
	const unsigned char *v_this_GOB;
	
	y_this_GOB = _this_1D_frame;
	u_this_GOB = _this_1D_frame + _picture_size;
	v_this_GOB = _this_1D_frame + _picture_size + _picture_size_quarter;
	
	ptr_MB = _MB_list;
	ptr_BLKa = _BLK_list;
	ptr_BLKb = NULL;
	k = 0;

	if ((_encode_mode == false) || _PB_frame_mode) {
		ptr_BLKb = _BLK_list + (_MB_per_gob * _GOB_per_frame * 6);
		k = 6;
	}

	// Dynamically create the tree structure
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {
			ptr_MB->Reset_Hierarchy(i, j, ptr_BLKa, ptr_BLKb);
			ptr_MB++;
			ptr_BLKa += 6;
			ptr_BLKb += k;
		}
	}


	// Initialize hierarchical objects at next level
	ptr_GOB = _GOB_list;
	for (i=0; i<_GOB_per_frame; i++) {
		ptr_GOB->Init_Structure(y_this_GOB, u_this_GOB, v_this_GOB, i);
		ptr_GOB++;
		y_this_GOB += _GOB_Y_offset;
		u_this_GOB += _GOB_UV_offset;
		v_this_GOB += _GOB_UV_offset;
	}

	Initializer();
	Fast_Structure();
}


/*
 * void D_Frame::Initializer(void)
 * 
 * Initialize/Reset mode decisions (should be applied for INTRA frame always?)
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	_cgi, _cmi, _flag_zero_mv, _mcbpc, _mcbpy
 * Ensures:		. Set all boolean pointers to false for each macroblock
 *				. set mcbpc to 3 and mcbpy to 15 for each macroblock 
 *
 * Warning:		
 */
void D_Frame::Initializer(void)
{
	int i, j;
	short *ptr_s1, *ptr_s2, *ptr_s3;
	bool *ptr_b1, *ptr_b2;

	ptr_s1 = _mtype;
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {
			*ptr_s1++ = INTRA;
		}
	}

	// Initialize coded GOB header indicator to false
	for (i=0, ptr_b1=_cgi; i<_GOB_per_frame; i++) {
		if ((i%2) == 1) *ptr_b1++ = true;
		else *ptr_b1++ = false;
	}

	//*(_cgi+3) = false;
	//*(_cgi+8) = true;

	// Initialize more :-)
	ptr_b1 = _cmi;
	ptr_b2 = _flag_zero_mv;
	ptr_s1 = _mcbpc;
	ptr_s2 = _mcbpy;

	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {
			*ptr_b1++ = false;	// Default: COD coded
			*ptr_b2++ = false;
			*ptr_s1++ = 3;		// default to send both U and V blocks
			*ptr_s2++ = 15;		// default to send all 4 Y blocks
		}
	}

	// Initialize routine for evil speed option: all motion vectors to 0
	ptr_s1 = _mv_type1;
	ptr_s2 = _mv_x1;
	ptr_s3 = _mv_y1;

	if(_evil_speed_mode) {
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				*ptr_s1++ = 1;
				*ptr_s2++ = 0;
				*ptr_s3++ = 0;
			}
		}
	}

	if (_reference_picture_selection) {
		// Initialize temporal reference array to 0
		int trpsize;
		if (_slice_mode) trpsize = _SLICE_per_frame;
		else trpsize = _GOB_per_frame;
		for (i = 0; i < trpsize; i++)
			_trp[i] = 0;
	}
}


/*
 * void D_Frame::Fast_Structure(void)
 * 
 * Initialize fast data structure
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	GOBs pointed to by _GOB_list
 * Ensures:		. call D_GOB::Fast_Structure() of GOBs pointed to by _GOB_list
 *				. call D_Frame::Fast_Differential_Motion_Vector()
 *				. if (SDEBUG), call D_Frame::Fast_Decoded_Structure()
 *
 * Warning:		
 */
void D_Frame::Fast_Structure(void) 
{
	D_GOB *ptr_GOB;
	int i;
	short *y_this_GOB;
	short *u_this_GOB;
	short *v_this_GOB;
	short *ptr_mcbpc, *ptr_mcbpy;
	short *ptr_mtype, *ptr_mquant;
	short *ptr_mv_type1, *ptr_mv_x1, *ptr_mv_y1;
	short *ptr_mv_type2, *ptr_mv_x2, *ptr_mv_y2;
	short *ptr_mv_type3, *ptr_mv_x3, *ptr_mv_y3;
	short *ptr_mv_type4, *ptr_mv_x4, *ptr_mv_y4;
	short *zigzag_y_this_GOB, *zigzag_u_this_GOB, *zigzag_v_this_GOB;
	bool  *ptr_cgi, *ptr_cmi, *ptr_flag_zero_mv;
	
	// Enable fast access to optimized data structures
	y_this_GOB = _fast_frame;
	u_this_GOB = _fast_frame + _picture_size;
	v_this_GOB = _fast_frame + _picture_size + _picture_size_quarter;

	zigzag_y_this_GOB = _zigzaged_central;
	zigzag_u_this_GOB = _zigzaged_central + _picture_size;
	zigzag_v_this_GOB = _zigzaged_central + _picture_size + _picture_size_quarter;

	// Enable access to header data, memory-allocated at frame level
	ptr_cgi = _cgi;
	ptr_cmi = _cmi;
	ptr_flag_zero_mv = _flag_zero_mv;
	ptr_mcbpc = _mcbpc;
	ptr_mcbpy = _mcbpy;
	ptr_mtype = _mtype;
	ptr_mquant = _mquant;
	
	ptr_mv_type1 = _mv_type1; ptr_mv_x1 = _mv_x1; ptr_mv_y1 = _mv_y1;
	ptr_mv_type2 = _mv_type2; ptr_mv_x2 = _mv_x2; ptr_mv_y2 = _mv_y2;
	ptr_mv_type3 = _mv_type3; ptr_mv_x3 = _mv_x3; ptr_mv_y3 = _mv_y3;
	ptr_mv_type4 = _mv_type4; ptr_mv_x4 = _mv_x4; ptr_mv_y4 = _mv_y4;

	ptr_GOB = _GOB_list;

	for (i=0; i<_GOB_per_frame; i++) {
		
		ptr_GOB->Fast_Structure(y_this_GOB, u_this_GOB, v_this_GOB,
			zigzag_y_this_GOB, zigzag_u_this_GOB, zigzag_v_this_GOB,
			ptr_cgi, ptr_cmi, ptr_flag_zero_mv, ptr_mcbpc, ptr_mcbpy, 
			ptr_mtype, ptr_mquant, ptr_mv_type1, ptr_mv_x1, ptr_mv_y1,
			ptr_mv_type2, ptr_mv_x2, ptr_mv_y2, ptr_mv_type3, ptr_mv_x3, 
			ptr_mv_y3, ptr_mv_type4, ptr_mv_x4, ptr_mv_y4);

		ptr_GOB++;
				
		y_this_GOB += _GOB_Y_offset;
		u_this_GOB += _GOB_UV_offset;
		v_this_GOB += _GOB_UV_offset;
		zigzag_y_this_GOB += _GOB_Y_offset;
		zigzag_u_this_GOB += _GOB_UV_offset;
		zigzag_v_this_GOB += _GOB_UV_offset;

		ptr_cgi++;
		ptr_cmi += _MB_per_gob;
		ptr_flag_zero_mv += _MB_per_gob;
		
		ptr_mcbpc += _MB_per_gob; ptr_mcbpy += _MB_per_gob;
		ptr_mtype += _MB_per_gob; ptr_mquant += _MB_per_gob;

		ptr_mv_type1 += _MB_per_gob; ptr_mv_x1 += _MB_per_gob; ptr_mv_y1 += _MB_per_gob;
		ptr_mv_type2 += _MB_per_gob; ptr_mv_x2 += _MB_per_gob; ptr_mv_y2 += _MB_per_gob;
		ptr_mv_type3 += _MB_per_gob; ptr_mv_x3 += _MB_per_gob; ptr_mv_y3 += _MB_per_gob;
		ptr_mv_type4 += _MB_per_gob; ptr_mv_x4 += _MB_per_gob; ptr_mv_y4 += _MB_per_gob;

	}

	if (_PB_frame_mode || !_encode_mode) Fast_PB_Structure();
	if (_reference_picture_selection || !_encode_mode) Fast_RPS_Structure();
	if (_slice_mode || _independent_segment_mode || !_encode_mode) Fast_Slice_Structure();

	// Specialized/Optimized structural setup for quick access to neighbouring motion vectors
	Fast_Differential_Motion_Vector();

	// DEBUG routines
	if (DEBUG) Fast_Decoded_Structure();
}


/*
 * void D_Frame::Fast_RPS_Structure(void)
 * 
 * Initialize fast data structure
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	GOBs pointed to by _GOB_list
 * Ensures:		trp traverses GOBs
 *
 * Warning:		
 */
void D_Frame::Fast_RPS_Structure(void) 
{
	D_GOB *ptr_GOB;
	D_Slice *ptr_Slice;
	int i;
	int *ptr_trp;

	ptr_GOB = _GOB_list;
	ptr_Slice = _SLICE_list;
	ptr_trp = _trp;

	if (_slice_mode) {
		for (i=0; i<_SLICE_per_frame; i++) {	
			ptr_Slice->Fast_RPS_Structure(ptr_trp, &_fr_num);
			
			ptr_Slice++;
			ptr_trp++;
		}
	}

	else {
		for (i=0; i<_GOB_per_frame; i++) {	
			ptr_GOB->Fast_RPS_Structure(ptr_trp, &_fr_num);
			
			ptr_GOB++;
			ptr_trp++;
		}
	}
}

/*
 * void D_Frame::Fast_PB_Structure(void)
 * 
 * Initialize fast data structure
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	GOBs pointed to by _GOB_list
 * Ensures:		. call D_GOB::Fast_Structure() of GOBs pointed to by _GOB_list
 *				. call D_Frame::Fast_Differential_Motion_Vector()
 *				. if (SDEBUG), call D_Frame::Fast_Decoded_Structure()
 *
 * Warning:		
 */
void D_Frame::Fast_PB_Structure(void) 
{
	D_GOB *ptr_GOB;
	int i;

	short *ptr_mcbpb;
	short *ptr_bquant;
	short *ptr_mvd_type, *ptr_mvd_x, *ptr_mvd_y;			// delta motion vector
	short *ptr_mv_type1_f, *ptr_mv_x1_f, *ptr_mv_y1_f;		// Forward motion vectors
	short *ptr_mv_type2_f, *ptr_mv_x2_f, *ptr_mv_y2_f;
	short *ptr_mv_type3_f, *ptr_mv_x3_f, *ptr_mv_y3_f;
	short *ptr_mv_type4_f, *ptr_mv_x4_f, *ptr_mv_y4_f;
	short *ptr_mv_type1_b, *ptr_mv_x1_b, *ptr_mv_y1_b;		// Backward motion vectors
	short *ptr_mv_type2_b, *ptr_mv_x2_b, *ptr_mv_y2_b;	
	short *ptr_mv_type3_b, *ptr_mv_x3_b, *ptr_mv_y3_b;	
	short *ptr_mv_type4_b, *ptr_mv_x4_b, *ptr_mv_y4_b;	
	short *ptr_mv_type_uv_f, *ptr_mv_uvx_f, *ptr_mv_uvy_f;	// Chrominance forward motion vector
	short *ptr_mv_type_uv_b, *ptr_mv_uvx_b, *ptr_mv_uvy_b;	// Chrominance backware motion vector
	

	// Enable fast access to optimized data structures
	ptr_mcbpb = _mcbpb;
	ptr_bquant = _bquant;

	ptr_mvd_type = _mvd_type; ptr_mvd_x = _mvd_x; ptr_mvd_y = _mvd_y;				// Delta motion vector
	
	ptr_mv_type1_f = _mv_type1_f; ptr_mv_x1_f = _mv_x1_f; ptr_mv_y1_f = _mv_y1_f;	// Forward motion vectors
	ptr_mv_type2_f = _mv_type2_f; ptr_mv_x2_f = _mv_x2_f; ptr_mv_y2_f = _mv_y2_f;
	ptr_mv_type3_f = _mv_type3_f; ptr_mv_x3_f = _mv_x3_f; ptr_mv_y3_f = _mv_y3_f;
	ptr_mv_type4_f = _mv_type4_f; ptr_mv_x4_f = _mv_x4_f; ptr_mv_y4_f = _mv_y4_f;
	ptr_mv_type_uv_f = _mv_type_uv_f; ptr_mv_uvx_f = _mv_uvx_f; ptr_mv_uvy_f = _mv_uvy_f;
	
	ptr_mv_type1_b = _mv_type1_b; ptr_mv_x1_b = _mv_x1_b; ptr_mv_y1_b = _mv_y1_b;	// Backward motion vectors
	ptr_mv_type2_b = _mv_type2_b; ptr_mv_x2_b = _mv_x2_b; ptr_mv_y2_b = _mv_y2_b;	
	ptr_mv_type3_b = _mv_type3_b; ptr_mv_x3_b = _mv_x3_b; ptr_mv_y3_b = _mv_y3_b;	
	ptr_mv_type4_b = _mv_type4_b; ptr_mv_x4_b = _mv_x4_b; ptr_mv_y4_b = _mv_y4_b;
	ptr_mv_type_uv_b = _mv_type_uv_b; ptr_mv_uvx_b = _mv_uvx_b; ptr_mv_uvy_b = _mv_uvy_b;
	

	// Enable access to header data, memory-allocated at frame level
	ptr_GOB = _GOB_list;

	for (i=0; i<_GOB_per_frame; i++) {
		
		ptr_GOB->Fast_PB_Structure(ptr_mcbpb, (const short *) &_dbquant, ptr_bquant,
			ptr_mvd_type, ptr_mvd_x, ptr_mvd_y,
			ptr_mv_type1_f, ptr_mv_x1_f, ptr_mv_y1_f,
			ptr_mv_type2_f, ptr_mv_x2_f, ptr_mv_y2_f,
			ptr_mv_type3_f, ptr_mv_x3_f, ptr_mv_y3_f,
			ptr_mv_type4_f, ptr_mv_x4_f, ptr_mv_y4_f,
			ptr_mv_type1_b, ptr_mv_x1_b, ptr_mv_y1_b,
			ptr_mv_type2_b, ptr_mv_x2_b, ptr_mv_y2_b,
			ptr_mv_type3_b, ptr_mv_x3_b, ptr_mv_y3_b,
			ptr_mv_type4_b, ptr_mv_x4_b, ptr_mv_y4_b,
			ptr_mv_type_uv_f, ptr_mv_uvx_f, ptr_mv_uvy_f,
			ptr_mv_type_uv_b, ptr_mv_uvx_b, ptr_mv_uvy_b);

		ptr_GOB++;
				
		ptr_mcbpb += _MB_per_gob;
		ptr_bquant += _MB_per_gob;

		ptr_mvd_type += _MB_per_gob; ptr_mvd_x += _MB_per_gob; ptr_mvd_y += _MB_per_gob;

		ptr_mv_type1_f += _MB_per_gob; ptr_mv_x1_f += _MB_per_gob; ptr_mv_y1_f += _MB_per_gob;
		ptr_mv_type2_f += _MB_per_gob; ptr_mv_x2_f += _MB_per_gob; ptr_mv_y2_f += _MB_per_gob;
		ptr_mv_type3_f += _MB_per_gob; ptr_mv_x3_f += _MB_per_gob; ptr_mv_y3_f += _MB_per_gob;
		ptr_mv_type4_f += _MB_per_gob; ptr_mv_x4_f += _MB_per_gob; ptr_mv_y4_f += _MB_per_gob;
		ptr_mv_type_uv_f += _MB_per_gob; ptr_mv_uvx_f += _MB_per_gob; ptr_mv_uvy_f += _MB_per_gob;

		ptr_mv_type1_b += _MB_per_gob; ptr_mv_x1_b += _MB_per_gob; ptr_mv_y1_b += _MB_per_gob;
		ptr_mv_type2_b += _MB_per_gob; ptr_mv_x2_b += _MB_per_gob; ptr_mv_y2_b += _MB_per_gob;	
		ptr_mv_type3_b += _MB_per_gob; ptr_mv_x3_b += _MB_per_gob; ptr_mv_y3_b += _MB_per_gob;	
		ptr_mv_type4_b += _MB_per_gob; ptr_mv_x4_b += _MB_per_gob; ptr_mv_y4_b += _MB_per_gob;
		ptr_mv_type_uv_b += _MB_per_gob; ptr_mv_uvx_b += _MB_per_gob; ptr_mv_uvy_b += _MB_per_gob;

	}

}


/*
 * void D_Frame::Fast_Slice_Structure(void)
 * 
 * Initialize fast slice data structure
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	GOBs pointed to by _GOB_list
 * Ensures:		. call D_GOB::Fast_Structure() of GOBs pointed to by _GOB_list
 *				. call D_Frame::Fast_Differential_Motion_Vector()
 *				. if (SDEBUG), call D_Frame::Fast_Decoded_Structure()
 *
 * Warning:		
 */
void D_Frame::Fast_Slice_Structure(void) 
{
	D_GOB *ptr_GOB;
	D_Slice *ptr_SLICE;
	int i;
	const short *ptr_mquant;
	const short *ptr_slice_MBA, *ptr_slice_size;
	const short *ptr_seg_ID, *ptr_seg_size;
	const short *ptr_right_span, *ptr_left_span;
	const short *ptr_x_bound_high, *ptr_x_bound_low;
	const short *ptr_y_bound_high, *ptr_y_bound_low;
	const short *ptr_mvx0_high, *ptr_mvx0_low;
	const short *ptr_mvx1_high, *ptr_mvx1_low;
	const short *ptr_mvx2_high, *ptr_mvx2_low;
	const short *ptr_mvx3_high, *ptr_mvx3_low;
	const short *ptr_mvx4_high, *ptr_mvx4_low;
	const short *ptr_mvy0_high, *ptr_mvy0_low;
	const short *ptr_mvy1_high, *ptr_mvy1_low;
	const short *ptr_mvy2_high, *ptr_mvy2_low;
	const short *ptr_mvy3_high, *ptr_mvy3_low;
	const short *ptr_mvy4_high, *ptr_mvy4_low;
	const bool *ptr_mvx_border_high, *ptr_mvx_border_low;
	const bool *ptr_mvy_border_high, *ptr_mvy_border_low;


	// Information to be passed to the macroblock object
	ptr_seg_ID = _seg_ID; ptr_seg_size = _seg_size;
	ptr_right_span = _right_span; ptr_left_span = _left_span;
	ptr_x_bound_high = _x_bound_high; ptr_x_bound_low = _x_bound_low;
	ptr_y_bound_high = _y_bound_high; ptr_y_bound_low = _y_bound_low;
	ptr_mvx0_high = _mvx0_high; ptr_mvx0_low = _mvx0_low;
	ptr_mvx1_high = _mvx1_high; ptr_mvx1_low = _mvx1_low;
	ptr_mvx2_high = _mvx2_high; ptr_mvx2_low = _mvx2_low;
	ptr_mvx3_high = _mvx3_high; ptr_mvx3_low = _mvx3_low;
	ptr_mvx4_high = _mvx4_high; ptr_mvx4_low = _mvx4_low;
	ptr_mvy0_high = _mvy0_high; ptr_mvy0_low = _mvy0_low;
	ptr_mvy1_high = _mvy1_high; ptr_mvy1_low = _mvy1_low;
	ptr_mvy2_high = _mvy2_high; ptr_mvy2_low = _mvy2_low;
	ptr_mvy3_high = _mvy3_high; ptr_mvy3_low = _mvy3_low;
	ptr_mvy4_high = _mvy4_high; ptr_mvy4_low = _mvy4_low;
	ptr_mvx_border_high = _mvx_border_high; ptr_mvx_border_low = _mvx_border_low;
	ptr_mvy_border_high = _mvy_border_high; ptr_mvy_border_low = _mvy_border_low;
	
	// slice call
	ptr_slice_MBA = _slice_MBA; ptr_slice_size = _slice_size; 

	// Enable access to header data, memory-allocated at frame level
	ptr_SLICE = _SLICE_list;
	ptr_GOB = _GOB_list;
	ptr_mquant = _mquant;

	for (i=0; i<_SLICE_per_frame; i++) {
		ptr_SLICE->Fast_Slice_Structure((short) i, ptr_slice_MBA, ptr_slice_size, ptr_mquant);
		ptr_SLICE++;
		ptr_mquant += *ptr_slice_size;
		ptr_slice_MBA++;
		ptr_slice_size++;
	}


	for (i=0; i<_GOB_per_frame; i++) {
		
		ptr_GOB->Fast_Slice_Structure(ptr_seg_ID, ptr_seg_size,
			ptr_right_span, ptr_left_span,
			ptr_x_bound_high, ptr_x_bound_low,
			ptr_y_bound_high, ptr_y_bound_low,
			ptr_mvx0_high, ptr_mvx0_low, ptr_mvy0_high, ptr_mvy0_low,
			ptr_mvx1_high, ptr_mvx1_low, ptr_mvy1_high, ptr_mvy1_low,
			ptr_mvx2_high, ptr_mvx2_low, ptr_mvy2_high, ptr_mvy2_low,
			ptr_mvx3_high, ptr_mvx3_low, ptr_mvy3_high, ptr_mvy3_low,
			ptr_mvx4_high, ptr_mvx4_low, ptr_mvy4_high, ptr_mvy4_low,
			ptr_mvx_border_high, ptr_mvx_border_low,
			ptr_mvy_border_high, ptr_mvy_border_low);

		ptr_GOB++;

		ptr_seg_ID += _MB_per_gob; ptr_seg_size += _MB_per_gob;
		ptr_right_span += _MB_per_gob; ptr_left_span += _MB_per_gob;
		ptr_x_bound_high += _MB_per_gob; ptr_x_bound_low += _MB_per_gob;
		ptr_y_bound_high += _MB_per_gob; ptr_y_bound_low += _MB_per_gob;

		ptr_mvx0_high += _MB_per_gob; ptr_mvx0_low += _MB_per_gob;
		ptr_mvy0_high += _MB_per_gob; ptr_mvy0_low += _MB_per_gob;
		ptr_mvx1_high += _MB_per_gob; ptr_mvx1_low += _MB_per_gob;
		ptr_mvy1_high += _MB_per_gob; ptr_mvy1_low += _MB_per_gob;
		ptr_mvx2_high += _MB_per_gob; ptr_mvx2_low += _MB_per_gob;
		ptr_mvy2_high += _MB_per_gob; ptr_mvy2_low += _MB_per_gob;
		ptr_mvx3_high += _MB_per_gob; ptr_mvx3_low += _MB_per_gob;
		ptr_mvy3_high += _MB_per_gob; ptr_mvy3_low += _MB_per_gob;
		ptr_mvx4_high += _MB_per_gob; ptr_mvx4_low += _MB_per_gob;
		ptr_mvy4_high += _MB_per_gob; ptr_mvy4_low += _MB_per_gob;
		ptr_mvx_border_high += _MB_per_gob; ptr_mvx_border_low += _MB_per_gob;
		ptr_mvy_border_high += _MB_per_gob; ptr_mvy_border_low += _MB_per_gob;
	}

}


/*
 * void D_Frame::Fast_Differential_Motion_Vector(void)
 * 
 * Initialize fast differential motion vectors
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	GOBs pointed to by _GOB_list
 * Ensures:		call D_GOB::Fast_Differential_Motion_Vector() of GOBs pointed to by _GOB_list
 *
 * Warning:		
 */
void D_Frame::Fast_Differential_Motion_Vector(void)
{
	D_GOB *ptr_GOB;
	int i;

	// Segment ID tag
	const short *ptr_seg_ID01, *ptr_seg_ID02, *ptr_seg_ID03;
	const short *ptr_seg_ID11, *ptr_seg_ID12, *ptr_seg_ID13;
	const short *ptr_seg_ID21, *ptr_seg_ID22, *ptr_seg_ID23;
	const short *ptr_seg_ID31, *ptr_seg_ID32, *ptr_seg_ID33;
	const short *ptr_seg_ID41, *ptr_seg_ID42, *ptr_seg_ID43;

	const short *ptr_mv_type01, *ptr_mv_x01, *ptr_mv_y01;
	const short *ptr_mv_type02, *ptr_mv_x02, *ptr_mv_y02;
	const short *ptr_mv_type03, *ptr_mv_x03, *ptr_mv_y03;
	
	// The following are for the Advanced Prediction mode or PB frame mode
	const short *ptr_mv_type11, *ptr_mv_x11, *ptr_mv_y11;
	const short *ptr_mv_type12, *ptr_mv_x12, *ptr_mv_y12;
	const short *ptr_mv_type13, *ptr_mv_x13, *ptr_mv_y13;

	const short *ptr_mv_type21, *ptr_mv_x21, *ptr_mv_y21;
	const short *ptr_mv_type22, *ptr_mv_x22, *ptr_mv_y22;
	const short *ptr_mv_type23, *ptr_mv_x23, *ptr_mv_y23;

	const short *ptr_mv_type31, *ptr_mv_x31, *ptr_mv_y31;
	const short *ptr_mv_type32, *ptr_mv_x32, *ptr_mv_y32;
	const short *ptr_mv_type33, *ptr_mv_x33, *ptr_mv_y33;

	const short *ptr_mv_type41, *ptr_mv_x41, *ptr_mv_y41;
	const short *ptr_mv_type42, *ptr_mv_x42, *ptr_mv_y42;
	const short *ptr_mv_type43, *ptr_mv_x43, *ptr_mv_y43;

	// Delta motion vector
	const short *ptr_mvd_type1, *ptr_mvd_x1, *ptr_mvd_y1;
	const short *ptr_mvd_type2, *ptr_mvd_x2, *ptr_mvd_y2;
	const short *ptr_mvd_type3, *ptr_mvd_x3, *ptr_mvd_y3;


	ptr_GOB = _GOB_list;
	
	// Initializing for the first GOB
	ptr_seg_ID01 = _seg_ID; ptr_seg_ID02 = _seg_ID; ptr_seg_ID03 = _seg_ID;
	ptr_mv_type01 = _mv_type1; ptr_mv_x01 = _mv_x1; ptr_mv_y01 = _mv_y1;
	ptr_mv_type02 = _mv_type1; ptr_mv_x02 = _mv_x1; ptr_mv_y02 = _mv_y1;
	ptr_mv_type03 = _mv_type1; ptr_mv_x03 = _mv_x1; ptr_mv_y03 = _mv_y1;
	
	ptr_GOB++->Fast_Differential_Motion_Vector(true,
		_fake_ID, _zero_mv_type, _zero_mv_x, _zero_mv_y,
		ptr_seg_ID01, ptr_mv_type01, ptr_mv_x01, ptr_mv_y01,
		ptr_seg_ID02, ptr_mv_type02, ptr_mv_x02, ptr_mv_y02,
		ptr_seg_ID03, ptr_mv_type03, ptr_mv_x03, ptr_mv_y03);
	
	
	// Initializing for the rest of GOBs
	ptr_seg_ID01  += _MB_per_gob; ptr_seg_ID02	= _seg_ID;	 ptr_seg_ID03  += 1;
	ptr_mv_type01 += _MB_per_gob; ptr_mv_type02 = _mv_type1; ptr_mv_type03 += 1;
	ptr_mv_x01	  += _MB_per_gob; ptr_mv_x02	= _mv_x1;	 ptr_mv_x03	   += 1;
	ptr_mv_y01	  += _MB_per_gob; ptr_mv_y02	= _mv_y1;	 ptr_mv_y03    += 1;


	for (i=1; i<_GOB_per_frame; i++) {

		ptr_GOB->Fast_Differential_Motion_Vector(false,
			_fake_ID, _zero_mv_type, _zero_mv_x, _zero_mv_y,
			ptr_seg_ID01, ptr_mv_type01, ptr_mv_x01, ptr_mv_y01,
			ptr_seg_ID02, ptr_mv_type02, ptr_mv_x02, ptr_mv_y02,
			ptr_seg_ID03, ptr_mv_type03, ptr_mv_x03, ptr_mv_y03);
		
		ptr_GOB++;
		ptr_seg_ID01  += _MB_per_gob; ptr_seg_ID02	+= _MB_per_gob;	ptr_seg_ID03  += _MB_per_gob;		
		ptr_mv_type01 += _MB_per_gob; ptr_mv_type02 += _MB_per_gob; ptr_mv_type03 += _MB_per_gob;
		ptr_mv_x01	  += _MB_per_gob; ptr_mv_x02	+= _MB_per_gob; ptr_mv_x03	  += _MB_per_gob;
		ptr_mv_y01	  += _MB_per_gob; ptr_mv_y02	+= _MB_per_gob; ptr_mv_y03	  += _MB_per_gob;
		
	}	// for (i=1; i<_GOB_per_frame; i++) {


	// 4 Motion Vectors: Advanced Predictions
	// Always created to support standalone decoder, which does not know encoding options
	// ahead of time...

	ptr_GOB = _GOB_list;
	// Handle first GOB differently
	// Delta Motion Vector
	ptr_seg_ID01 = _seg_ID;		ptr_seg_ID02 = _seg_ID;	ptr_seg_ID03 = _seg_ID;
	ptr_mvd_type1 = _mvd_type;	ptr_mvd_x1 = _mvd_x;	ptr_mvd_y1 = _mvd_y;
	ptr_mvd_type2 = _mvd_type;	ptr_mvd_x2 = _mvd_x;	ptr_mvd_y2 = _mvd_y;
	ptr_mvd_type3 = _mvd_type;	ptr_mvd_x3 = _mvd_x;	ptr_mvd_y3 = _mvd_y;
	// Block 1: completely predicted by Block 2 (previous macroblock)
	ptr_seg_ID11 = _seg_ID;		ptr_seg_ID12 = _seg_ID; ptr_seg_ID13 = _seg_ID;
	ptr_mv_type11 = _mv_type2;	ptr_mv_x11 = _mv_x2;	ptr_mv_y11 = _mv_y2;
	ptr_mv_type12 = _mv_type2;	ptr_mv_x12 = _mv_x2;	ptr_mv_y12 = _mv_y2;
	ptr_mv_type13 = _mv_type2;	ptr_mv_x13 = _mv_x2;	ptr_mv_y13 = _mv_y2;
	
	// Block 2: completely predicted by Block 1
	ptr_seg_ID21 = _seg_ID;		ptr_seg_ID22 = _seg_ID; ptr_seg_ID23 = _seg_ID;
	ptr_mv_type21 = _mv_type1;	ptr_mv_x21 = _mv_x1;	ptr_mv_y21 = _mv_y1;
	ptr_mv_type22 = _mv_type1;	ptr_mv_x22 = _mv_x1;	ptr_mv_y22 = _mv_y1;
	ptr_mv_type23 = _mv_type1;	ptr_mv_x23 = _mv_x1;	ptr_mv_y23 = _mv_y1;
	
	// Block 3: Block 4 (previous macroblock), and Block 1 and Block 2
	ptr_seg_ID31 = _seg_ID;		ptr_seg_ID32 = _seg_ID; ptr_seg_ID33 = _seg_ID;
	ptr_mv_type31 = _mv_type4;	ptr_mv_x31 = _mv_x4;	ptr_mv_y31 = _mv_y4;
	ptr_mv_type32 = _mv_type1;	ptr_mv_x32 = _mv_x1;	ptr_mv_y32 = _mv_y1;
	ptr_mv_type33 = _mv_type2;	ptr_mv_x33 = _mv_x2;	ptr_mv_y33 = _mv_y2;
	
	// Block 4: Block 3, Block 1, and Block 2
	ptr_seg_ID41 = _seg_ID;		ptr_seg_ID42 = _seg_ID; ptr_seg_ID43 = _seg_ID;
	ptr_mv_type41 = _mv_type3;	ptr_mv_x41 = _mv_x3;	ptr_mv_y41 = _mv_y3;
	ptr_mv_type42 = _mv_type1;	ptr_mv_x42 = _mv_x1;	ptr_mv_y42 = _mv_y1;
	ptr_mv_type43 = _mv_type2;	ptr_mv_x43 = _mv_x2;	ptr_mv_y43 = _mv_y2;


	ptr_GOB++->Fast_Differential_Motion_Vector(true,
		_fake_ID, _zero_mv_type, _zero_mv_x, _zero_mv_y,
		ptr_seg_ID01, ptr_mvd_type1, ptr_mvd_x1, ptr_mvd_y1,
		ptr_seg_ID02, ptr_mvd_type2, ptr_mvd_x2, ptr_mvd_y2,
		ptr_seg_ID03, ptr_mvd_type3, ptr_mvd_x3, ptr_mvd_y3,
		ptr_seg_ID11, ptr_mv_type11, ptr_mv_x11, ptr_mv_y11,
		ptr_seg_ID12, ptr_mv_type12, ptr_mv_x12, ptr_mv_y12,
		ptr_seg_ID13, ptr_mv_type13, ptr_mv_x13, ptr_mv_y13,
		ptr_seg_ID21, ptr_mv_type21, ptr_mv_x21, ptr_mv_y21,
		ptr_seg_ID22, ptr_mv_type22, ptr_mv_x22, ptr_mv_y22,
		ptr_seg_ID23, ptr_mv_type23, ptr_mv_x23, ptr_mv_y23,
		ptr_seg_ID31, ptr_mv_type31, ptr_mv_x31, ptr_mv_y31,
		ptr_seg_ID32, ptr_mv_type32, ptr_mv_x32, ptr_mv_y32,
		ptr_seg_ID33, ptr_mv_type33, ptr_mv_x33, ptr_mv_y33,
		ptr_seg_ID41, ptr_mv_type41, ptr_mv_x41, ptr_mv_y41,
		ptr_seg_ID42, ptr_mv_type42, ptr_mv_x42, ptr_mv_y42,
		ptr_seg_ID43, ptr_mv_type43, ptr_mv_x43, ptr_mv_y43);


	// Initializing for the rest of GOBs
	// Delta Motion Vector
	ptr_seg_ID01 += _MB_per_gob;	ptr_seg_ID02 = _seg_ID;			ptr_seg_ID03 += 1; 
	ptr_mvd_type1 += _MB_per_gob;	ptr_mvd_type2 = _mvd_type;		ptr_mvd_type3 += 1;
	ptr_mvd_x1 += _MB_per_gob;		ptr_mvd_x2 = _mvd_x;			ptr_mvd_x3 += 1;
	ptr_mvd_y1 += _MB_per_gob;		ptr_mvd_y2 = _mvd_y;			ptr_mvd_y3 += 1;
	// Block 1
	ptr_seg_ID11 += _MB_per_gob;	ptr_seg_ID12 = _seg_ID;			ptr_seg_ID13 = _seg_ID + 1;
	ptr_mv_type11 += _MB_per_gob;	ptr_mv_type12 = _mv_type2;		ptr_mv_type13 = _mv_type2 + 1;
	ptr_mv_x11 += _MB_per_gob;		ptr_mv_x12 = _mv_x2;			ptr_mv_x13 = _mv_x2 + 1;
	ptr_mv_y11 += _MB_per_gob;		ptr_mv_y12 = _mv_y2;			ptr_mv_y13 = _mv_y2 + 1;
	// For block 2
	ptr_seg_ID21 += _MB_per_gob;	ptr_seg_ID22 = _seg_ID;			ptr_seg_ID23 = _seg_ID + 1; 
	ptr_mv_type21 += _MB_per_gob;	ptr_mv_type22 = _mv_type3;		ptr_mv_type23 = _mv_type2 + 1;
	ptr_mv_x21 += _MB_per_gob;		ptr_mv_x22 = _mv_x3;			ptr_mv_x23 = _mv_x2 + 1;
	ptr_mv_y21 += _MB_per_gob;		ptr_mv_y22 = _mv_y3;			ptr_mv_y23 = _mv_y2 + 1;
	// For block 3
	ptr_seg_ID31 += _MB_per_gob;	ptr_seg_ID32 += _MB_per_gob;	ptr_seg_ID33 += _MB_per_gob; 
	ptr_mv_type31 += _MB_per_gob;	ptr_mv_type32 += _MB_per_gob;	ptr_mv_type33 += _MB_per_gob;
	ptr_mv_x31 += _MB_per_gob;		ptr_mv_x32 += _MB_per_gob;		ptr_mv_x33 += _MB_per_gob;
	ptr_mv_y31 += _MB_per_gob;		ptr_mv_y32 += _MB_per_gob;		ptr_mv_y33 += _MB_per_gob;	
	// For block 4
	ptr_seg_ID11 += _MB_per_gob;	ptr_seg_ID12 += _MB_per_gob;	ptr_seg_ID13 += _MB_per_gob; 
	ptr_mv_type41 += _MB_per_gob;	ptr_mv_type42 += _MB_per_gob;	ptr_mv_type43 += _MB_per_gob;
	ptr_mv_x41 += _MB_per_gob;		ptr_mv_x42 += _MB_per_gob;		ptr_mv_x43 += _MB_per_gob;
	ptr_mv_y41 += _MB_per_gob;		ptr_mv_y42 += _MB_per_gob;		ptr_mv_y43 += _MB_per_gob;
					

	for (i=1; i<_GOB_per_frame; i++) {

		ptr_GOB->Fast_Differential_Motion_Vector(true,
			_fake_ID, _zero_mv_type, _zero_mv_x, _zero_mv_y,
			ptr_seg_ID01, ptr_mvd_type1, ptr_mvd_x1, ptr_mvd_y1,
			ptr_seg_ID02, ptr_mvd_type2, ptr_mvd_x2, ptr_mvd_y2,
			ptr_seg_ID03, ptr_mvd_type3, ptr_mvd_x3, ptr_mvd_y3,
			ptr_seg_ID11, ptr_mv_type11, ptr_mv_x11, ptr_mv_y11,
			ptr_seg_ID12, ptr_mv_type12, ptr_mv_x12, ptr_mv_y12,
			ptr_seg_ID13, ptr_mv_type13, ptr_mv_x13, ptr_mv_y13,
			ptr_seg_ID21, ptr_mv_type21, ptr_mv_x21, ptr_mv_y21,
			ptr_seg_ID22, ptr_mv_type22, ptr_mv_x22, ptr_mv_y22,
			ptr_seg_ID23, ptr_mv_type23, ptr_mv_x23, ptr_mv_y23,
			ptr_seg_ID31, ptr_mv_type31, ptr_mv_x31, ptr_mv_y31,
			ptr_seg_ID32, ptr_mv_type32, ptr_mv_x32, ptr_mv_y32,
			ptr_seg_ID33, ptr_mv_type33, ptr_mv_x33, ptr_mv_y33,
			ptr_seg_ID41, ptr_mv_type41, ptr_mv_x41, ptr_mv_y41,
			ptr_seg_ID42, ptr_mv_type42, ptr_mv_x42, ptr_mv_y42,
			ptr_seg_ID43, ptr_mv_type43, ptr_mv_x43, ptr_mv_y43);
	
		ptr_GOB++;

		ptr_seg_ID01  += _MB_per_gob; ptr_seg_ID02 += _MB_per_gob;	ptr_seg_ID03  += _MB_per_gob;		
		ptr_mvd_type1 += _MB_per_gob; ptr_mvd_type2 += _MB_per_gob; ptr_mvd_type3 += _MB_per_gob; 
		ptr_mvd_x1 += _MB_per_gob;	  ptr_mvd_x2 += _MB_per_gob;	ptr_mvd_x3 += _MB_per_gob;
		ptr_mvd_y1 += _MB_per_gob;	  ptr_mvd_y2 += _MB_per_gob;	ptr_mvd_y3 += _MB_per_gob;

		ptr_seg_ID11  += _MB_per_gob; ptr_seg_ID12	+= _MB_per_gob;	ptr_seg_ID13  += _MB_per_gob;		
		ptr_mv_type11 += _MB_per_gob; ptr_mv_type12 += _MB_per_gob; ptr_mv_type13 += _MB_per_gob;
		ptr_mv_x11	  += _MB_per_gob; ptr_mv_x12	+= _MB_per_gob; ptr_mv_x13	  += _MB_per_gob;
		ptr_mv_y11	  += _MB_per_gob; ptr_mv_y12	+= _MB_per_gob; ptr_mv_y13	  += _MB_per_gob;

		ptr_seg_ID21  += _MB_per_gob; ptr_seg_ID22	+= _MB_per_gob;	ptr_seg_ID23  += _MB_per_gob;		
		ptr_mv_type21 += _MB_per_gob; ptr_mv_type22 += _MB_per_gob; ptr_mv_type23 += _MB_per_gob;
		ptr_mv_x21	  += _MB_per_gob; ptr_mv_x22	+= _MB_per_gob; ptr_mv_x23	  += _MB_per_gob;
		ptr_mv_y21	  += _MB_per_gob; ptr_mv_y22	+= _MB_per_gob; ptr_mv_y23	  += _MB_per_gob;

		ptr_seg_ID31  += _MB_per_gob; ptr_seg_ID32	+= _MB_per_gob;	ptr_seg_ID33  += _MB_per_gob;		
		ptr_mv_type31 += _MB_per_gob; ptr_mv_type32 += _MB_per_gob; ptr_mv_type33 += _MB_per_gob;
		ptr_mv_x31	  += _MB_per_gob; ptr_mv_x32	+= _MB_per_gob; ptr_mv_x33	  += _MB_per_gob;
		ptr_mv_y31	  += _MB_per_gob; ptr_mv_y32	+= _MB_per_gob; ptr_mv_y33	  += _MB_per_gob;
		
		ptr_seg_ID41  += _MB_per_gob; ptr_seg_ID42	+= _MB_per_gob;	ptr_seg_ID43  += _MB_per_gob;		
		ptr_mv_type41 += _MB_per_gob; ptr_mv_type42 += _MB_per_gob; ptr_mv_type43 += _MB_per_gob;
		ptr_mv_x41	  += _MB_per_gob; ptr_mv_x42	+= _MB_per_gob; ptr_mv_x43	  += _MB_per_gob;
		ptr_mv_y41	  += _MB_per_gob; ptr_mv_y42	+= _MB_per_gob; ptr_mv_y43	  += _MB_per_gob;

	}	// for (i=1; i<_GOB_per_frame; i++) {

}


/*
 * void D_Frame::Fast_Decoded_Structure(void)
 * 
 * Initialize fast decoded data structure setup
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	GOBs pointed to by _GOB_list
 * Ensures:		call D_GOB::Fast_Decoded_Structure() of GOBs acroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_Frame::Fast_Decoded_Structure(void)
{
	int i;
	D_GOB *ptr_GOB;

	unsigned char *decoded_shift_Y_c;
	unsigned char *decoded_shift_U_c;
	unsigned char *decoded_shift_V_c;
	
	decoded_shift_Y_c = _shift_frame;
	decoded_shift_U_c = _shift_frame + _picture_size;
	decoded_shift_V_c = _shift_frame + _picture_size + _picture_size_quarter;
	
	ptr_GOB = _GOB_list;
	for (i=0; i<_GOB_per_frame; i++) {
		
		ptr_GOB->Fast_Decoded_Structure(decoded_shift_Y_c, decoded_shift_U_c,
			decoded_shift_V_c);
		
		ptr_GOB++;
		decoded_shift_Y_c += _GOB_Y_offset;
		decoded_shift_U_c += _GOB_UV_offset;
		decoded_shift_V_c += _GOB_UV_offset;
	}	
}


#endif

