
#ifndef __D_FRAME_IMAGE_RECOVERY_MODULE_C__
#define __D_FRAME_IMAGE_RECOVERY_MODULE_C__

#include "D_Frame.h"


/*
 * void D_Frame::Image_Recovery_Module(void)
 * 
 * Reconstruct the frame
 * This is a private method
 *
 * Requires:	D_GOB::Decode_GOB() must be called before this
 * Modifies:	_fast_frame
 * Ensures:		Adding the residual with the previous decoded frame to reconstruct the frame
 *
 * Warning:		
 */
void D_Frame::Image_Recovery_Module(void)
{
	int i, j, k, m, loop;
	short *ptr_des_Y_s, *ptr_des_U_s, *ptr_des_V_s;
	short *ptr_fast_Y_s, *ptr_fast_U_s, *ptr_fast_V_s;
	short *ptr_evil_Y_s, *ptr_evil_U_s, *ptr_evil_V_s;
	short *ptr_mtype, *ptr_mcbpy, *ptr_mcbpc;
	unsigned char *ptr_shift_Y_c, *ptr_shift_U_c, *ptr_shift_V_c; 
	
	// The prediction frame
	// _shift_frame is not valid when in evil speed mode			
	ptr_shift_Y_c = _shift_frame;
	ptr_shift_U_c = _shift_frame + _picture_size;
	ptr_shift_V_c = _shift_frame + _picture_size + _picture_size_quarter;
	
	// The prediction frame
	// _evil_predict_frame is only valid when in evil speed mode			
	ptr_evil_Y_s = _evil_predict_frame;
	ptr_evil_U_s = _evil_predict_frame + _picture_size;
	ptr_evil_V_s = _evil_predict_frame + _picture_size + _picture_size_quarter;

	// The residue frame
	ptr_fast_Y_s = _fast_frame;
	ptr_fast_U_s = _fast_frame + _picture_size;
	ptr_fast_V_s = _fast_frame + _picture_size + _picture_size_quarter;

	// The reconstructed frame, the destination buffer
	ptr_des_Y_s = _recov_frame;
	ptr_des_U_s = _recov_frame + _picture_size;
	ptr_des_V_s = _recov_frame + _picture_size + _picture_size_quarter;


	ptr_mtype = _mtype;
	ptr_mcbpc = _mcbpc;
	ptr_mcbpy = _mcbpy;

	if (_evil_speed_mode) {
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				
				// INTRA-coded macroblocks; No change in _fast_frame
				if ((*ptr_mtype == INTRA) || (*ptr_mtype == INTRAQ)) {

					for (k=0; k<256; k++) *ptr_des_Y_s++ = *ptr_fast_Y_s++;
					for (k=0; k<64; k++) {
						*ptr_des_U_s++ = *ptr_fast_U_s++;
						*ptr_des_V_s++ = *ptr_fast_V_s++;
					}
					
					ptr_evil_Y_s += 256;
					ptr_evil_U_s += 64;
					ptr_evil_V_s += 64;
					
				}
				else {	// INTER-coded macroblocks
					
					// Luminance (Y) Blocks
					// Add residue only when mcbp = 1
					k = *ptr_mcbpy;
					for (loop=0; loop<4; loop++) {
						if (k & 8) {
							for (m=0; m<64; m++) 
								*ptr_des_Y_s++ = (short) (*ptr_fast_Y_s++ +  *ptr_evil_Y_s++);
						}
						else {
							ptr_fast_Y_s += 64;
							for (m=0; m<64; m++) 
								*ptr_des_Y_s++ = *ptr_evil_Y_s++;
						}
						k <<= 1;
					}
					
					// Chrominance (U,V) Blocks
					// Add residue only when mcbp = 1
					k = *ptr_mcbpc;
					if (k & 2) {
						for (m=0; m<64; m++) 
							*ptr_des_U_s++ = (short) (*ptr_fast_U_s++ + *ptr_evil_U_s++);
					}
					else {
						ptr_fast_U_s += 64;
						for (m=0; m<64; m++)
							*ptr_des_U_s++ = *ptr_evil_U_s++;
					}
					
					if (k & 1) {
						for (m=0; m<64; m++) 
							*ptr_des_V_s++ = (short) (*ptr_fast_V_s++ + *ptr_evil_V_s++);
					}
					else {
						ptr_fast_V_s += 64;
						for (m=0; m<64; m++)
							*ptr_des_V_s++ = *ptr_evil_V_s++;
					}
				} // else {	// INTER-coded blocks
				
				
				ptr_mtype++;
				ptr_mcbpy++;
				ptr_mcbpc++;
				
			} // for (j=0; j<_MB_per_gob; j++)
		} // for (i=0; i<_GOB_per_frame; i++)
	}
	
	else {
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				
				// INTRA-coded macroblocks No change in _fast_frame
				if ((*ptr_mtype == INTRA) || (*ptr_mtype == INTRAQ)) {

					for (k=0; k<256; k++) *ptr_des_Y_s++ = *ptr_fast_Y_s++;
					for (k=0; k<64; k++) {
						*ptr_des_U_s++ = *ptr_fast_U_s++;
						*ptr_des_V_s++ = *ptr_fast_V_s++;
					}

					ptr_shift_Y_c += 256;
					ptr_shift_U_c += 64;
					ptr_shift_V_c += 64;
										
				}
				else {	// INTER-coded macroblocks
					
					// Luminance (Y) Blocks
					// Add residue only when mcbp = 1
					k = *ptr_mcbpy;
					for (loop=0; loop<4; loop++) {
						if (k & 8) {
							for (m=0; m<64; m++) 
								*ptr_des_Y_s++ = (short) (*ptr_fast_Y_s++ +  (short) *ptr_shift_Y_c++);
						}
						else {
							ptr_fast_Y_s += 64;
							for (m=0; m<64; m++) 
								*ptr_des_Y_s++ = (short) *ptr_shift_Y_c++;
						}
						k <<= 1;
					}
					
					// Chrominance (U,V) Blocks
					// Add residue only when mcbp = 1
					k = *ptr_mcbpc;
					if (k & 2) {
						for (m=0; m<64; m++) 
							*ptr_des_U_s++ = (short) (*ptr_fast_U_s++ +  (short) *ptr_shift_U_c++);
					}
					else {
						ptr_fast_U_s += 64;
						for (m=0; m<64; m++)
							*ptr_des_U_s++ = (short) *ptr_shift_U_c++;
					}
					
					if (k & 1) {
						for (m=0; m<64; m++) 
							*ptr_des_V_s++ = (short) (*ptr_fast_V_s++ +  (short) *ptr_shift_V_c++);
					}
					else {
						ptr_fast_V_s += 64;
						for (m=0; m<64; m++)
							*ptr_des_V_s++ = (short) *ptr_shift_V_c++;
					}
				} // else {	// INTER-coded blocks
				
				
				ptr_mtype++;
				ptr_mcbpy++;
				ptr_mcbpc++;
				
			} // for (j=0; j<_MB_per_gob; j++)
		} // for (i=0; i<_GOB_per_frame; i++)
	}	// else {

}


/*
 * void D_Frame::Image_Recovery_Module(bool P_picture)
 * 
 * Reconstruct the frame
 * This is a private method
 *
 * Requires:	D_GOB::Decode_GOB() must be called before this
 * Modifies:	_fast_frame
 * Ensures:		Adding the residual with the previous decoded frame to reconstruct the frame
 *
 * Warning:		
 */
void D_Frame::Image_Recovery_Module(bool P_picture)
{
	int i, j, k, m, loop, offset;
	short *ptr_des_Y_s, *ptr_des_U_s, *ptr_des_V_s;
	short *ptr_fast_Y_s, *ptr_fast_U_s, *ptr_fast_V_s;
	short *ptr_mtype, *ptr_mcbpy, *ptr_mcbpc, *ptr_mcbpb;
	unsigned char *ptr_shift_Y_c, *ptr_shift_U_c, *ptr_shift_V_c; 
	
	offset = 0;
	if (P_picture) offset = _PB_offset;
	// The prediction frame
	// _shift_frame is not valid when in evil speed mode			
	ptr_shift_Y_c = _shift_frame + offset;
	ptr_shift_U_c = _shift_frame + _picture_size + offset;
	ptr_shift_V_c = _shift_frame + _picture_size + _picture_size_quarter + offset;
	
	// The residue frame
	ptr_fast_Y_s = _fast_frame + offset;
	ptr_fast_U_s = _fast_frame + _picture_size + offset;
	ptr_fast_V_s = _fast_frame + _picture_size + _picture_size_quarter + offset;

	// The reconstructed frame, the destination buffer
	ptr_des_Y_s = _recov_frame;
	ptr_des_U_s = _recov_frame + _picture_size;
	ptr_des_V_s = _recov_frame + _picture_size + _picture_size_quarter;


	ptr_mtype = _mtype;
	ptr_mcbpc = _mcbpc;		// coded block pattern for Chrominance blocks plus macroblock type
	ptr_mcbpy = _mcbpy;		// coded block pattern for Luminance blocks
	ptr_mcbpb = _mcbpb;		// coded block pattern for Luminance and Chrominance blocks
	
	
	if (P_picture) {		// P picture

		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				
				// INTRA-coded macroblocks No change in _fast_frame
				if ((*ptr_mtype == INTRA) || (*ptr_mtype == INTRAQ)) {
					
					for (k=0; k<256; k++) *ptr_des_Y_s++ = *ptr_fast_Y_s++;
					for (k=0; k<64; k++) {
						*ptr_des_U_s++ = *ptr_fast_U_s++;
						*ptr_des_V_s++ = *ptr_fast_V_s++;
					}
					
					ptr_shift_Y_c += 256;
					ptr_shift_U_c += 64;
					ptr_shift_V_c += 64;
					
				}
				else {	// INTER-coded macroblocks
					
					// Luminance (Y) Blocks
					// Add residue only when mcbp = 1
					k = *ptr_mcbpy;
					for (loop=0; loop<4; loop++) {
						if (k & 8) {
							for (m=0; m<64; m++) 
								*ptr_des_Y_s++ = (short) (*ptr_fast_Y_s++ +  (short) *ptr_shift_Y_c++);
						}
						else {
							ptr_fast_Y_s += 64;
							for (m=0; m<64; m++) 
								*ptr_des_Y_s++ = (short) *ptr_shift_Y_c++;
						}
						k <<= 1;
					}
					
					// Chrominance (U,V) Blocks
					// Add residue only when mcbp = 1
					k = *ptr_mcbpc;
					if (k & 2) {
						for (m=0; m<64; m++) 
							*ptr_des_U_s++ = (short) (*ptr_fast_U_s++ +  (short) *ptr_shift_U_c++);
					}
					else {
						ptr_fast_U_s += 64;
						for (m=0; m<64; m++)
							*ptr_des_U_s++ = (short) *ptr_shift_U_c++;
					}
					
					if (k & 1) {
						for (m=0; m<64; m++) 
							*ptr_des_V_s++ = (short) (*ptr_fast_V_s++ +  (short) *ptr_shift_V_c++);
					}
					else {
						ptr_fast_V_s += 64;
						for (m=0; m<64; m++)
							*ptr_des_V_s++ = (short) *ptr_shift_V_c++;
					}
				} // else {	// INTER-coded blocks
				
				
				ptr_mtype++;
				ptr_mcbpy++;
				ptr_mcbpc++;
				
			} // for (j=0; j<_MB_per_gob; j++)
		} // for (i=0; i<_GOB_per_frame; i++)

	} // if (P_picture) {		// P picture
	else {						// B picture

		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				
				// Luminance (Y) Blocks
				// Add residue only when mcbp = 1
				k = *ptr_mcbpb;
				for (loop=0; loop<4; loop++) {
					if (k & 32) {
						for (m=0; m<64; m++) 
							*ptr_des_Y_s++ = (short) (*ptr_fast_Y_s++ +  (short) *ptr_shift_Y_c++);
					}
					else {
						ptr_fast_Y_s += 64;
						for (m=0; m<64; m++) 
							*ptr_des_Y_s++ = (short) *ptr_shift_Y_c++;
					}
					k <<= 1;
				}
				
				// Chrominance (U,V) Blocks
				// Add residue only when mcbp = 1
				k = *ptr_mcbpb++;
				if (k & 2) {
					for (m=0; m<64; m++) 
						*ptr_des_U_s++ = (short) (*ptr_fast_U_s++ +  (short) *ptr_shift_U_c++);
				}
				else {
					ptr_fast_U_s += 64;
					for (m=0; m<64; m++)
						*ptr_des_U_s++ = (short) *ptr_shift_U_c++;
				}
				
				if (k & 1) {
					for (m=0; m<64; m++) 
						*ptr_des_V_s++ = (short) (*ptr_fast_V_s++ +  (short) *ptr_shift_V_c++);
				}
				else {
					ptr_fast_V_s += 64;
					for (m=0; m<64; m++)
						*ptr_des_V_s++ = (short) *ptr_shift_V_c++;
				}
				
			} // for (j=0; j<_MB_per_gob; j++)
		} // for (i=0; i<_GOB_per_frame; i++)

	} // else {						// B picture

}


#endif

