
#ifndef __D_FRAME_ENCODE_FRAME_C__
#define __D_FRAME_ENCODE_FRAME_C__

#include "Serialencoder.h"
#include "D_Frame.h"

extern HWND ghWndTTY;

/*
 * void D_Frame::Encode_Frame(yuv_video *yuv_ostream, 
 *								yuv_video *yuv_istream,
 *								PSC_Fifo &bit_ostream,
 *								const int yuv_fr_index)
 * 
 * Code a single video frame
 * This is a public method
 *
 * Requires:	data structure of the tree is correctly created for current frame object
 * Modifies:	nothing
 * Ensures:		. call D_Frame::Transform_2D_To_1D()
 *				. call D_frame::Motion_Estimation()
 *				. call D_Frame::Motion_Vectored_Decoded_Frame()
 *				. call D_Frame::Temploral_Compression_Control()
 *				. call D_Frame::Temporal_Compresser()
 *				. call D_GOB::Encode_GOB for GOBs pointed to by _GOB_list
 *				. call D_Frame::Entropy_Encoder()
 *				. call D_GOB::Decode_GOB()
 *				. call D_Frame::Motion_Compensation
 *				. call D_Frame::Transform_1D_to_2D
 *				. call D_Frame::Subpixel_Interpolation_Module()
 *
 * Warning:		
 */
void D_Frame::Encode_Frame(yuv_video *yuv_ostream, yuv_video *yuv_istream,
						   PSC_Fifo &bit_ostream, const int yuv_fr_index)
{
	D_GOB *ptr_GOB;
	int i;
	char output[150];
	unsigned char *y_this_frame, *u_this_frame, *v_this_frame;
	
	_PB_Ppicture_flag = false;
	D_GOB::_PB_Ppicture_flag = false;
	D_Slice::_PB_Ppicture_flag = false;
	D_Macroblock::_PB_Ppicture_flag = false;

	// Grab a frame from yuv_istream object
	y_this_frame = _this_2D_frame;
	u_this_frame = _this_2D_frame + _picture_size;
	v_this_frame = _this_2D_frame + _picture_size + _picture_size_quarter;
	
	memcpy(y_this_frame, yuv_istream->Get_Y(yuv_fr_index), sizeof(unsigned char) * _picture_size);
	memcpy(u_this_frame, yuv_istream->Get_U(yuv_fr_index), sizeof(unsigned char) * _picture_size_quarter);
	memcpy(v_this_frame, yuv_istream->Get_V(yuv_fr_index), sizeof(unsigned char) * _picture_size_quarter);
	
	if (_pskipped == 0) _pskipped = _fr_to_skip;
	else {
		sprintf(output,"Frame %3i: Frame skipped-> ", yuv_fr_index);
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		_pskipped--;
		goto BYPASS;
	}

	// Start processing
	if (_reset_segment_flag) {
		Reset_Segment();
		Update_Segment();
	}

	sprintf(output,"Frame %3i: Data-> ", yuv_fr_index);
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	Transform_2D_To_1D();
	
	if (_evil_speed_mode) Evil_Predict_Frame();
	
	if (_ME_enabled) {
		
		sprintf(output, "ME-> ");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		if (!_evil_speed_mode) {

			Motion_Estimation();
			if(_advanced_prediction_mode) Make_OPMC_Frame(true);
			else Temporal_Prediction_Module();
		}

		if(!_advanced_prediction_mode) Temporal_Compression_Control();
		Temporal_Compresser();
	}
	Set_MCBP();
	
	// Start Encoding Pixel data in _fast_frame, containing "residual"
	sprintf(output, "Enc_Video_");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	ptr_GOB = _GOB_list;
	for (i=0; i<_GOB_per_frame; i++) {
		ptr_GOB->Encode_GOB();
		ptr_GOB++;
	}

	// Start Entropy Encoding routine
	// Long Live The Entropy Encoder !!!
	Entropy_Encoder(bit_ostream);


	// Start Decoding Pixel data to reconstruct _fast_frame, containing "residual"
	sprintf(output, "VdoDec-> ");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	ptr_GOB = _GOB_list;
	for (i=0; i<_GOB_per_frame; i++) {
		ptr_GOB->Decode_GOB();
		ptr_GOB++;
	}

	// Reconstructing Picture
	sprintf(output, "MC-> ");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	Image_Recovery_Module();
	Transform_1D_To_2D();

	sprintf(output, "spixel-> "); fflush(stdout);
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	if(_advanced_prediction_mode && !_reference_picture_selection)
		Make_UMV_Padded_Frame(_decoded_frame);
	if (!_evil_speed_mode) Subpixel_Interpolation_Module();
	if (_reference_picture_selection) StoreDecodedFrames();
	/* if (_inter_frame_mode) Dump(false);*/



BYPASS:

	// Dump a frame to yuv_ostream object
	y_this_frame = _decoded_frame;
	u_this_frame = _decoded_frame + _picture_size;
	v_this_frame = _decoded_frame + _picture_size + _picture_size_quarter;
	
	sprintf(output, "done\n\r");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	yuv_ostream->Set_Y(yuv_fr_index, y_this_frame);
	yuv_ostream->Set_U(yuv_fr_index, u_this_frame);
	yuv_ostream->Set_V(yuv_fr_index, v_this_frame);
	_fr_num++;
}


/*
 * void D_Frame::Encode_Frame(yuv_video *yuv_ostream, 
 *								yuv_video *yuv_istream,
 *								PSC_Fifo &bit_ostream,
 *								const int yuv_fr_index,
 *								const bool PB_available,
 *								const bool P_frame)
 * 
 * Used in PB frame mode, "code" PB frame
 * This is a public method
 *
 * Requires:	data structure of the tree is correctly created for current frame object
 * Modifies:	nothing
 * Ensures:		. call D_Frame::Transform_2D_To_1D()
 *				. call D_frame::Motion_Estimation()
 *				. call D_Frame::Motion_Vectored_Decoded_Frame()
 *				. call D_Frame::Temploral_Compression_Control()
 *				. call D_Frame::Temporal_Compresser()
 *				. call D_GOB::Encode_GOB for GOBs pointed to by _GOB_list
 *				. call D_Frame::Entropy_Encoder()
 *				. call D_GOB::Decode_GOB()
 *				. call D_Frame::Motion_Compensation
 *				. call D_Frame::Transform_1D_to_2D
 *				. call D_Frame::Subpixel_Interpolation_Module()
 *
 * Warning:		
 */
void D_Frame::Encode_Frame(yuv_video *yuv_ostream, yuv_video *yuv_istream,
						   PSC_Fifo &bit_ostream, const int skip_override,
						   const int P_fr_index)
{
	D_GOB *ptr_GOB;
	int i, skip_count1, skip_count2, index, B_fr_index;
	char output[150];
	unsigned char *y_this_frame, *u_this_frame, *v_this_frame;
	
	if (!_PB_conditions_checked) {
		perror("\nPB conditions MUST be formally verified before actual Encoding process!\n");
		exit(-1);
	}

	_PB_Ppicture_flag = true;
	D_GOB::_PB_Ppicture_flag = true;
	D_Slice::_PB_Ppicture_flag = true;
	D_Macroblock::_PB_Ppicture_flag = true;

	// Process input arguments first
	skip_count1 = 0;
	skip_count2 = 0;

	if (_fr_to_skip != 0) {
		
		if (skip_override == -1) {
			skip_count1 = (int) ceil(_fr_to_skip/2);
			if (skip_count1 > 6) skip_count1 = 6;		// limited to 6 by standard
		}
		else 	skip_count1 = skip_override;
		
		skip_count2 = _fr_to_skip - skip_count1;
	}

	B_fr_index = skip_count1 + _fr_num;
	index = _fr_num;
	_fr_num = P_fr_index;		// _fr_num is now ready for use in entropy encoder
	_trb = skip_count1 + 1;
	_trd = skip_count2 + 1 + _trb;


	// This takes care of skip n frames before B frame
	for (i=0; i<skip_count1; i++) {
		sprintf(output, "Frame %3i: Frame skipped-> done\n\r", index);
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		y_this_frame = _decoded_frame;
		u_this_frame = _decoded_frame + _picture_size;
		v_this_frame = _decoded_frame + _picture_size + _picture_size_quarter;
		yuv_ostream->Set_Y(index, y_this_frame);
		yuv_ostream->Set_U(index, u_this_frame);
		yuv_ostream->Set_V(index, v_this_frame);
		index++;
	}

	// Grab a frame from yuv_istream object
	sprintf(output, "Frame %3i: PB data-> ", index);
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	y_this_frame = _this_2D_frame;
	u_this_frame = _this_2D_frame + _picture_size;
	v_this_frame = _this_2D_frame + _picture_size + _picture_size_quarter;
	
	// B-picture
	memcpy(y_this_frame, yuv_istream->Get_Y(B_fr_index), sizeof(unsigned char) * _picture_size);
	memcpy(u_this_frame, yuv_istream->Get_U(B_fr_index), sizeof(unsigned char) * _picture_size_quarter);
	memcpy(v_this_frame, yuv_istream->Get_V(B_fr_index), sizeof(unsigned char) * _picture_size_quarter);
	
	// P-picture
	memcpy((y_this_frame + _PB_offset), yuv_istream->Get_Y(P_fr_index), sizeof(unsigned char) * _picture_size);
	memcpy((u_this_frame + _PB_offset), yuv_istream->Get_U(P_fr_index), sizeof(unsigned char) * _picture_size_quarter);
	memcpy((v_this_frame + _PB_offset), yuv_istream->Get_V(P_fr_index), sizeof(unsigned char) * _picture_size_quarter);

	// This code really shouldn't be here for baseline PB-frame mode
	// Start processing
	if (_reset_segment_flag) {
		Reset_Segment();
		Update_Segment();
	}

	// Pre-process input data; first on B picture then P picturet
	Transform_2D_To_1D(false);			// transform B picture
	Transform_2D_To_1D(true);			// transform P picture
	
	// P Picture
	// Remove Temporal Redundancy
	// Forward prediction for P picture
	sprintf(output, "Encode Ppict> ");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	Motion_Estimation();

	if (_advanced_prediction_mode) Make_OPMC_Frame(true);
	else {
		Temporal_Prediction_Module();		// in PB mode, shift frame is offset
		Temporal_Compression_Control();		// in PB mode, only need to process P picture, offset
	}

	Temporal_Compresser(true);			// Calculate P-picture residue
	Set_MCBP();							// Determine macroblock coding info
	
	// Remove Spatial Redundancy
	// Compression for P picture residue
	ptr_GOB = _GOB_list;
	for (i=0; i<_GOB_per_frame; i++) {
		ptr_GOB->Encode_GOB(true);		// compression for P picture only
		ptr_GOB++;
	}

	// Recover Spatial Redundancy
	// Uncompress for P picture residue
	ptr_GOB = _GOB_list;
	for (i=0; i<_GOB_per_frame; i++) {
		ptr_GOB->Decode_GOB(true);
		ptr_GOB++;
	}

	// Reconstructing P Picture
	Image_Recovery_Module(true);		// Reconstruct P-picture
	Transform_1D_To_2D(true);			// map 1D decoded frame to 2D representation for P picture
	if(_advanced_prediction_mode) Make_UMV_Padded_Frame(_decoded_frame);
	Subpixel_Interpolation_Module();	// Create half_pel frames for P picture; _decoded_frame_x shifted by offset
	if (_reference_picture_selection) StoreDecodedFrames();

	// B Picture
	// Remove Temporal Redundancy
	// Bidirectional/Forward prediction for B picture
	sprintf(output, "Bidirectional_Prediction-> ");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	Interpolate_Bpicture_Motion_Vectors();
	Temporal_Prediction_Module(true);
	Temporal_Compresser(false);
	Set_MCBPB();

	// Remove Spatial Redundancy
	// Compression for B picture residue
	ptr_GOB = _GOB_list;
	for (i=0; i<_GOB_per_frame; i++) {
		ptr_GOB->Encode_GOB(false);		// compression for B picture only
		ptr_GOB++;
	}

	// Recover Spatial Redundancy
	// Uncompress for B picture residue
	ptr_GOB = _GOB_list;
	for (i=0; i<_GOB_per_frame; i++) {
		ptr_GOB->Decode_GOB(false);
		ptr_GOB++;
	}

	// Reconstructing B Picture
	sprintf(output, "Bpicture done\n\r");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	Image_Recovery_Module(false);		// Reconstruct B-picture
	Transform_1D_To_2D(false);			// map 1D decoded frame to 2D representation for B picture

	// Start Entropy Encoding routine
	// Long Live The Entropy Encoder !!!
	Entropy_Encoder(bit_ostream);


	// Dump B frame to yuv_ostream object
	y_this_frame = _decoded_frame;
	u_this_frame = _decoded_frame + _picture_size;
	v_this_frame = _decoded_frame + _picture_size + _picture_size_quarter;
	
	yuv_ostream->Set_Y(index, y_this_frame);
	yuv_ostream->Set_U(index, u_this_frame);
	yuv_ostream->Set_V(index, v_this_frame);
	index++;

	// This takes care of skip frames between B and P frame
	for (i=0; i<skip_count2; i++) {
		sprintf(output, "Frame %3i: Frame skipped-> done\n\r", index);
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		yuv_ostream->Set_Y(index, y_this_frame);
		yuv_ostream->Set_U(index, u_this_frame);
		yuv_ostream->Set_V(index, v_this_frame);
		index++;
	}


	// Transfer _decoded frame to default location, instead of offset by _PB_offset
	memcpy(_decoded_frame, (_decoded_frame + _PB_offset), sizeof(unsigned char) * _buffer_size);
	memcpy(_decoded_frame_half_full, (_decoded_frame_half_full + _PB_offset), sizeof(unsigned char) * _buffer_size);
	memcpy(_decoded_frame_full_half, (_decoded_frame_full_half + _PB_offset), sizeof(unsigned char) * _buffer_size);
	memcpy(_decoded_frame_half_half, (_decoded_frame_half_half + _PB_offset), sizeof(unsigned char) * _buffer_size);

	// Transfer data into prev_frames structure
	if (_reference_picture_selection) {
		memcpy(_prev_frames->GetFrame(1), (_decoded_frame + _PB_offset), sizeof(unsigned char) * _buffer_size);
		memcpy(_prev_half_full->GetFrame(1), (_decoded_frame_half_full + _PB_offset), sizeof(unsigned char) * _buffer_size);
		memcpy(_prev_full_half->GetFrame(1), (_decoded_frame_full_half + _PB_offset), sizeof(unsigned char) * _buffer_size);
		memcpy(_prev_half_half->GetFrame(1), (_decoded_frame_half_half + _PB_offset), sizeof(unsigned char) * _buffer_size);
	}
	// Dump(true);


	// Dump P frame to yuv_ostream object
	sprintf(output, "Frame %3i: Frame B picture @ %i -> ", P_fr_index, B_fr_index);
	sprintf(output, "%s[s,B,s,P]", output);
	sprintf(output, "%s- [%i,%i,%i,%i)-> done\n\r", output, skip_count1, B_fr_index, skip_count2, P_fr_index);
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	yuv_ostream->Set_Y(index, y_this_frame);
	yuv_ostream->Set_U(index, u_this_frame);
	yuv_ostream->Set_V(index, v_this_frame);
	_fr_num++;
}


#endif

