
#ifndef __D_FRAME_DISTANCE_ME_C__
#define __D_FRAME_DISTANCE_ME_C__

#include "D_Frame.h"


/*
 * void D_Frame::Distance_ME(unsigned char *prev_frame, int ysn, int xsn, int yso, int xso)
 * 
 * Compute the sum of absolute pixel difference of 2 macroblocks
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	_current_MAD
 * Ensures:		Compute the absolute sum of pixel differences between 2 macroblocks in current frame and target frame
 *
 * Warning:		
*/
void D_Frame::Distance_ME(unsigned char *target_frame, int ysn, int xsn, int yso, int xso)
{
	int p, q, r, position;
	unsigned char *cur_frame;
	unsigned char *dec_frame;
	
	if(_advanced_prediction_mode && !_first_search_in_AP)  {
		position = (ysn/16)*16*_frame_xsize + (xsn/16)*256;
		if(ysn%16 == 8) position += 128;
		if(xsn%16 == 8) position += 64;
	}
	else
		position = (xsn << 4) + (ysn * _frame_xsize);
		/* Do a mapping to temporary variables for the fast frame
		* ynew = _frame_xsize/(16)*ysn/(16)*16*16
		* xnew = xsn/(16)*16*16
		* The mapping table looks like (0,0) -> 0, (0,16) -> 256, (16,0) -> 11*256, 
		* (16,16) -> 11*256+256 etc. etc.
	*/
	
	cur_frame = _this_1D_frame + position;
	
	// Compute the position in the previously _decoded_frame
	
	if(_advanced_prediction_mode) //Pass the padded frame to it
		dec_frame = target_frame + xso + yso * (_frame_xsize + 32);
	else
		dec_frame = target_frame + xso + (yso * _frame_xsize);
	
	// Computes the absolute difference
	_current_MAD = 0;
	
	//For advanced prediction compute distance over a block alone
	
	if(_advanced_prediction_mode) {
		if(!_first_search_in_AP) {
			for (p=0; p<8; p++) {
				for (q=0; q<8; q++) {
					_current_MAD = (unsigned short) (_current_MAD + abs(*cur_frame++ - *dec_frame++));
					if (_current_MAD > _min_MAD) return;
				}
				
				dec_frame += (_frame_xsize + 32 - 8); 
				// Increment pointer to point to next row of block
			}//for (p=0; p<8; p++)
		}//if(!_first_search_in_AP)
		else {
			
			for (r=0; r<2; r++) {
				for (p=0; p<8; p++) {
					for (q=0; q<8; q++) {
						_current_MAD = (unsigned short) (_current_MAD + abs(*cur_frame++ - *dec_frame++));
						if (_current_MAD > _min_MAD) return;
					}
					dec_frame += (_frame_xsize + 32 - 8); // Increment pointer to point to next row of block
				}
				// Increment pointer to point to the next block in the macroblock
				if (r==0) dec_frame -= ((_frame_xsize + 32) << 3) - 8;
			}
			dec_frame -= 8;
			
			// Absolute difference for the next two blocks
			for (r=0; r<2; r++) {
				for (p=0; p<8; p++) {
					for (q=0; q<8; q++) {
						_current_MAD = (unsigned short) (_current_MAD + abs(*cur_frame++ - *dec_frame++));
						if (_current_MAD > _min_MAD) return;
					}
					dec_frame += (_frame_xsize + 32 - 8);
				}
				dec_frame -= ((_frame_xsize + 32) << 3) -8;
			}//for (r=0; r<2; r++)
		}//if(_first_search_in_AP) 
		
	}//if(_advanced_prediction_mode)
	else {
		for (r=0; r<2; r++) {
			for (p=0; p<8; p++) {
				for (q=0; q<8; q++) {
					_current_MAD = (unsigned short) (_current_MAD + abs(*cur_frame++ - *dec_frame++));
					if (_current_MAD > _min_MAD) return;
				}
				dec_frame += (_frame_xsize - 8); // Increment pointer to point to next row of block
			}//for (p=0; p<8; p++)
			// Increment pointer to point to the next block in the macroblock
			if (r==0) dec_frame -= ((_frame_xsize << 3) - 8);
		}//for (r=0; r<2; r++)
		dec_frame -= 8;
		
		// Absolute difference for the next two blocks
		for (r=0; r<2; r++) {
			for (p=0; p<8; p++) {
				for (q=0; q<8; q++) {
					_current_MAD = (unsigned short) (_current_MAD + abs(*cur_frame++ - *dec_frame++));
					if (_current_MAD > _min_MAD) return;
				}
				dec_frame += (_frame_xsize - 8);
			}
			dec_frame -= ((_frame_xsize << 3) -8);
		}//for (r=0; r<2; r++)
	}//if(!_advanced_prediction_mode)
}


#endif

