
#ifndef __D_FRAME_DECODE_SLICE_C__
#define __D_FRAME_DECODE_SLICE_C__

#include "D_Frame.h"


/*
 * bool Entropy_Decoder::Decode_Slice (PSC_Fifo& input)
 *
 * Entropy Decoding of the Slice Layer
 * This layer is optional which affects the treatment of the Median Prediction
 * of the Motion Vectors for this GOB
 *
 * Requires: Valid input Bitstream
 *           EDEBUG activates on-screen information
 *
 * Modifies: quant (Quantization value for rest of picture)
 *           
 * Ensures:  Setting of quantization levels and treatment of motion vectors for GOB
 */
bool D_Frame::Decode_Slice(PSC_Fifo& input, bool psc_found) {
	int i,j,k;

	if (EDEBUG) { cout << "-> SLICE " << _ed_gn << endl; cout.flush(); }

	// SEPB1 - Slice Emulation Prevention Bit 1 - 1 bit
	if (!input.ReadBit()) {
		cout << "Invalid SEPB1: Expected a 1" << endl;
		return (false);
	}

	// MBA - Macroblock Address - 5/6/7/9/11/12/13/14 bits
	j = MBA_Length[_sformat];
	input.ReadNBits(_ed_bits, j);
	_ed_mba = 0;
	for (i = 0; i < j; i++) {
		_ed_mba = (_ed_mba << 1) + _ed_bits[i];
	}
	_slice_MBA[_ed_gn] = _ed_mba;
	if (EDEBUG) { cout << "SMBA " << _ed_mba << endl; cout.flush(); }

	// SEPB2 - Slice Emulation Prevention Bit 2 - 1 bit
	if (psc_found && _rectangular_submode) {
		if (!input.ReadBit()) {
			cout << "Invalid SEPB2: Expected a 1" << endl;
			return (false);
		}
	}
	else if (MBA_Length[_sformat] > 11) {
		if (!input.ReadBit()) {
			cout << "Invalid SEPB2: Expected a 1" << endl;
			return (false);
		}
	}

	// SQUANT - Quantizer Information - 5 bits
	if (!psc_found) {
		_ed_quant = 0;
		input.ReadNBits(_ed_bits,5);
		for (i = 0; i < 5; i++) {
			_ed_quant = (short) ((_ed_quant << 1) + _ed_bits[i]);
		}
		if (EDEBUG) { cout << "SQUANT " << _ed_quant << endl; cout.flush(); }
	}

	// SWI - Slice Width Indication in macroblocks - 3/4/5/6/7 bits
	if (_rectangular_submode) {
		j = SWI_Length[_sformat];
		input.ReadNBits(_ed_bits, j);
		k = 0;
		for (i = 0; i < j; i++) {
			k = (k << 1) + _ed_bits[i];
		}
		_slice_size[_ed_gn] = k;
		if (EDEBUG) { cout << "SWI " << k << endl; cout.flush(); }
	}

	// SEPB3 - Slice Emulation Prevention Bit 3 - 1 bit
	if (!input.ReadBit()) {
		cout << "Invalid SEPB2: Expected a 1" << endl;
		return (false);
	}

	// GFID - GOB Frame ID - 2 bits
	// Changes needed: must handle when gfid is different
	_ed_gfid = 0;
	input.ReadNBits(_ed_bits,2);
	for (i = 0; i < 2; i++) {
		_ed_gfid = (_ed_gfid << 1) + _ed_bits[i];
	}
	if (EDEBUG) { cout << "GFID " << _ed_gfid << endl; cout.flush(); }

	// Receive Reference Picture Selection Mode info
	if (_reference_picture_selection) {
		// TRI - Temporal Reference Indicator - 1 bit
		if (input.ReadBit()) {	// (BCM must be implemented)
			input.ReadNBits(_ed_bits, 8);
			for (i=0,j=0; i<8; i++) {
				j = (j<<1) + _ed_bits[i];
			}
			cout << "Ignoring TRI: Decoder does not support GOBs from other TRs" << endl;
			if (EDEBUG) { cout << "STR " << j << endl; cout.flush(); }
		}

		// TRPI - Temporal reference for prediction indication - 1 bit
		if (input.ReadBit()) {
			// TRP - Temporal Reference for Prediction - 10 bits
			input.ReadNBits(_ed_bits,10);
			
			if (_ed_bits[0] || _ed_bits[1]) {
				cout << "Invalid TRP: Decoder does not support custom PCFs" << endl;
				return (false);
			}
			for (i=2, j=0; i<10; i++) {
				j = (j<<=1) + _ed_bits[i];
			}
			i = _ed_tr - j;
			if (i < 0) i += 256;
			*(_trp+_ed_gn) = i;
			if (EDEBUG) { cout << "STRP " << j << " - TRP " << *(_trp+_ed_gn) << endl; cout.flush(); }
		}
		else *(_trp+_ed_gn) = 0;

		// BCI - Back-Channel message indication - Variable Length
		if (input.ReadBit()) {
			cout << "Invalid BCI: Decoder does not support Back-Channel messages" << endl;
			return (false);
		}
		else input.ReadBit();
	}

	return (true);
}


#endif

