
#ifndef __D_FRAME_DECODE_PICTURE_C__
#define __D_FRAME_DECODE_PICTURE_C__

#include "D_Frame.h"


/*
 * bool Entropy_Decoder::Decode_Picture(PSC_Fifo& input, yuv_video *yuv_post)
 *
 * Entropy Decoding of the Picture Layer
 *
 * Requires: Valid input PSC_Fifo
 *           EDEBUG activates on-screen information
 *
 * Modifies: _inter_frame_mode (Is it INTER (1) or INTRA (0))
 *           quant (Quantization value for whole picture. Calls PQUANT())
 *           Creates YUV output video once source format is determined by PTYPE
 *           
 * Ensures:  Setting of frame mode and quantization level
 *           Checks TR for frame skipping
 */
bool D_Frame::Decode_Picture(PSC_Fifo& input, yuv_video& yuv_post) {
	int i, j;
	bool ufep_sent;
	short dbquanttemp, shorttemp;

	// TR - Temporal Reference - 8 bits
	// The frame number at the picture clock frequency.
	// This currently holds the frame number with indicies starting from 0
	// Changes needed: Don't know how to handle the clock frequency
	_ed_tr = 0;
	input.ReadNBits(_ed_bits,8);
	for (i = 0; i < 8; i++) {
		_ed_tr = (_ed_tr << 1) + _ed_bits[i];
	}
	if (EDEBUG) { cout << endl << "TR " << _ed_tr << endl; cout.flush(); }

	// PTYPE - Type Information - 8 bits
	_ed_ptype = 0;
	input.ReadNBits(_ed_bits,8);
	for (i = 0; i < 8; i++) {
		_ed_ptype = (_ed_ptype << 1) + _ed_bits[i];
	}
	// PTYPE Bit 1 & 2: Should always be 10
	if (!_ed_bits[0] || _ed_bits[1]) {
		cout << "Invalid PTYPE: Invalid start bits " << _ed_bits[0] << _ed_bits[1] << endl;
		return (false);
	}
	// PTYPE Bit 3: Split Screen Indicator
	if (_ed_bits[2]) {
		cout << "Invalid PTYPE: Decoder does not support split screen" << endl;
		return (false);
	}
	// PTYPE Bit 4: Document Camera Indicator
	if (_ed_bits[3]) {
		cout << "Invalid PTYPE: Decoder does not support document camera" << endl;
		return (false);
	}
	// PTYPE Bit 5: Full Picture Freeze Release
	if (_ed_bits[4]) {
		cout << "Invalid PTYPE: Decoder does not support full picture freeze" << endl;
		return (false);
	}
	if (EDEBUG) { cout << "PTYPE " << _ed_bits[0] << _ed_bits[1] << _ed_bits[2] <<
		_ed_bits[3] << _ed_bits[4] << endl; cout.flush(); }
	// PTYPE Bit 6-8: Source Format
	_plusptype = false;
	_ed_ciftype = _ed_ptype & 7;
	if (_ed_ciftype == 1) {
		_sformat = SQCIF;
		_max_mba = 7;
		_max_gn = 5;
	}
	else if (_ed_ciftype == 2) {
		_sformat = QCIF;
		_max_mba = 10;
		_max_gn = 8;
	}
	else if (_ed_ciftype == 7) {
		_plusptype = true;
	}
	else { // Baseline only supports sub-QCIF (1) and QCIF (2)
		cout << "Invalid PTYPE: Decoder only supports sub-QCIF and QCIF" << endl;
		return (false);
	}

	// PLUSPTYPE - Plus PTYPE - Variable Length
	if (_plusptype) {
		// UFEP - Update Full Extended PTYPE - 3 bits
		input.ReadNBits(_ed_bits,3);
		if (!_ed_bits[0] && !_ed_bits[1]) ufep_sent = _ed_bits[2];
		else {
			cout << "Invalid UFEP: " << _ed_bits[0] << _ed_bits[1] << _ed_bits[2] << endl;
			return (false);
		}

		// OPPTYPE - Optional part of PLUSPTYPE - 18 bits
		if (ufep_sent) {
			input.ReadNBits(_ed_bits, 18);
			// OPPTYPE Bit 1-3: Source Format
			_ed_ciftype = 0;
			for (i = 0; i < 3; i++) {
				_ed_ciftype = (_ed_ciftype << 1) + _ed_bits[i];
			}
			if (_ed_ciftype == 1) {
				_sformat = SQCIF;
				_max_mba = 7;
				_max_gn = 5;
			}
			else if (_ed_ciftype == 2) {
				_sformat = QCIF;
				_max_mba = 10;
				_max_gn = 8;
			}
			else { // Baseline only supports sub-QCIF (1) and QCIF (2)
				cout << "Invalid SFORMAT: Decoder only supports sub-QCIF and QCIF" << endl;
				return (false);
			}
			if (EDEBUG) { cout << "SFORMAT " << _ed_bits[0] << _ed_bits[1] <<
				_ed_bits[2] << endl; cout.flush(); }
			// Initialize Data Structure for CIFTYPE only at first frame
			if (_fr_num == 0) {
				Create_Data_Structure(false);
				switch (_sformat) {
				case (SQCIF):
					yuv_post.SetXY(SQCIFX, SQCIFY);
					break;
				case (QCIF):
					yuv_post.SetXY(QCIFX, QCIFY);
					break;
				}
				yuv_post.SetFile(_ed_outfilename, true);
			}

			// OPPTYPE Bit 4: Optional Custom PCF
			if (_ed_bits[3]) {
				cout << "Invalid OPPTYPE: Decoder does not support custom PCF" << endl;
				return (false);
			}
			// OPPTYPE Bit 5: Optional Unrestricted Motion Vector (UMV) mode
			if (_ed_bits[4] & !_unrestricted_motion_vector_mode) Enable_UMV_Mode();
			else if (!_ed_bits[4] & _unrestricted_motion_vector_mode) Disable_UMV_Mode();
			if (EDEBUG) { cout << "UMV " << _unrestricted_motion_vector_mode << endl; cout.flush(); }
			// OPPTYPE Bit 6: Optional Syntax-based Arithmetic Coding (SAC) mode
			if (_ed_bits[5] & !_syntax_arithmetic_coding_mode) Enable_SAC_Mode();
			else if (!_ed_bits[5] & _syntax_arithmetic_coding_mode) Disable_SAC_Mode();
			if (EDEBUG) { cout << "SAC " << _syntax_arithmetic_coding_mode << endl; cout.flush(); }
			// OPPTYPE Bit 7: Optional Advanced Prediction (AP) mode
			if (_ed_bits[6] & !_advanced_prediction_mode) Enable_AP_Mode();
			else if (!_ed_bits[6] & _advanced_prediction_mode) Disable_AP_Mode();
			if (EDEBUG) { cout << "AP " << _advanced_prediction_mode << endl; cout.flush(); }
			// OPPTYPE Bit 8: Optional Advanced INTRA Coding (AIC) mode
			if (_ed_bits[7]) {
				cout << "Invalid OPPTYPE: Decoder does not support AIC mode" << endl; cout.flush();
				return (false);
			}
			if (EDEBUG) { cout << "AIC 0" << endl; cout.flush(); }
			// OPPTYPE Bit 9: Optional Deblocking Filter (DF) mode
			if (_ed_bits[8]) {
				cout << "Invalid OPPTYPE: Decoder does not support DF mode" << endl; cout.flush();
				return (false);
			}
			if (EDEBUG) { cout << "DF 0" << endl; cout.flush(); }
			// OPPTYPE Bit 10: Optional Slice Structured (SS) mode
			if (_ed_bits[9] & !_slice_mode) _slice_mode = true; // Handle SS modes in SSS
			else if (!_ed_bits[9] & _slice_mode) Disable_SLICE_Mode();
			if (EDEBUG) { cout << "SS " << _slice_mode << endl; cout.flush(); }
			// OPPTYPE Bit 11: Optional Optional Reference Pictre Selection (RPS) mode
			if (_ed_bits[10] & !_reference_picture_selection) Enable_RPS_Mode();
			else if (!_ed_bits[10] & _reference_picture_selection) Disable_RPS_Mode();
			if (EDEBUG) { cout << "RPS " << _reference_picture_selection << endl; cout.flush(); }
			// OPPTYPE Bit 12: Optional Independent Segment Decoding (ISD) mode
			if (_ed_bits[11] & !_independent_segment_mode) Enable_ISD_Mode();
			else if (!_ed_bits[11] & _independent_segment_mode) Disable_ISD_Mode();
			if (EDEBUG) { cout << "ISD " << _independent_segment_mode << endl; cout.flush(); }
			// OPPTYPE Bit 13: Optional Alternative INTER VLC (AIV) mode
			if (_ed_bits[12]) {
				cout << "Invalid OPPTYPE: Decoder does not support AIV mode" << endl; cout.flush();
				return (false);
			}
			if (EDEBUG) { cout << "AIV 0" << endl; cout.flush(); }
			// OPPTYPE Bit 14: Optional Modified Quantization (MQ) mode
			if (_ed_bits[13]) {
				cout << "Invalid OPPTYPE: Decoder does not support MQ mode" << endl; cout.flush();
				return (false);
			}
			if (EDEBUG) { cout << "MQ 0" << endl; cout.flush(); }
			// OPPTYPE Bit 15-18: 1000
			if (!_ed_bits[14] || _ed_bits[15] || _ed_bits[16] || _ed_bits[17]) {
				cout << "Invalid OPPTYPE: Bits 15-18: " << _ed_bits[14] << _ed_bits[15] <<
					_ed_bits[16] << _ed_bits[17] << endl;
				return (false);
			}
		} // if (ufep_sent) // OPPTYPE
		
		// MPPTYPE - Mandatory part of PLUSPTYPE - 9 bits
		// MPPTYPE Bit 1-3: Picture Type Code
		input.ReadNBits(_ed_bits,9);
		for (i=0, j=0; i<3; i++) {
			j = (j<<1) + _ed_bits[i];
		}
		switch (j) {
		case (0):
			Set_Frame_Mode_INTRA();
			break;
		case (1):
			Set_Frame_Mode_INTER();
			break;
		default:
			cout << "Invalid MPPTYPE: Picture Type Code - Decoder does not support " << j << endl;
			return (false);
		}
		if (EDEBUG) { cout << "PCODE " << _inter_frame_mode << endl; cout.flush(); }
		// MPPTYPE Bit 4: Optional Reference Picture resampling (RPR) mode
		if (_ed_bits[3]) {
			cout << "Invalid MPPTYPE: Decoder does not support RPR mode" << endl; cout.flush();
			return (false);
		}
		if (EDEBUG) { cout << "RPR 0" << endl; cout.flush(); }
		// MPPTYPE Bit 5: Optional Reduced-Resolution Update mode
		if (_ed_bits[4]) {
			cout << "Invalid MPPTYPE: Decoder does not support RRU mode" << endl; cout.flush();
			return (false);
		}
		if (EDEBUG) { cout << "RRU 0" << endl; cout.flush(); }
		// MPPTYPE Bit 6: Rounding Type (RTYPE)
		_RCONTROL = _ed_bits[5];
		if (EDEBUG) { cout << "RTYPE " << _RCONTROL << endl; cout.flush(); }
		// MPPTYPE Bits 7-9: 001
		if (_ed_bits[6] || _ed_bits[7] || !_ed_bits[8]) {
			cout << "Invalid MPPTYPE: Bits 7-9: " << _ed_bits[6] << _ed_bits[7]
				<< _ed_bits[8] << endl;
			return (false);
		}

		// CPM - Continuous Presence Multipoint and Videoi Multiplex - 1 bit
		if (input.ReadBit()) {
			cout << "Invalid CPM: Decoder does not support this optional mode" << endl;
			return (false);
		}
		if (EDEBUG) { cout << "CPM 0" << endl; cout.flush();}

		// CPFMT - Custom Picture Format - 23 bits
		// EPAR - Extended Pixel Aspect Ratio - 16 bits
		// CPCFC - Custom Picture Clock Frequency Code - 8 bits
		// ETR - Extended Temporal Reference - 2 bits

		// UUI - Unlimited Unrestricted Motion Vectors Indicator - Variable Length
		if (_unrestricted_motion_vector_mode) {
			if (!input.ReadBit()) input.ReadBit();
			
		}

		// SSS - Slice Structured submode bits - 2 bits
		if (ufep_sent && _slice_mode) {
			_rectangular_submode = input.ReadBit();
			_arbitrary_order_submode = input.ReadBit();
			Enable_SLICE_Mode(_rectangular_submode, _arbitrary_order_submode);
			if (EDEBUG) { cout << "SSS " << _rectangular_submode <<
				_arbitrary_order_submode << endl; cout.flush(); }
		}

		// ELNUM - Enhancement layer number - 4 bits
		// RLNUM - Reference Layer Number - 4 bits

		if (_reference_picture_selection) {
			// RPSMF - Reference picture Selection Mode Flags - 3 bits
			if (ufep_sent) {
				input.ReadNBits(_ed_bits,3);
				if (!_ed_bits[0] || _ed_bits[1] || _ed_bits[2]) {
					cout << "Invalid RPSMF: Decoder does not support ACK nor NACK signals" << endl;
					return (false);
				}
			}

			// TRPI - Temporal reference for prediction indication - 1 bit
			if (input.ReadBit()) {
				// TRP - Temporal Reference for Prediction - 10 bits
				input.ReadNBits(_ed_bits,10);

				if (_ed_bits[0] || _ed_bits[1]) {
					cout << "Invalid TRP: Decoder does not support custom PCFs" << endl;
					return (false);
				}
				for (i=2, j=0; i<10; i++) {
					j = (j<<=1) + _ed_bits[i];
				}
				i = _ed_tr - j;
				if (i < 0) i += 256;
				*_trp = i;
				if (EDEBUG) { cout << "PTRP " << j << " - TRP " << *_trp << endl; cout.flush(); }
			}
			else *_trp = 0;

			// BCI - Back-Channel message indication - Variable Length
			if (input.ReadBit()) {
				cout << "Invalid BCI: Decoder does not support Back-Channel messages" << endl;
				return (false);
			}
			else input.ReadBit();
		}

		// RPRP - Reference picture Resampling Parameters - Variable Length

		// PQUANT - Quantizer Information - 5 bits (Half the step sizes)
		_ed_quant = 0;
		input.ReadNBits(_ed_bits,5);
		for (i = 0; i < 5; i++) {
			_ed_quant = (short) ((_ed_quant << 1) + _ed_bits[i]);
		}
		if (EDEBUG) { cout << "PQUANT " << _ed_quant << endl; cout.flush(); }

		// Must use Improved-PB frames mode instead
		Disable_PB_Mode();
		_PB_Ppicture_flag = false;
		D_GOB::_PB_Ppicture_flag = false;
		D_Macroblock::_PB_Ppicture_flag = false;
		_PB_conditions_checked = false;
	}
	else {
		if (EDEBUG) { cout << "SFORMAT " << _ed_bits[5] << _ed_bits[6] <<
			_ed_bits[7] << endl; cout.flush(); }
		// Initialize Data Structure for CIFTYPE only at first frame
		if (_fr_num == 0) {
			Create_Data_Structure(false);
			switch (_sformat) {
			case (SQCIF):
				yuv_post.SetXY(SQCIFX, SQCIFY);
				break;
			case (QCIF):
				yuv_post.SetXY(QCIFX, QCIFY);
				break;
			}
			yuv_post.SetFile(_ed_outfilename, true);
		}
		
		input.ReadNBits(_ed_bits,5);
		// PTYPE Bit 9: Picture Coding Type
		if (_ed_bits[0]) Set_Frame_Mode_INTER(); // INTRA I-picture (0) or INTER P-picture (1)
		else Set_Frame_Mode_INTRA();
		if (EDEBUG) { cout << "PCODE " << _inter_frame_mode << endl; cout.flush(); }
		// PTYPE Bit 10: Optional Unrestricted Motion Vector (UMV) mode
		if (_ed_bits[1] & !_unrestricted_motion_vector_mode) Enable_UMV_Mode();
		else if (!_ed_bits[1] & _unrestricted_motion_vector_mode) Disable_UMV_Mode();
		if (EDEBUG) { cout << "UMV " << _unrestricted_motion_vector_mode << endl; cout.flush(); }
		// PTYPE Bit 11: Optional Syntax-Based Arithmetic Coding (SAC) mode
		if (_ed_bits[2] & !_syntax_arithmetic_coding_mode) Enable_SAC_Mode();
		else if (!_ed_bits[2] & _syntax_arithmetic_coding_mode) Disable_SAC_Mode();
		if (EDEBUG) { cout << "SAC " << _syntax_arithmetic_coding_mode << endl; cout.flush(); }
		// PTYPE Bit 12: Optional Advanced Prediction (AP) mode
		if (_ed_bits[3] & !_advanced_prediction_mode) Enable_AP_Mode();
		else if (!_ed_bits[3] & _advanced_prediction_mode) Disable_AP_Mode();
		if (EDEBUG) { cout << "AP " << _advanced_prediction_mode << endl; cout.flush(); }
		// PTYPE Bit 13: Optional PB-frames (PB) mode
		if (_ed_bits[4] & !_PB_frame_mode) {
			Enable_PB_Mode();
			_PB_Ppicture_flag = true;
			D_GOB::_PB_Ppicture_flag = true;
			D_Macroblock::_PB_Ppicture_flag = true;
			_PB_conditions_checked = true;
		}
		else if (!_ed_bits[4] & _PB_frame_mode) {
			Disable_PB_Mode();
			_PB_Ppicture_flag = false;
			D_GOB::_PB_Ppicture_flag = false;
			D_Macroblock::_PB_Ppicture_flag = false;
			_PB_conditions_checked = false;
		}
		if (EDEBUG) { cout << "PB" << _PB_frame_mode << endl; cout.flush(); }

		// PQUANT - Quantizer Information - 5 bits (Half the step sizes)
		_ed_quant = 0;
		input.ReadNBits(_ed_bits,5);
		for (i = 0; i < 5; i++) {
			_ed_quant = (short) ((_ed_quant << 1) + _ed_bits[i]);
		}
		if (EDEBUG) { cout << "PQUANT " << _ed_quant << endl; cout.flush(); }
		
		// CPM - Continuous Presence Multipoint and Videoi Multiplex - 1 bit
		if (input.ReadBit()) {
			cout << "Invalid CPM: Decoder does not support this optional mode" << endl;
			return (false);
		}
		if (EDEBUG) { cout << "CPM 0" << endl; cout.flush();}

		// Disable modes when PLUSPTYPE is not sent
		Disable_RPS_Mode();
		Disable_ISD_Mode();
		Disable_SLICE_Mode();
	}

	// Only for PB frames
	if (_PB_frame_mode) {
		// TRB - Temporal Reference for B-pictures in PB-frames - 3 bits
		shorttemp = 0;
		input.ReadNBits(_ed_bits,3);
		for (i = 0; i < 3; i++) {
			shorttemp = (short) ((shorttemp << 1) + _ed_bits[i]);
		}
		_trb = shorttemp;
		if (_trb == 0) {
			cout << "Invalid TRB: TRB cannot be zero" << endl;
			return (false);
		}
		if (EDEBUG) { cout << "TRB " << _trb << endl; cout.flush(); }

		// DBQUANT - Quantization Information for B-pictures in PB frames - 2 bits
		dbquanttemp = 0;
		input.ReadNBits(_ed_bits,2);
		for (i = 0; i < 2; i++) {
			dbquanttemp = (short) ((dbquanttemp << 1) + _ed_bits[i]);
		}
		if (EDEBUG) { cout << "DBQUANT " << dbquanttemp << endl; cout.flush(); }
	}
	else dbquanttemp = 0;

	Set_PQuant(_ed_quant, dbquanttemp);

	// PEI - Extra Insertion Information - 1 bit
	while (input.ReadBit()) {
		if (EDEBUG) { cout << "PEI 1" << endl; cout.flush(); }
		// PSUPP - Supplemental Enhancement Information - multiple of 8 bits
		input.ReadNBits(_ed_bits,8);
		if (EDEBUG) { cout << "PSUPP " << _ed_bits[0] << _ed_bits[1] <<
			_ed_bits[2] << _ed_bits[3] << _ed_bits[4] << _ed_bits[5] <<
			_ed_bits[6] << _ed_bits[7] << endl; cout.flush(); }
	}
	if (EDEBUG) { cout << "PEI 0" << endl; cout.flush(); }

	return (true);
}

#endif

