
#ifndef __D_FRAME_DECODE_BIT_C__
#define __D_FRAME_DECODE_BIT_C__

#include "D_Frame.h"
#include "SAC.h"
#include "PSC_Fifo.h"

/*
 * bool D_Frame::Decode_Bit (PSC_Fifo& input, yuv_video *yuv_post)
 * Finite state machine which controls whether the next bits are
 * a Picture Layer, GOB Layer, or MB Layer
 *
 * Requires: input Bitstream and yuv_video object
 *           EDEBUG activates on-screen information
 *
 * Modifies: _fr_num (Frame number)
 *           _zigzaged_central (bitstream data)
 *           _fast_frame (coefficients or residues)
 *           _shift_frame (last frame motion compensated)
 *           
 * Ensures:  Calls Header_Decode() to see what is header is next on the bitstream
 *           It will call either Picture_Decode(), GOB_Decode(), or MB_Decode().
 *           If the bitstream EOF, then it will stop
 *           After each frame is completed, decoding, motion compensation,
 *           subpixel interpolation, and output to a YUV file is done
 */
bool D_Frame::Decode_Bit(PSC_Fifo& input) {
	D_GOB *ptr_GOB;
	int i;
	int skip;
	yuv_video yuv_post;

	_fr_num = -1;
	_ME_enabled = true;
	_psc_found = false;	// One PSC must be shown at least once
	_want_header = false;

	while (1) {
		// Headers - PSC & EOS & GBSC
		// PSC - Picture Start Code - 22 bits - (byte aligned)
		// 0000 0000 0000 0000 1 00000
		// EOS - End of Sequence - 22 bits - (optionally byte aligned) Optional
		// 0000 0000 0000 0000 1 11111
		// GSBC - Group of Block Start Code - 16 bits (Optionally byte aligned) Optional
		// 0000 0000 0000 0000 1
		// Changes needed: Need to make sure PSC is byte aligned
		if (Decode_Header(input, _want_header)) { // Find out what header is next on the bitstream
			if (_ed_header == 0) {	// If header is a PSC
				if (_syntax_arithmetic_coding_mode & _Created_Data_Structures) {
					input.Disable_SAC_Zero_Run();
					sac->reset=false;
				}
				if (_fr_num > -1) {	// Process zigzaged_central after the 1st frame is read in
					if (!_rectangular_submode)
						_slice_size[_ed_gn] = (short) (_ed_mba - _slice_MBA[_ed_gn]);

					skip = _ed_tr - _ed_last_tr;
					if (skip < 0) skip += 256;
					_trd = skip;

					if (_PB_frame_mode) {
						_PB_conditions_checked = true;
						_PB_Ppicture_flag = true;
						D_GOB::_PB_Ppicture_flag = true;
						D_Macroblock::_PB_Ppicture_flag = true;
						for (i = 0; i < _trb-1; i++) {	// Skip frames here up to B frame
							cout << "YUV (skipped frame)" << endl;
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							cout << "Frame " << ++_fr_num << "-> ";
						}

						if (_inter_frame_mode) {
							if(_advanced_prediction_mode) Make_OPMC_Frame(false);
							else Temporal_Prediction_Module();
						}

						// Decode P-pictures
						cout << "D-> "; cout.flush();
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB(true);
							ptr_GOB++;
						}
						cout << "MC-> "; cout.flush();
						Image_Recovery_Module(true);
						Transform_1D_To_2D(true);

						cout << "Subpixel-> "; cout.flush();
						if(_advanced_prediction_mode) 
							Make_UMV_Padded_Frame(_decoded_frame);
						Subpixel_Interpolation_Module();

						// Decode B-pictures
						Interpolate_Bpicture_Motion_Vectors();
						Temporal_Prediction_Module(true);
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB(false);
							ptr_GOB++;
						}
						Image_Recovery_Module(false);		// Reconstruct B-picture
						Transform_1D_To_2D(false);			// map 1D decoded frame to 2D representation for B picture

						// Dump a frame to yuv_post object
						cout << "B-picture-> YUV" << endl; cout.flush();
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);

						cout << "Frame " << ++_fr_num << "-> "; cout.flush();
						// Dump(true);

						for (i = _trd - _trb - 1; i > 0; i--) {	// Skip frames here up to B frame
							cout << "YUV (skipped frame)" << endl;
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							cout << "Frame " << ++_fr_num << "-> ";
						}
						memcpy(_decoded_frame, (_decoded_frame + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_half_full, (_decoded_frame_half_full + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_full_half, (_decoded_frame_full_half + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_half_half, (_decoded_frame_half_half + _PB_offset), sizeof(unsigned char) * _buffer_size);

						// Dump a P-picture to yuv_post object
						cout << "P-picture-> YUV" << endl; cout.flush();
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
					}
					else {
						for (; skip > 1; skip--) {	// Skip frames here
							cout << "YUV (skipped frame)" << endl;
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							cout << "Frame " << ++_fr_num << "-> ";
						}

						if (_slice_mode) {
							_SLICE_per_frame = _ed_gn + 1;
							if (_arbitrary_order_submode) Sort_Segment(0, _SLICE_per_frame-1);
						}

						if (_inter_frame_mode) {
							if(_advanced_prediction_mode) {
								Make_OPMC_Frame(false);
							}
							else Temporal_Prediction_Module();
						}
						else {
							Reset_Segment();
							Update_Segment();
						}
						cout << "D-> ";
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB();
							ptr_GOB++;
						}
						cout << "MC-> ";
						Image_Recovery_Module();
						Transform_1D_To_2D();
						// Dump();
						cout << "Subpixel-> ";
						if(_advanced_prediction_mode && !_reference_picture_selection) {
							Make_UMV_Padded_Frame(_decoded_frame);
						}
						Subpixel_Interpolation_Module();
						if (_reference_picture_selection) StoreDecodedFrames();
						// Dump a frame to yuv_post object
						cout << "YUV" << endl;
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
					}
				}
				cout << "Frame " << ++_fr_num << "-> ";
				_ed_last_tr = _ed_tr;
				_ed_last_ptype = _ed_ptype;
				if (EDEBUG) { cout << "Decoded PSC" << endl; cout.flush(); }
				if (!Decode_Picture(input, yuv_post)) {
					cout << "(sync) ";
					_want_header = true; // Entropy Decode Picture Data
				}
				_ed_gn = 0; _ed_last_gn = 0;
				_ed_mba = 0;
				_psc_found = true;
				if (_slice_mode) {	// Since first slice follows Picture Layer
					if (!Decode_Slice(input, true)) {
						cout << "(sync) ";
						_want_header = true; // Entropy Decode Slice Data
					}
				}
			}
			else if (_ed_header == 31) { // If header is EOS
				_psc_found = false;
				if (EDEBUG) { cout << "Decoded EOS" << endl; cout.flush(); }
			}
			else { // Positive values
				if (_psc_found) {  // If header is GOB or a Slice
					if (_syntax_arithmetic_coding_mode){
						input.Disable_SAC_Zero_Run();
						sac->reset=false;
					}
					if (_slice_mode) {
						if (!_rectangular_submode) _slice_size[_ed_gn] = (short) (_ed_mba - _slice_MBA[_ed_gn]);
						_ed_gn++;
						if (EDEBUG) { cout << "Decoded SLICE " << _ed_gn << endl; cout.flush(); }
						if (!Decode_Slice(input, false)) {
							cout << "(sync) ";
							_want_header = true; // Entropy Decode Slice Data
						}
					}
					else {
						_ed_last_gn = _ed_gn;
						if (EDEBUG) { cout << "Decoded GOB " << _ed_header << endl; cout.flush(); }
						if (!Decode_GOB(input)) {
							cout << "(sync) ";
							_want_header = true; // Entropy Decode GOB Data
						}
						_ed_mba = 0;
						_cgi[_ed_gn] = true;
					}
				}
				else {
					if (_slice_mode) cout << "Decoded GOB: PSC expected" << endl;
					else cout << "Decoded SLICE: PSC expected" << endl;
					cout << "(sync)-> ";
					_want_header = true;
				}
			}
		}
		else { // No header exists
			if (_ed_header == -31) {  // EOF - Process last frame and exit
				if (_fr_num > -1) { // Process zigzaged_central after the 1st frame is read in
					if (!_rectangular_submode)
						_slice_size[_ed_gn] = (short) (_ed_mba - _slice_MBA[_ed_gn]);
				
					skip = _ed_tr - _ed_last_tr;
					if (skip < 0) skip += 256;
					_trd = skip;

					if (_PB_frame_mode) {
						_PB_conditions_checked = true;
						_PB_Ppicture_flag = true;
						D_GOB::_PB_Ppicture_flag = true;
						D_Macroblock::_PB_Ppicture_flag = true;
						for (i = 0; i < _trb-1; i++) {	// Skip frames here up to B frame
							cout << "YUV (skipped frame)" << endl;
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							cout << "Frame " << ++_fr_num << "-> ";
						}

						if (_inter_frame_mode) {
							if(_advanced_prediction_mode) Make_OPMC_Frame(false);
							else Temporal_Prediction_Module();
						}

						// Decode P-pictures
						cout << "D-> ";
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB(true);
							ptr_GOB++;
						}
						cout << "MC-> ";
						Image_Recovery_Module(true);
						Transform_1D_To_2D(true);

						cout << "Subpixel-> ";
						if(_advanced_prediction_mode) 
							Make_UMV_Padded_Frame(_decoded_frame);
						Subpixel_Interpolation_Module();

						// Decode B-pictures
						Interpolate_Bpicture_Motion_Vectors();
						Temporal_Prediction_Module(true);
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB(false);
							ptr_GOB++;
						}
						Image_Recovery_Module(false);		// Reconstruct B-picture
						Transform_1D_To_2D(false);			// map 1D decoded frame to 2D representation for B picture


						// Dump a frame to yuv_post object
						cout << "B-picture-> YUV" << endl;
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);

						cout << "Frame " << ++_fr_num << "-> ";
						// Dump(true);
						for (i = _trd - _trb - 1; i > 0; i--) {	// Skip frames here up to B frame
							cout << "YUV (skipped frame)" << endl;
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							cout << "Frame " << ++_fr_num << "-> ";
						}
						memcpy(_decoded_frame, (_decoded_frame + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_half_full, (_decoded_frame_half_full + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_full_half, (_decoded_frame_full_half + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_half_half, (_decoded_frame_half_half + _PB_offset), sizeof(unsigned char) * _buffer_size);

						// Dump a P-picture to yuv_post object
						cout << "P-picture-> YUV" << endl;
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
					}
					else {
						for (; skip > 1; skip--) {	// Skip frames here
							cout << "YUV (skipped frame)" << endl;
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							cout << "Frame " << ++_fr_num << "-> ";
						}

						if (_slice_mode) {
							_SLICE_per_frame = _ed_gn + 1;
							if (_arbitrary_order_submode) Sort_Segment(0, _SLICE_per_frame-1);
						}

						if (_inter_frame_mode) {
							if(_advanced_prediction_mode) {
								Make_OPMC_Frame(false);
							}
							else Temporal_Prediction_Module();
						}
						else {
							Reset_Segment();
							Update_Segment();
						}
						cout << "D-> ";
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB();
							ptr_GOB++;
						}
						cout << "MC-> ";
						Image_Recovery_Module();
						Transform_1D_To_2D();
						//Dump(false);

						cout << "Subpixel-> ";
						if(_advanced_prediction_mode && !_reference_picture_selection) {
							Make_UMV_Padded_Frame(_decoded_frame);
						}
						Subpixel_Interpolation_Module();

						// Dump a frame to yuv_post object
						cout << "YUV" << endl;
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
					}
				}
				cout << "Bitstream ended" << endl; cout.flush();
				return(true);
			}
			else {
				if (_psc_found) {  // Must be a MB
					// Test for invalid mba values
					if (_slice_mode) {
						if (_ed_mba > (_GOB_per_frame*_MB_per_gob) - 1) {
							cout << "Exceeded Maximum MBA: " << _ed_mba << endl;
							cout << "(sync)-> ";
							_want_header = true;
						}
						if (_rectangular_submode) {
							if (_ed_mba > (_slice_size[_ed_gn]+_slice_MBA[_ed_gn]-1)) {
								cout << "Exceeded Maximum SWI of Slice " << _ed_gn << endl;
								cout << "(sync)-> ";
								_want_header = true;
							}
						}
					}
					else {
						if (_ed_mba > _max_mba) { // _max_mba holds (# of MB's in a GOB) - 1
							_ed_last_gn = _ed_gn;
							if (++_ed_gn > _max_gn) { // _max_gn holds (# of GOB's in a picture) - 1
								cout << "Exceeded Maximum GN: " << _ed_gn << endl;
								cout << "(sync)-> ";
								_want_header = true;
							}
							_ed_mba = 0;
							_cgi[_ed_gn] = false;
							_trp[_ed_gn] = _trp[_ed_gn-1];
							if (EDEBUG) { cout << "-> GOB " << _ed_gn << endl; cout.flush(); }
						}
					}
					if (EDEBUG) { cout << "Decoded MB" << endl; cout.flush(); }
					if (!_want_header) {
						if (_syntax_arithmetic_coding_mode){
							if (sac->reset == false){
								input.Enable_SAC_Zero_Run();
								sac->decoder_reset(input);
								sac->reset = true;
							}
							if (!Decode_SAC_MB(input, sac)) {
								cout << "(sync)-> ";
								// Something is wrong, search for a header
								_want_header = true;
							}
							else if ((_max_gn == _ed_gn) && (_max_mba == _ed_mba))
								_want_header = true;
							else _ed_mba++;
						}
						else {
							if (!Decode_MB(input)) {
								// Something is wrong, search for a header
								cout << "(sync)-> ";
								_want_header = true;
							}
							else if ((_max_gn == _ed_gn) && (_max_mba == _ed_mba))
								_want_header = true;
							else _ed_mba++;
						}
					}
				}
				else {
					cout << "Decoded MB: PSC expected" << endl;
					cout << "(sync)-> ";
					_want_header = true;
				}
			}
		}
	}
}


#endif

