
#ifndef __D_FRAME_C__
#define __D_FRAME_C__

#include "D_Frame.h"

bool D_GOB::_encode_mode;
bool D_Macroblock::_encode_mode;
bool D_Slice::_encode_mode;
bool D_Block::_encode_mode;

bool D_GOB::_inter_frame_mode;
bool D_Slice::_inter_frame_mode;
bool D_Macroblock::_inter_frame_mode;
bool D_Block::_inter_frame_mode;

bool D_GOB::_PB_frame_mode;
bool D_Slice::_PB_frame_mode;

bool D_GOB::_PB_Ppicture_flag;
bool D_Slice::_PB_Ppicture_flag;
bool D_Macroblock::_PB_Ppicture_flag;

bool D_GOB::_syntax_arithmetic_coding_mode;
bool D_Slice::_syntax_arithmetic_coding_mode;

bool D_GOB::_advanced_prediction_mode;
bool D_Slice::_advanced_prediction_mode;
bool D_Macroblock::_advanced_prediction_mode;

int D_GOB::_sformat;
int D_Slice::_sformat;

int D_GOB::_PB_offset;
int D_Slice::_PB_offset;

bool D_GOB::_coded_mvd_flag;
bool D_Slice::_coded_mvd_flag;
bool D_Macroblock::_coded_mvd_flag;

bool D_GOB::_independent_segment_mode;
bool D_Slice::_independent_segment_mode;
bool D_Macroblock::_independent_segment_mode;

bool D_GOB::_reference_picture_selection;
bool D_Slice::_reference_picture_selection;

bool D_Macroblock::_slice_mode;
bool D_Block::_slice_mode;

bool D_Slice::_rectangular_submode;
bool D_Slice::_arbitrary_order_submode;
bool D_Macroblock::_rectangular_submode;
bool D_Macroblock::_arbitrary_order_submode;


/*
 * D_Frame::D_Frame(void)
 *
 * Constructor
 * 
 * Requires: nothing
 * Modifies: _fr_num, _pquant, _thresh_no_residue, _thresh_large,
 *           _RCONTROL
 * Ensures:  Initialization for these variables
 *
 * Warning:
 */
D_Frame::D_Frame (void) {
	// Boolean flags initialization
	_encode_mode = true;
	_RCONTROL = false;
	_Created_Data_Structures = false;

	_advanced_prediction_mode = false;
	_evil_speed_mode = false;
	_independent_segment_mode = false;
	_PB_frame_mode = false;
	_reference_picture_selection = false;
	_slice_mode = false;
	_syntax_arithmetic_coding_mode = false;
	_unrestricted_motion_vector_mode = false;

	_rectangular_submode = false;
	_arbitrary_order_submode = false;

	_AP_conditions_checked = false;
	_PB_conditions_checked = false;
	_SAC_conditions_checked = false;
	_UMV_conditions_checked = false;

	_coded_mvd_flag = false;
	_PB_Ppicture_flag = false;
	_reset_segment_flag = true;


	// Basic class parameters
	_fr_num = 0;
	_pquant = 8;
	_thresh_no_residue = 512;
	_thresh_large = 500;

	// Initialize all pointers
	_GOB_list = NULL;
	_SLICE_list = NULL;
	_MB_list = NULL;
	_BLK_list = NULL;

	_cgi = NULL;

	_this_2D_frame = NULL; 
	_this_1D_frame = NULL;
	_fast_frame = NULL;
	_recov_frame = NULL;
	_zigzaged_central = NULL;

	_evil_predict_frame = NULL;

	_cmi = NULL;
	_flag_zero_mv = NULL;
	_mcbpc = NULL;
	_mcbpy = NULL;
	_mquant = NULL;
	_mtype = NULL;

	_mv_type1 = NULL; _mv_x1 = NULL; _mv_y1 = NULL;
	_mv_type2 = NULL; _mv_x2 = NULL; _mv_y2 = NULL;
	_mv_type3 = NULL; _mv_x3 = NULL; _mv_y3 = NULL;
	_mv_type4 = NULL; _mv_x4 = NULL; _mv_y4 = NULL;

	_zero_mv_type = NULL;
	_zero_mv_x = NULL;
	_zero_mv_y = NULL;
	
	_decoded_frame = NULL;
	_decoded_frame_half_full = NULL;
	_decoded_frame_full_half = NULL;
	_decoded_frame_half_half = NULL;
	
	_left_shift = NULL;
	_upper_shift = NULL;
	_upper_left_shift = NULL;

	_prev_frames = NULL;
	_prev_half_full = NULL; 
	_prev_full_half = NULL;
	_prev_half_half = NULL;
	_ref_index = 0;
	_trp = NULL;
}


/*
 * D_Frame::~D_Frame(void)
 * 
 * Destructor
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	everything
 * Ensures:		all memory space are returned to free store
 *
 * Warning:		
 */
D_Frame::~D_Frame(void) 
{
	if (_Created_Data_Structures) {

		delete[] _GOB_list;
		delete[] _MB_list;
		delete[] _cgi;

		delete[] _SLICE_list;
		delete[] _BLK_list;
		
		delete[] _this_2D_frame; 
		delete[] _this_1D_frame;
		delete[] _fast_frame;
		delete[] _recov_frame;
		delete[] _zigzaged_central;
		
		if (_evil_speed_mode) delete[] _evil_predict_frame;
		
		
		delete[] _flag_zero_mv;
		delete[] _mcbpc;
		delete[] _mcbpy;
		delete[] _mquant;
		delete[] _mtype;

		// Video Segment Data
		delete[] _slice_size;
		delete[] _slice_MBA;

		delete[] _seg_ID; delete[] _seg_size;
		delete[] _right_span; delete[] _left_span;

		delete[] _mvx0_low; delete[] _mvx0_high;
		delete[] _mvx1_low; delete[] _mvx1_high;
		delete[] _mvx2_low; delete[] _mvx2_high;
		delete[] _mvx3_low; delete[] _mvx3_high;
		delete[] _mvx4_low; delete[] _mvx4_high;
		
		delete[] _mvy0_low; delete[] _mvy0_high;
		delete[] _mvy1_low; delete[] _mvy1_high;
		delete[] _mvy2_low; delete[] _mvy2_high;
		delete[] _mvy3_low; delete[] _mvy3_high;
		delete[] _mvy4_low; delete[] _mvy4_high;
		
		delete[] _x_bound_low; delete[] _x_bound_high;
		delete[] _y_bound_low; delete[] _y_bound_high;

		delete [] _mvx_border_low; delete[] _mvx_border_high;
		delete [] _mvy_border_low; delete[] _mvy_border_high;

		// 4 motion vectors
		delete[] _mv_type1; delete[] _mv_x1; delete[] _mv_y1;
		delete[] _mv_type2; delete[] _mv_x2; delete[] _mv_y2;
		delete[] _mv_type3; delete[] _mv_x3; delete[] _mv_y3;
		delete[] _mv_type4; delete[] _mv_x4; delete[] _mv_y4;

		// Delta motion vectors
		delete[] _mvd_type; delete[] _mvd_x; delete[] _mvd_y;

		// Zero motion vector
		delete _zero_mv_type; delete _zero_mv_x; delete _zero_mv_y;
		
		if (_PB_frame_mode || !_encode_mode) {

			delete[] _mcbpb;
			delete[] _bquant;
			
			delete[] _mv_type1_f; delete[] _mv_x1_f; delete[] _mv_y1_f;
			delete[] _mv_type2_f; delete[] _mv_x2_f; delete[] _mv_y2_f;
			delete[] _mv_type3_f; delete[] _mv_x3_f; delete[] _mv_y3_f;
			delete[] _mv_type4_f; delete[] _mv_x4_f; delete[] _mv_y4_f;
			
			delete[] _mv_type1_b; delete[] _mv_x1_b; delete[] _mv_y1_b;
			delete[] _mv_type2_b; delete[] _mv_x2_b; delete[] _mv_y2_b;
			delete[] _mv_type3_b; delete[] _mv_x3_b; delete[] _mv_y3_b;
			delete[] _mv_type4_b; delete[] _mv_x4_b; delete[] _mv_y4_b;
			
			delete[] _mv_type_uv_f; delete[] _mv_uvx_f; delete[] _mv_uvy_f;
			delete[] _mv_type_uv_b; delete[] _mv_uvx_b; delete[] _mv_uvy_b;
		}
		
		delete[] _decoded_frame;
		delete[] _decoded_frame_half_full;
		delete[] _decoded_frame_full_half;
		delete[] _decoded_frame_half_half;

		if(_advanced_prediction_mode || _unrestricted_motion_vector_mode || !_encode_mode) {
			delete[] _padded_UMV_frame;
			delete[] _padded_UMV_frame_half_full;
			delete[] _padded_UMV_frame_full_half;
			delete[] _padded_UMV_frame_half_half;
			delete[] _padded_left_shift;
			delete[] _padded_upper_shift;
			delete[] _padded_upper_left_shift;
		}
		
		delete[] _left_shift;
		delete[] _upper_shift;
		delete[] _upper_left_shift;
		delete[] _cmi;

		if (_syntax_arithmetic_coding_mode || !_encode_mode) delete sac;

		if(_independent_segment_mode && _advanced_prediction_mode || !_encode_mode) {
			delete [] _ISD_extrapolated_frame;
			delete [] _ISD_extrapolated_frame_half_full;
			delete [] _ISD_extrapolated_frame_full_half;
			delete [] _ISD_extrapolated_frame_half_half;
		}

		if (_reference_picture_selection || !_encode_mode) {
			delete _prev_frames;
			delete _prev_half_full;
			delete _prev_full_half;
			delete _prev_half_half;
			delete[] _trp;
		}
	}
}


#endif

