
#ifndef __D_BLOCK_ZIGZAG_SCAN_C__
#define __D_BLOCK_ZIGZAG_SCAN_C__

#include "D_Block.h"


/*
 * void D_Block::Zigzag_Scan(void)
 * 
 * Re-arrange coefficients into transmission order, according to the zigzag table
 * This is a private method
 *
 * Requires:	Quantize() and Encode_Clip_Non_INTRA_DC() is called before invoking this method
 * Modifies:	_zigzaged_coef
 * Ensures:		_zigzaged_coef[ZIGZAGN_ORDER[i] = _quantized_coef[i]
 *
 * Warning:
 */
void D_Block::Zigzag_Scan(void)
{
	int i;
	const short *ptr_src_i = _quantized_coef;
	
	for (i=0; i<64; i++) 
		_zigzaged_coef[ZIGZAG_ORDER[i]] = *ptr_src_i++;
}


#endif

