

#ifndef __D_BLOCK_INVERSE_DCT_C__
#define __D_BLOCK_INVERSE_DCT_C__

#include "D_Block.h"
#include <math.h>


/*
 * void D_Block::Inverse_DCT(void)
 * 
 * Quantize the DCT coefficents
 * This is a private method
 *
 * Requires:	Decode_Clip_Non_INTRA_DC() is called before invoking this method
 * Modifies:	_data_fast
 * Ensures:		. if intra mode, the DC coefficient is quantized with no dead-zone and step 8 and no deadzone
 *					. if quantized to 0, reset to 1
 *					. if quantized to 128, set to 255
 *					. if quantized to 255, set to 254
 *				. if inter mode, the DC coefficient is treated as AC coefficients
 *				. AC coefficients are quantized with dead-zone and step=2*mquant
 *
 * Warning:
 */
void  D_Block::Inverse_DCT(void)
{
    double y0, y1, y2, y3, z0, z1, z2, z3;
	double tmp0, tmp1;
	double tmp10, tmp11, tmp12, tmp13;
	double *wptr, workspace[64];
	int i;
	short *inptr, *outptr;

	inptr = _dct_coef;
	wptr = workspace;
	
	for (i=0; i<8; i++) {
		tmp0 = inptr[5] + inptr[7];
		tmp1 = inptr[1] + inptr[3];
		
		y0 = tmp0 + tmp1;
		y1 = tmp1 * 1.414213562;						// 1/c[4]
		y2 = inptr[3] + inptr[5];
		y3 = inptr[1] * 1.414213562;					// 1/c[4]
		
		z0 = (y1 - y0) * 1.306562965;					// c[6]
		z2 = (y1 + y0) * 0.541196100;					// c[2]
		z1 = (y3 - y2);
		z3 = (y3 + y2);
		
		tmp10 = (z1 - z0) * 0.899976223;				// c[5] 
		tmp11 = (z3 - z2) * 2.562915448;				// c[7]
		tmp12 = (z1 + z0) * 0.601344887;				// c[3]
		tmp13 = (z3 + z2) * 0.509795579;				// c[1] 
		
		tmp0 = inptr[6] + inptr[2];
		tmp1 = inptr[2] * 1.414213562;					// 1/c[4]
		
		y0 = (tmp1 - tmp0) * 1.306562965;				// c[6]
		y2 = (tmp1 + tmp0) * 0.541196100;				// c[2]
		y1 = inptr[0] - inptr[4];
		y3 = inptr[0] + inptr[4];
		
		z0 = y1 - y0;
		z1 = y3 - y2;
		z2 = y1 + y0; 
		z3 = y3 + y2;
		
		wptr[40] = (z0 - tmp10);
		wptr[16] = (z0 + tmp10);
		wptr[32] = (z1 - tmp11);
		wptr[24] = (z1 + tmp11);
		wptr[48] = (z2 - tmp12);
		wptr[8]  = (z2 + tmp12);
		wptr[56] = (z3 - tmp13);
		wptr[0]  = (z3 + tmp13);
		
		inptr += 8;
		wptr++;
	}
	

	outptr = _data_fast;
	wptr = workspace;
	
	for (i=0; i<8; i++) {
		tmp0 = wptr[5] + wptr[7];
		tmp1 = wptr[1] + wptr[3];
		
		y0 = tmp1 + tmp0;
		y1 = tmp1 * 1.414213562;						// 1/c[4]
		y2 = wptr[3] + wptr[5];
		y3 = wptr[1] * 1.414213562;						// 1/c[4]
		
		z0 = (y1 - y0) * 1.306562965;					// c[6]
		z2 = (y1 + y0) * 0.541196100;					// c[2]
		z1 = (y3 - y2);
		z3 = (y3 + y2);
		
		tmp10 = (z1 - z0) * 0.1124970279;				// c[5]*0.125
		tmp11 = (z3 - z2) * 0.3203644310;				// c[7]*0.125
		tmp12 = (z1 + z0) * 0.0751681109;				// c[3]*0.125
		tmp13 = (z3 + z2) * 0.0637244474;				// c[1]*0.125
		
		tmp0 = wptr[6] + wptr[2];
		tmp1 = wptr[2] * 1.414213562; 
		
		y0 = (tmp1 - tmp0) * 0.163320371;				// c[6]*0.125
		y2 = (tmp1 + tmp0) * 0.067649513;				// c[2]*0.125
		y1 = (wptr[0] - wptr[4]) * 0.125;
		y3 = (wptr[0] + wptr[4]) * 0.125;
		
		z0 = y1 - y0;
		z1 = y3 - y2;
		z2 = y1 + y0;
		z3 = y3 + y2;
		
		tmp0 = z0 - tmp10;
		if (tmp0 < 0.0) outptr[40] = ((short) (tmp0 - 0.5));
		else outptr[40] = ((short) (tmp0 + 0.5));

		tmp1 = z0 + tmp10;
		if (tmp1 < 0.0)	outptr[16] = ((short) (tmp1 - 0.5));
		else outptr[16] = ((short) (tmp1 + 0.5));

		tmp0 = z1 - tmp11;
		if (tmp0 < 0.0) outptr[32] = ((short) (tmp0 - 0.5));
		else outptr[32] = ((short) (tmp0 + 0.5));

		tmp1 = z1 + tmp11;
		if (tmp1 < 0.0)	outptr[24] = ((short) (tmp1 - 0.5));
		else outptr[24] = ((short) (tmp1 + 0.5));

		tmp0 = z2 - tmp12;
		if (tmp0 < 0.0) outptr[48] = ((short) (tmp0 - 0.5));
		else outptr[48] = ((short) (tmp0 + 0.5));

		tmp1 = z2 + tmp12;
		if (tmp1 < 0.0)	outptr[ 8] = ((short) (tmp1 - 0.5));
		else outptr[ 8] = ((short) (tmp1 + 0.5));

		tmp0 = z3 - tmp13;
		if (tmp0 < 0.0) outptr[56] = ((short) (tmp0 - 0.5));
		else outptr[56] = ((short) (tmp0 + 0.5));

		tmp1 = z3 + tmp13;
		if (tmp1 < 0.0)	outptr[ 0] = ((short) (tmp1 - 0.5));
		else outptr[ 0] = ((short) (tmp1 + 0.5));

		wptr += 8;  
		outptr++;
	}

}


#endif

