
#ifndef __D_BLOCK_BLOCK_PATTERN_ANALYZER_C__
#define __D_BLOCK_BLOCK_PATTERN_ANALYZER_C__

#include "D_Block.h"


/*
 * short D_Block::Block_Pattern_Analyzer(void)
 * 
 * Check zigzaged coefficients for a non-intra DC coefficients
 * Return 1 if found a non-zero AC coeffecients, else return 0
 * This is a public method
 *
 * Requires:	Encode_BLK() called for the current block already
 * Modifies:	_last_non_zero_index
 * Ensures:		Set to the index (0 to 63) of last known nonzero AC coeff, else set to -1
 *
 * Warning:		
 */
short D_Block::Block_Pattern_Analyzer(void) 
{
	int i, j;
	const short *ptr_src_i;

	i = 0;
	ptr_src_i = _zigzaged_coef+63;
	_last_non_zero_index = -1;
	
	// this is probably unnecessary, as DC coefficient should(?) not be 0
	if (((*_mtype ==INTRA) || (*_mtype == INTRAQ)) && (!_B_picture)) 
		i = 1;

	for (j=64; j>i; j--) {
		if (*ptr_src_i != 0) { 
			_last_non_zero_index = (j - 1);
			break;
		}
		ptr_src_i--;
	}
	
	if (_last_non_zero_index == -1) return 0;
	else return 1;
}


#endif

