
#ifndef D_BLOCK_H
#define D_BLOCK_H	/*+ To stop multiple inclusions. +*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include "PSC_Fifo.h"
#include "Constants.h"
#include "SAC.h"
#include "SAC_Cumf.h"

const int ZIGZAG_ORDER[64]={
  0,	1,	5,	6,	14,	15,	27,	28,	
  2,	4,	7,	13,	16,	26,	29,	42,	
  3,	8,	12,	17,	25,	30,	41,	43,	
  9,	11,	18,	24,	31,	40,	44,	53,	
  10,	19,	23,	32,	39,	45,	52,	54,	
  20,	22,	33,	38,	46,	51,	55,	60,	
  21,	34,	37,	47,	50,	56,	59,	61,	
  35,	36,	48,	49,	57,	58,	62,	63
};


//class D_Block;


class D_Block {
protected:
	D_Block *_left, *_right;
	D_Block *_top, *_bottom;

	const int *_clock;
	int _group_id, _macroblock_id, _block_id;	// ID tag
	const short **_seg_ID;
	const bool  **_cgi;

	int _MB_per_gob, _GOB_per_frame;
	int _frame_xsize, _frame_ysize;							
	int _ROW_offset;							// row offset: different for U, V blocks
	int _last_non_zero_index;					// last non_zero index in this block

	const short *_mtype;						// upper layer macroblock coding type

	// *** All the data structures use 1D representation
	short *_data_fast;							// mapped to _fast_frame memory region
	short *_zigzaged_coef;						// zigzag scanned coefficients
	short _quantized_coef[64];					// quantized coefficients
	short _dct_coef[64];						// dct coefficients    
	short _row_value[8], _row_predictor[8];		// for AIC, row value/prediction
	short _col_value[8], _col_predictor[8];		// for AIC, col value/prediction

	const unsigned char *_data_1D;				// 1D representation of the original pixels
	const unsigned char *_decoded_coef;			// 1D representation of the decoded pixels

	bool _B_picture;							// Used only in Encoder to identify B picture blocks

	// For Encoder
	void DCT(void);								// DCT:			FAST (residual) coeff to DCT coeff
	void Quantize(const int mquant);			// QUANTIZER:	DCT coeff to QUANTIZED coeff
	void Encode_Clip_Non_INTRA_DC(void);		// Clipping:	Clip QUANTIZED coeff: ~127 to 127
	void Zigzag_Scan(void);						// ZZ SCAN:		QUANTIZED coeff to ZZ coeff

	// For Decoder
	void De_Zigzag_Scan(void);					// DZZ SCANNER: ZZ coeff to QUANTIZED coeff	
	void De_Quantize(const int mquant);			// DEQUANTIZER: QUANTIZED coeff to DCTt coeff
	void Decode_Clip_Non_INTRA_DC(void);		// CLIPPER :	Clip DCT coeff: ~2048 to 2047
	void Inverse_DCT(void);						// IDCT:		DCT coeff to FAST (reconstructed residual) coeff

	// AIC Support
	void D_Block::AIC_Predictor(void);
	const short *const Get_Predictor(const int clock, const short **const seg_ID, 
		const bool need_column, bool *const safe);

public:
	static int _sformat;						// picture type; defined in Constants.h
	static int _PB_offset;

	static bool _encode_mode;
	static bool _inter_frame_mode;				// current frame mode: INTRA (false) vs. INTER (true)
	static bool _PB_frame_mode;
	static bool _slice_mode;

	bool _PB_B_frame;							// Notify that this block is in a B-frame

	D_Block(void);
	~D_Block(void);

	void Reset_Hierarchy(const bool **const cgi, const short **const seg_ID,
		const int *const clock, const int row_ID, const int MB_ID, const int BLK_ID);
	inline void Show_ID(void) {fprintf(stdout, "\n%i %i %i\n", _group_id, _macroblock_id, _block_id); }

	void Init_Structure(const unsigned char *src_c);
	void Fast_Structure(const short *const src_mtype, short *const src_s, short *const zsrc_s);
	void Fast_Decoded_Structure(const unsigned char *const src_c);

	void Encode_BLK(const int mquant, const bool B_picture);
	short Block_Pattern_Analyzer(void);			// Analyse the block to find last non_zero coefficients

	void Entropy_Encoder(PSC_Fifo &bit_ostream);
	void SAC_Encoder(PSC_Fifo &bit_ostream, symbol *sac);
	void Decode_BLK(const int mquant, const bool B_picture);
};


#endif /* D_BLOCK_H */
