
#ifndef __D_BLOCK_C__
#define __D_BLOCK_C__

#include "D_Block.h"


/*
 * D_Block::D_Block(void)
 * 
 * Constructor
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_frame_xsize, _ROW_offset
 * Ensures:		Set according to picture format
 *
 * Warning:		
 */
D_Block::D_Block(void) 
{
	if (_sformat == QCIF) {
		_frame_xsize = QCIFX; 
		_frame_ysize = QCIFY;
		_GOB_per_frame = 9;
		_MB_per_gob    = 11;
	} 
	else if (_sformat == SQCIF) {
		_frame_xsize = SQCIFX; 
		_frame_ysize = SQCIFY;
		_GOB_per_frame = 6;
		_MB_per_gob    = 8;
	}
	
	_ROW_offset = _frame_xsize;
	_PB_B_frame = false;
}


/*
 * D_Block::~D_Block(void)
 * 
 * Destructor, does nothing
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	nothing
 * Ensures:		nothing
 *
 * Warning:		
 */
D_Block::~D_Block(void) 
{
	;
}


#endif

