#ifndef __BITSTREAM_H__
#define __BITSTREAM_H__

#include <iostream.h>
#include <fstream.h>

static const int _buffer_size = 8192; // In bits (Must be a multiple of 8)

class Bitstream {
private:
	bool _mode; // 0 is read, 1 is write
	bool *_buffer;
	bool _eof;	// When EOF is found
	int	_current;	// The bit to be read from or written to
	int	_cache_end; // The bit to deposit read values to or the start bit of the write cache
	int _cached_bits; // Number of bits stored in the cache

	ifstream *_infile;
	ofstream *_outfile;

	void Init();	// Initializes variables
	void FillBuffer();	// Fills the buffer
	void Flush(const bool all);	// Flushes buffer in bytes
public:
	Bitstream(ifstream *fileptr);
	Bitstream(ofstream *fileptr);
	~Bitstream();
	void PeekNBits(bool *bits, const int N);
	void ReadNBits(bool *bits, const int N);
	bool ReadBit();
	void WriteNBits(const bool *bits, const int N);
};

#endif


