
#include "yuv_video.h"
#include "resource.h"
#include <vfw.h>
#include <windowsx.h>
/*#include <ddraw.h>
#include "ddutil.h"
*/
HWND Dialoghwnd;

LPBITMAPINFOHEADER lpbi;
HDRAWDIB gdd;
/*
LPDIRECTDRAW lpDD;
LPDIRECTDRAWSURFACE lpDDSPrimary;
LPDIRECTDRAWSURFACE lpDDSBack;
LPDIRECTDRAWSURFACE lpDDSOne;
LPDIRECTDRAWPALETTE lpDDPal;
BOOL bActive;
*/
unsigned char *pix;
int framenumber;

/*
 * yuv_video::yuv_video(const char *file, const int x, const int y, const bool write)
 * Constructor, when file name, picture format, and mode of operation are known
 * This is a public method
 *
 * Requires:	Valid file name, frame size in X and Y axis, and mode of operation
 * Modifies:	_horiz, _vert, _filename, _initialized, _y, _u, _v, _writing
 * Ensures:		._horiz set to x, _horize set to y
 *				.before calling yuv_video:Init(void)
 *					- set _y, _u, _v, _filename to NULL
 *					- set _writig to -1
 *					- set _initialized to false 
 *				.call yuv_video:Init(void) 
 *
 * Alert:		Should cause program to terminate if given invalid inputs
 */
yuv_video::yuv_video(const char *filename, const int x, const int y, const bool write)
{
  _horiz = x;
  _vert = y;
  Dialoghwnd = NULL;
  _hMovieThread = NULL;
  _y = NULL;
  _u = NULL;
  _v = NULL;
  _writing = (int) write;
//  _filename = (char *) strdup(filename);
  _fp = NULL;
  _initialized = false;
  _first_write = false;

  Init();
}


/*
 * yuv_video::yuv_video(const int x, const int y)
 * Constructor, when only picture format is known
 * This is a public method
 *
 * Requires:	Valid frame size in X and Y axis
 * Modifies:	_horiz, _vert, _filename, _initialized, _y, _u, _v, _writing
 * Ensures:		._horiz set to x, _horize set to y
 *				.before calling yuv_video:Init(void)
 *					- set _y, _u, _v, _filename to NULL
 *					- set _writig to -1
 *					- set _initialized to false 
 *				.call yuv_video:Init(void) 
 *
 * Alert:		Should cause program to terminate if given invalid inputs
 */
yuv_video::yuv_video(const int x, const int y)
{
  _horiz = x;
  _vert = y;
  Dialoghwnd = NULL;
  _hMovieThread = NULL;

//  _filename = NULL;
  _fp = NULL;
  _initialized = false;
  _y = NULL;
  _u = NULL;
  _v = NULL;
  _writing = -1;
  _first_write = false;

  Init();
}


/*
 * yuv_video::yuv_video(void)
 * Constructor, when nothinhg is known
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_horiz, _vert, _filename, _initialized, _y, _u, _v, _writing
 * Ensures:		._horiz set to -1, _horize set to -1
 *				._filename set to NULL
 *				._y, _u, _v set to NULL
 *				._writing set to -1
 *				.call yuv_video:Init(void) 
 *
 */
yuv_video::yuv_video(void)
{
  Dialoghwnd = NULL;
  _hMovieThread = NULL;

	_horiz = -1;
	_vert = -1;
//	_filename = NULL;
	_fp = NULL;
	_initialized = false;
	_y = NULL;
	_u = NULL;
	_v = NULL;
	_writing = -1;
	_first_write = false;
	
	Init();
}


/*
 * yuv_video::yuv_video(void)
 * Constructor, when nothinhg is known
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_horiz, _vert, _filename, _initialized, _y, _u, _v, _writing
 * Ensures:		._horiz set to -1, _horize set to -1
 *				._filename set to NULL
 *				._y, _u, _v set to NULL
 *				._writing set to -1
 *				.call yuv_video:Init(void) 
 *
 */
yuv_video::yuv_video(const yuv_video &y)
{
  Dialoghwnd = NULL;
  _hMovieThread = NULL;
	// Have to copy everything!
	_horiz = y._horiz;
	_vert = y._vert;
	
//	if(y._filename != NULL)
//		_filename = (char *) strdup(y._filename);
//	else
//		_filename = NULL;
	
	_initialized = false;
	_writing = y._writing;
	_first_write = y._first_write;
	
	// Hopefully this will re-read the data.
	Init();
}


/*
 * yuv_video::~yuv_video()
 * Destructor for yuv_video object
 * This is a public method
 *
 * Requires:	A valid object, with _fp opened
 * Modifies:	_fp, _filename, _y, _u, _v, *this
 * Ensures:		. _fp closed
 *				. delete[] _filename, _y, _u, _v
 *				. the object is destroyed
 *
 * Alert:	Check on _writing part of code
 */
yuv_video::~yuv_video()
{
//	if(_writing == 1 && _fp != NULL) 
	DumpFrame(_cur_frame);	// Have we finished the frame?
//	if (_fp != NULL) fclose(_fp); 

	PostMessage(Dialoghwnd, WM_DESTROY, 0, 0);

	delete[] _filename;
	delete[] _y;
	delete[] _u;
	delete[] _v;
}


/*
 * void yuv_video::Init(void)
 * Initialization of data members
 * This is a private method
 * 
 *
 * Requires:	valid _filename
 * Modifies:	_y, _u, _v, _tu, _tv, cur_frame, , _size, _initialized, _fp
 * Ensures:		.DO NOTHING if _horiz, _vert, or _writing is -1
 *				.memory is allocated for _y, _u, _v
 *				. _cur_frame set to 0, _size set to frame size (Y+U+V)
 *				._fp opened in "wb" if _writing, else in "rb"; exit(-1) if cannot open file
 *				.call yuv_video:ReadVideo() if in reading mode
 *				.if no error from ReadVideo, _initialized set to true
 * 
 */
void yuv_video::Init(void)
{
	// Check all data.
	if(_horiz <= 0) return;
	if(_vert <= 0) return;
	if(_writing == -1) return;	// _filename available if _writing is true
	
	// Satisfied with basic data, move on with the rest of task
	_y = new unsigned char[_horiz * _vert];
	_u = new unsigned char[(_horiz / 2) * (_vert / 2)];
	_v = new unsigned char[(_horiz / 2) * (_vert / 2)];
	
	_cur_frame = 0;
	
	// sizeof (single frame) = sizeof (Y frame) + size of (U frame) + size of (V frame)
	_size = (_horiz * _vert) + ((_horiz / 2) * (_vert / 2) * 2);
	
	if(_writing == 1) {
		// Writing
//		if(_filename == NULL) exit(-1);
//		else {
//			if((_fp = fopen(_filename, "wb")) == NULL) {
//				cerr << "Can't open file " << _filename << " for writing!\n";
//				exit(-1);
//			}
//		}
/****/
		if (_hMovieThread == NULL) {
			pix = new unsigned char[176*144*3];
			framenumber = 0;

			_hMovieThread = CreateThread(NULL, 0, 
				MovieProc, (LPVOID) 0, 0, &_dwThreadId);
			if (_hMovieThread == NULL) {
				cerr << "CreateThread couldn't create" << endl;
				exit(-1);
			}

			for (int i = 0; i < 256; i++) {
				YUVtoRGB1641[i] = (float) ((i-16) * 1.1641);
				YUVtoRGB0018[i] = (float) ((i-128) * (-0.0018));
				YUVtoRGB5958[i] = (float) ((i-128) * 1.5958);
				YUVtoRGB3914[i] = (float) ((i-128) * (-0.3914));
				YUVtoRGB8135[i] = (float) ((i-128) * (-0.8135));
				YUVtoRGB0178[i] = (float) ((i-128) * 2.0178);
				YUVtoRGB0012[i] = (float) ((i-128) * (-0.0012));
			}
		}
	} //else {
		// Reading
//		if(_filename == NULL) exit(-1);
//		else {
//			if((_fp = fopen(_filename, "rb")) == NULL) {
//				cerr << "Can't open file " << _filename << " for reading!" << endl;
//				exit(-1);
//			}
//		}
		// Read the initial frame.
//		ReadVideo();
//	}
	_initialized = true;
}


/*
 * void yuv_video::ReadVideo(void)
 * Read a video frame from a binary file
 * Thus is a private method
 * 
 * Requires:	_fp is ready for reading in binary format
 * Modifies:	_y, _u, _v
 * Ensures:		Y frame is read into _y
 *				U frame is read into _u
 *				V frame is read into _v
 *				
 * Alert:		Should throw an exception if an error occurs here
 */
void yuv_video::ReadVideo(void)
{

//	if (_fp == NULL) {
//		cerr << "File pointer is null, unable to read";
//		exit(-1);
//	}
	
	// Read "Y" component, size _horiz*_vert
	fread(_y, sizeof(unsigned char), _vert * _horiz, _fp);
	
	// Read "U" component, size _horiz*_vert/4
	fread(_u, sizeof(unsigned char), (_vert*_horiz>>2), _fp);
	
	// Read "V" component, size _horiz*_vert/4
	fread(_v, sizeof(unsigned char), (_vert*_horiz>>2), _fp);
}



/*
 * void yuv_video::WriteVideo(void)
 * Write a video frame into a binary file
 * Thus is a private method
 * 
 * Requires:	_fp is ready for writing in binary format
 * Modifies:	nothing (except _fp)
 * Ensures:		_y is written to _fp
 *				_u is written to _fp
 *				_v is written to _fp
 *				
 * Alert:		Should throw an exception if an error occurs here
 */
void yuv_video::WriteVideo(void)
{
	if (_first_write) {
		// First, the "y" component
		fwrite(_y, sizeof(unsigned char), _vert * _horiz, _fp);
		// Next, the "u" component
		fwrite(_u, sizeof(unsigned char), (_vert / 2) * (_horiz / 2), _fp);
		// And finally, the "v" component
		fwrite(_v, sizeof(unsigned char), (_vert / 2) * (_horiz / 2), _fp);
	}
}


/*
 * void yuv_video::FetchFrame(const int frame_index)
 * Fetch a frame from the file stream
 * This is a private method
 *
 * Requires:	_fp is ready for reading in binary mode
 *				file pointer is at the beginning of next frame, instead of _cur_frame
 *				frame_index indicating the desired frame in pictures
 * Modifies:	_y, _u, _v, _cur_frame, _fp (location of the file pointer)
 * Ensures:		_y, _u, _v, respectively set to the Y, U, V "frame" of the desired frame in the picture
 *				_fp is set to the beginning of the (frame_index+1)-th frame
 *				_cur_frame set to _frame_index
 *				
 * Alert:		Unroll the necessary loops and reduce the method call frequencies
 */
void yuv_video::FetchFrame(const int frame_index)
{
	if(_cur_frame < frame_index) {
		while(_cur_frame != frame_index) {
			ReadVideo();
			_cur_frame++;
		}
	} else {
		// FP is at the head of (_cur_frame+1)-th frame, 
		// as its contents are stored in this object
		while(_cur_frame != frame_index ) {
			fseek(_fp, -2*_size, SEEK_CUR);
			_cur_frame--;
			ReadVideo();	// This will move fp ahead by 1 frame
		}
	}
}


/*
 * void yuv_video::DumpFrame(const int frame_index)
 * The purpose is to adjust the file pointer to (n+1)th frame as
 *		we move the _cur_frame to the nth frame
 * This is a private method
 *
 * Requires:	_fp is ready for writing in binary mode
 *				file pointer is at the beginning of next frame, instead of _cur_frame
 *				frame_index indicating the desired frame in pictures
 * Modifies:	_cur_frame, _fp (location of the file pointer)
 * Ensures:		.if _fp is NULL, exit(-1)
 *				.if _cur_frame is too small, call WriteVideo() then _cur_frame++
 *				.otherwise, call fseek then _cur_frame--, continue until done
 *
 * Note:		_fp is set to the beginning of the (frame_index+1)th frame*				
 * Alert:		This is probably never called
 */
void yuv_video::DumpFrame(const int frame_index)
{
	unsigned char* ptry = _y;
	unsigned char* ptru = _u;
	unsigned char* ptrv = _v;
	unsigned char Y, U, V;
	int rr, gg, bb;
	unsigned char* ptrpix = pix+143*176*3;
	float Ylookup;
	bool movex = false, movey = true;

	for (int y=0;y<144;y++) {
		for (int x = 0; x < 176; x++) {
			Y = *ptry++;
			U = *ptru;
			V = *ptrv;
			Ylookup = YUVtoRGB1641[Y];
			rr = (int)(Ylookup + YUVtoRGB0018[U] + YUVtoRGB5958[V]);
			if (rr<0) rr = 0; else if (rr > 255) rr = 255;
			gg = (int)(Ylookup + YUVtoRGB3914[U] + YUVtoRGB8135[V]);
			if (gg<0) gg = 0; else if (gg > 255) gg = 255;
			bb = (int)(Ylookup + YUVtoRGB0178[U] + YUVtoRGB0012[V]);
			if (bb<0) bb = 0; else if (bb > 255) bb = 255;
			*ptrpix++ = (unsigned char) bb;
			*ptrpix++ = (unsigned char) gg;
			*ptrpix++ = (unsigned char) rr;
			if (movex) { ptru++; ptrv++; }
			movex = !movex;
		}
		if (movey) { ptru-=88; ptrv-=88; }
		movey = !movey;
		ptrpix -= 176*3*2;
	}
	framenumber = _cur_frame++;
	PostMessage(Dialoghwnd, WM_PAINT, 0, 0);
	// DrawFrame(Dialoghwnd);
/****/
//	if (_fp == NULL) {
//		cerr << "Dumping Frame, but file pointer is empty\n";
//		exit(-1);
//	}

//	if(_cur_frame < frame_index) {
//		while(_cur_frame != frame_index) {	// this loop does not make sense
//			WriteVideo();
//			_cur_frame++;
//		}
//	} else {
//		WriteVideo();	// Dump to the file. The dumped data is ignored, overwritten.....
//		fseek(_fp, -_size, SEEK_CUR);
//		while(_cur_frame != frame_index) {	// only after _fp?
//			fseek(_fp, -_size, SEEK_CUR);
//			_cur_frame--;
//		}
//	}

}


/*
 * unsigned char *yuv_video::Get_Y(const int frame_index)
 * Return the "Y" component.
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 * Modifies:	nothing
 * Ensures:		if _cur_frame != frame_index, call FetchFrame(frame_index)
 *				return _y
 *
 */
unsigned char *yuv_video::Get_Y(const int frame_index)
{
	if(!_initialized) {
		cerr << "Can't get frame from unitialized video!\n";
		exit(-1);
	}

	if (_cur_frame != frame_index) FetchFrame(frame_index);

	return _y;
}


/*
 * unsigned char *yuv_video::Get_Y(const int frame_index, const int x, const int y)
 * Return the "Y" component, at (x, y) position
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 * Modifies:	nothing
 * Ensures:		call Get_Y(frame_index)
 *				if x or y invalid, cerr and terminate
 *				return _y[x + y*_horiz]
 *
 * Warning:		This method is currently not used
 */
unsigned char yuv_video::Get_Y(const int frame_index, const int x, const int y)
{
	Get_Y(frame_index);
	
	if(x > _horiz || x < 0) {
		cerr << "Out of bound: x=" << x << "is not between 0 and " << _horiz << endl;
		exit(-1);
	}
	
	if(y > _vert || y < 0) {
		cerr << "Out of bound: y=" << y << "is not between 0 and " << _vert << endl;
		cerr << "Can't read y = " << x << endl;
		exit(-1);
	}
	
	return _y[x + y * _horiz];
}


/*
 * unsigned char *yuv_video::Get_U(const int frame_index)
 * Return the "U" component.
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 * Modifies:	nothing
 * Ensures:		if _cur_frame != frame_index, call FetchFrame(frame_index)
 *				return _u
 *
 */
unsigned char *yuv_video::Get_U(const int frame_index)
{
	if(!_initialized) {
		cerr << "Can't get frame from unitialized video!\n";
		exit(-1);
	}

	if (_cur_frame != frame_index) FetchFrame(frame_index);
	
	return _u;
}


/*
 * unsigned char *yuv_video::Get_U(const int frame_index, const int x, const int y)
 * Return the "U" component, at (x, y) position
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 * Modifies:	nothing
 * Ensures:		call Get_U(frame_index)
 *				if x or y invalid, cerr and terminate
 *				*note* bounds for x and y is 1/2 of _horiz and _vert respectively
 *				return _u[x + y*_horiz/2]
 *
 * Warning:		This method is currently not used
 */
unsigned char yuv_video::Get_U(const int frame_index, const int x, const int y)
{
	Get_U(frame_index);
	
	if(x > (_horiz>>1) || x < 0) {
		cerr << "Out of bound: x=" << x << "is not between 0 and " << (_horiz>>1) << endl;
		exit(-1);
	}
	
	if(y > (_vert>>1) || y < 0) {
		cerr << "Out of bound: y=" << y << "is not between 0 and  "<< (_vert>>1) << endl;
		cerr << "Can't read y = " << x << endl;
		exit(-1);
	}
	
	return _u[x + ((y * _horiz) >> 1)];
}


/*
 * unsigned char *yuv_video::Get_V(const int frame_index)
 * Return the "V" component.
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 * Modifies:	nothing
 * Ensures:		if _cur_frame != frame_index, call FetchFrame(frame_index)
 *				return _v
 *
 */
unsigned char *yuv_video::Get_V(const int frame_index)
{
	if(!_initialized) {
		cerr << "Can't get frame from unitialized video!\n";
		exit(-1);
	}

	if (_cur_frame != frame_index) FetchFrame(frame_index);
	
	return _v;
}



/*
 * unsigned char *yuv_video::Get_V(const int frame_index, const int x, const int y)
 * Return the "V" component, at (x, y) position
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 * Modifies:	nothing
 * Ensures:		call Get_V(frame_index)
 *				if x or y invalid, cerr and terminate
 *				*note* bounds for x and y is 1/2 of _horiz and _vert respectively
 *				return _v[x + y*_horiz]
 *
 * Warning:		This method is currently not used
 */
unsigned char yuv_video::Get_V(const int frame_index, const int x, const int y)
{
	Get_V(frame_index);
	
	if(x > (_horiz>>1) || x < 0) {
		cerr << "Out of bound: x=" << x << "is not between 0 and " << (_horiz>>1) << endl;
		exit(-1);
	}
	
	if(y > (_vert>>1) || y < 0) {
		cerr << "Out of bound: y=" << y << "is not between 0 and " << (_vert>>1) << endl;
		exit(-1);
	}
	
	return _v[x + ((y * _horiz) >> 1)];
}


/*
 * void yuv_video::Put_Y(const int frame_index, const int x, const int y, const unsigned char val)
 * Write a value to (x,y) in _y in this object
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 *				valid x, y
 * Modifies:	_y
 * Ensures:		_y[x+y*_horiz] = val
 *
 */
void yuv_video::Put_Y(const int frame_index, const int x, const int y, const unsigned char val)
{
	if (_cur_frame != frame_index) DumpFrame(frame_index);
	
	if(!_initialized) {
		cerr << "Can't put frame to unitialized video!\n";
		exit(-1);
	}
	
	if(x > _horiz || x < 0) {
		cerr << "Out of bound: x=" << x << "is not between 0 and " << _horiz << endl;
		exit(-1);
	}
	
	if(y > _vert || y < 0) {
		cerr << "Out of bound: y=" << y << "is not between 0 and " << _vert << endl;
		exit(-1);
	}

	_y[x + y * _horiz] = val;
}


/*
 * void yuv_video::Put_U(const int frame_index, const int x, const int y, const unsigned char val)
 * Write a value to (x,y) in _u in this object
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 *				valid x, y
 * Modifies:	_u
 * Ensures:		_u[x+y*_horiz/2] = val
 *
 */
void yuv_video::Put_U(const int frame_index, const int x, const int y, const unsigned char val)
{
	if (_cur_frame != frame_index) DumpFrame(frame_index);
	
	if(!_initialized) {
		cerr << "Can't put frame to unitialized video!" << endl;
		exit(-1);
	}
	
	if(x > (_horiz>>1) || x < 0) {
		cerr << "Out of bound: x=" << x << "is not between 0 and " << (_horiz>>1) << endl;
		exit(-1);
	}
	
	if(y > (_vert>>1) || y < 0) {
		cerr << "Out of bound: y=" << y << "is not between 0 and " << (_vert>>1) << endl;
		exit(-1);
	}

    
	_u[x + ((y * _horiz) >> 1)] = val;
}


/*
 * void yuv_video::Put_V(const int frame_index, const int x, const int y, const unsigned char val)
 * Write a value to (x,y) in _v in this object
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 *				valid x, y
 * Modifies:	_v
 * Ensures:		_v[x+y*_horiz/2] = val
 *
 */
void yuv_video::Put_V(const int frame_index, const int x, const int y, const unsigned char val)
{
	if (_cur_frame != frame_index) DumpFrame(frame_index);
	
	if(!_initialized) {
		cerr << "Can't put frame to unitialized video!" << endl;
		exit(-1);
	}
	
	if(x > (_horiz>>1) || x < 0) {
		cerr << "Out of bound: x=" << x << "is not between 0 and " << (_horiz>>1) << endl;
		exit(-1);
	}
	
	if(y > (_vert>>1) || y < 0) {
		cerr << "Out of bound: y=" << y << "is not between 0 and " << (_vert>>1) << endl;
		exit(-1);
	}
    
	_v[x + ((y * _horiz) >> 1)] = val;
}


/*
 * void yuv_video::Set_Y(const int frame_index, const unsigned char *y)
 * copy contents of y to _y
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 * Modifies:	_y
 * Ensures:		memcpy contents y to _y
 *
 */
void yuv_video::Set_Y(const int frame_index, const unsigned char *y)
{
	if(!_initialized) {
		cerr << "Can't put frame to unitialized video!" << endl;
		exit(-1);
	}

	_first_write = true;
	if (_cur_frame != frame_index) DumpFrame(frame_index);
	memcpy(_y, y, sizeof(unsigned char) * _horiz * _vert);
}  


/*
 * void yuv_video::Set_V(const int frame_index, const unsigned char *u)
 * copy contents of u to _u
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 * Modifies:	_u
 * Ensures:		memcpy contents of u to _u
 *
 */
void yuv_video::Set_U(const int frame_index, const unsigned char *u)
{
	if(!_initialized) {
		cerr << "Can't put frame to unitialized video!" << endl;
		exit(-1);
	}

	_first_write = true;
	if (_cur_frame != frame_index) DumpFrame(frame_index);	
	memcpy(_u, u, (sizeof(unsigned char) * _horiz * _vert) >> 2 );
}  


/*
 * void yuv_video::Set_V(const int frame_index, const unsigned char *v)
 * copy contents of v to _v
 * This is a public method
 *
 * Requires:	frame_index not out of bound, ie. smalller than 0 or bigger than the picture's total frames
 * Modifies:	_v
 * Ensures:		memcpy contents of v to _v
 *
 */
void yuv_video::Set_V(const int frame_index, const unsigned char *v)
{
	if(!_initialized) {
		cerr << "Can't put frame to unitialized video!" << endl;
		exit(-1);
	}

	_first_write = true;
	if (_cur_frame != frame_index) DumpFrame(frame_index);
	memcpy(_v, v, sizeof(unsigned char) * _horiz / 2 * _vert / 2);
}  


/*
 * void yuv_video::SetFile(const char *filename, const bool writing)
 * Set the filename as well as mode of operation
 * This is a public method
 *
 * Requires:	filename is the name of the file and not NULL
 *				writing is mode of operation, reading or writing
 * Modifies:	_filename, _writing
 * Ensures:		.if _filename is NULL, exit(-1)
 *				._filename set to filename
 *				._writing set to writing
 *				.call Init()
 *
 */
void yuv_video::SetFile(const char *filename, const bool writing)
{
	if(filename == NULL) exit(-1);	// illegal usage
	else _filename = strdup(filename);
	_writing = (int) writing;

	Init();
}


/*
 * void yuv_video::SetXY(const int x, const int y)
 * Set dimension of a frame
 * This is a public method
 *
 * Requires:	x and y dimension of a frame
 * Modifies:	_horitz, _vert
 * Ensures:		._horiz set to x, _vert set to y
 *				.call Init()
 *
 * Alert:		this method is not being used
 */
void yuv_video::SetXY(const int x, const int y)
{
	_horiz = x;
	_vert = y;
	
	Init();
}

void DrawFrame(HWND hwnd) {
    char szframe[256];

	PAINTSTRUCT  ps ;
	HDC dc;
	dc = BeginPaint(hwnd, &ps);

	sprintf(szframe, "Frame #%d\0", framenumber);

	DrawDibDraw(gdd,dc,5,5,176,144,lpbi, pix, 0, 0, 176, 144, 0);
	RECT rcDirty;
	rcDirty.left = 5;
	rcDirty.top = 5;
	rcDirty.right = 5+176;
	rcDirty.bottom = 5+144;

	InvalidateRect(hwnd,&rcDirty,FALSE);
	EndPaint(Dialoghwnd, &ps);

	SetDlgItemText(hwnd, IDC_FRAME, szframe);
	UpdateWindow(hwnd);
/*	static int phase = 0;
	LPDIRECTDRAWSURFACE pdds;

	RECT rcRect;
	rcRect.left = 5;
	rcRect.top = 5;
	rcRect.right = 5+176;
	rcRect.bottom = 5+144;
	if (phase) {
		lpDDSTwo = DD
		pdds = lpDDSTwo;
		phase = 0;
	}
	else {
		pdds = lpDDSOne;
		phase = 1;
	}
*/
}

BOOL CALLBACK FrameProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
/*		HRESULT ddrval;
		DDSURFACEDESC ddsd;
		DDSCAPS ddscaps;
*/
		lpbi = (LPBITMAPINFOHEADER)calloc(40,1);
		lpbi->biSize			= 40;
		lpbi->biWidth			= 176;
		lpbi->biHeight			= 144;
		lpbi->biPlanes			= 1;
		lpbi->biBitCount		= 24;
		lpbi->biCompression		= 0;
		lpbi->biSizeImage		= 176*144*3;
		lpbi->biXPelsPerMeter	= 0;
		lpbi->biYPelsPerMeter	= 0;
		lpbi->biClrUsed			= 0;
		lpbi->biClrImportant	= 0;
		gdd = DrawDibOpen();

		ShowWindow(hwnd, SW_SHOWNORMAL);
		UpdateWindow(hwnd);

/*		ddrval = DirectDrawCreate( NULL, &lpDD, NULL );
		if (ddrval != DD_OK) {
			cout << "Can't create DirectDraw object" << endl;
			exit(-1);
		}
		ddsd.dwSize = sizeof( ddsd );
		ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
		ddsd.dwBackBufferCount = 1;
		ddrval = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULl );
		if (ddrval != DD_OK) {
			cout << "Can't create DirectDraw Surface" << endl;
			exit(-1);
		}

		ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
		ddrval = lpDDSPrimary->GetAttachedSurface(&ddscaps, &lpDDSBack);
		if (ddrval != DD_OK) {
			cout << "Can't Attach BackBuffer" << endl;
			exit(-1);
		}

		ddsd.dwFalgs = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		ddsd.dwHeight = 144;
		ddsd.dwWidth = 176;
		ddrval = lpDD->CreateSurface(&ddsd, &lpDDSOne, NULL);
		if (ddrval != DD_OK) {
			cout << "Can't Create DDSOne Surface" << endl;
			exit(-1);
		}

		ddrval = lpDD->CreateSurface(&ddsd, &lpDDSTwo, NULL );
		if (ddrval != DD_OK) {
			cout << "Can't Create DDSTwo Surface" << endl;
			exit(-1);
		}

		PALETTEENTRY ape[256];
		for (i=0; i<256; i++)
		{
			ape[i].peRed   = (BYTE)(((i >> 5) & 0x07) * 255 / 7);
			ape[i].peGreen = (BYTE)(((i >> 2) & 0x07) * 255 / 7);
			ape[i].peBlue  = (BYTE)(((i >> 0) & 0x03) * 255 / 3);
			ape[i].peFlags = (BYTE)0;
		}

		lpDD->CreatePalette(DDPCAPS_8BIT, ape, &lpDDPal, NULL);
		if (lpDDPal)
			lpDDSPrimary->SetPalette( lpDDPal );
*/
		Dialoghwnd = hwnd;
		break;
	case WM_PAINT:
		DrawFrame(hwnd);
		break;
	case WM_DESTROY:
		cout << "Window Destroyed" << endl;
		DrawDibClose(gdd);
		EndDialog(hwnd, TRUE);
		break;
	}
	return FALSE;
}

DWORD WINAPI MovieProc(LPVOID lpV) {
	DialogBox(NULL, MAKEINTRESOURCE(IDD_MOVIE), NULL, FrameProc);
	return 0;
}
