
#ifndef __SAC_DECODER_C__
#define __SAC_DECODER_C__

#include "SAC.h"
#include "SAC_Cumf.h"

void symbol::decode(int cumul_freq[], short & index, PSC_Fifo &input)
{
	length = high - low + 1;
	cum = (-1 + (code_value - low + 1) * cumul_freq[0]) / length;
	for (index = 1; cumul_freq[index] > cum; index++);
	high = low - 1 + (length * cumul_freq[index-1]) / cumul_freq[0];
	low += (length * cumul_freq[index]) / cumul_freq[0];
	for ( ; ; ) {  
		if (high < q2);
		else if (low >= q2) {
			code_value -= q2;
			low -= q2;
			high -= q2;
		}
		else if (low >= q1 && high < q3) {
			code_value -= q1;
			low -= q1;
			high -= q1;
		}
		else break;
		low *= 2;
		high = 2 * high + 1;
		bit = input.ReadBit();
		code_value = 2 * code_value + bit;
	}
	index -= 1;
};

void symbol::decoder_reset(PSC_Fifo &input)
{
	code_value = 0;
	low = 0;
	high = top;
	for (int x = 1;   x <= 16; x++) {
		bit = input.ReadBit();
		code_value = 2 * code_value + bit;
	}
};

#endif