#ifndef __PSC_FIFO_H__
#define __PSC_FIFO_H__

#include <iostream.h>
#include "Bitstream.h"

static const int _fifo_size = 511;

class PSC_Fifo {
private:
	bool _mode; // 0 is read, 1 is write
	bool *_buffer;
	bool _SAC_mode; // notifies when bitstream is SAC

	int _zerorun; // Tracks the number of zeros passed
	bool _found_header;

	Bitstream *_bitstream; // Where the bits come from

public:
	PSC_Fifo(ifstream *fileptr);
	PSC_Fifo(ofstream *fileptr);
	~PSC_Fifo();

	void Enable_SAC_Zero_Run();
	void Disable_SAC_Zero_Run();
	void PeekNBits(bool *bits, const int N);
	void ReadNBits(bool *bits, const int N);
	bool ReadBit();
	void WriteNBits(const bool *bits, const int N);
	bool FoundHeader(void);
	int  GetZeroRun(void);
	void ResetFifo(void);
};

#endif