#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "PSC_Fifo.h"
#include "Constants.h"
#include "D_Frame.h"
#include "yuv_video.h"
#include "Serialdecoder.h"

char* blurb = "CMU H.263 Decoder v4.0\n\r";

int D_Frame::_sformat;
int D_Frame::_pskipped;

extern HWND          ghWndTTY;

DWORD WINAPI H263_Decoder(LPVOID lpV) {
	char output[150];
	DWORD errornum = 0;

	OutputABufferToWindow(ghWndTTY, blurb, strlen(blurb));

	char *outfilename;
	ifstream ifp_bitstream;
	D_Frame *Codec;

	// Set up bitstream read
/*	ifp_bitstream.open("test.bits", ios::in | ios::nocreate | ios::binary);
	if (!ifp_bitstream.is_open()) {
		sprintf(output, "No such file: test.bits\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		return 1;
	}
	*/
	PSC_Fifo infile(&ifp_bitstream);

	// Start up decoder
	Codec = new D_Frame();
	// To ensure all data structures are available
	
	// Set up video
	// Create output file name first
	outfilename = new char[strlen((char *)lpV)+1];
	strcpy(outfilename, (char *)lpV);

	sprintf(output, "Input Bitstream: test.bits\n\r");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));
	sprintf(output, "Output YUV file: %s\n\r", outfilename);
	OutputABufferToWindow(ghWndTTY, output, strlen(output));

	Codec->_ed_outfilename = outfilename;
	Codec->Initialize_Entropy_Decoder();
	// Set Modes off
	Codec->Disable_AIC_Mode();
	Codec->Disable_AIV_Mode();
	Codec->Disable_AP_Mode();
	Codec->Disable_DF_Mode();
	Codec->Disable_ES_Mode();
	Codec->Disable_FEC_Mode();
	Codec->Disable_ISD_Mode();
	Codec->Disable_ME();
	Codec->Disable_PB_Mode();
	Codec->Disable_RPS_Mode();
	Codec->Disable_SAC_Mode();
	Codec->Disable_SLICE_Mode();
	Codec->Disable_UMV_Mode();
	if (!Codec->Decode_Bit(infile)) {
		sprintf(output, "Error decoding picture\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		errornum = 1;
	}
	else {
		sprintf(output, "Finished Decoding\n\r");
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
		switch (D_Frame::_sformat) {
		case (SQCIF):
			sprintf(output, "SQCIF bitstream\n\r");
			break;
		case (QCIF):
			sprintf(output, "QCIF bitstream\n\r");
			break;
		case (CIF):
			sprintf(output, "CIF bitstream\n\r");
			break;
		case (CIF4):
			sprintf(output, "4CIF bitstream\n\r");
			break;
		case (CIF16):
			sprintf(output, "16CIF bitstream\n\r");
			break;
		default:
			sprintf(output, "Invalid format bitstream\n\r");
			errornum = 1;
		}
		OutputABufferToWindow(ghWndTTY, output, strlen(output));
	}
		
	// Close up everything
	Codec->Destroy_Entropy_Decoder();
	// To ensure everything will be deleted when deleting Codec
	delete Codec;

	if (ifp_bitstream.is_open()) ifp_bitstream.close();
	sprintf(output, "Decoder is finished\n\r");
	OutputABufferToWindow(ghWndTTY, output, strlen(output));

	return errornum;
}

