
#ifndef D_SLICE_H
#define D_SLICE_H		/*+ To stop multiple inclusions. +*/

#include "PSC_Fifo.h"
#include "Constants.h"
#include "D_Macroblock.h"


class D_Slice {
protected:
	D_Macroblock *_MB_list;

	short _slice_ID;							// ID tag; also doubles as segment ID
	const short *_mba;							// Macroblock Address of 1st Macroblock in this Slice
	const short *_MB_this_slice;				// set dynamically by upper layer object
	const short *_squant;						// slice quant
	const int *_trp;							// Temporal Reference Predictor
	const int *_fr_num;							// Pointer to Frame's _fr_num



public:
	static bool _encode_mode;

	static int _sformat;						// picture type; defined in Constants.h
	static int _PB_offset;

	static bool _advanced_prediction_mode;
	static bool _coded_mvd_flag;
	static bool _independent_segment_mode;
	static bool _inter_frame_mode;				// current frame mode: INTRA (false) vs. INTER (true)
	static bool _PB_frame_mode;
	static bool _PB_Ppicture_flag;
	static bool _syntax_arithmetic_coding_mode;
	static bool _reference_picture_selection;
	static bool _advanced_intra_coding_mode;

	static bool _rectangular_submode;
	static bool _arbitrary_order_submode;

	D_Slice(void);
	~D_Slice(void);

	void Create_Data_Structure(D_Macroblock *src_head);
	void Fast_Slice_Structure(const short slice_ID, const short *src_mba, 
		const short *src_width, const short* src_mquant);

	void Encode_Slice(void);
	void Encode_Slice(bool P_picture);

	void Entropy_Encoder(PSC_Fifo &bit_ostream, bool first_sent);
	void SAC_Encoder(PSC_Fifo &bit_ostream, symbol *, bool plusptype, bool first_sent);
	
	void Decode_Slice(void);
	void Decode_Slice(bool P_picture);

	void Fast_RPS_Structure(const int *const src_trp, const int *const src_fr_num);
};


#endif


