
#ifndef __D_MACROBLOCK_INIT_C__
#define __D_MACROBLOCK_INIT_C__

#include "D_Macroblock.h"


/*
 * void D_Macroblock::Reset_Hierarchy(const int row_ID, const int MB_ID,
 *			D_Block *const src_heada, D_Block *const src_headb)
 * 
 * Reset the hierarchy info for this MB in the Video tree
 * This is a public method
 *
 * Requires:	row_ID, MB_ID,
 *				src_heada and src_headb, each begins a list of 6 pointers
 * Modifies:	_BLK_list, _BLK_list_PB
 * Ensures:		initializes hierarchy of the current D_Macroblock
 *				_BLK_list points to an array of 6 D_Block associated with this MB
 *				_BLK_list_PB is also initialized if in PB_frame mode or in decode_mode
 *
 * Warning:		
 */
void D_Macroblock::Reset_Hierarchy(const int row_ID, const int MB_ID,
		D_Block *const src_heada, D_Block *const src_headb)
{
	D_Block *ptr_BLKa, *ptr_BLKb;
	int i, j;

	_clock = 0;
	_group_id = row_ID;
	_macroblock_id = MB_ID;
	_BLK_list = src_heada;
	_BLK_list_PB = src_headb;

	// Reset Block-Level Hierarchy
	ptr_BLKa = _BLK_list;
	ptr_BLKb = _BLK_list + 2;
	for (i=0, j=1; i<2; i++, j++) {
		ptr_BLKa++->Reset_Hierarchy(&_cgi, &_seg_ID, &_clock, row_ID, MB_ID, j);
		ptr_BLKb++->Reset_Hierarchy(&_cgi, &_seg_ID, &_clock, row_ID, MB_ID, j+2);
	}
	ptr_BLKb++->Reset_Hierarchy(&_cgi, &_seg_ID, &_clock, row_ID, MB_ID, 5);
	ptr_BLKb->Reset_Hierarchy(&_cgi, &_seg_ID, &_clock, row_ID, MB_ID, 6);

	if (_PB_frame_mode || !_encode_mode) {
		ptr_BLKa = _BLK_list_PB;
		ptr_BLKb = _BLK_list_PB + 2;
		for (i=0, j=1; i<2; i++, j++) {
			ptr_BLKa++->Reset_Hierarchy(&_cgi, &_seg_ID, &_clock, row_ID, MB_ID, j);
			ptr_BLKb++->Reset_Hierarchy(&_cgi, &_seg_ID, &_clock, row_ID, MB_ID, j+2);
		}
		ptr_BLKb++->Reset_Hierarchy(&_cgi, &_seg_ID, &_clock, row_ID, MB_ID, 5);
		ptr_BLKb->Reset_Hierarchy(&_cgi, &_seg_ID, &_clock, row_ID, MB_ID, 6);
	}

}


/*
 * void D_Macroblock::Init_Structure(const unsigned char *const src_Y_c, 
 *									const unsigned char *const src_U_c,
 *									const unsigned char *const src_V_c) 
 * 
 * Initialize basic data structure
 * This is a public method
 *
 * Requires:	none
 * Modifies:	none
 * Ensures:		cycle through D_Block::Init_Structure() for blocks in _BLK_list and _BLK_list_PB
 *
 * Warning:		
 */
void D_Macroblock::Init_Structure(const unsigned char *const src_Y_c,
		const unsigned char *const src_U_c, const unsigned char *const src_V_c)
{
	D_Block *ptr_BLKa, *ptr_BLKb;
	int i, j;
	const unsigned char *y_this_BLKa, *y_this_BLKb;
	const unsigned char *u_this_BLK;
	const unsigned char *v_this_BLK;

	y_this_BLKa = src_Y_c;
	y_this_BLKb = src_Y_c + 128;
	u_this_BLK  = src_U_c;
	v_this_BLK  = src_V_c;
	
	ptr_BLKa = _BLK_list;
	ptr_BLKb = _BLK_list + 2;
	for (i=0, j=0; i<2; i++, j++) {
		ptr_BLKa++->Init_Structure(y_this_BLKa);
		ptr_BLKb++->Init_Structure(y_this_BLKb);
		y_this_BLKa += _BLK_Y_offset;
		y_this_BLKb += _BLK_Y_offset;
	}
	ptr_BLKb++->Init_Structure(u_this_BLK);
	ptr_BLKb->Init_Structure(v_this_BLK);

	if (_PB_frame_mode || !_encode_mode) {
		ptr_BLKa = _BLK_list_PB;
		ptr_BLKb = _BLK_list_PB + 2;
		for (i=0, j=0; i<2; i++, j++) {
			ptr_BLKa++->Init_Structure(y_this_BLKa);
			ptr_BLKb++->Init_Structure(y_this_BLKb);
			y_this_BLKa += _BLK_Y_offset;
			y_this_BLKb += _BLK_Y_offset;
		}
		ptr_BLKb++->Init_Structure(u_this_BLK);
		ptr_BLKb->Init_Structure(v_this_BLK);
	}
}


/*
 * void D_Macroblock::Fast_Structure(short *const src_Y_c, short *const src_U_c,
 *									short *const src_V_c, short *const zsrc_Y_s,
 *									short *const zsrc_U_s, short *const zsrc_V_s, 
 *									const bool *const src_cgi, bool *const src_cmi, 
 *									const bool *const src_flag_zero_mv, short *const src_mcbpc, 
 *									short *const src_mcbpy, const short *const src_mtype, 
 *									const short *const src_mquant, const short *const src_mv_type0,
 *									const short *const src_mv_x0, const short *const src_mv_y0)
 * 
 * Initialize fast data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_cgi, _cmi, _flag_zero_mv, _mcbpc, _mcbpy, _BLK_list
 *				_mtype, _mquant, _mv_type0, _mv_x0, _mv_y0
 * Ensures:		. Set above listed pointers
 *				. call D_Block::Fast_Structure() of 6 blocks in this macroblock, held by _BLK_list
 *
 * Warning:		
 */
void D_Macroblock::Fast_Structure(short *const src_Y_c, short *const src_U_c,
							 short *const src_V_c, short *const zsrc_Y_s,
							 short *const zsrc_U_s, short *const zsrc_V_s, 
							 const bool *const src_cgi, bool *const src_cmi, 
							 const bool *const src_flag_zero_mv, short *const src_mcbpc, 
							 short *const src_mcbpy, const short *const src_mtype, 
							 const short *const src_mquant, const short *const src_mv_type0,
							 const short *const src_mv_x0, const short *const src_mv_y0)
{
	D_Block *ptr_BLKa, *ptr_BLKb;
	int i;
	short *y_this_BLKa, *y_this_BLKb;
	short *u_this_BLK;
	short *v_this_BLK;
	short *zigzag_y_this_BLKa, *zigzag_y_this_BLKb;
	short *zigzag_u_this_BLK;
	short *zigzag_v_this_BLK;

	// Enable fast access to optimized data structures
	y_this_BLKa = src_Y_c;
	y_this_BLKb = src_Y_c + 128;
	u_this_BLK = src_U_c;
	v_this_BLK = src_V_c;

	zigzag_y_this_BLKa = zsrc_Y_s;
	zigzag_y_this_BLKb = zsrc_Y_s + 128;
	zigzag_u_this_BLK = zsrc_U_s;
	zigzag_v_this_BLK = zsrc_V_s;

	
	// Enable access to Mode Decision Data, memory-allocated at frame level
	_cgi = src_cgi;
	_cmi = src_cmi;
	_flag_zero_mv = src_flag_zero_mv;
	_mcbpc = src_mcbpc;
	_mcbpy = src_mcbpy;	

	// Enable access to header data, memory-allocated at frame level
	// Final Destination for the next 5 set of pointers
	_mtype = src_mtype;
	_mquant = src_mquant;
	_mv_type1 = src_mv_type0;
	_mv_x1 = src_mv_x0;
	_mv_y1 = src_mv_y0;
	
	ptr_BLKa = _BLK_list;
	ptr_BLKb = _BLK_list + 2;
	for (i=0; i<2; i++) {
		ptr_BLKa->Fast_Structure(src_mtype, y_this_BLKa, zigzag_y_this_BLKa);
		ptr_BLKb->Fast_Structure(src_mtype, y_this_BLKb, zigzag_y_this_BLKb);
		ptr_BLKa++;
		ptr_BLKb++;
		zigzag_y_this_BLKa += 64;
		zigzag_y_this_BLKb += 64;
		y_this_BLKa += 64;
		y_this_BLKb += 64;
	}
	ptr_BLKb++->Fast_Structure(src_mtype, u_this_BLK, zigzag_u_this_BLK);
	ptr_BLKb->Fast_Structure(src_mtype, v_this_BLK, zigzag_v_this_BLK);
}


/*
 * void D_Macroblock::Fast_Structure(
 *		short *const src_Y_c, short *const src_U_c, short *const src_V_c,
 *		short *const zsrc_Y_s, short *const zsrc_U_s, short *const zsrc_V_s, 
 *		const bool *const src_cgi, bool *const src_cmi, const bool *const src_flag_zero_mv,
 *		short *const src_mcbpc, short *const src_mcbpy,
 *		const short *const src_mtype, const short *const src_mquant,
 *		const short *const src_mv_type1, const short *const src_mv_x1, const short *const src_mv_y1,
 *		const short *const src_mv_type2, const short *const src_mv_x2, const short *const src_mv_y2,
 *		const short *const src_mv_type3, const short *const src_mv_x3, const short *const src_mv_y3,
 *		const short *const src_mv_type4, const short *const src_mv_x4, const short *const src_mv_y4)
 * 
 * Initialize fast data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_cgi, _cmi, _flag_zero_mv, _mcbpc, _mcbpy, _BLK_list
 * Ensures:		. Set above listed pointers
 *				. call D_Block::Fast_Structure() of 6 blocks in this macroblock, held by _BLK_list
 *
 * Warning:		
 */
void D_Macroblock::Fast_Structure(
	short *const src_Y_c, short *const src_U_c, short *const src_V_c,
	short *const zsrc_Y_s, short *const zsrc_U_s, short *const zsrc_V_s,
	const bool *const src_cgi, bool *const src_cmi, const bool *const src_flag_zero_mv,
	short *const src_mcbpc, short *const src_mcbpy,
	const short *const src_mtype, const short *const src_mquant,
	const short *const src_mv_type1, const short *const src_mv_x1, const short *const src_mv_y1,
	const short *const src_mv_type2, const short *const src_mv_x2, const short *const src_mv_y2,
	const short *const src_mv_type3, const short *const src_mv_x3, const short *const src_mv_y3,
	const short *const src_mv_type4, const short *const src_mv_x4, const short *const src_mv_y4)
{
	D_Block *ptr_BLKa, *ptr_BLKb;
	int i;
	short *y_this_BLKa, *y_this_BLKb;
	short *u_this_BLK;
	short *v_this_BLK;
	short *zigzag_y_this_BLKa, *zigzag_y_this_BLKb;
	short *zigzag_u_this_BLK;
	short *zigzag_v_this_BLK;

	// Enable access to Mode Decision Data, memory-allocated at frame level
	_cgi = src_cgi;
	_cmi = src_cmi;
	_flag_zero_mv = src_flag_zero_mv;
	_mcbpc = src_mcbpc;
	_mcbpy = src_mcbpy;	

	// Enable access to header data, memory-allocated at frame level
	// Final Destination for the next 5 set of pointers
	_mtype = src_mtype;
	_mquant = src_mquant;
	_mv_type1 = src_mv_type1; _mv_x1 = src_mv_x1; _mv_y1 = src_mv_y1;
	_mv_type2 = src_mv_type2; _mv_x2 = src_mv_x2; _mv_y2 = src_mv_y2;
	_mv_type3 = src_mv_type3; _mv_x3 = src_mv_x3; _mv_y3 = src_mv_y3;
	_mv_type4 = src_mv_type4; _mv_x4 = src_mv_x4; _mv_y4 = src_mv_y4;


	// Enable fast access to optimized data structures
	y_this_BLKa = src_Y_c;
	y_this_BLKb = src_Y_c + 128;
	u_this_BLK = src_U_c;
	v_this_BLK = src_V_c;

	zigzag_y_this_BLKa = zsrc_Y_s;
	zigzag_y_this_BLKb = zsrc_Y_s + 128;
	zigzag_u_this_BLK = zsrc_U_s;
	zigzag_v_this_BLK = zsrc_V_s;
	
	ptr_BLKa = _BLK_list;
	ptr_BLKb = _BLK_list + 2;
	for (i=0; i<2; i++) {
		ptr_BLKa->Fast_Structure(src_mtype, y_this_BLKa, zigzag_y_this_BLKa);
		ptr_BLKb->Fast_Structure(src_mtype, y_this_BLKb, zigzag_y_this_BLKb);
		
		ptr_BLKa++; ptr_BLKb++;
		zigzag_y_this_BLKa += 64; zigzag_y_this_BLKb += 64;
		y_this_BLKa += 64; y_this_BLKb += 64;
	}
	ptr_BLKb++->Fast_Structure(src_mtype, u_this_BLK, zigzag_u_this_BLK);
	ptr_BLKb->Fast_Structure(src_mtype, v_this_BLK, zigzag_v_this_BLK);

	if (_PB_frame_mode || !_encode_mode) {
		// Enable fast access to optimized data structures
		y_this_BLKa = src_Y_c + _PB_offset;
		y_this_BLKb = src_Y_c + 128 + _PB_offset;
		u_this_BLK = src_U_c + _PB_offset;
		v_this_BLK = src_V_c + _PB_offset;
		
		zigzag_y_this_BLKa = zsrc_Y_s + _PB_offset;
		zigzag_y_this_BLKb = zsrc_Y_s + 128 + _PB_offset;
		zigzag_u_this_BLK = zsrc_U_s + _PB_offset;
		zigzag_v_this_BLK = zsrc_V_s + _PB_offset;

		ptr_BLKa = _BLK_list_PB;
		ptr_BLKb = _BLK_list_PB + 2;
		for (i=0; i<2; i++) {
			ptr_BLKa->Fast_Structure(src_mtype, y_this_BLKa, zigzag_y_this_BLKa);
			ptr_BLKb->Fast_Structure(src_mtype, y_this_BLKb, zigzag_y_this_BLKb);
			
			ptr_BLKa++; ptr_BLKb++;
			zigzag_y_this_BLKa += 64; zigzag_y_this_BLKb += 64;
			y_this_BLKa += 64; y_this_BLKb += 64;
		}
		ptr_BLKb++->Fast_Structure(src_mtype, u_this_BLK, zigzag_u_this_BLK);
		ptr_BLKb->Fast_Structure(src_mtype, v_this_BLK, zigzag_v_this_BLK);
	}

}


/*
 * void D_Macroblock::Fast_PB_Structure(short *const src_mcbpb, const short *dbquant, const short *bquant,
 *	const short *const src_mvd_type, const short *const src_mvd_x, const short *const src_mvd_y,
 *	const short *const src_mv_type1_f, const short *const src_mv_x1_f, const short *const src_mv_y1_f,
 *	const short *const src_mv_type2_f, const short *const src_mv_x2_f, const short *const src_mv_y2_f,
 *	const short *const src_mv_type3_f, const short *const src_mv_x3_f, const short *const src_mv_y3_f,
 *	const short *const src_mv_type4_f, const short *const src_mv_x4_f, const short *const src_mv_y4_f,
 *	const short *const src_mv_type1_b, const short *const src_mv_x1_b, const short *const src_mv_y1_b,
 *	const short *const src_mv_type2_b, const short *const src_mv_x2_b, const short *const src_mv_y2_b,
 *	const short *const src_mv_type3_b, const short *const src_mv_x3_b, const short *const src_mv_y3_b,
 *	const short *const src_mv_type4_b, const short *const src_mv_x4_b, const short *const src_mv_y4_b,
 *	const short *const src_mv_type_uv_f, const short *const src_mv_uvx_f, const short *const src_mv_uvy_f,
 *	const short *const src_mv_type_uv_b, const short *const src_mv_uvx_b, const short *const src_mv_uvy_b)
 * 
 * Initialize fast data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_mcbpb, _dbquant,
 *				_bquant, _mvd_type, _mvd_x, _mvd_y
 *				_mv_type1_f, _mv_x1_f, _mv_y1_f
 *				_mv_type2_f, _mv_x2_f, _mv_y2_f
 *				_mv_type3_f, _mv_x3_f, _mv_y3_f
 *				_mv_type4_f, _mv_x4_f, _mv_y4_f
 *				_mv_type1_b, _mv_x1_b, _mv_y1_b
 *				_mv_type2_b, _mv_x2_b, _mv_y2_b
 *				_mv_type3_b, _mv_x3_b, _mv_y3_b
 *				_mv_type4_b, _mv_x4_b, _mv_y4_b
 *				_mv_type_uv_f, _mv_uvx_f, _mv_uvy_f
 *				_mv_type_uv_b, _mv_uvx_b, _mv_uvy_b
 *				
 * Ensures:		. Set above listed pointers to the corresponding input pointers
 *
 * Warning:		
 */
void D_Macroblock::Fast_PB_Structure(short *const src_mcbpb, const short *dbquant, const short *bquant,
	const short *const src_mvd_type, const short *const src_mvd_x, const short *const src_mvd_y,
	const short *const src_mv_type1_f, const short *const src_mv_x1_f, const short *const src_mv_y1_f,
	const short *const src_mv_type2_f, const short *const src_mv_x2_f, const short *const src_mv_y2_f,
	const short *const src_mv_type3_f, const short *const src_mv_x3_f, const short *const src_mv_y3_f,
	const short *const src_mv_type4_f, const short *const src_mv_x4_f, const short *const src_mv_y4_f,
	const short *const src_mv_type1_b, const short *const src_mv_x1_b, const short *const src_mv_y1_b,
	const short *const src_mv_type2_b, const short *const src_mv_x2_b, const short *const src_mv_y2_b,
	const short *const src_mv_type3_b, const short *const src_mv_x3_b, const short *const src_mv_y3_b,
	const short *const src_mv_type4_b, const short *const src_mv_x4_b, const short *const src_mv_y4_b,
	const short *const src_mv_type_uv_f, const short *const src_mv_uvx_f, const short *const src_mv_uvy_f,
	const short *const src_mv_type_uv_b, const short *const src_mv_uvx_b, const short *const src_mv_uvy_b)
{
	_mcbpb = src_mcbpb;
	_dbquant = dbquant;
	_bquant = bquant;
	_mvd_type = src_mvd_type; _mvd_x = src_mvd_x; _mvd_y = src_mvd_y;

	_mv_type1_f = src_mv_type1_f; _mv_x1_f = src_mv_x1_f; _mv_y1_f = src_mv_y1_f;
	_mv_type2_f = src_mv_type2_f; _mv_x2_f = src_mv_x2_f; _mv_y2_f = src_mv_y2_f;
	_mv_type3_f = src_mv_type3_f; _mv_x3_f = src_mv_x3_f; _mv_y3_f = src_mv_y3_f;
	_mv_type4_f = src_mv_type4_f; _mv_x4_f = src_mv_x4_f; _mv_y4_f = src_mv_y4_f;

	_mv_type1_b = src_mv_type1_b; _mv_x1_b = src_mv_x1_b; _mv_y1_b = src_mv_y1_b;
	_mv_type2_b = src_mv_type2_b; _mv_x2_b = src_mv_x2_b; _mv_y2_b = src_mv_y2_b;
	_mv_type3_b = src_mv_type3_b; _mv_x3_b = src_mv_x3_b; _mv_y3_b = src_mv_y3_b;
	_mv_type4_b = src_mv_type4_b; _mv_x4_b = src_mv_x4_b; _mv_y4_b = src_mv_y4_b;

	_mv_type_uv_f = src_mv_type_uv_f; _mv_uvx_f = src_mv_uvx_f; _mv_uvy_f = src_mv_uvy_f;
	_mv_type_uv_b = src_mv_type_uv_b; _mv_uvx_b = src_mv_uvx_b; _mv_uvy_b = src_mv_uvy_b;
}


/*
 * void D_Macroblock::Fast_Slice_Structure(const short *const src_seg_ID, const short *const src_seg_size, 
 *	const short *const src_right_span, const short *const src_left_span,
 *	const short *const src_x_bound_high, const short *const src_x_bound_low,
 *	const short *const src_y_bound_high, const short *const src_y_bound_low,
 *	const short *const src_mvx0_high, const short *const src_mvx0_low, 
 *	const short *const src_mvy0_high, const short *const src_mvy0_low,
 *	const short *const src_mvx1_high, const short *const src_mvx1_low,
 *	const short *const src_mvy1_high, const short *const src_mvy1_low,
 *	const short *const src_mvx2_high, const short *const src_mvx2_low,
 *	const short *const src_mvy2_high, const short *const src_mvy2_low,
 *	const short *const src_mvx3_high, const short *const src_mvx3_low,
 *	const short *const src_mvy3_high, const short *const src_mvy3_low,
 *	const short *const src_mvx4_high, const short *const src_mvx4_low,
 *	const short *const src_mvy4_high, const short *const src_mvy4_low,
 * 	const bool *const src_mvx_border_high, const bool *const src_mvx_border_low,
 *	const bool *const src_mvy_border_high, const bool *const src_mvy_border_low)
 * 
 * Initialize fast data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_seg_ID, _seg_size, _right_span, _left_span
 *				_x_bound_high, _x_bound_low, _y_bound_high, _y_bound_low
 *				_mvx0_high, _mvx0_low, _mvx1_high, _mvx1_low
 *				_mvx2_high, _mvx2_low, _mvx3_high, _mvx3_low
 *				_mvx4_high, _mvx4_low, _mvy0_high, _mvy0_low
 *				_mvy1_high, _mvy1_low, _mvy2_high, _mvy2_low
 *				_mvy3_high, _mvy3_low, _mvy4_high, _mvy4_low
 *				_mvx_border_high, _mvx_border_lowm _mvy_border_high, _mvy_border_low
 *
 * Ensures:		. Set above listed pointers to the corresponding input pointers
 *
 * Warning:		
 */
void D_Macroblock::Fast_Slice_Structure(const short *const src_seg_ID, const short *const src_seg_size, 
	const short *const src_right_span, const short *const src_left_span,
	const short *const src_x_bound_high, const short *const src_x_bound_low,
	const short *const src_y_bound_high, const short *const src_y_bound_low,
	const short *const src_mvx0_high, const short *const src_mvx0_low, 
	const short *const src_mvy0_high, const short *const src_mvy0_low,
	const short *const src_mvx1_high, const short *const src_mvx1_low,
	const short *const src_mvy1_high, const short *const src_mvy1_low,
	const short *const src_mvx2_high, const short *const src_mvx2_low,
	const short *const src_mvy2_high, const short *const src_mvy2_low,
	const short *const src_mvx3_high, const short *const src_mvx3_low,
	const short *const src_mvy3_high, const short *const src_mvy3_low,
	const short *const src_mvx4_high, const short *const src_mvx4_low,
	const short *const src_mvy4_high, const short *const src_mvy4_low,
	const bool *const src_mvx_border_high, const bool *const src_mvx_border_low,
	const bool *const src_mvy_border_high, const bool *const src_mvy_border_low)
{
	_seg_ID = src_seg_ID; _seg_size = src_seg_size;
	_right_span = src_right_span; _left_span = src_left_span;
	_x_bound_high = src_x_bound_high; _x_bound_low = src_x_bound_low;
	_y_bound_high = src_y_bound_high; _y_bound_low = src_y_bound_low;

	_mvx0_high = src_mvx0_high; _mvx0_low = src_mvx0_low;
	_mvx1_high = src_mvx1_high; _mvx1_low = src_mvx1_low;
	_mvx2_high = src_mvx2_high; _mvx2_low = src_mvx2_low;
	_mvx3_high = src_mvx3_high; _mvx3_low = src_mvx3_low;
	_mvx4_high = src_mvx4_high; _mvx4_low = src_mvx4_low;
	_mvy0_high = src_mvy0_high; _mvy0_low = src_mvy0_low;
	_mvy1_high = src_mvy1_high; _mvy1_low = src_mvy1_low;
	_mvy2_high = src_mvy2_high; _mvy2_low = src_mvy2_low;
	_mvy3_high = src_mvy3_high; _mvy3_low = src_mvy3_low;
	_mvy4_high = src_mvy4_high; _mvy4_low = src_mvy4_low;
	_mvx_border_high = src_mvx_border_high; _mvx_border_low = src_mvx_border_low;
	_mvy_border_high = src_mvy_border_high; _mvy_border_low = src_mvy_border_low;
}


/*
 * void D_Macroblock::Fast_Decoded_Structure(const unsigned char *const src_Y_c,
 *											const unsigned char *const src_U_c, 
 *											const unsigned char *const src_V_c)
 * 
 * Initialize fast decoded structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	6 blocks pointed by _BLK_list
 * Ensures:		call D_Block::Fast_Decoded_Structure() of 6 blocks in this macroblock, held by _BLK_list
 *
 * Warning:		
 */
void D_Macroblock::Fast_Decoded_Structure(const unsigned char *const src_Y_c, 
		const unsigned char *const src_U_c, const unsigned char *const src_V_c)
{
	int i;
	D_Block *ptr_BLKa, *ptr_BLKb;
	const unsigned char *y_decoded_BLKa, *y_decoded_BLKb;
	const unsigned char *u_decoded_BLK;
	const unsigned char *v_decoded_BLK;

	// Enable fast access to optimized data structures
	y_decoded_BLKa = src_Y_c;
	y_decoded_BLKb = src_Y_c + 128;
	u_decoded_BLK = src_U_c;
	v_decoded_BLK = src_V_c;

	ptr_BLKa = _BLK_list;
	ptr_BLKb = _BLK_list + 2;
	for (i=0; i<2; i++) {
		ptr_BLKa->Fast_Decoded_Structure(y_decoded_BLKa);
		ptr_BLKb->Fast_Decoded_Structure(y_decoded_BLKb);
		ptr_BLKa++;
		ptr_BLKb++;
		y_decoded_BLKa += 64;
		y_decoded_BLKb += 64;
	}
	ptr_BLKb++->Fast_Decoded_Structure(u_decoded_BLK);
	ptr_BLKb->Fast_Decoded_Structure(v_decoded_BLK);
}

										  
/*
 * void D_Macroblock::Fast_Differential_Motion_Vector(const short *const src_mv_type01, 
 *													const short *const src_mv_type02, 
 *													const short *const src_mv_type03,
 *													const short *const src_mv_x01,
 *													const short *const src_mv_x02,
 *													const short *const src_mv_x03,
 *													const short *const src_mv_y01,
 *													const short *const src_mv_y02,
 *													const short *const src_mv_y03)
 * 
 * Initialize fast differential motion vectors
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_dmv_type01, _dmv_x01, _dmv_y01
 *				_dmv_type02, _dmv_x02, _dmv_y02
 *				_dmv_type03, _dmv_x03, _dmv_y03
 * Ensures:		Set differential motion vector source pointers
 *
 * Warning:		
 */
void D_Macroblock::Fast_Differential_Motion_Vector(
		const short *const src_seg_ID01, const short *const src_seg_ID02,
		const short *const src_seg_ID03, const short *const src_mv_type01, 
		const short *const src_mv_type02, const short *const src_mv_type03, 
		const short *const src_mv_x01, const short *const src_mv_x02, 
		const short *const src_mv_x03, const short *const src_mv_y01,
		const short *const src_mv_y02, const short *const src_mv_y03)
{
	_dmv_ID01 = src_seg_ID01;
	_dmv_ID02 = src_seg_ID02;
	_dmv_ID03 = src_seg_ID03;
	_dmv_type01 = src_mv_type01;
	_dmv_type02 = src_mv_type02;
	_dmv_type03 = src_mv_type03;
	_dmv_x01 = src_mv_x01;
	_dmv_x02 = src_mv_x02;
	_dmv_x03 = src_mv_x03;
	_dmv_y01 = src_mv_y01;
	_dmv_y02 = src_mv_y02;
	_dmv_y03 = src_mv_y03;
}

/* Overloaded function for Advanced Prediction Mode
 * void D_Macroblock::Fast_Differential_Motion_Vector(const short *const src_mv_type01, 
 *													const short *const src_mv_type02, 
 *													const short *const src_mv_type03,
 *													const short *const src_mv_x01,
 *													const short *const src_mv_x02,
 *													const short *const src_mv_x03,
 *													const short *const src_mv_y01,
 *													const short *const src_mv_y02,
 *													const short *const src_mv_y03)
 * 
 * Initialize fast differential motion vectors
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_dmv_type01, _dmv_x01, _dmv_y01
 *				_dmv_type02, _dmv_x02, _dmv_y02
 *				_dmv_type03, _dmv_x03, _dmv_y03
 * Ensures:		Set differential motion vector source pointers
 *
 * Warning:		
 */
void D_Macroblock::Fast_Differential_Motion_Vector(
	const short *const src_seg_ID11, const short *const src_seg_ID12, const short *const src_seg_ID13,
	const short *const src_mv_type11, const short *const src_mv_type12, const short *const src_mv_type13,
	const short *const src_mv_x11, const short *const src_mv_x12, const short *const src_mv_x13,
	const short *const src_mv_y11, const short *const src_mv_y12, const short *const src_mv_y13,
	const short *const src_seg_ID21, const short *const src_seg_ID22, const short *const src_seg_ID23,
	const short *const src_mv_type21, const short *const src_mv_type22, const short *const src_mv_type23,
	const short *const src_mv_x21, const short *const src_mv_x22, const short *const src_mv_x23,
	const short *const src_mv_y21, const short *const src_mv_y22, const short *const src_mv_y23,
	const short *const src_seg_ID31, const short *const src_seg_ID32, const short *const src_seg_ID33,
	const short *const src_mv_type31, const short *const src_mv_type32, const short *const src_mv_type33,
	const short *const src_mv_x31, const short *const src_mv_x32, const short *const src_mv_x33,
	const short *const src_mv_y31, const short *const src_mv_y32, const short *const src_mv_y33,
	const short *const src_seg_ID41, const short *const src_seg_ID42, const short *const src_seg_ID43,
	const short *const src_mv_type41, const short *const src_mv_type42, const short *const src_mv_type43,
	const short *const src_mv_x41, const short *const src_mv_x42, const short *const src_mv_x43,
	const short *const src_mv_y41, const short *const src_mv_y42, const short *const src_mv_y43,
	const short *const src_seg_ID01, const short *const src_seg_ID02, const short *const src_seg_ID03,
	const short *const src_mvd_type1, const short *const src_mvd_type2, const short *const src_mvd_typ3,
	const short *const src_mvd_x1, const short *const src_mvd_x2, const short *const src_mvd_x3,
	const short *const src_mvd_y1, const short *const src_mvd_y2, const short *const src_mvd_y3)
{
	_dmv_ID11 = src_seg_ID11;		_dmv_ID12 = src_seg_ID12;	_dmv_ID13 = src_seg_ID13;
	_dmv_type11 = src_mv_type11;	_dmv_x11 = src_mv_x11;		_dmv_y11 = src_mv_y11;
	_dmv_type12 = src_mv_type12;	_dmv_x12 = src_mv_x12;		_dmv_y12 = src_mv_y12;
	_dmv_type13 = src_mv_type13;	_dmv_x13 = src_mv_x13;		_dmv_y13 = src_mv_y13;
	
	_dmv_ID21 = src_seg_ID21;		_dmv_ID22 = src_seg_ID22;	_dmv_ID23 = src_seg_ID23;
	_dmv_type21 = src_mv_type21;	_dmv_x21 = src_mv_x21;		_dmv_y21 = src_mv_y21;
	_dmv_type22 = src_mv_type22;	_dmv_x22 = src_mv_x22;		_dmv_y22 = src_mv_y22;
	_dmv_type23 = src_mv_type23;	_dmv_x23 = src_mv_x23;		_dmv_y23 = src_mv_y23;
	
	_dmv_ID31 = src_seg_ID31;		_dmv_ID32 = src_seg_ID32;	_dmv_ID33 = src_seg_ID33;
	_dmv_type31 = src_mv_type31;	_dmv_x31 = src_mv_x31;		_dmv_y31 = src_mv_y31;
	_dmv_type32 = src_mv_type32;	_dmv_x32 = src_mv_x32;		_dmv_y32 = src_mv_y32;
	_dmv_type33 = src_mv_type33;	_dmv_x33 = src_mv_x33;		_dmv_y33 = src_mv_y33;
	
	_dmv_ID41 = src_seg_ID41;		_dmv_ID42 = src_seg_ID42;	_dmv_ID43 = src_seg_ID43;
	_dmv_type41 = src_mv_type41;	_dmv_x41 = src_mv_x41;		_dmv_y41 = src_mv_y41;
	_dmv_type42 = src_mv_type42;	_dmv_x42 = src_mv_x42;		_dmv_y42 = src_mv_y42;
	_dmv_type43 = src_mv_type43;	_dmv_x43 = src_mv_x43;		_dmv_y43 = src_mv_y43;

	_dmvd_ID1 = src_seg_ID01; _dmvd_ID2 = src_seg_ID02; _dmvd_ID3 = src_seg_ID03;
	_dmvd_type1 = src_mvd_type1; _dmvd_type2 = src_mvd_type2; 	_dmvd_type3 = src_mvd_typ3;
	_dmvd_x1 = src_mvd_x1; _dmvd_x2 = src_mvd_x2; _dmvd_x3 = src_mvd_x3;
	_dmvd_y1 = src_mvd_y1; _dmvd_y2 = src_mvd_y2; _dmvd_y3 = src_mvd_y3;
}


#endif

