
#ifndef __D_MACROBLOCK_ENTROPY_ENCODER_C__
#define __D_MACROBLOCK_ENTROPY_ENCODER_C__

#include "D_Macroblock.h"


/*
 * void D_Macroblock::Entropy_Encoder(PSC_Fifo &bit_ostream)
 * 
 * Entropy encode the current macroblock, 
 * then call D_Block::Entropy_Encoder() for 6 blocks pointed by _BLK_list
 * This is a public method
 *
 * Requires:	Encode_MB() is called before evoking this method from the GOB layer
 * Modifies:	bit_ostream
 * Ensures:		Entropy encode the macroblock header according to the standard
 *
 * Warning:		baseline implementation
 */
void D_Macroblock::Entropy_Encoder(PSC_Fifo &bit_ostream)
{
	// Array checked
	static char *I_MCBPC[9] = 
	{ "1", "001", "010", "011", "0001", "000001", "000010", "000011", "000000001" };

	// Array checked
	static char *P_MCBPC[25] = 
	{ "1", "0011", "0010", "000101", "011", "0000111", "0000110", "000000101", "010", "0000101",
	"0000100", "00000101", "00011", "00000100", "00000011", "0000011", "000100", "000000100",
	"000000011", "000000010", "000000001", "00000000010", "0000000001100", "0000000001110",
	"0000000001111" };

	// Array checked
	static char *A_CBPY[16] =
	{ "0011", "00101", "00100", "1001", "00011", "0111", "000010", "1011", "00010", "000011", 
	"0101", "1010", "0100", "1000", "0110", "11" };

	// Array checked
	static char *R_CBPY[16] =
	{ "11", "0110", "1000", "0100", "1010", "0101", "000011", "00010", "1011", "000010", 
	"0111", "00011", "1001", "00100", "00101", "0011" };

	// Array checked
	static char *VLC_MODB[4] = 
	{ "0", "10", "11" };

	static char *VLC_MVD[64] =
	{ "0000000000101","0000000000111","000000000101","000000000111",
	"000000001001","000000001011","000000001101","000000001111",
	"00000001001","00000001011","00000001101","00000001111",
	"00000010001","00000010011","00000010101","00000010111",
	"00000011001","00000011011","00000011101","00000011111",
	"00000100001","00000100011","0000010011","0000010101",
	"0000010111","00000111","00001001","00001011",
	"0000111","00011","0011","011",
	"1","010","0010","00010",
	"0000110","00001010","00001000","00000110",
	"0000010110","0000010100","0000010010","00000100010",
	"00000100000","00000011110","00000011100","00000011010",
	"00000011000","00000010110","00000010100","00000010010",
	"00000010000","00000001110","00000001100","00000001010",
	"00000001000","000000001110","000000001100","000000001010",
	"000000001000","000000000110","000000000100","0000000000110" };

	static int MVD_Length[64] =
	{ 13, 13, 12, 12, 12, 12, 12, 12,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 10, 10,
	10, 8, 8, 8, 7, 5, 4, 3,
	1, 3, 4, 5, 7, 8, 8, 8,
	10, 10, 10, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 12, 12, 12, 12, 12, 12, 13};

	int i, bitcount, k, l;
	int mtype, mcbpy, mcbpc, modb;
	const char *ptr_c;
	double median_x0, median_y0,
		median_x1, median_y1,
		median_x2, median_y2,
		median_x3, median_y3, tx, ty;
	bool bits[162];	// COD(1)+MCBPC(13)+INTRA_MODE(2)+MODB(2)+CBPB(6)+CBPY(6)+DQUANT(2)+
	bool *ptr_b;	// 2* [MVD(13)+MVD2(13)+MVD3(13)+MVD4(13)+MVDB(13)] = 160
	D_Block *ptr_BLK;


	bitcount = 0;
	ptr_b = bits;

	median_x1 = median_y1 = 0.0;
	median_x2 = median_y2 = 0.0;
	median_x3 = median_y3 = 0.0;

	mtype = *_mtype;
	mcbpy = *_mcbpy;
	mcbpc = *_mcbpc;

// RESTART:

	// COD - Coded Macroblock Indication - CMI - 1 bit
	if (_inter_frame_mode == true) {
		bitcount++;
		*ptr_b++ = *_cmi;
		if (EDEBUG) fprintf(stdout, "COD %d\n", *_cmi);
		if (*_cmi == true) {	// No more information is sent
			bit_ostream.WriteNBits(bits, bitcount);
			return;
		}
	}

	// MCBPC - Macroblock type & Coded block pattern for chrominance (MCBPC) - (Variable Length)
	if (_inter_frame_mode) {		// ** no stuffing yet
		k = (mtype << 2) + mcbpc;	// MCBPC in INTER frame
		if (mtype == 5) k++;		// Index 20 is already reserved for *stuffing*
		ptr_c = P_MCBPC[k];
	}
	else {
		k = mcbpc;					// MCBPC in INTRA frame
		if (mtype == INTRAQ) k += 4;
		ptr_c = I_MCBPC[k];
	}
	l = strlen(ptr_c);
	bitcount += l;
	for (i=0; i<l; i++) {
		if (*ptr_c++ == '1') *ptr_b++ = true;
		else *ptr_b++ = false;
	}
	if (EDEBUG) fprintf(stdout, "MTYPE %d\n", mtype);
	if (EDEBUG) fprintf(stdout, "CBPC %d%d\n", (mcbpc&2) > 0, (mcbpc&1) > 0);
	
	// INTRA_MODE - Advanced Intra Coding Prediction Mode
	if (_advanced_intra_coding_mode && (mtype == INTRA || mtype == INTRAQ)){
		switch (_advanced_intra_prediction_mode) {
		case 1:
			bitcount += 2;
			*ptr_b++ = true; *ptr_b++ = false;
			break;
		case 2:
			bitcount += 2;
			*ptr_b++ = true; *ptr_b++ = true;
			break;
		default: // Case 0
			bitcount++;
			*ptr_b++ = false;
		}
		if (EDEBUG) fprintf(stdout, "INTRA_MODE %d\n", _advanced_intra_prediction_mode);
	}
	// MODB - Macroblock mode for B-blocks - (Variable Length)
	modb = 0;
	if (_PB_Ppicture_flag) {	// Only for PB-frames
		if (*_mcbpb != 0) modb = 2;	// If CBPB & no MVDB, send 0 for MVDBs
		else modb = _coded_mvd_flag;
		ptr_c = VLC_MODB[modb];
		l = strlen(ptr_c);
		bitcount += l;
		for (i=0; i<l; i++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) fprintf(stdout, "MODB %d\n", modb);

		// CBPB - Coded block pattern for B-blocks - 6 bits
		if (modb == 2) {	// Sent if MODB says so
			k = *_mcbpb;
			bitcount += 6;
			if (EDEBUG) fprintf(stdout, "CBPB ");
			for (i=0; i<6; i++, k<<=1) {
				if (k & 32) {
					*ptr_b++ = true;
					if (EDEBUG) fprintf(stdout, "1");
				}
				else {
					*ptr_b++ = false;
					if (EDEBUG) fprintf(stdout, "0");
				}
			}
			if (EDEBUG) fprintf(stdout, "\n");
		}
	}

	// CBPY - Coded Block Pattern for Luminance - (Variable Length)
	if (_alternative_inter_vlc_mode && (mtype <= 2 || mtype == 5) && (mcbpc == 3)) {
		ptr_c = A_CBPY[mcbpy];
		if (EDEBUG) fprintf (stdout, "AIV used ");
	}
	else {
		if (mtype <= 2 || mtype == 5) { // INTER Macroblocks
			ptr_c = R_CBPY[mcbpy];
		}
		else {
			ptr_c = A_CBPY[mcbpy];		// MCBPY (Intra) in INTRA frame
		}
	}
	l = strlen(ptr_c);
	bitcount += l;
	for (i=0; i<l; i++) {
		if (*ptr_c++ == '1') *ptr_b++ = true;
		else *ptr_b++ = false;
	}
	if (EDEBUG) fprintf(stdout, "CBPY %d%d%d%d\n",
		(mcbpy&8) > 0, (mcbpy&4) > 0, (mcbpy&2) > 0, (mcbpy&1) > 0);

	// DQUANT - Quantizer Information - 2 bits/(Variable length)
	// Waiting for future...
	// if (mtype == 1 || mtype >= 4)
	// if (EDEBUG) fprintf(stdout, "DQUANT %d\n", _dquant);

	// MVD - Motion Vector Data - (Variable Length)
	
//	static bool infected = false;     used for flipping bits
	
	if (mtype <= 2 || mtype == 5 || _PB_Ppicture_flag) { // PB mode always has MVDs
		if (mtype == INTER4V || mtype == INTER4VQ) {
			Median_Predictor(&median_x0, &median_y0,
				&median_x1, &median_y1, &median_x2, &median_y2,
				&median_x3, &median_y3);
		}
		else Median_Predictor(&median_x0, &median_y0, false);

		tx = *_mv_x1;
		ty = *_mv_y1;

		if ((*_mv_type1 == 2) || (*_mv_type1 == 4) )  tx += 0.5;
		if (*_mv_type1 > 2) ty += 0.5;

		if (EDEBUG) fprintf(stdout, "MVD %g,%g TYPE%d - Median %g,%g\n",
			tx, ty, *_mv_type1, median_x0, median_y0);

		tx -= median_x0;
		ty -= median_y0;

		if (EDEBUG) { fprintf(stdout, "MVD sent %g,%g\n", tx, ty); fflush(stdout); }

		k = (int)(tx*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_c = VLC_MVD[k];
		l = MVD_Length[k];
		bitcount += l;
		for (i=0; i<l; i++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) { fprintf(stdout, "MVDx %d\n", k); fflush(stdout); }

		k = (int)(ty*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_c = VLC_MVD[k];
		l = MVD_Length[k];
		bitcount += l;
		for (i=0; i<l; i++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;

			//flip a bit
/*			if (i==0 && _group_id == 3 && _macroblock_id == 5 && infected == false) {
				*(ptr_b-1) = !*(ptr_b-1);
				infected = true;
			}*/

		}
		if (EDEBUG) { fprintf(stdout, "MVDy %d\n", k); fflush(stdout); }
	}

	// MVD2-4 - Motion Vector Data - (Variable Length)
	if (mtype == INTER4V || mtype == INTER4VQ) {
		// MVD2
		tx = *_mv_x2;
		ty = *_mv_y2;
		
		if ((*_mv_type2 == 2) || (*_mv_type2 == 4) )  tx += 0.5;
		if (*_mv_type2 > 2) ty += 0.5;

		if (EDEBUG) fprintf(stdout, "MVD2 %g,%g TYPE%d - Median %g,%g\n",
			tx, ty, *_mv_type2, median_x1, median_y1);

		tx -= median_x1;
		ty -= median_y1;

		if (EDEBUG) { fprintf(stdout, "MVD2 sent %g,%g\n", tx, ty); fflush(stdout); }

		k = (int)(tx*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_c = VLC_MVD[k];
		l = MVD_Length[k];
		bitcount += l;
		for (i=0; i<l; i++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) { fprintf(stdout, "MVD2x %d\n", k); fflush(stdout); }

		k = (int)(ty*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_c = VLC_MVD[k];
		l = MVD_Length[k];
		bitcount += l;
		for (i=0; i<l; i++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) { fprintf(stdout, "MVD2y %d\n", k); fflush(stdout); }

		// MVD3
		tx = *_mv_x3;
		ty = *_mv_y3;
		
		if ((*_mv_type3 == 2) || (*_mv_type3 == 4) )  tx += 0.5;
		if (*_mv_type3 > 2) ty += 0.5;

		if (EDEBUG) fprintf(stdout, "MVD3 %g,%g TYPE%d - Median %g,%g\n",
			tx, ty, *_mv_type3, median_x2, median_y2);
		
		tx -= median_x2;
		ty -= median_y2;

		if (EDEBUG) { fprintf(stdout, "MVD3 sent %g,%g\n", tx, ty); fflush(stdout); }

		k = (int)(tx*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_c = VLC_MVD[k];
		l = MVD_Length[k];
		bitcount += l;
		for (i=0; i<l; i++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) { fprintf(stdout, "MVD3x %d\n", k); fflush(stdout); }

		k = (int)(ty*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_c = VLC_MVD[k];
		l = MVD_Length[k];
		bitcount += l;
		for (i=0; i<l; i++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) { fprintf(stdout, "MVD3y %d\n", k); fflush(stdout); }

		// MVD4
		tx = *_mv_x4;
		ty = *_mv_y4;
		
		if ((*_mv_type4 == 2) || (*_mv_type4 == 4) )  tx += 0.5;
		if (*_mv_type4 > 2) ty += 0.5;

		if (EDEBUG) fprintf(stdout, "MVD4 %g,%g TYPE%d - Median %g,%g\n",
			tx, ty, *_mv_type4, median_x3, median_y3);
		
		tx -= median_x3;
		ty -= median_y3;

		if (EDEBUG) { fprintf(stdout, "MVD4 sent %g,%g\n", tx, ty); fflush(stdout); }

		k = (int)(tx*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_c = VLC_MVD[k];
		l = MVD_Length[k];
		bitcount += l;
		for (i=0; i<l; i++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) { fprintf(stdout, "MVD4x %d\n", k); fflush(stdout); }

		k = (int)(ty*2);
		if (k >= 32) k -= 32;
		else if (k <= -33) k += 96;
		else k += 32;
		ptr_c = VLC_MVD[k];
		l = MVD_Length[k];
		bitcount += l;
		for (i=0; i<l; i++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) { fprintf(stdout, "MVD4y %d\n", k); fflush(stdout); }
	}

	// MVDB - Motion Vector Data for B-macroblock - (Variable Length)
	if (modb >= 1) {	// If MODB says MVDB is present
		if (_coded_mvd_flag) {
			Median_Predictor(&median_x0, &median_y0, true);
			
			tx = *_mvd_x;
			ty = *_mvd_y;
			
			if ((*_mvd_type == 2) || (*_mvd_type == 4) ) tx += 0.5;
			if (*_mvd_type > 2) ty += 0.5;
			
			if (EDEBUG) fprintf(stdout, "MVDB %g,%g TYPE%d - Median %g,%g\n",
				tx, ty, *_mvd_type, median_x0, median_y0);
			
			tx -= median_x0;
			ty -= median_y0;

			if (EDEBUG) { fprintf(stdout, "MVDB sent %g,%g\n", tx, ty); fflush(stdout); }
			
			k = (int)(tx*2);
			if (k >= 32) k -= 32;
			else if (k <= -33) k += 96;
			else k += 32;
			ptr_c = VLC_MVD[k];
			l = MVD_Length[k];
			bitcount += l;
			for (i=0; i<l; i++) {
				if (*ptr_c++ == '1') *ptr_b++ = true;
				else *ptr_b++ = false;
			}
			if (EDEBUG) { fprintf(stdout, "MVDBx %d\n", k); fflush(stdout); }
			
			k = (int)(ty*2);
			if (k >= 32) k -= 32;
			else if (k <= -33) k += 96;
			else k += 32;
			ptr_c = VLC_MVD[k];
			l = MVD_Length[k];
			bitcount += l;
			for (i=0; i<l; i++) {
				if (*ptr_c++ == '1') *ptr_b++ = true;
				else *ptr_b++ = false;
			}
			if (EDEBUG) { fprintf(stdout, "MVDBy %d\n", k); fflush(stdout); }
		}
		else {
			bitcount += 2;
			*ptr_b++ = true;
			*ptr_b++ = true;
			if (EDEBUG) fprintf(stdout, "MVDB 0,0 TYPE1 - Median 0,0\n");
		}
	}

	bit_ostream.WriteNBits(bits, bitcount);

	// Encode Block Layer
	if (_PB_Ppicture_flag) ptr_BLK = _BLK_list_PB;
	else ptr_BLK = _BLK_list;
	// If it is an INTRA block, we still have to encode the DC component
	if ((mtype == INTRA) || (mtype == INTRAQ)) {
		for (i=0; i<_BLK_per_mb; i++) {
			if (EDEBUG) fprintf(stdout, "BLOCK %d -> ", i);
			ptr_BLK->Entropy_Encoder(bit_ostream);
			ptr_BLK++;
		}
	}
	// If it is an INTER block, we have to examine the Coded Block Pattern
	else {
		k = (mcbpy << 2) + mcbpc;
		for (i=0; i<_BLK_per_mb; i++) {
			if (k & 32) {
				if (EDEBUG) fprintf(stdout, "BLOCK %d -> ", i);
				ptr_BLK->Entropy_Encoder(bit_ostream);
			}
			ptr_BLK++;
			k <<= 1;
		}
	}

	// If PB_frame mode is on, output the B-frame
	if (_PB_Ppicture_flag) {
		ptr_BLK = _BLK_list;
		k = *_mcbpb;
		for (i=0; i<_BLK_per_mb; i++) {
			if (k & 32) {
				if (EDEBUG) fprintf(stdout, "BLOCK %d -> ", i+6);
				ptr_BLK->_PB_B_frame = true;
				ptr_BLK->Entropy_Encoder(bit_ostream);
				ptr_BLK->_PB_B_frame = false;
			}
			ptr_BLK++;
			k <<= 1;
		}
	}
}


#endif

