
#ifndef D_MACROBLOCK_H
#define D_MACROBLOCK_H	/*+ To stop multiple inclusions. +*/

#include "PSC_Fifo.h"
#include "Constants.h"
#include "D_Block.h"
#include "SAC.h"
#include "SAC_Cumf.h"
#include <stdlib.h>
#include <string.h>

class D_Macroblock {
protected:
	D_Block *_BLK_list, *_BLK_list_PB;

	int _clock;
	int _group_id, _macroblock_id;					// ID tag

	int _frame_xsize;
	int _BLK_per_mb;								// Defined to be 6
	int _BLK_Y_offset, _BLK_UV_offset;				// block offset, to traverse 1D data structure

	const short *_dbquant;
	const short *_mtype, *_mquant, *_bquant;
	const short *_mv_type1, *_mv_x1, *_mv_y1; // motion vector of current block
	const short *_mv_type2, *_mv_x2, *_mv_y2;
	const short *_mv_type3, *_mv_x3, *_mv_y3;
	const short *_mv_type4, *_mv_x4, *_mv_y4;

	// Baseline support
	const short *_dmv_ID01, *_dmv_type01, *_dmv_x01, *_dmv_y01;	// motion vector of previous block
	const short *_dmv_ID02, *_dmv_type02, *_dmv_x02, *_dmv_y02;	// motion vector of above block
	const short *_dmv_ID03, *_dmv_type03, *_dmv_x03, *_dmv_y03;	// motion vector of upper right block


	// Advanced Prediction and PB Frame support
	// Y1 block
	const short *_dmv_ID11, *_dmv_type11, *_dmv_x11, *_dmv_y11;	// motion vector of previous block
	const short *_dmv_ID12, *_dmv_type12, *_dmv_x12, *_dmv_y12;	// motion vector of above block
	const short *_dmv_ID13, *_dmv_type13, *_dmv_x13, *_dmv_y13;	// motion vector of upper right block
	// Y2 block
	const short *_dmv_ID21, *_dmv_type21, *_dmv_x21, *_dmv_y21;	// motion vector of previous block
	const short *_dmv_ID22, *_dmv_type22, *_dmv_x22, *_dmv_y22;	// motion vector of above block
	const short *_dmv_ID23, *_dmv_type23, *_dmv_x23, *_dmv_y23;	// motion vector of upper right block
	// Y3 block
	const short *_dmv_ID31, *_dmv_type31, *_dmv_x31, *_dmv_y31;	// motion vector of previous block
	const short *_dmv_ID32, *_dmv_type32, *_dmv_x32, *_dmv_y32;	// motion vector of above block
	const short *_dmv_ID33, *_dmv_type33, *_dmv_x33, *_dmv_y33;	// motion vector of upper right block
	// Y4 block
	const short *_dmv_ID41, *_dmv_type41, *_dmv_x41, *_dmv_y41;	// motion vector of previous block
	const short *_dmv_ID42, *_dmv_type42, *_dmv_x42, *_dmv_y42;	// motion vector of above block
	const short *_dmv_ID43, *_dmv_type43, *_dmv_x43, *_dmv_y43;	// motion vector of upper right block


	// Differential Delta Motion Vectors
	const short *_dmvd_ID1, *_dmvd_type1, *_dmvd_x1, *_dmvd_y1;	// motion vector of previous block
	const short *_dmvd_ID2, *_dmvd_type2, *_dmvd_x2, *_dmvd_y2;	// motion vector of above block
	const short *_dmvd_ID3, *_dmvd_type3, *_dmvd_x3, *_dmvd_y3;	// motion vector of upper right block


	// Support for PB frame mode
	const short *_mvd_type, *_mvd_x, *_mvd_y;				// delta motion vector
	const short *_mv_type1_f, *_mv_x1_f, *_mv_y1_f;		// Forward motion vectors
	const short *_mv_type2_f, *_mv_x2_f, *_mv_y2_f;
	const short *_mv_type3_f, *_mv_x3_f, *_mv_y3_f;
	const short *_mv_type4_f, *_mv_x4_f, *_mv_y4_f;
	const short *_mv_type1_b, *_mv_x1_b, *_mv_y1_b;		// Backward motion vectors
	const short *_mv_type2_b, *_mv_x2_b, *_mv_y2_b;	
	const short *_mv_type3_b, *_mv_x3_b, *_mv_y3_b;	
	const short *_mv_type4_b, *_mv_x4_b, *_mv_y4_b;	
	const short *_mv_type_uv_f, *_mv_uvx_f, *_mv_uvy_f;	// Chrominance forward motion vector
	const short *_mv_type_uv_b, *_mv_uvx_b, *_mv_uvy_b;	// Chrominance backware motion vector


	// Support for Video Segment and Annex K/R
	const short *_seg_ID, *_seg_size;
	const short *_right_span, *_left_span;
	const short *_x_bound_high, *_x_bound_low;
	const short *_y_bound_high, *_y_bound_low;
	const short *_mvx0_high, *_mvx0_low;
	const short *_mvx1_high, *_mvx1_low;
	const short *_mvx2_high, *_mvx2_low;
	const short *_mvx3_high, *_mvx3_low;
	const short *_mvx4_high, *_mvx4_low;
	const short *_mvy0_high, *_mvy0_low;
	const short *_mvy1_high, *_mvy1_low;
	const short *_mvy2_high, *_mvy2_low;
	const short *_mvy3_high, *_mvy3_low;
	const short *_mvy4_high, *_mvy4_low;
	const bool *_mvx_border_high, *_mvx_border_low;
	const bool *_mvy_border_high, *_mvy_border_low;

	
	// Mode Decision Support
	short *_mcbpc;					// Coded Block Pattern for Chrominance
	short *_mcbpy;					// Coded Block Pattern for Luminance
	short *_mcbpb;					// CBP for B-Frame blocks: Luminance and Chrominance
	bool *_cmi;								// COD
	const bool *_cgi, *_flag_zero_mv;

	
public:
	static bool _encode_mode;

	static int _sformat;							// picture type; defined in Constants.h
	static int _PB_offset;
	static bool _inter_frame_mode;					// current frame mode: INTRA (false) vs. INTER (true)
	static bool _PB_frame_mode;
	static bool _PB_Ppicture_flag;
	static bool _coded_mvd_flag;
	static bool _advanced_prediction_mode;
	static bool _independent_segment_mode;
	static bool _alternative_inter_vlc_mode;
	static bool _advanced_intra_coding_mode;
	int _advanced_intra_prediction_mode;
	static bool _slice_mode;
	static bool _rectangular_submode;
	static bool _arbitrary_order_submode;

	D_Macroblock(void);
	~D_Macroblock(void);

	void Reset_Hierarchy(const row_ID, const MB_ID, 
		D_Block *const src_heada, D_Block *const src_headb);

	void Init_Structure(const unsigned char *const src_Y_c, const unsigned char *const src_U_c,
		const unsigned char *const src_V_c);

	void Fast_Structure(short *const src_Y_c, short *const src_U_c,
		short *const src_V_c, short *const zsrc_Y_s,
		short *const zsrc_U_s, short *const zsrc_V_s, 
		const bool *const src_cgi, bool *const src_cmi, 
		const bool *const src_flag_no_mv, short *const src_mcbpc, 
		short *const src_mcbpy, const short *const src_mtype,
		const short *const src_mquant, const short *const src_mv_type0,
		const short *const src_mv_x0, const short *const src_mv_y0);
	void Fast_Structure(short *const src_Y_c, short *const src_U_c,
		short *const src_V_c, short *const zsrc_Y_s,
		short *const zsrc_U_s, short *const zsrc_V_s, 
		const bool *const src_cgi, bool *const src_cmi, 
		const bool *const src_flag_no_mv, short *const src_mcbpc, 
		short *const src_mcbpy, const short *const src_mtype, const short *const src_mquant,
		const short *const src_mv_type1, const short *const src_mv_x1, const short *const src_mv_y1,
		const short *const src_mv_type2, const short *const src_mv_x2, const short *const src_mv_y2,
		const short *const src_mv_type3, const short *const src_mv_x3, const short *const src_mv_y3,
		const short *const src_mv_type4, const short *const src_mv_x4, const short *const src_mv_y4);

	void Fast_PB_Structure(short *const src_mcbpb, const short *dbquant, const short *bquant,
		const short *const src_mvd_type, const short *const src_mvd_x, const short *const src_mvd_y,
		const short *const src_mv_type1_f, const short *const src_mv_x1_f, const short *const src_mv_y1_f,
		const short *const src_mv_type2_f, const short *const src_mv_x2_f, const short *const src_mv_y2_f,
		const short *const src_mv_type3_f, const short *const src_mv_x3_f, const short *const src_mv_y3_f,
		const short *const src_mv_type4_f, const short *const src_mv_x4_f, const short *const src_mv_y4_f,
		const short *const src_mv_type1_b, const short *const src_mv_x1_b, const short *const src_mv_y1_b,
		const short *const src_mv_type2_b, const short *const src_mv_x2_b, const short *const src_mv_y2_b,
		const short *const src_mv_type3_b, const short *const src_mv_x3_b, const short *const src_mv_y3_b,
		const short *const src_mv_type4_b, const short *const src_mv_x4_b, const short *const src_mv_y4_b,
		const short *const src_mv_type_uv_f, const short *const src_mv_uvx_f, const short *const src_mv_uvy_f,
		const short *const src_mv_type_uv_b, const short *const src_mv_uvx_b, const short *const src_mv_uvy_b);

	void Fast_Slice_Structure(const short *const src_seg_ID, const short *const src_seg_size, 
		const short *const src_right_span, const short *const src_left_span,
		const short *const src_x_bound_high, const short *const src_x_bound_low,
		const short *const src_y_bound_high, const short *const src_y_bound_low,
		const short *const src_mvx0_high, const short *const src_mvx0_low, 
		const short *const src_mvy0_high, const short *const src_mvy0_low,
		const short *const src_mvx1_high, const short *const src_mvx1_low,
		const short *const src_mvy1_high, const short *const src_mvy1_low,
		const short *const src_mvx2_high, const short *const src_mvx2_low,
		const short *const src_mvy2_high, const short *const src_mvy2_low,
		const short *const src_mvx3_high, const short *const src_mvx3_low,
		const short *const src_mvy3_high, const short *const src_mvy3_low,
		const short *const src_mvx4_high, const short *const src_mvx4_low,
		const short *const src_mvy4_high, const short *const src_mvy4_low,
		const bool *const src_mvx_border_high, const bool *const src_mvx_border_low,
		const bool *const src_mvy_border_high, const bool *const src_mvy_border_low);

	void Fast_Decoded_Structure(const unsigned char *const src_Y_c,
		const unsigned char *const src_U_c, const unsigned char *const src_V_c);

	void Fast_Differential_Motion_Vector(
		const short *const src_seg_ID01, const short *const src_seg_ID02,
		const short *const src_seg_ID03, const short *const src_mv_type01, 
		const short *const src_mv_type02, const short *const src_mv_type03, 
		const short *const src_mv_x01, const short *const src_mv_x02, 
		const short *const src_mv_x03, const short *const src_mv_y01,
		const short *const src_mv_y02, const short *const src_mv_y03);

	void Fast_Differential_Motion_Vector(
		const short *const src_seg_ID11, const short *const src_seg_ID12, 
		const short *const src_seg_ID13, const short *const src_mv_type11, 
		const short *const src_mv_type12, const short *const src_mv_type13, 
		const short *const src_mv_x11, const short *const src_mv_x12, 
		const short *const src_mv_x13, const short *const src_mv_y11,
		const short *const src_mv_y12, const short *const src_mv_y13,
		const short *const src_seg_ID21, const short *const src_seg_ID22, 
		const short *const src_seg_ID23, const short *const src_mv_type21, 
		const short *const src_mv_type22, const short *const src_mv_type23, 
		const short *const src_mv_x21, const short *const src_mv_x22, 
		const short *const src_mv_x23, const short *const src_mv_y21,
		const short *const src_mv_y22, const short *const src_mv_y23,
		const short *const src_seg_ID31, const short *const src_seg_ID32,
		const short *const src_seg_ID33, const short *const src_mv_type31, 
		const short *const src_mv_type32, const short *const src_mv_type33, 
		const short *const src_mv_x31, const short *const src_mv_x32, 
		const short *const src_mv_x33, const short *const src_mv_y31, 
		const short *const src_mv_y32, const short *const src_mv_y33,
		const short *const src_seg_ID41, const short *const src_seg_ID42,
		const short *const src_seg_ID43, const short *const src_mv_type41,
		const short *const src_mv_type42, const short *const src_mv_type43,
		const short *const src_mv_x41, const short *const src_mv_x42,
		const short *const src_mv_x43, const short *const src_mv_y41,
		const short *const src_mv_y42, const short *const src_mv_y43,
		const short *const src_seg_ID01, const short *const src_seg_ID02,
		const short *const src_seg_ID03, const short *const src_mvd_type1,
		const short *const src_mvd_type2, const short *const src_mvd_typ3,
		const short *const src_mvd_x1, const short *const src_mvd_x2,
		const short *const src_mvd_x3, const short *const src_mvd_y1,
		const short *const src_mvd_y2, const short *const src_mvd_y3);

	void Median_Predictor(double *x, double *y, bool mvdb);
	void Median_Predictor(double *x0, double *y0, double *x1,
		double *y1, double *x2, double *y2, double *x3, double *y3);
	void D_Macroblock::Median_Predictor_1(double *x0, double *y0);
	void D_Macroblock::Median_Predictor_2(short &mv_x0, short &mv_y0, short &mv_type0,
										  double *x1, double *y1);
	void D_Macroblock::Median_Predictor_3(short &mv_x0, short &mv_y0, short &mv_type0,
										  short &mv_x1, short &mv_y1, short &mv_type1,
										  double *x2, double *y2);
	void D_Macroblock::Median_Predictor_4(short &mv_x0, short &mv_y0, short &mv_type0,
										  short &mv_x1, short &mv_y1, short &mv_type1,
										  short &mv_x2, short &mv_y2, short &mv_type2,
										  double *x3, double *y3);

	void Encode_MB(void);
	void Encode_MB(bool P_picture);
	void Entropy_Encoder(PSC_Fifo &bit_ostream);
	void SAC_Encoder(PSC_Fifo &bit_ostream, symbol *sac, bool plusptype);

	void Decode_MB(void);
	void Decode_MB(bool P_picture);
};

#endif
