
#ifndef __D_MACROBLOCK_C__
#define __D_MACROBLOCK_C__

#include "D_Macroblock.h"

bool D_Block::_PB_frame_mode;
int D_Block::_sformat;


/*
 * D_Macroblock::D_Macroblock(void)
 * 
 * Constructor
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_frame_xsize, D_Block::_sformat
 *				_BLK_per_mb, _BLK_Y_offset, _BLK_UV_offset
 *				_BLK_list
 * Ensures:		. Set (_frame_xsize, D_Block::ptype) according to picture format 
 *				. _BLK_per_mb hardwired to BLOCK_PER_MACROBLCOK (Constants.h)
 *				. _BLK_Y_offset = _BLK_UV_offset = 64
 *				. _BLK_list is allocated 6 blocks
 *
 * Warning:		
 */
D_Macroblock::D_Macroblock(void)
{
	switch (_sformat) {
	case (SQCIF):
		_frame_xsize = SQCIFX; 
		break;
	case (QCIF):
		_frame_xsize = QCIFX; 
		break;
	case (CIF):
		_frame_xsize = CIFX; 
		break;
	case (CIF4):
		_frame_xsize = CIFX4; 
		break;
	case (CIF16):
		_frame_xsize = CIFX16; 
		break;
	}

	_BLK_per_mb = BLOCK_PER_MACROBLOCK;
	D_Block::_sformat = _sformat;
	D_Block::_PB_frame_mode = _PB_frame_mode;

	_BLK_list = NULL;
	_BLK_list_PB = NULL;

	_BLK_Y_offset = 64;
	_BLK_UV_offset = 64;
}


/*
 * D_Macroblock::~D_Macroblock(void)
 * 
 * Destructor
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	6 blocks pointed by _BLK_list
 * Ensures:		delete[] _BLK_list
 *
 * Warning:		
 */
D_Macroblock::~D_Macroblock(void)
{
}


#endif

